/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.rcp.ui.internal.search;

import com.ibm.team.process.common.IProjectAreaHandle;
import com.ibm.team.workitem.rcp.ui.QueriesUI;
import com.ibm.team.workitem.rcp.ui.internal.ImagePool;
import com.ibm.team.workitem.rcp.ui.internal.actions.ProjectAreaSelectionAction;
import com.ibm.team.workitem.rcp.ui.internal.search.Messages;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.DialogPage;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.search.internal.ui.SearchPlugin;
import org.eclipse.search.ui.ISearchPage;
import org.eclipse.search.ui.ISearchPageContainer;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.ui.PlatformUI;

public class WorkItemSearchPage
extends DialogPage
implements ISearchPage {
    private static final int HISTORY_SIZE = 12;
    private static final String PAGE_NAME = "WorkItemSearchPage";
    private static final String STORE_HISTORY = "HISTORY";
    private static final String STORE_HISTORY_SIZE = "HISTORY_SIZE";
    private Composite fComposite;
    private Combo fQuickSearchControl;
    private List fSearchHistory = new ArrayList(20);
    private IDialogSettings fDialogSettings;
    private ISearchPageContainer fContainer;
    private boolean fFirstTime = true;
    private ProjectAreaSelectionAction fProjectAreaSelectionAction = new ProjectAreaSelectionAction("query"){

        public boolean isEnabled() {
            return this.getConnectedProjectAreas().size() > 1;
        }
    };

    public boolean performAction() {
        SearchData searchData = this.getSearchData();
        String quickSearch = searchData.quickSearchText;
        if (quickSearch == null || quickSearch.trim().length() == 0) {
            return false;
        }
        IProjectAreaHandle projectAreaHandle = this.fProjectAreaSelectionAction.getProjectArea();
        if (projectAreaHandle != null) {
            QueriesUI.showQueryResults(PlatformUI.getWorkbench().getActiveWorkbenchWindow(), projectAreaHandle, quickSearch);
        }
        return true;
    }

    public void setContainer(ISearchPageContainer container) {
        this.fContainer = container;
    }

    public void createControl(Composite parent) {
        this.readConfiguration();
        this.fComposite = new Composite(parent, 0);
        this.fComposite.setLayoutData((Object)new GridData(4, 128, true, false));
        this.fComposite.setLayout((Layout)new GridLayout(2, false));
        Label label = new Label(this.fComposite, 0);
        label.setText(Messages.WorkItemSearchPage_CONTAINING_ID_OR_TEXT);
        label.setLayoutData((Object)new GridData(1, 0x1000000, false, false, 2, 1));
        this.fQuickSearchControl = new Combo(this.fComposite, 2052);
        this.fQuickSearchControl.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.fQuickSearchControl.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                WorkItemSearchPage.this.handleWidgetSelected();
                WorkItemSearchPage.this.updateOKStatus();
            }
        });
        this.fQuickSearchControl.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                WorkItemSearchPage.this.updateOKStatus();
            }
        });
        ToolBar toolBar = new ToolBar(this.fComposite, 0x800100);
        toolBar.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        this.fProjectAreaSelectionAction.setImageDescriptor(ImagePool.PROJECT_AREA);
        this.fProjectAreaSelectionAction.setText(Messages.WorkItemSearchPage_CHOOSE_PA);
        new ActionContributionItem((IAction)this.fProjectAreaSelectionAction).fill(toolBar, 0);
        toolBar.pack();
        this.setControl((Control)this.fComposite);
    }

    private String[] getPreviousQuickSearchStrings() {
        int size = this.fSearchHistory.size();
        String[] patterns = new String[size];
        int i = 0;
        while (i < size) {
            patterns[i] = ((SearchData)this.fSearchHistory.get((int)i)).quickSearchText;
            ++i;
        }
        return patterns;
    }

    final void updateOKStatus() {
        this.fContainer.setPerformActionEnabled(this.fQuickSearchControl.getText().trim().length() > 0);
    }

    private void handleWidgetSelected() {
        int selectionIndex = this.fQuickSearchControl.getSelectionIndex();
        if (selectionIndex < 0 || selectionIndex >= this.fSearchHistory.size()) {
            return;
        }
        SearchData patternData = (SearchData)this.fSearchHistory.get(selectionIndex);
        if (!this.fQuickSearchControl.getText().equals(patternData.quickSearchText)) {
            return;
        }
    }

    private IDialogSettings getDialogSettings() {
        IDialogSettings settings = SearchPlugin.getDefault().getDialogSettings();
        this.fDialogSettings = settings.getSection(PAGE_NAME);
        if (this.fDialogSettings == null) {
            this.fDialogSettings = settings.addNewSection(PAGE_NAME);
        }
        return this.fDialogSettings;
    }

    private void readConfiguration() {
        IDialogSettings s = this.getDialogSettings();
        if (s.get(STORE_HISTORY_SIZE) == null) {
            return;
        }
        int historySize = s.getInt(STORE_HISTORY_SIZE);
        int i = 0;
        while (i < historySize) {
            SearchData data;
            IDialogSettings histSettings = s.getSection(STORE_HISTORY + i);
            if (histSettings != null && (data = SearchData.create(histSettings)) != null) {
                this.fSearchHistory.add(data);
            }
            ++i;
        }
    }

    private void writeConfiguration() {
        IDialogSettings s = this.getDialogSettings();
        int historySize = Math.min(this.fSearchHistory.size(), 12);
        s.put(STORE_HISTORY_SIZE, historySize);
        int i = 0;
        while (i < historySize) {
            IDialogSettings histSettings = s.addNewSection(STORE_HISTORY + i);
            SearchData data = (SearchData)this.fSearchHistory.get(i);
            data.store(histSettings);
            ++i;
        }
    }

    public void dispose() {
        this.writeConfiguration();
        if (this.fProjectAreaSelectionAction != null) {
            this.fProjectAreaSelectionAction.dispose();
            this.fProjectAreaSelectionAction = null;
        }
        super.dispose();
    }

    public void setVisible(boolean visible) {
        if (visible && this.fQuickSearchControl != null) {
            if (this.fFirstTime) {
                this.fFirstTime = false;
                this.fQuickSearchControl.setItems(this.getPreviousQuickSearchStrings());
                if (!this.initializeQuickSearchControl()) {
                    this.fQuickSearchControl.select(0);
                    this.handleWidgetSelected();
                }
            }
            this.fQuickSearchControl.setFocus();
        }
        this.updateOKStatus();
        super.setVisible(visible);
    }

    private boolean initializeQuickSearchControl() {
        String text;
        ISelection selection = this.fContainer.getSelection();
        if (selection instanceof ITextSelection && !selection.isEmpty() && (text = ((ITextSelection)selection).getText()) != null) {
            this.fQuickSearchControl.setText(text);
            return true;
        }
        return false;
    }

    private SearchData getSearchData() {
        SearchData match = this.findInPrevious(this.fQuickSearchControl.getText());
        if (match != null) {
            this.fSearchHistory.remove(match);
        }
        match = new SearchData(this.fQuickSearchControl.getText());
        this.fSearchHistory.add(0, match);
        return match;
    }

    private SearchData findInPrevious(String pattern) {
        for (SearchData element : this.fSearchHistory) {
            if (!pattern.equals(element.quickSearchText)) continue;
            return element;
        }
        return null;
    }

    private static class SearchData {
        public final String quickSearchText;

        public SearchData(String quickSearchText) {
            this.quickSearchText = quickSearchText;
        }

        public void store(IDialogSettings settings) {
            settings.put("quickSearchText", this.quickSearchText);
        }

        public static SearchData create(IDialogSettings settings) {
            String textPattern = settings.get("quickSearchText");
            return new SearchData(textPattern);
        }
    }
}

