/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.rcp.ui.internal.quicksearch;

import com.ibm.team.jface.JazzResources;
import com.ibm.team.workitem.rcp.ui.internal.WorkItemRCPUIPlugin;
import com.ibm.team.workitem.rcp.ui.internal.quicksearch.Messages;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuCreator;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;

public class DropDownToolItem {
    private final IPropertyChangeListener fPropertyChangeListener = new IPropertyChangeListener(){

        public void propertyChange(PropertyChangeEvent event) {
            DropDownToolItem.this.handleActionPropertyChange(event);
        }
    };
    private final IAction fAction;
    private final ToolItem fToolItem;
    private final ResourceManager fResourceManager;

    public DropDownToolItem(ToolBar toolBar, IAction action) {
        this.fAction = action;
        this.fResourceManager = new LocalResourceManager(JFaceResources.getResources());
        this.fToolItem = new ToolItem(toolBar, 4);
        this.fToolItem.setImage(JazzResources.getImageWithDefault((ResourceManager)this.fResourceManager, (ImageDescriptor)this.fAction.getImageDescriptor()));
        this.fToolItem.setDisabledImage(JazzResources.getImageWithDefault((ResourceManager)this.fResourceManager, (ImageDescriptor)this.fAction.getImageDescriptor()));
        this.fToolItem.setToolTipText(this.fAction.getToolTipText());
        this.fAction.addPropertyChangeListener(this.fPropertyChangeListener);
        this.fToolItem.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                DropDownToolItem.this.handleSelection(event);
            }
        });
        this.fToolItem.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                DropDownToolItem.this.dispose();
            }
        });
    }

    private void handleActionPropertyChange(PropertyChangeEvent event) {
        boolean updateEnabledState;
        String property = event.getProperty();
        final boolean updateTooltip = property == null || "toolTipText".equals(property);
        boolean bl = updateEnabledState = property == null || "enabled".equals(property);
        if (!updateTooltip && !updateEnabledState) {
            return;
        }
        WorkItemRCPUIPlugin.runInUI(Messages.DropDownToolItem_UPDATE, new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                if (DropDownToolItem.this.fToolItem.isDisposed()) {
                    return;
                }
                if (updateTooltip) {
                    DropDownToolItem.this.fToolItem.setToolTipText(DropDownToolItem.this.fAction.getToolTipText());
                } else if (updateEnabledState) {
                    DropDownToolItem.this.fToolItem.setEnabled(DropDownToolItem.this.fAction.isEnabled());
                }
            }
        }, null);
    }

    private void handleSelection(Event event) {
        Menu menu;
        IMenuCreator menuCreator;
        if (event.detail == 4 && (menuCreator = this.fAction.getMenuCreator()) != null && (menu = menuCreator.getMenu((Control)this.fToolItem.getParent())) != null) {
            Point location = this.getLocation(menu, event);
            menu.setLocation(location);
            menu.setVisible(true);
            return;
        }
        if (this.fAction.isEnabled()) {
            this.fAction.runWithEvent(event);
        }
    }

    private Point getLocation(Menu menu, Event event) {
        int menuHeight = menu.getItemCount() * 20;
        Rectangle screen = this.fToolItem.getDisplay().getBounds();
        Rectangle bounds = this.fToolItem.getParent().getBounds();
        Point point = this.map(new Point(event.x, bounds.y + bounds.height));
        if (point.y + menuHeight < screen.height) {
            return point;
        }
        return this.map(new Point(event.x, bounds.y));
    }

    private Point map(Point point) {
        return this.fToolItem.getDisplay().map((Control)this.fToolItem.getParent(), null, point);
    }

    private void dispose() {
        this.fAction.removePropertyChangeListener(this.fPropertyChangeListener);
        IMenuCreator menuCreator = this.fAction.getMenuCreator();
        if (menuCreator != null) {
            menuCreator.dispose();
        }
        this.fResourceManager.dispose();
    }
}

