/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.rcp.ui.internal.queries;

import com.ibm.team.jface.internal.AdaptedElementTreeSelectionDialog;
import com.ibm.team.workitem.common.expression.IQueryableAttribute;
import com.ibm.team.workitem.common.internal.expression.QueryableLinkAttribute;
import com.ibm.team.workitem.rcp.ui.internal.HelpContextIds;
import com.ibm.team.workitem.rcp.ui.internal.WorkItemRCPUIPlugin;
import com.ibm.team.workitem.rcp.ui.internal.queries.Messages;
import com.ibm.team.workitem.rcp.ui.internal.queries.QueryableAttributeContentProvider;
import com.ibm.team.workitem.rcp.ui.internal.queries.QueryableAttributeLabelProvider;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.accessibility.AccessibleAdapter;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.eclipse.swt.accessibility.AccessibleListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.ui.dialogs.FilteredTree;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QueryableAttributeSelectionDialog
extends AdaptedElementTreeSelectionDialog {
    private final ViewerFilter fFilter = new ViewerFilter(){

        public boolean select(Viewer viewer, Object parentElement, Object element) {
            if (element instanceof IQueryableAttribute) {
                IQueryableAttribute attribute = (IQueryableAttribute)element;
                if (parentElement == viewer.getInput()) {
                    if (!(QueryableAttributeSelectionDialog.this.fShowBuiltIn || attribute.isStateExtension() || attribute instanceof QueryableLinkAttribute)) {
                        return false;
                    }
                    if (!QueryableAttributeSelectionDialog.this.fShowCustom && attribute.isStateExtension()) {
                        return false;
                    }
                    if (!QueryableAttributeSelectionDialog.this.fShowLinks && attribute instanceof QueryableLinkAttribute) {
                        return false;
                    }
                    if (!QueryableAttributeSelectionDialog.this.fShowArchived && attribute.isArchived()) {
                        return false;
                    }
                }
                if (QueryableAttributeSelectionDialog.this.fFiltered != null) {
                    return !QueryableAttributeSelectionDialog.this.fFiltered.contains(attribute.getIdentifier());
                }
            }
            return true;
        }
    };
    private static final String SETTINGS = QueryableAttributeSelectionDialog.class.getName();
    public static final int SHOW_BUILT_IN = 2;
    public static final int SHOW_CUSTOM = 4;
    public static final int SHOW_LINKS = 8;
    public static final int SHOW_ARCHIVED = 16;
    public static final String KEY_SHOW_BUILT_IN = "showBuiltIn";
    public static final String KEY_SHOW_CUSTOM = "showCustom";
    public static final String KEY_SHOW_LINKS = "showLinks";
    public static final String KEY_SHOW_ARCHVIED = "showArchived";
    private HashSet<String> fFiltered;
    private boolean fShowBuiltIn;
    private boolean fShowCustom;
    private boolean fShowLinks;
    private boolean fShowArchived;
    private int fButtonFilter;
    private final String fSettingsKey;

    public QueryableAttributeSelectionDialog(Shell parent, ILabelProvider labelProvider, ITreeContentProvider contentProvider, String settingsKey) {
        super(parent, labelProvider, contentProvider);
        this.fSettingsKey = settingsKey;
        this.setMessage(Messages.QueryableAttributeSelectionDialog_SELECT_ATTRIBUTES);
        this.setStatusLineAboveButtons(false);
        this.setSorter(new ViewerSorter());
        this.addFilter(this.fFilter);
        this.restoreState(this.getDialogSettings());
        this.fButtonFilter = 0xFFFFFF;
    }

    public QueryableAttributeSelectionDialog(Shell parent, ILabelProvider labelProvider) {
        this(parent, labelProvider, new QueryableAttributeContentProvider(), SETTINGS);
    }

    public QueryableAttributeSelectionDialog(Shell parent) {
        this(parent, (ILabelProvider)new QueryableAttributeLabelProvider(), new QueryableAttributeContentProvider(), SETTINGS);
    }

    public void setFilteredAttributes(List<String> attributeIdentifiers) {
        this.fFiltered = new HashSet<String>(attributeIdentifiers);
    }

    public void configureButtons(int flags) {
        this.fButtonFilter = flags;
    }

    public List<IQueryableAttribute> getSelectedAttributes() {
        Object[] result;
        ArrayList<IQueryableAttribute> attributes = new ArrayList<IQueryableAttribute>();
        Object[] objectArray = result = this.getResult();
        int n = result.length;
        int n2 = 0;
        while (n2 < n) {
            Object object = objectArray[n2];
            if (object instanceof IQueryableAttribute) {
                attributes.add((IQueryableAttribute)object);
            }
            ++n2;
        }
        return attributes;
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        Composite filterComposite = new Composite(composite, 0);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)filterComposite);
        filterComposite.setLayout((Layout)new RowLayout());
        if (this.showButton(2)) {
            this.createShowBuiltInButton(filterComposite);
        }
        if (this.showButton(4)) {
            this.createShowCustomButton(filterComposite);
        }
        if (this.showButton(8)) {
            this.createShowLinksButton(filterComposite);
        }
        if (this.showButton(16)) {
            this.createShowArchivedButton(filterComposite);
        }
        HelpContextIds.hookHelpListener((Control)parent, "com.ibm.team.workitem.rcp.ui.query_attribute_selection_dialog");
        return composite;
    }

    protected FilteredTree createFilteredTree(Composite parent) {
        FilteredTree filteredTree = super.createFilteredTree(parent);
        filteredTree.getFilterControl().addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                Tree tree;
                if (e.keyCode == 0x1000002 && (tree = QueryableAttributeSelectionDialog.this.getTreeViewer().getTree()).getSelectionCount() == 0 && tree.getItemCount() > 0) {
                    if (!tree.isFocusControl()) {
                        tree.setFocus();
                    }
                    tree.setSelection(tree.getItem(0));
                    QueryableAttributeSelectionDialog.this.getTreeViewer().setSelection(QueryableAttributeSelectionDialog.this.getTreeViewer().getSelection());
                }
            }
        });
        this.initAccessibility(filteredTree);
        return filteredTree;
    }

    private void initAccessibility(FilteredTree filteredTree) {
        filteredTree.getViewer().getTree().getAccessible().addAccessibleListener((AccessibleListener)new AccessibleAdapter(){

            public void getName(AccessibleEvent e) {
                if (e.childID == -1) {
                    e.result = QueryableAttributeSelectionDialog.this.getMessage();
                }
            }
        });
    }

    private void createShowLinksButton(Composite filterComposite) {
        final Button showLinks = new Button(filterComposite, 32);
        showLinks.setText(Messages.QueryableAttributeSelectionDialog_SHOW_LINKS);
        showLinks.setSelection(this.fShowLinks);
        showLinks.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                QueryableAttributeSelectionDialog.this.fShowLinks = showLinks.getSelection();
                QueryableAttributeSelectionDialog.this.getTreeViewer().refresh(false);
            }
        });
    }

    private void createShowCustomButton(Composite filterComposite) {
        final Button showCustom = new Button(filterComposite, 32);
        showCustom.setText(Messages.QueryableAttributeSelectionDialog_SHOW_CUSTOM);
        showCustom.setSelection(this.fShowCustom);
        showCustom.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                QueryableAttributeSelectionDialog.this.fShowCustom = showCustom.getSelection();
                QueryableAttributeSelectionDialog.this.getTreeViewer().refresh(false);
            }
        });
    }

    private void createShowBuiltInButton(Composite filterComposite) {
        final Button showBuiltIn = new Button(filterComposite, 32);
        showBuiltIn.setText(Messages.QueryableAttributeSelectionDialog_SHOW_BUILT_IN);
        showBuiltIn.setSelection(this.fShowBuiltIn);
        showBuiltIn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                QueryableAttributeSelectionDialog.this.fShowBuiltIn = showBuiltIn.getSelection();
                QueryableAttributeSelectionDialog.this.getTreeViewer().refresh(false);
            }
        });
    }

    private void createShowArchivedButton(Composite filterComposite) {
        final Button showArchived = new Button(filterComposite, 32);
        showArchived.setText(Messages.QueryableAttributeSelectionDialog_SHOW_ARCHIVED);
        showArchived.setSelection(this.fShowArchived);
        showArchived.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                QueryableAttributeSelectionDialog.this.fShowArchived = showArchived.getSelection();
                QueryableAttributeSelectionDialog.this.getTreeViewer().refresh(false);
            }
        });
    }

    public boolean close() {
        this.saveState(this.getDialogSettings());
        return super.close();
    }

    protected void updateButtonsEnableState(IStatus status) {
        Button okButton = this.getOkButton();
        if (okButton != null && !okButton.isDisposed()) {
            okButton.setEnabled(!status.matches(4) && this.getResult().length > 0);
        }
    }

    private void saveState(IDialogSettings settings) {
        settings.put(KEY_SHOW_BUILT_IN, this.fShowBuiltIn);
        settings.put(KEY_SHOW_CUSTOM, this.fShowCustom);
        settings.put(KEY_SHOW_LINKS, this.fShowLinks);
        settings.put(KEY_SHOW_ARCHVIED, this.fShowArchived);
    }

    private void restoreState(IDialogSettings settings) {
        this.fShowBuiltIn = this.getBooleanSetting(settings, KEY_SHOW_BUILT_IN, true);
        this.fShowCustom = this.getBooleanSetting(settings, KEY_SHOW_CUSTOM, false);
        this.fShowLinks = this.getBooleanSetting(settings, KEY_SHOW_LINKS, false);
        this.fShowArchived = this.getBooleanSetting(settings, KEY_SHOW_ARCHVIED, false);
    }

    private boolean getBooleanSetting(IDialogSettings settings, String key, boolean defaultValue) {
        return settings.get(key) != null ? settings.getBoolean(key) : defaultValue;
    }

    private boolean showButton(int button) {
        return (this.fButtonFilter & button) != 0;
    }

    private IDialogSettings getDialogSettings() {
        IDialogSettings settings = WorkItemRCPUIPlugin.getDefault().getDialogSettings();
        IDialogSettings dialogSettings = settings.getSection(this.fSettingsKey);
        if (dialogSettings == null) {
            dialogSettings = settings.addNewSection(this.fSettingsKey);
        }
        return dialogSettings;
    }
}

