/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.rcp.ui.internal.queries;

import com.ibm.team.foundation.common.URIReference;
import com.ibm.team.foundation.rcp.core.hyperlinks.ContextProvider;
import com.ibm.team.foundation.rcp.core.hyperlinks.HyperlinkHandler;
import com.ibm.team.foundation.rcp.ui.util.FoundationUIUtils;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.Location;
import com.ibm.team.repository.common.PermissionDeniedException;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.workitem.client.URIService;
import com.ibm.team.workitem.common.query.IQueryDescriptor;
import com.ibm.team.workitem.common.query.IQueryDescriptorHandle;
import com.ibm.team.workitem.rcp.ui.QueriesUI;
import com.ibm.team.workitem.rcp.ui.WorkItemUI;
import com.ibm.team.workitem.rcp.ui.internal.WorkItemRCPUIPlugin;
import com.ibm.team.workitem.rcp.ui.internal.queries.Messages;
import java.net.URI;
import java.util.ArrayList;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public class QueryDescriptorHyperlinkHandler
extends HyperlinkHandler {
    public static final String TYPE = IQueryDescriptor.class.getName();

    public boolean handles(URI uri) {
        return IQueryDescriptor.ITEM_TYPE.equals(URIService.findItemType((URI)uri));
    }

    public boolean resolves(URI uri) {
        return IQueryDescriptor.ITEM_TYPE.equals(URIService.findItemType((URI)uri));
    }

    public Object resolve(URI uri, ContextProvider provider) throws TeamRepositoryException {
        return URIService.resolveObject((URI)uri);
    }

    public IStatus open2(URI uri, ContextProvider context, IProgressMonitor progressmonitor) {
        try {
            IWorkbenchWindow workbenchWindow = null;
            if (context != null) {
                Object uiContext = context.findUIContext();
                if (uiContext instanceof IWorkbenchWindow) {
                    workbenchWindow = (IWorkbenchWindow)uiContext;
                } else if (uiContext instanceof Shell) {
                    workbenchWindow = QueryDescriptorHyperlinkHandler.getWorkbenchWindow((Shell)uiContext);
                }
            }
            if (workbenchWindow == null) {
                workbenchWindow = QueryDescriptorHyperlinkHandler.getWorkbenchWindow();
            }
            if (workbenchWindow == null) {
                return new Status(4, "com.ibm.team.workitem.rcp.ui", Messages.QueryDescriptorHyperlinkHandler_COULD_NOT_LOCATE_WORKBENCHWINDOW);
            }
            ITeamRepository repository = URIService.findTeamRepository((URI)uri);
            if (repository == null) {
                return Status.CANCEL_STATUS;
            }
            IStatus status = FoundationUIUtils.validateRepository((ITeamRepository)repository, (boolean)false, (IProgressMonitor)progressmonitor);
            if (!status.isOK()) {
                return status;
            }
            Object object = URIService.resolveObject((URI)uri, (IProgressMonitor)progressmonitor);
            if (!(object instanceof IQueryDescriptorHandle)) {
                return new Status(4, "com.ibm.team.workitem.rcp.ui", Messages.QueryDescriptorHyperlinkHandler_UNKNOWN_CLASS);
            }
            QueriesUI.showQueryResults(workbenchWindow, (IQueryDescriptorHandle)object);
            return Status.OK_STATUS;
        }
        catch (PermissionDeniedException permissionDeniedException) {
            WorkItemUI.openPermissionDeniedDialog(Messages.QueryDescriptorHyperlinkHandler_QUERY);
            return Status.OK_STATUS;
        }
        catch (TeamRepositoryException e) {
            return new Status(4, "com.ibm.team.workitem.rcp.ui", String.valueOf(Messages.QueryDescriptorHyperlinkHandler_RESOLVE_FAILED) + uri, (Throwable)e);
        }
    }

    public URIReference createHyperlink(Object object, IProgressMonitor monitor) {
        IQueryDescriptorHandle handle;
        ITeamRepository repository;
        if (object instanceof IQueryDescriptorHandle && (repository = (ITeamRepository)(handle = (IQueryDescriptorHandle)object).getOrigin()).loggedIn()) {
            ArrayList<String> properties = new ArrayList<String>(2);
            properties.add(IQueryDescriptor.NAME_PROPERTY);
            properties.add(IQueryDescriptor.DESCRIPTION_PROPERTY);
            try {
                IQueryDescriptor descriptor = (IQueryDescriptor)repository.itemManager().fetchPartialItem((IItemHandle)handle, 0, properties, monitor);
                if (descriptor != null) {
                    URI uri = Location.itemLocation((IItemHandle)descriptor, (String)repository.getRepositoryURI()).toAbsoluteUri();
                    return new URIReference(descriptor.getName(), descriptor.getDescription(), TYPE, uri);
                }
            }
            catch (TeamRepositoryException e) {
                WorkItemRCPUIPlugin.getDefault().log(Messages.QueryDescriptorHyperlinkHandler_EXCEPTION_RESOLVING_QUERY_DESCRIPTOR, e);
            }
        }
        return super.createHyperlink(object, monitor);
    }

    public boolean links(Object object) {
        if (object instanceof IQueryDescriptorHandle) {
            return true;
        }
        return super.links(object);
    }

    private static IWorkbenchWindow getWorkbenchWindow() {
        IWorkbench workbench = PlatformUI.getWorkbench();
        IWorkbenchWindow window = workbench.getActiveWorkbenchWindow();
        if (window == null) {
            if (workbench.getWorkbenchWindowCount() > 0) {
                window = workbench.getWorkbenchWindows()[0];
            } else {
                return null;
            }
        }
        return window;
    }

    private static IWorkbenchWindow getWorkbenchWindow(Shell shell) {
        IWorkbench workbench = PlatformUI.getWorkbench();
        IWorkbenchWindow[] windows = workbench.getWorkbenchWindows();
        int i = 0;
        while (i < windows.length) {
            if (windows[i].getShell().equals(shell)) {
                return windows[i];
            }
            ++i;
        }
        return null;
    }
}

