/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.rcp.ui.internal.queries;

import com.ibm.team.process.rcp.ui.teamnavigator.IMenuOperationTarget;
import com.ibm.team.workitem.common.query.IQueryDescriptor;
import com.ibm.team.workitem.rcp.ui.internal.actions.DeleteQueryAction;
import com.ibm.team.workitem.rcp.ui.internal.actions.RunQueryAction;
import com.ibm.team.workitem.rcp.ui.internal.queries.Messages;
import org.eclipse.core.runtime.IAdapterFactory;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IWorkbenchSite;

public class QueryDescriptorAdapterFactory
implements IAdapterFactory {
    public Object getAdapter(Object adaptableObject, Class adapterType) {
        if (adapterType == IMenuOperationTarget.class && adaptableObject instanceof IQueryDescriptor) {
            return new QueryDescriptorMenuOperationTarget();
        }
        return null;
    }

    public Class[] getAdapterList() {
        return new Class[]{IMenuOperationTarget.class};
    }

    private static class QueryDescriptorMenuOperationTarget
    implements IMenuOperationTarget {
        private QueryDescriptorMenuOperationTarget() {
        }

        public boolean canDoOperation(String actionId, IStructuredSelection selection) {
            if (selection.getFirstElement() instanceof IQueryDescriptor) {
                if ("jazz.open".equals(actionId) || IMenuOperationTarget.REFRESH.equals(actionId)) {
                    return true;
                }
                if (IMenuOperationTarget.PROPERTIES.equals(actionId)) {
                    return false;
                }
                if (IMenuOperationTarget.DELETE.equals(actionId)) {
                    return DeleteQueryAction.getEnabledState(selection);
                }
            }
            return false;
        }

        public void doOperation(String actionId, IWorkbenchSite site, IStructuredSelection selection) {
            Action action;
            if ("jazz.open".equals(actionId)) {
                action = new RunQueryAction(site.getPage().getActivePart(), selection);
                action.run();
            }
            if (IMenuOperationTarget.DELETE.equals(actionId)) {
                action = new DeleteQueryAction(site.getPage().getActivePart(), selection);
                action.run();
            }
        }

        public String getLabel(String actionId) {
            if ("jazz.open".equals(actionId)) {
                return Messages.QueryDescriptorAdapterFactory_SHOW_WORK_ITEMS;
            }
            return null;
        }
    }
}

