/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.rcp.ui.internal.queries;

import com.ibm.team.workitem.rcp.ui.internal.queries.IShowsQuery;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IViewReference;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;

public class Queries {
    private static Pattern fgIdPattern;
    private static final String WORK_ITEM_EXPLORER = "com.ibm.magnolia.workItemExplorer";

    public static Integer getWorkItemId(String queryValue) {
        Matcher m;
        String idString = null;
        if (fgIdPattern == null) {
            fgIdPattern = Pattern.compile("#?([0-9]+)");
        }
        if ((m = fgIdPattern.matcher(queryValue)).matches()) {
            idString = m.group(1);
        }
        try {
            if (idString != null) {
                return new Integer(idString);
            }
        }
        catch (NumberFormatException numberFormatException) {}
        return null;
    }

    public static IViewPart findWorkItemExplorer(IWorkbenchWindow window) throws PartInitException {
        IViewReference[] ref = window.getActivePage().getViewReferences();
        IViewPart visiblePart = null;
        IViewPart notPinnedPart = null;
        IViewPart pinnedPart = null;
        String partId = null;
        String foundPartId = null;
        int i = 0;
        while (i < ref.length) {
            partId = ref[i].getId();
            IViewPart part = (IViewPart)ref[i].getPart(false);
            if (partId.startsWith(WORK_ITEM_EXPLORER) && window.getActivePage().isPartVisible((IWorkbenchPart)part)) {
                foundPartId = partId;
            }
            ++i;
        }
        String desiredExplorerType = foundPartId != null ? foundPartId : WORK_ITEM_EXPLORER;
        int i2 = 0;
        while (i2 < ref.length) {
            IViewPart part;
            if (ref[i2].getId().equals(desiredExplorerType) && (part = (IViewPart)ref[i2].getPart(false)) != null) {
                boolean pinned = ((IShowsQuery)part).isPinned();
                if (window.getActivePage().isPartVisible((IWorkbenchPart)part) && !pinned) {
                    visiblePart = part;
                    break;
                }
                if (!pinned && notPinnedPart == null) {
                    notPinnedPart = part;
                } else if (pinned) {
                    pinnedPart = part;
                }
            }
            ++i2;
        }
        if (visiblePart != null) {
            return visiblePart;
        }
        if (notPinnedPart != null) {
            window.getActivePage().showView(desiredExplorerType, notPinnedPart.getViewSite().getSecondaryId(), 1);
            return notPinnedPart;
        }
        if (pinnedPart == null) {
            return window.getActivePage().showView(desiredExplorerType);
        }
        return ((IShowsQuery)pinnedPart).openNewView();
    }
}

