/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.rcp.ui.internal.preview;

import com.ibm.team.jface.preview.DomainAdapter;
import com.ibm.team.jface.preview.IDomainAdapter;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IAuditableHandle;
import com.ibm.team.repository.common.PermissionDeniedException;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.util.NLS;
import com.ibm.team.workitem.client.IAuditableClient;
import com.ibm.team.workitem.client.internal.util.ClientUtils;
import com.ibm.team.workitem.common.query.IQueryDescriptor;
import com.ibm.team.workitem.common.query.IQueryDescriptorHandle;
import com.ibm.team.workitem.rcp.core.queries.Query;
import com.ibm.team.workitem.rcp.ui.internal.WorkItemRCPUIPlugin;
import com.ibm.team.workitem.rcp.ui.internal.preview.Messages;
import com.ibm.team.workitem.rcp.ui.internal.preview.QueryHTMLGenerator;
import java.util.HashMap;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.action.IAction;

public class QueryDomainAdapter
extends DomainAdapter {
    protected Object convertToDomainObject(Object object) {
        Query query = (Query)ClientUtils.castObject((Object)object, Query.class);
        if (query != null) {
            return query;
        }
        IQueryDescriptorHandle queryDescriptorHandle = (IQueryDescriptorHandle)ClientUtils.castObject((Object)object, IQueryDescriptorHandle.class);
        if (queryDescriptorHandle != null) {
            return queryDescriptorHandle;
        }
        return null;
    }

    public void generateContentAsHTML(HashMap head, StringBuffer body, Object input, IDomainAdapter.Info info) {
        Query query = (Query)ClientUtils.castObject((Object)input, Query.class);
        if (query != null) {
            new QueryHTMLGenerator(query).generate(head, body, info);
            return;
        }
        IQueryDescriptorHandle queryDescriptorHandle = (IQueryDescriptorHandle)ClientUtils.castObject((Object)input, IQueryDescriptorHandle.class);
        if (queryDescriptorHandle != null) {
            new QueryHTMLGenerator(queryDescriptorHandle).generate(head, body, info);
        }
    }

    public String generateContentAsText(Object input) {
        return this.generateTitle(input);
    }

    public String generateTitle(Object input) {
        Query query = (Query)ClientUtils.castObject((Object)input, Query.class);
        if (query != null) {
            return query.getName();
        }
        IQueryDescriptorHandle queryDescriptorHandle = (IQueryDescriptorHandle)ClientUtils.castObject((Object)input, IQueryDescriptorHandle.class);
        if (queryDescriptorHandle != null) {
            try {
                ITeamRepository repository = (ITeamRepository)queryDescriptorHandle.getOrigin();
                IAuditableClient auditableClient = (IAuditableClient)repository.getClientLibrary(IAuditableClient.class);
                IQueryDescriptor queryDescriptor = (IQueryDescriptor)auditableClient.resolveAuditable((IAuditableHandle)queryDescriptorHandle, IQueryDescriptor.SMALL_PROFILE, (IProgressMonitor)new NullProgressMonitor());
                return queryDescriptor.getName();
            }
            catch (PermissionDeniedException permissionDeniedException) {
                return Messages.QueryDomainAdapter_PERMISSION_DENIED;
            }
            catch (TeamRepositoryException e) {
                WorkItemRCPUIPlugin.getDefault().log(Messages.QueryDomainAdapter_EXCEPTION_GENERATING_TITLE, e);
                return Messages.QueryDomainAdapter_EXCEPTION_OCCURED_SEE_ERROR_LOG;
            }
        }
        return null;
    }

    public IAction getGotoInputAction() {
        return null;
    }

    public String generateJobInfo(Object input, IDomainAdapter.Info info) {
        String name = this.getName(input);
        return NLS.bind((String)Messages.QueryDomainAdapter_PROCESSING_QUERY, (Object)name, (Object[])new Object[0]);
    }

    private String getName(Object input) {
        Query query = (Query)ClientUtils.castObject((Object)input, Query.class);
        if (query != null) {
            return query.getName();
        }
        IQueryDescriptor descriptor = (IQueryDescriptor)ClientUtils.castObject((Object)input, IQueryDescriptor.class);
        if (descriptor != null) {
            return descriptor.getName();
        }
        return "";
    }
}

