/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.rcp.ui.internal.preview;

import com.ibm.icu.text.DateFormat;
import com.ibm.team.foundation.common.URIReference;
import com.ibm.team.foundation.common.internal.util.XMLBuilder;
import com.ibm.team.foundation.rcp.core.hyperlinks.Hyperlinks;
import com.ibm.team.jface.itemview.MarkupUtil;
import com.ibm.team.jface.preview.DomainAdapterUtils;
import com.ibm.team.jface.preview.HTMLGenerator;
import com.ibm.team.jface.preview.IDomainAdapter;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IAuditable;
import com.ibm.team.repository.common.IAuditableHandle;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.IItemType;
import com.ibm.team.repository.common.PermissionDeniedException;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.util.NLS;
import com.ibm.team.workitem.client.IAuditableClient;
import com.ibm.team.workitem.common.model.IDeliverable;
import com.ibm.team.workitem.common.model.IDeliverableHandle;
import com.ibm.team.workitem.common.model.ItemProfile;
import com.ibm.team.workitem.rcp.ui.internal.WorkItemRCPUIPlugin;
import com.ibm.team.workitem.rcp.ui.internal.preview.Messages;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;

public class DeliverableHTMLGenerator
extends HTMLGenerator {
    private static final String CSS_KEY = "GENERAL_CATEGORY_CSS";
    private static final String NONE = Messages.DeliverableHTMLGenerator_NO_VALUE;
    private IDeliverableHandle fDeliverableHandle;

    public DeliverableHTMLGenerator(IDeliverableHandle deliverable) {
        this.fDeliverableHandle = deliverable;
    }

    protected void createControl(HTMLGenerator.Composite composite) {
    }

    public void generate(HashMap headDefinitions, StringBuffer buffer, IDomainAdapter.Info info) {
        try {
            XMLBuilder builder = new XMLBuilder();
            this.generate(builder);
            buffer.append(builder);
        }
        catch (PermissionDeniedException permissionDeniedException) {
            buffer.append(Messages.DeliverableHTMLGenerator_PERMISSION_DENIED);
        }
        catch (TeamRepositoryException e) {
            WorkItemRCPUIPlugin.getDefault().log(Messages.DeliverableHTMLGenerator_EXCEPTION_RESOLVING_RELEASE, e);
            buffer.append(Messages.DeliverableHTMLGenerator_EXCEPTION_RESOLVING_RELEASE);
        }
        this.generateHead(headDefinitions);
    }

    private void generate(XMLBuilder builder) throws TeamRepositoryException {
        ITeamRepository teamRepository = (ITeamRepository)this.fDeliverableHandle.getOrigin();
        IAuditableClient auditableClient = (IAuditableClient)teamRepository.getClientLibrary(IAuditableClient.class);
        IDeliverable deliverable = (IDeliverable)auditableClient.resolveAuditable((IAuditableHandle)this.fDeliverableHandle, IDeliverable.FULL_PROFILE, null);
        builder.xml("<b>").plain(Messages.DeliverableHTMLGenerator_NAME).xml("</b> ").plain(deliverable.getName()).xml("<br/>");
        String description = deliverable.getHTMLDescription().getXMLText();
        if (description == null || description.length() == 0) {
            description = NONE;
        }
        builder.xml("<b>").plain(Messages.DeliverableHTMLGenerator_DESCRIPTION).xml("</b> ").xml(description).xml("<br/>");
        String creationDate = deliverable.getCreationDate() != null ? DateFormat.getInstance().format((Date)deliverable.getCreationDate()) : NONE;
        builder.xml("<b>").plain(Messages.DeliverableHTMLGenerator_CREATION_DATE).xml("</b> ").plain(creationDate).xml("<br/>");
        String visibility = deliverable.isFiltered() ? Messages.DeliverableHTMLGenerator_VISIBILITY_PROJECT_TEAM : Messages.DeliverableHTMLGenerator_VISIBILITY_PUBLIC;
        builder.xml("<b>").plain(Messages.DeliverableHTMLGenerator_VISIBILITY).xml("</b> ").plain(visibility).xml("<br/>");
        builder.xml("<b>").plain(Messages.DeliverableHTMLGenerator_ARTIFACT).xml("</b> ");
        if (deliverable.getArtifact() != null) {
            this.appendLink(builder, deliverable.getArtifact());
        } else {
            builder.plain(NONE);
        }
    }

    private void appendLink(XMLBuilder builder, IItemHandle artifact) throws TeamRepositoryException {
        URIReference uri;
        String title = null;
        IDomainAdapter adapter = DomainAdapterUtils.getDomainAdapter((Object)artifact);
        if (adapter != null) {
            title = adapter.generateTitle((Object)artifact);
        }
        if (title == null) {
            title = Messages.DeliverableHTMLGenerator_UNRESOLVED;
        }
        boolean deleted = false;
        if (artifact instanceof IAuditableHandle) {
            IAuditable auditable;
            ITeamRepository teamRepository = (ITeamRepository)artifact.getOrigin();
            IAuditableClient auditableClient = (IAuditableClient)teamRepository.getClientLibrary(IAuditableClient.class);
            List resolvedAuditables = auditableClient.resolveAuditablesPermissionAware(Collections.singletonList((IAuditableHandle)artifact), ItemProfile.createProfile((IItemType)artifact.getItemType(), (String[])new String[0]), null);
            IAuditable iAuditable = auditable = !resolvedAuditables.isEmpty() ? (IAuditable)resolvedAuditables.get(0) : null;
            if (auditable == null) {
                title = NLS.bind((String)Messages.DeliverableHTMLGenerator_DELETED_ARTIFACT, (Object)title, (Object[])new Object[0]);
                deleted = true;
            }
        }
        URIReference uRIReference = uri = !deleted ? Hyperlinks.create((Object)artifact, null) : null;
        if (uri == null) {
            builder.plain(title);
            return;
        }
        builder.xml("<a href=\"").plain(uri.getURI().toString()).xml("\">").plain(title).xml("</a>");
    }

    protected void generateHead(HashMap map) {
        if (!map.containsKey(CSS_KEY)) {
            StringBuffer css = new StringBuffer();
            css.append("<style type=\"text/css\">");
            css.append("body { overflow: auto; ").append(MarkupUtil.getFont()).append(" }");
            css.append("</style>");
            map.put(CSS_KEY, css.toString());
        }
    }
}

