/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.rcp.ui.internal.preview;

import com.ibm.team.jface.preview.IDomainAdapter;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IAuditableHandle;
import com.ibm.team.repository.common.PermissionDeniedException;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.workitem.client.IAuditableClient;
import com.ibm.team.workitem.client.IWorkItemClient;
import com.ibm.team.workitem.common.model.ICategory;
import com.ibm.team.workitem.common.model.ICategoryHandle;
import com.ibm.team.workitem.common.model.ItemProfile;
import com.ibm.team.workitem.rcp.ui.internal.WorkItemRCPUIPlugin;
import com.ibm.team.workitem.rcp.ui.internal.preview.CategoryHTMLGenerator;
import com.ibm.team.workitem.rcp.ui.internal.preview.Messages;
import com.ibm.team.workitem.rcp.ui.internal.preview.ResolveDomainAdapter;
import java.util.HashMap;

public class CategoryDomainAdapter
extends ResolveDomainAdapter {
    public String generateContentAsText(Object input) {
        try {
            input = this.resolve(input, ICategory.SMALL_PROFILE);
        }
        catch (PermissionDeniedException permissionDeniedException) {
            return this.permissionDenied();
        }
        if (input instanceof ICategory) {
            return this.resolveHierarchicalName((ICategory)input);
        }
        return "";
    }

    public String generateTitle(Object input) {
        try {
            input = this.resolve(input, ICategory.SMALL_PROFILE);
        }
        catch (PermissionDeniedException permissionDeniedException) {
            return this.permissionDenied();
        }
        if (input instanceof ICategory) {
            return this.resolveHierarchicalName((ICategory)input);
        }
        return "";
    }

    public void generateContentAsHTML(HashMap head, StringBuffer body, Object input, IDomainAdapter.Info info) {
        if (input instanceof ICategoryHandle) {
            new CategoryHTMLGenerator((ICategoryHandle)input).generate(head, body, info);
        }
    }

    public String generateJobInfo(Object input, IDomainAdapter.Info info) {
        return Messages.CategoryDomainAdapter_RESOLVING_CATEGORY;
    }

    private Object resolve(Object input, ItemProfile itemProfile) throws PermissionDeniedException {
        if (input instanceof ICategoryHandle) {
            ICategoryHandle ah = (ICategoryHandle)input;
            try {
                ITeamRepository teamRepository = (ITeamRepository)ah.getOrigin();
                if (teamRepository != null) {
                    IAuditableClient auditableClient = (IAuditableClient)teamRepository.getClientLibrary(IAuditableClient.class);
                    input = auditableClient.resolveAuditable((IAuditableHandle)ah, itemProfile, null);
                }
            }
            catch (PermissionDeniedException x) {
                throw x;
            }
            catch (TeamRepositoryException x) {
                WorkItemRCPUIPlugin.getDefault().log(Messages.CategoryHTMLGenerator_EXCEPTION_RESOLVING_CATEGORY, x);
            }
        }
        return input;
    }

    private String resolveHierarchicalName(ICategory category) {
        try {
            ITeamRepository teamRepository = (ITeamRepository)category.getOrigin();
            IWorkItemClient workItemClient = (IWorkItemClient)teamRepository.getClientLibrary(IWorkItemClient.class);
            return workItemClient.resolveHierarchicalName((ICategoryHandle)category, null);
        }
        catch (TeamRepositoryException x) {
            WorkItemRCPUIPlugin.getDefault().log(Messages.CategoryHTMLGenerator_EXCEPTION_RESOLVING_CATEGORY, x);
            return "";
        }
    }
}

