/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.rcp.ui.internal.navigator;

import com.ibm.team.process.common.IProjectAreaHandle;
import com.ibm.team.process.common.ITeamArea;
import com.ibm.team.process.rcp.ui.teamnavigator.Category;
import com.ibm.team.process.rcp.ui.teamnavigator.Domain;
import com.ibm.team.process.rcp.ui.teamnavigator.DomainSubtreeRoot;
import com.ibm.team.process.rcp.ui.teamnavigator.IProcessAreaCategory;
import com.ibm.team.process.rcp.ui.teamnavigator.IProcessAreaEditorCategory;
import com.ibm.team.workitem.common.query.IQueryDescriptor;
import com.ibm.team.workitem.common.query.IQueryDescriptorHandle;
import com.ibm.team.workitem.rcp.ui.QueriesUI;
import com.ibm.team.workitem.rcp.ui.internal.ImagePool;
import com.ibm.team.workitem.rcp.ui.internal.actions.NewQueryAction;
import com.ibm.team.workitem.rcp.ui.internal.navigator.AbstractQueryFolder;
import com.ibm.team.workitem.rcp.ui.internal.navigator.Messages;
import com.ibm.team.workitem.rcp.ui.internal.navigator.PersonalQueryFolder;
import com.ibm.team.workitem.rcp.ui.internal.navigator.QueriesContentProvider;
import com.ibm.team.workitem.rcp.ui.internal.navigator.QueryDomainLabelProvider;
import com.ibm.team.workitem.rcp.ui.internal.navigator.QueryDomainViewerSorter;
import com.ibm.team.workitem.rcp.ui.internal.navigator.TeamAreaQueryFolder;
import com.ibm.team.workitem.rcp.ui.internal.viewer.ItemComparer;
import com.ibm.team.workitem.rcp.ui.internal.wizards.NewWorkItemWizard;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.IElementComparer;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreePathContentProvider;
import org.eclipse.jface.viewers.ITreePathLabelProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.ui.IWorkbenchPartSite;

public class WorkItemQueryDomain
extends Domain {
    private QueriesContentProvider fContentProvider;
    private IElementComparer fComparer;
    private ViewerSorter fViewerSorter;
    private ITreePathLabelProvider fLabelProvider;

    public boolean open(IWorkbenchPartSite site, IStructuredSelection selection) {
        if (selection.getFirstElement() instanceof IQueryDescriptor) {
            QueriesUI.showQueryResults(site.getWorkbenchWindow(), (IQueryDescriptorHandle)((IQueryDescriptor)selection.getFirstElement()));
            return true;
        }
        return super.open(site, selection);
    }

    public void contributeContextMenuActions(IMenuManager manager, IStructuredSelection selection) {
        if (selection.size() == 1) {
            Object selected = selection.getFirstElement();
            if (selected instanceof DomainSubtreeRoot) {
                Object categoryElement = ((DomainSubtreeRoot)selected).getCategoryElement();
                if (categoryElement instanceof ITeamArea) {
                    categoryElement = ((ITeamArea)categoryElement).getProjectArea();
                }
                IProjectAreaHandle projectAreaHandle = (IProjectAreaHandle)categoryElement;
                MenuManager newMenu = new MenuManager(Messages.WorkItemQueryDomain_NEW_MENU);
                newMenu.add((IAction)new NewWorkItemAction(projectAreaHandle));
                newMenu.add(this.createNewQueryAction(projectAreaHandle, Messages.WorkItemQueryDomain_SUB_NEW_QUERY_ACTION));
                manager.appendToGroup("jazz.new.group", (IContributionItem)newMenu);
            } else if (selected instanceof PersonalQueryFolder || selected instanceof TeamAreaQueryFolder) {
                manager.appendToGroup("jazz.new.group", this.createNewQueryAction((IStructuredSelection)new StructuredSelection(selected), Messages.WorkItemQueryDomain_NEW_QUERY_ACTION));
            }
        }
        super.contributeContextMenuActions(manager, selection);
    }

    private IAction createNewQueryAction(IProjectAreaHandle projectArea, String label) {
        StructuredSelection selection;
        if (this.limitScopeToTeamAreas()) {
            Object[] selectedTeamAreas = this.getConnectedProjectAreaRegistry().getSelectedTeamAreas(projectArea).toArray();
            selection = new StructuredSelection(selectedTeamAreas);
        } else {
            selection = new StructuredSelection((Object)projectArea);
        }
        return this.createNewQueryAction((IStructuredSelection)selection, label);
    }

    private IAction createNewQueryAction(IStructuredSelection selection, String label) {
        NewQueryAction action = new NewQueryAction(this.getWorkbenchPart(), selection);
        action.setText(label);
        action.setImageDescriptor(ImagePool.CREATE_QUERY_ACTION_ICON);
        action.setDisabledImageDescriptor(ImagePool.CREATE_QUERY_DISABLED_ACTION_ICON);
        return action;
    }

    public boolean contains(Object element) {
        return element instanceof AbstractQueryFolder || element instanceof IQueryDescriptor;
    }

    public ITreePathContentProvider getContentProvider() {
        if (this.fContentProvider == null) {
            this.fContentProvider = new QueriesContentProvider(this.getConnectedProjectAreaRegistry(), this.limitScopeToTeamAreas(), false);
        }
        return this.fContentProvider;
    }

    public ViewerSorter getSorter() {
        if (this.fViewerSorter == null) {
            this.fViewerSorter = new QueryDomainViewerSorter();
        }
        return this.fViewerSorter;
    }

    private boolean limitScopeToTeamAreas() {
        Category category = this.getCategory();
        if (category instanceof IProcessAreaEditorCategory) {
            return ((IProcessAreaEditorCategory)category).getProcessArea() instanceof ITeamArea;
        }
        return false;
    }

    public ITreePathLabelProvider getLabelProvider() {
        if (this.fLabelProvider == null) {
            this.fLabelProvider = new QueryDomainLabelProvider();
        }
        return this.fLabelProvider;
    }

    public IElementComparer getComparer() {
        if (this.fComparer == null) {
            this.fComparer = new ItemComparer();
        }
        return this.fComparer;
    }

    public Object getRoot() {
        return this;
    }

    public boolean supportsCategory(Category category) {
        return category instanceof IProcessAreaCategory;
    }

    public void dispose() {
        if (this.fContentProvider != null) {
            this.fContentProvider.dispose();
        }
        this.fContentProvider = null;
        if (this.fLabelProvider != null) {
            this.fLabelProvider.dispose();
        }
        this.fLabelProvider = null;
        super.dispose();
    }

    private class NewWorkItemAction
    extends Action {
        private IProjectAreaHandle fProjectArea;

        public NewWorkItemAction(IProjectAreaHandle projectAreaHandle) {
            super(Messages.WorkItemQueryDomain_SUB_NEW_WORKITEM_ACTION);
            this.setImageDescriptor(ImagePool.WORKITEM_CREATE);
            this.setDisabledImageDescriptor(ImagePool.WORKITEM_CREATE_DISABLED);
            this.fProjectArea = projectAreaHandle;
        }

        public void run() {
            NewWorkItemWizard wizard = new NewWorkItemWizard(this.fProjectArea);
            wizard.init(WorkItemQueryDomain.this.getWorkbenchPart().getSite().getWorkbenchWindow().getWorkbench(), (IStructuredSelection)StructuredSelection.EMPTY);
            WizardDialog dialog = new WizardDialog(WorkItemQueryDomain.this.getShell(), (IWizard)wizard);
            dialog.open();
        }
    }
}

