/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.rcp.ui.internal.navigator;

import com.ibm.team.foundation.rcp.core.IModelAccessor;
import com.ibm.team.process.common.IDevelopmentLine;
import com.ibm.team.process.common.IProjectArea;
import com.ibm.team.process.common.IProjectAreaHandle;
import com.ibm.team.process.common.ITeamArea;
import com.ibm.team.process.common.ITeamAreaHandle;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.workitem.client.IQueryClient;
import com.ibm.team.workitem.common.query.IQueryDescriptor;
import com.ibm.team.workitem.rcp.ui.internal.navigator.AbstractQueryFolder;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TeamAreaQueryFolder
extends AbstractQueryFolder
implements IModelAccessor {
    private final ITeamAreaHandle fTeamAreaHandle;
    private final IProjectArea fProjectArea;
    private final ITeamArea fTeamArea;
    private final IDevelopmentLine fDevLine;

    public static Object createComparisonObject(IProjectAreaHandle projectArea, ITeamAreaHandle teamArea) {
        return new TeamAreaQueryFolder(projectArea, teamArea);
    }

    private TeamAreaQueryFolder(IProjectAreaHandle projectArea, ITeamAreaHandle teamArea) {
        super(projectArea);
        this.fTeamAreaHandle = teamArea;
        this.fProjectArea = null;
        this.fTeamArea = null;
        this.fDevLine = null;
    }

    public TeamAreaQueryFolder(IProjectArea projectArea, ITeamArea teamArea, IDevelopmentLine devLine) {
        super(teamArea.getProjectArea());
        Assert.isNotNull((Object)projectArea);
        this.fProjectArea = projectArea;
        this.fTeamArea = teamArea;
        this.fTeamAreaHandle = teamArea;
        this.fDevLine = devLine;
    }

    public IProjectArea getProjectArea() {
        return this.fProjectArea;
    }

    public ITeamArea getTeamArea() {
        return this.fTeamArea;
    }

    public IDevelopmentLine getDevelopmentLine() {
        return this.fDevLine;
    }

    @Override
    public List<?> fetchFolderContents(IProgressMonitor monitor) throws TeamRepositoryException {
        IQueryClient queryClient = this.getClientLibrary(IQueryClient.class);
        return queryClient.findSharedQueries(this.getProjectAreaHandle(), Collections.singletonList((ITeamAreaHandle)this.fTeamArea.getItemHandle()), "com.ibm.team.workitem.workItemType", IQueryDescriptor.FULL_PROFILE, monitor);
    }

    public boolean equals(Object obj) {
        if (obj instanceof TeamAreaQueryFolder) {
            return ((TeamAreaQueryFolder)obj).fTeamAreaHandle.sameItemId((IItemHandle)this.fTeamAreaHandle);
        }
        return super.equals(obj);
    }

    public int hashCode() {
        return this.getClass().hashCode() ^ this.fTeamAreaHandle.getItemId().hashCode();
    }

    public Object getModelInstance() {
        return this.fTeamArea;
    }

    @Override
    public Object getAdapter(Class adapter) {
        if (adapter.isAssignableFrom(ITeamArea.class)) {
            return this.getTeamArea();
        }
        return super.getAdapter(adapter);
    }
}

