/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.rcp.ui.internal.navigator;

import com.ibm.team.foundation.client.util.FoundationJob;
import com.ibm.team.process.common.IDevelopmentLine;
import com.ibm.team.process.common.IDevelopmentLineHandle;
import com.ibm.team.process.common.IProcessAreaHandle;
import com.ibm.team.process.common.IProjectArea;
import com.ibm.team.process.common.IProjectAreaHandle;
import com.ibm.team.process.common.ITeamArea;
import com.ibm.team.process.common.ITeamAreaHandle;
import com.ibm.team.process.rcp.ui.teamnavigator.DomainSubtreeRoot;
import com.ibm.team.process.rcp.ui.teamnavigator.IConnectedProjectAreaRegistry;
import com.ibm.team.process.rcp.ui.teamnavigator.IConnectedProjectAreaRegistryChangeEvent;
import com.ibm.team.process.rcp.ui.teamnavigator.IConnectedProjectAreaRegistryListener;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IAuditable;
import com.ibm.team.repository.common.IAuditableHandle;
import com.ibm.team.repository.common.IContributorHandle;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.IItemType;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.workitem.client.IAuditableClient;
import com.ibm.team.workitem.client.IQueryListener;
import com.ibm.team.workitem.client.QueryChangeEvent;
import com.ibm.team.workitem.client.QueryEventAdapter;
import com.ibm.team.workitem.client.QueryExecutionStateChangeEvent;
import com.ibm.team.workitem.client.internal.util.ClientUtils;
import com.ibm.team.workitem.client.query.QueryDescriptorEvents;
import com.ibm.team.workitem.common.model.ItemProfile;
import com.ibm.team.workitem.common.query.IAssociation;
import com.ibm.team.workitem.common.query.IAssociations;
import com.ibm.team.workitem.common.query.IQueryDescriptor;
import com.ibm.team.workitem.rcp.ui.internal.WorkItemRCPUIPlugin;
import com.ibm.team.workitem.rcp.ui.internal.navigator.AbstractQueryFolder;
import com.ibm.team.workitem.rcp.ui.internal.navigator.IndividuallySharedQueryFolder;
import com.ibm.team.workitem.rcp.ui.internal.navigator.Messages;
import com.ibm.team.workitem.rcp.ui.internal.navigator.PersonalQueryFolder;
import com.ibm.team.workitem.rcp.ui.internal.navigator.ProjectAreaQueryFolder;
import com.ibm.team.workitem.rcp.ui.internal.navigator.SharedQueryFolder;
import com.ibm.team.workitem.rcp.ui.internal.navigator.TeamAreaQueryFolder;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.AbstractTreeViewer;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.ITreePathContentProvider;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.model.IWorkbenchAdapter;
import org.eclipse.ui.progress.DeferredTreeContentManager;
import org.eclipse.ui.progress.IDeferredWorkbenchAdapter;
import org.eclipse.ui.progress.IElementCollector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QueriesContentProvider
implements ITreePathContentProvider,
ITreeContentProvider,
IDeferredWorkbenchAdapter {
    IConnectedProjectAreaRegistryListener fProjectListener = new IConnectedProjectAreaRegistryListener(){

        public void connectedProjectAreaRegistryChanged(IConnectedProjectAreaRegistryChangeEvent changeEvent) {
            if (QueriesContentProvider.this.fViewer != null) {
                QueriesContentProvider.this.postUpdate(new Runnable(){

                    public void run() {
                        if (QueriesContentProvider.this.fViewer != null) {
                            QueriesContentProvider.this.fViewer.refresh();
                        }
                    }
                });
            }
        }
    };
    private final IConnectedProjectAreaRegistry fConnectedProjectAreaRegistry;
    private final boolean fLimitScopeToTeamAreas;
    private DeferredTreeContentManager fDeferred;
    private AbstractTreeViewer fViewer;
    private QueryChangeListener fChangeListener;

    public QueriesContentProvider(IConnectedProjectAreaRegistry registry, boolean limitScopeToTeamAreas, boolean trackProjectChanges) {
        this.fConnectedProjectAreaRegistry = registry;
        this.fLimitScopeToTeamAreas = limitScopeToTeamAreas;
        this.fChangeListener = new QueryChangeListener();
        if (trackProjectChanges) {
            this.fConnectedProjectAreaRegistry.addListener(this.fProjectListener);
        }
        QueryDescriptorEvents.getInstance().addQueryListener((Object)"com.ibm.team.workitem.query.event.QueryCreated", (IQueryListener)this.fChangeListener);
        QueryDescriptorEvents.getInstance().addQueryListener((Object)"com.ibm.team.workitem.query.event.QueryChanged", (IQueryListener)this.fChangeListener);
        QueryDescriptorEvents.getInstance().addQueryListener((Object)"com.ibm.team.workitem.query.event.QueryDeleted", (IQueryListener)this.fChangeListener);
    }

    public void fetchDeferredChildren(Object object, IElementCollector collector, IProgressMonitor monitor) {
        try {
            try {
                if (object instanceof AbstractQueryFolder) {
                    monitor.beginTask(Messages.QueriesContentProvider_FETCHING_SHARED_QUERIES, 100);
                    AbstractQueryFolder folder = (AbstractQueryFolder)object;
                    List<?> contents = folder.fetchFolderContents((IProgressMonitor)new SubProgressMonitor(monitor, 90));
                    collector.add(contents.toArray(), (IProgressMonitor)new SubProgressMonitor(monitor, 10));
                } else if (object instanceof IProjectAreaHandle[]) {
                    this.fetchProjectAreaRoots((IProjectAreaHandle[])object, collector, monitor);
                }
            }
            catch (TeamRepositoryException e) {
                this.handleException(e);
                monitor.done();
            }
        }
        finally {
            monitor.done();
        }
    }

    private void fetchProjectAreaRoots(IProjectAreaHandle[] handles, IElementCollector collector, IProgressMonitor monitor) {
        monitor.beginTask(Messages.QueriesContentProvider_FETCHING_PROJECT_AREAS, handles.length * 10);
        int i = 0;
        while (i < handles.length) {
            ITeamRepository repository = (ITeamRepository)handles[i].getOrigin();
            IAuditableClient client = (IAuditableClient)repository.getClientLibrary(IAuditableClient.class);
            try {
                IAuditable auditable = client.resolveAuditable((IAuditableHandle)handles[i], ItemProfile.createFullProfile((IItemType)IProjectArea.ITEM_TYPE), (IProgressMonitor)new SubProgressMonitor(monitor, 9));
                collector.add((Object)auditable, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
            }
            catch (TeamRepositoryException e) {
                this.handleException(e);
            }
            ++i;
        }
    }

    public ISchedulingRule getRule(Object object) {
        return null;
    }

    public boolean isContainer() {
        return true;
    }

    public ImageDescriptor getImageDescriptor(Object object) {
        if (object instanceof IWorkbenchAdapter) {
            return ((IWorkbenchAdapter)object).getImageDescriptor(object);
        }
        return null;
    }

    public String getLabel(Object object) {
        if (object instanceof SharedQueryFolder) {
            return Messages.QueriesContentProvider_SHARED_QUERIES_LABEL;
        }
        if (object instanceof PersonalQueryFolder) {
            return Messages.QueriesContentProvider_MY_QUERIES_LABEL;
        }
        if (object instanceof TeamAreaQueryFolder) {
            return Messages.QueriesContentProvider_TEAM_QUERIES_LABEL;
        }
        if (object instanceof IProcessAreaHandle[]) {
            return Messages.QueriesContentProvider_PROJECT_AREAS_LABEL;
        }
        if (object instanceof ProjectAreaQueryFolder) {
            return Messages.QueriesContentProvider_PROJECT_QUERIES;
        }
        if (object instanceof IndividuallySharedQueryFolder) {
            return Messages.QueriesContentProvider_INDIVIDUALLY_SHARED_QUERIES;
        }
        return null;
    }

    public Object[] getChildren(TreePath parentPath) {
        Object parentElement = parentPath.getLastSegment();
        if (parentElement instanceof DomainSubtreeRoot || parentElement instanceof IProjectAreaHandle) {
            return this.getElements(parentElement);
        }
        if (parentElement instanceof IProjectAreaHandle[]) {
            return (Object[])parentElement;
        }
        return this.fDeferred.getChildren(parentElement);
    }

    public Object[] getChildren(Object parentElement) {
        return this.getChildren(new TreePath(new Object[]{parentElement}));
    }

    public TreePath[] getParents(Object element) {
        return new TreePath[0];
    }

    public Object getParent(Object element) {
        return null;
    }

    private List<TreePath> getPaths(IQueryDescriptor queryDescriptor, IProgressMonitor monitor, boolean comparisonOnly) throws TeamRepositoryException {
        ITeamRepository repository = (ITeamRepository)queryDescriptor.getOrigin();
        ArrayList<TreePath> paths = new ArrayList<TreePath>(1);
        if (queryDescriptor.isShared()) {
            List associations = queryDescriptor.getAssociations().getContents();
            for (IAssociation association : associations) {
                if (association.getTarget() instanceof ITeamAreaHandle) {
                    paths.add(this.createTeamAreaPath(queryDescriptor, (ITeamAreaHandle)association.getTarget(), monitor, comparisonOnly));
                    continue;
                }
                if (association.getTarget() instanceof IContributorHandle) {
                    if (association.getTarget().sameItemId((IItemHandle)repository.loggedInContributor())) {
                        paths.add(this.createIndividualPath(queryDescriptor));
                    }
                    if (!queryDescriptor.getCreator().sameItemId((IItemHandle)repository.loggedInContributor()) || queryDescriptor.getAssociations().filterTargets(ITeamAreaHandle.class).size() != 0) continue;
                    paths.add(this.createPersonalPath(queryDescriptor));
                    continue;
                }
                if (!(association.getTarget() instanceof IProjectAreaHandle)) continue;
                paths.add(this.createProjectAreaPath(queryDescriptor));
            }
        } else if (queryDescriptor.getCreator().sameItemId((IItemHandle)repository.loggedInContributor())) {
            paths.add(this.createPersonalPath(queryDescriptor));
        }
        return paths;
    }

    private TreePath createTeamAreaPath(IQueryDescriptor descriptor, ITeamAreaHandle teamAreaHandle, IProgressMonitor monitor, boolean comparisonOnly) throws TeamRepositoryException {
        ArrayList<Object> segments = new ArrayList<Object>(3);
        segments.add(this.createSharedQueryFolder(descriptor.getProjectArea()));
        if (comparisonOnly) {
            segments.add(TeamAreaQueryFolder.createComparisonObject(descriptor.getProjectArea(), teamAreaHandle));
        } else {
            segments.add(this.createResolvedTeamAreaFolder(descriptor.getProjectArea(), teamAreaHandle, monitor));
        }
        segments.add(descriptor);
        return new TreePath(segments.toArray());
    }

    private TeamAreaQueryFolder createResolvedTeamAreaFolder(IProjectAreaHandle projectAreaHandle, ITeamAreaHandle teamAreaHandle, IProgressMonitor monitor) throws TeamRepositoryException {
        IAuditableClient auditableClient = (IAuditableClient)ClientUtils.getClientLibrary((IItemHandle)projectAreaHandle, IAuditableClient.class);
        IProjectArea projectArea = (IProjectArea)auditableClient.resolveAuditable((IAuditableHandle)projectAreaHandle, ItemProfile.PROJECT_AREA_DEFAULT, monitor);
        ITeamArea teamArea = (ITeamArea)auditableClient.resolveAuditable((IAuditableHandle)teamAreaHandle, ItemProfile.TEAM_AREA_DEFAULT, monitor);
        IDevelopmentLineHandle devLineHandle = projectArea.getTeamAreaHierarchy().getDevelopmentLine(teamAreaHandle);
        IDevelopmentLine devLine = null;
        if (devLineHandle != null) {
            devLine = (IDevelopmentLine)auditableClient.resolveAuditable((IAuditableHandle)devLineHandle, ItemProfile.DEVELOPMENT_LINE_DEFAULT, monitor);
        }
        return new TeamAreaQueryFolder(projectArea, teamArea, devLine);
    }

    private TreePath createProjectAreaPath(IQueryDescriptor descriptor) {
        ArrayList<Object> segments = new ArrayList<Object>(3);
        segments.add(this.createSharedQueryFolder(descriptor.getProjectArea()));
        segments.add(ProjectAreaQueryFolder.createComparisonObject(descriptor.getProjectArea()));
        segments.add(descriptor);
        return new TreePath(segments.toArray());
    }

    private TreePath createPersonalPath(IQueryDescriptor descriptor) {
        PersonalQueryFolder personalFolder = new PersonalQueryFolder(descriptor.getProjectArea());
        return new TreePath(new Object[]{personalFolder, descriptor});
    }

    private TreePath createIndividualPath(IQueryDescriptor descriptor) {
        ArrayList<AbstractQueryFolder> segments = new ArrayList<AbstractQueryFolder>(3);
        segments.add(this.createSharedQueryFolder(descriptor.getProjectArea()));
        segments.add(new IndividuallySharedQueryFolder(descriptor.getProjectArea()));
        segments.add((AbstractQueryFolder)descriptor);
        return new TreePath(segments.toArray());
    }

    private SharedQueryFolder createSharedQueryFolder(IProjectAreaHandle projectArea) {
        return new SharedQueryFolder(projectArea, this.fConnectedProjectAreaRegistry, this.fLimitScopeToTeamAreas);
    }

    public boolean hasChildren(TreePath elementPath) {
        Object element = elementPath.getLastSegment();
        if (element instanceof DomainSubtreeRoot || element instanceof IProjectAreaHandle || element instanceof IProjectAreaHandle[]) {
            return true;
        }
        return element instanceof AbstractQueryFolder || element instanceof TeamAreaQueryFolder;
    }

    public boolean hasChildren(Object element) {
        return this.hasChildren(new TreePath(new Object[]{element}));
    }

    public Object[] getElements(Object inputElement) {
        IProjectAreaHandle projectAreaHandle = null;
        if (inputElement instanceof DomainSubtreeRoot) {
            Object categoryElement = ((DomainSubtreeRoot)inputElement).getCategoryElement();
            if (categoryElement instanceof ITeamArea) {
                ITeamArea teamArea = (ITeamArea)categoryElement;
                projectAreaHandle = teamArea.getProjectArea();
            }
            if (categoryElement instanceof IProjectAreaHandle) {
                projectAreaHandle = (IProjectAreaHandle)categoryElement;
            }
        } else if (inputElement instanceof IProjectAreaHandle) {
            projectAreaHandle = (IProjectAreaHandle)inputElement;
        }
        if (projectAreaHandle != null) {
            ArrayList<AbstractQueryFolder> roots = new ArrayList<AbstractQueryFolder>();
            if (!this.fLimitScopeToTeamAreas) {
                roots.add(new PersonalQueryFolder(projectAreaHandle));
            }
            roots.add(new SharedQueryFolder(projectAreaHandle, this.fConnectedProjectAreaRegistry, this.fLimitScopeToTeamAreas));
            return roots.toArray();
        }
        if (inputElement instanceof IProjectAreaHandle[]) {
            return this.getChildren(inputElement);
        }
        return new Object[0];
    }

    public void dispose() {
        QueryDescriptorEvents.getInstance().removeQueryListener((IQueryListener)this.fChangeListener);
        this.fConnectedProjectAreaRegistry.removeListener(this.fProjectListener);
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        this.fViewer = (AbstractTreeViewer)viewer;
        this.fDeferred = new DeferredTreeContentManager(this, this.fViewer){

            protected IDeferredWorkbenchAdapter getAdapter(Object element) {
                IDeferredWorkbenchAdapter adapter = super.getAdapter(element);
                if (adapter == null && QueriesContentProvider.this.hasChildren(element)) {
                    return QueriesContentProvider.this;
                }
                return adapter;
            }
        };
    }

    protected void handleException(TeamRepositoryException e) {
        Status status = new Status(2, "com.ibm.team.workitem.rcp.ui", 2, Messages.QueriesContentProvider_EXCEPTION_RETRIEVING_DATA, (Throwable)e);
        WorkItemRCPUIPlugin.getDefault().log((IStatus)status);
    }

    private void handleDeleted(IQueryDescriptor queryDescriptor) {
        try {
            this.remove(this.getPaths(queryDescriptor, null, true));
        }
        catch (TeamRepositoryException teamRepositoryException) {}
    }

    private void handleChanged(IQueryDescriptor queryDescriptor, IQueryDescriptor beforeState) {
        IAssociations currentSharing = queryDescriptor.getAssociations();
        IAssociations previousSharing = beforeState.getAssociations();
        if (currentSharing != null && currentSharing.equals(previousSharing)) {
            this.update(queryDescriptor);
        } else {
            this.handleDeleted(beforeState);
            this.handleCreated(queryDescriptor);
        }
    }

    private void handleCreated(final IQueryDescriptor queryDescriptor) {
        IAssociations sharing = queryDescriptor.getAssociations();
        if (sharing != null && sharing.filterTargets(ITeamAreaHandle.class).size() > 0) {
            new FoundationJob(Messages.QueriesContentProvider_RESOLVING_TEAMS){

                protected IStatus runProtected(IProgressMonitor monitor) throws Exception {
                    QueriesContentProvider.this.add(QueriesContentProvider.this.getPaths(queryDescriptor, monitor, false));
                    return Status.OK_STATUS;
                }
            }.schedule();
        } else {
            try {
                this.add(this.getPaths(queryDescriptor, null, true));
            }
            catch (TeamRepositoryException teamRepositoryException) {}
        }
    }

    private void update(final IQueryDescriptor element) {
        if (element == null) {
            return;
        }
        this.postUpdate(new Runnable(){

            public void run() {
                if (QueriesContentProvider.this.fViewer != null) {
                    QueriesContentProvider.this.fViewer.update((Object)element, null);
                }
            }
        });
    }

    private void add(final List<TreePath> paths) {
        if (paths.isEmpty()) {
            return;
        }
        this.postUpdate(new Runnable(){

            public void run() {
                if (QueriesContentProvider.this.fViewer != null) {
                    for (TreePath path : paths) {
                        Object sharedFolder;
                        Object query = path.getLastSegment();
                        Object teamAreaFolder = path.getSegmentCount() > 1 ? path.getSegment(path.getSegmentCount() - 2) : null;
                        Object object = sharedFolder = path.getSegmentCount() > 2 ? path.getSegment(path.getSegmentCount() - 3) : null;
                        if (QueriesContentProvider.this.fLimitScopeToTeamAreas) {
                            if (sharedFolder == null) continue;
                            this.add(sharedFolder, query);
                            continue;
                        }
                        if (sharedFolder != null && QueriesContentProvider.this.fViewer.testFindItem(teamAreaFolder) == null) {
                            this.add(sharedFolder, teamAreaFolder);
                        }
                        this.add(teamAreaFolder, query);
                    }
                }
            }

            private void add(Object root, Object element) {
                QueriesContentProvider.this.fViewer.add(root, element);
                QueriesContentProvider.this.fViewer.setExpandedState(root, true);
            }
        });
    }

    private void remove(final List<TreePath> paths) {
        if (paths.isEmpty()) {
            return;
        }
        this.postUpdate(new Runnable(){

            public void run() {
                if (QueriesContentProvider.this.fViewer != null) {
                    for (TreePath path : paths) {
                        TreeItem widget;
                        Object query = path.getLastSegment();
                        Object teamAreaFolder = path.getSegmentCount() > 1 ? path.getSegment(path.getSegmentCount() - 2) : null;
                        QueriesContentProvider.this.fViewer.remove(query);
                        if (QueriesContentProvider.this.fLimitScopeToTeamAreas || teamAreaFolder == null || (widget = (TreeItem)QueriesContentProvider.this.fViewer.testFindItem(teamAreaFolder)) == null || widget.isDisposed() || widget.getItemCount() != 0) continue;
                        QueriesContentProvider.this.fViewer.remove(teamAreaFolder);
                        return;
                    }
                }
            }
        });
    }

    private void postUpdate(Runnable runnable) {
        if (this.fViewer == null) {
            return;
        }
        Control tree = this.fViewer.getControl();
        if (!tree.isDisposed()) {
            tree.getDisplay().syncExec(runnable);
        }
    }

    private class QueryChangeListener
    extends QueryEventAdapter {
        private QueryChangeListener() {
        }

        protected void changed(QueryChangeEvent event) {
            if ("com.ibm.team.workitem.query.event.QueryCreated".equals(event.getEventType())) {
                QueriesContentProvider.this.handleCreated(event.getQueryDescriptor());
            } else if ("com.ibm.team.workitem.query.event.QueryChanged".equals(event.getEventType())) {
                QueriesContentProvider.this.handleChanged(event.getQueryDescriptor(), event.getBeforeState());
            } else if ("com.ibm.team.workitem.query.event.QueryDeleted".equals(event.getEventType())) {
                QueriesContentProvider.this.handleDeleted(event.getQueryDescriptor());
            }
        }

        protected void executionStateChanged(QueryExecutionStateChangeEvent event) {
        }
    }
}

