/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.rcp.ui.internal.feed.section;

import com.ibm.team.feed.core.ClientFeedUtils;
import com.ibm.team.feed.core.model.NewsItem;
import com.ibm.team.feed.ui.internal.itemview.Mappings;
import com.ibm.team.foundation.common.internal.util.Dates;
import com.ibm.team.foundation.rcp.core.IDateProvider;
import com.ibm.team.jface.GenericAggregationBin;
import com.ibm.team.jface.itemview.IItemViewUIAdvisor;
import com.ibm.team.jface.itemview.ItemViewUIConfigurer;
import com.ibm.team.jface.itemview.ItemViewerFilter;
import com.ibm.team.jface.itemview.ItemViewerSorter;
import com.ibm.team.jface.itemview.MarkupItemView;
import com.ibm.team.workitem.rcp.ui.internal.feed.section.Messages;
import com.ibm.team.workitem.rcp.ui.internal.feed.section.TeamFilter;
import java.util.Date;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.viewers.ViewerSorter;

public class WorkItemTypesItemViewUIAdvisor
implements IItemViewUIAdvisor {
    static final int TEAM_FILTER_TEAM = 0;
    static final int TEAM_FILTER_OWNER = 1;
    static final int TEAM_FILTER_CREATOR = 2;
    static final int TEAM_FILTER_SUBSCRIBER = 3;

    public void configure(ItemViewUIConfigurer configurer) {
        configurer.addFilter(this.createTeamFilter("com.ibm.team.feed.ui.internal.itemview.TeamFilter", Messages.WorkItemTypesItemViewUIAdvisor_TEAM, 0, 0));
        configurer.addFilter(this.createTeamFilter("com.ibm.team.feed.ui.internal.itemview.OwnerFilter", Messages.WorkItemTypesItemViewUIAdvisor_OWNER, 1, 1));
        configurer.addFilter(this.createTeamFilter("com.ibm.team.feed.ui.internal.itemview.CreatorFilter", Messages.WorkItemTypesItemViewUIAdvisor_CREATOR, 2, 2));
        configurer.addFilter(this.createTeamFilter("com.ibm.team.feed.ui.internal.itemview.SubscriberFilter", Messages.WorkItemTypesItemViewUIAdvisor_SUBSCRIBER, 3, 3));
        configurer.addSorter(this.createRelationSorter("com.ibm.team.feed.ui.internal.itemview.RelationSorter", Messages.WorkItemTypesItemViewUIAdvisor_RELATION));
    }

    private ItemViewerFilter createTeamFilter(String id, String name, int type, int sortOrder) {
        TeamFilter filter = new TeamFilter(type);
        return new ItemViewerFilter((ViewerFilter)filter, id, name, 2, sortOrder);
    }

    private ItemViewerSorter createRelationSorter(String id, String name) {
        ViewerSorter sorter = new ViewerSorter(){

            public int compare(Viewer viewer, Object e1, Object e2) {
                if (e1 instanceof GenericAggregationBin) {
                    e1 = ((GenericAggregationBin)e1).getMostRecent();
                }
                if (e2 instanceof GenericAggregationBin) {
                    e2 = ((GenericAggregationBin)e2).getMostRecent();
                }
                if (e1 instanceof NewsItem && e2 instanceof NewsItem) {
                    int rel2;
                    NewsItem item1 = (NewsItem)e1;
                    NewsItem item2 = (NewsItem)e2;
                    int rel1 = Mappings.getSubjectRelationshipValue((String)ClientFeedUtils.getInstance().getRelation(item1));
                    if (rel1 == (rel2 = Mappings.getSubjectRelationshipValue((String)ClientFeedUtils.getInstance().getRelation(item2)))) {
                        return this.compareByDate(viewer, e1, e2);
                    }
                    if (rel1 == -1) {
                        return 1;
                    }
                    return rel1 < rel2 ? -1 : 1;
                }
                return super.compare(viewer, e1, e2);
            }

            private int compareByDate(Viewer viewer, Object e1, Object e2) {
                IDateProvider dateProvider1 = MarkupItemView.getDateProvider((Object)e1);
                IDateProvider dateProvider2 = MarkupItemView.getDateProvider((Object)e2);
                if (dateProvider1 != null && dateProvider2 != null) {
                    Date date1 = dateProvider1.getDate();
                    Date date2 = dateProvider2.getDate();
                    if (date2 != null) {
                        return Dates.compareTo((Date)date2, (Date)date1);
                    }
                }
                return super.compare(viewer, e1, e2);
            }
        };
        return new ItemViewerSorter(sorter, id, name);
    }
}

