/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.rcp.ui.internal.feed;

import com.ibm.team.feed.core.FeedManager;
import com.ibm.team.feed.core.model.Channel;
import com.ibm.team.foundation.client.util.FoundationJob;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.client.ITeamRepositoryService;
import com.ibm.team.repository.client.TeamPlatform;
import com.ibm.team.repository.client.util.IEvent;
import com.ibm.team.repository.client.util.IListener;
import com.ibm.team.workitem.rcp.ui.internal.WorkItemRCPUIPlugin;
import com.ibm.team.workitem.rcp.ui.internal.feed.AbstractFeedMigrationHandler;
import com.ibm.team.workitem.rcp.ui.internal.feed.Messages;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.osgi.service.prefs.BackingStoreException;
import org.osgi.service.prefs.Preferences;

public class FeedsMigration {
    private static final String DISABLE_MIGRATION = "com.ibm.feeds.disableMigration";
    private static final String PREFS_ID = "migrated_repositories";
    private static final String REPOCOUNT = "repocount";
    private static final String REPO = "repo";
    private static final String REPOURL = "repourl";
    private Channel[] fChannels;
    private AbstractFeedMigrationHandler[] fMigrationHandlers = new AbstractFeedMigrationHandler[0];
    protected IListener fListener;
    private Job fJob;
    private boolean fIsDisabled;

    public FeedsMigration(Channel[] channels) {
        Arrays.sort(this.fMigrationHandlers, new Comparator<AbstractFeedMigrationHandler>(){

            @Override
            public int compare(AbstractFeedMigrationHandler o1, AbstractFeedMigrationHandler o2) {
                return o1.getMigrationId() - o2.getMigrationId();
            }
        });
        this.fListener = new IListener(){

            public void handleEvents(List events) {
                for (IEvent event : events) {
                    final ITeamRepository teamRepository = (ITeamRepository)event.getEventSource();
                    if (!teamRepository.loggedIn() || teamRepository.getErrorState() != 0) continue;
                    teamRepository.removeGenericListener((Object)"state", FeedsMigration.this.fListener);
                    teamRepository.removeGenericListener((Object)"error_state", FeedsMigration.this.fListener);
                    FoundationJob job = new FoundationJob(Messages.FeedsMigration_MIGRATING_FEEDS){

                        protected IStatus runProtected(IProgressMonitor monitor) {
                            AbstractFeedMigrationHandler[] abstractFeedMigrationHandlerArray = FeedsMigration.this.fMigrationHandlers;
                            int n = abstractFeedMigrationHandlerArray.length;
                            int n2 = 0;
                            while (n2 < n) {
                                AbstractFeedMigrationHandler handler = abstractFeedMigrationHandlerArray[n2];
                                if (!handler.getMigratedRepositories().contains(teamRepository.getRepositoryURI())) {
                                    FeedsMigration.this.migrate(handler, teamRepository);
                                }
                                ++n2;
                            }
                            return Status.OK_STATUS;
                        }
                    };
                    job.setSystem(true);
                    job.schedule();
                }
            }
        };
        this.fChannels = channels;
    }

    public FeedsMigration() {
        Arrays.sort(this.fMigrationHandlers, new /* invalid duplicate definition of identical inner class */);
        this.fListener = new /* invalid duplicate definition of identical inner class */;
    }

    public void start() {
        String property = System.getProperty(DISABLE_MIGRATION);
        if (property != null && property.length() > 0) {
            this.fIsDisabled = Boolean.parseBoolean(property.trim());
            if (this.fIsDisabled) {
                return;
            }
        }
        if (this.fMigrationHandlers.length == 0) {
            return;
        }
        this.fJob = new FoundationJob(Messages.FeedsMigration_MIGRATING_FEEDS){

            protected IStatus runProtected(IProgressMonitor monitor) {
                FeedsMigration.this.readPrefs();
                ITeamRepository[] teamRepositories = TeamPlatform.getTeamRepositoryService().getTeamRepositories();
                TeamPlatform.getTeamRepositoryService().addRepositoryServiceListener(new ITeamRepositoryService.IRepositoryServiceListener(){

                    public void addedRepository(ITeamRepository repository) {
                        AbstractFeedMigrationHandler[] abstractFeedMigrationHandlerArray = FeedsMigration.this.fMigrationHandlers;
                        int n = abstractFeedMigrationHandlerArray.length;
                        int n2 = 0;
                        while (n2 < n) {
                            AbstractFeedMigrationHandler handler = abstractFeedMigrationHandlerArray[n2];
                            handler.getMigratedRepositories().add(repository.getRepositoryURI());
                            ++n2;
                        }
                    }

                    public void removedRepository(ITeamRepository repository) {
                        repository.removeGenericListener((Object)"state", (this).FeedsMigration.this.fListener);
                        repository.removeGenericListener((Object)"error_state", (this).FeedsMigration.this.fListener);
                    }
                });
                AbstractFeedMigrationHandler[] abstractFeedMigrationHandlerArray = FeedsMigration.this.fMigrationHandlers;
                int n = abstractFeedMigrationHandlerArray.length;
                int n2 = 0;
                while (n2 < n) {
                    AbstractFeedMigrationHandler handler = abstractFeedMigrationHandlerArray[n2];
                    ITeamRepository[] iTeamRepositoryArray = teamRepositories;
                    int n3 = teamRepositories.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        ITeamRepository teamRepository = iTeamRepositoryArray[n4];
                        if (!handler.getMigratedRepositories().contains(teamRepository.getRepositoryURI())) {
                            if (teamRepository.loggedIn() && teamRepository.getErrorState() == 0) {
                                FeedsMigration.this.migrate(handler, teamRepository);
                            } else {
                                teamRepository.addGenericListener((Object)"state", FeedsMigration.this.fListener);
                                teamRepository.addGenericListener((Object)"error_state", FeedsMigration.this.fListener);
                            }
                        }
                        ++n4;
                    }
                    ++n2;
                }
                FeedsMigration.this.fJob = null;
                return Status.OK_STATUS;
            }
        };
        this.fJob.setSystem(true);
        this.fJob.schedule();
    }

    public void stop() {
        if (this.fIsDisabled || this.fMigrationHandlers.length == 0) {
            return;
        }
        this.join();
        try {
            this.storePrefs();
        }
        catch (BackingStoreException e) {
            WorkItemRCPUIPlugin.getDefault().log(Messages.FeedsMigration_ERROR_STORING_MIGRATION_STATE, e);
        }
    }

    public void join() {
        if (this.fJob != null) {
            try {
                this.fJob.join();
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    private void migrate(AbstractFeedMigrationHandler handler, ITeamRepository repository) {
        if (this.fChannels == null) {
            this.fChannels = FeedManager.getDefault().getChannels();
        }
        handler.getMigratedRepositories().add(repository.getRepositoryURI());
        handler.migrate(repository, this.fChannels);
    }

    private void readPrefs() {
        AbstractFeedMigrationHandler[] abstractFeedMigrationHandlerArray = this.fMigrationHandlers;
        int n = this.fMigrationHandlers.length;
        int n2 = 0;
        while (n2 < n) {
            AbstractFeedMigrationHandler handler = abstractFeedMigrationHandlerArray[n2];
            String migrationId = handler.getMigrationId() == 0 ? "" : Integer.toString(handler.getMigrationId());
            HashSet<String> migratedRepositories = new HashSet<String>();
            handler.setMigratedRepositories(migratedRepositories);
            Preferences serverPrefs = new InstanceScope().getNode("com.ibm.team.workitem.rcp.ui").node(PREFS_ID + migrationId);
            if (serverPrefs == null) {
                return;
            }
            int count = serverPrefs.getInt(REPOCOUNT, 0);
            int i = 0;
            while (i < count) {
                Preferences repoPref = serverPrefs.node(REPO + i);
                String url = repoPref.get(REPOURL, null);
                if (url != null) {
                    migratedRepositories.add(url);
                }
                ++i;
            }
            ++n2;
        }
    }

    private void storePrefs() throws BackingStoreException {
        AbstractFeedMigrationHandler[] abstractFeedMigrationHandlerArray = this.fMigrationHandlers;
        int n = this.fMigrationHandlers.length;
        int n2 = 0;
        while (n2 < n) {
            AbstractFeedMigrationHandler handler = abstractFeedMigrationHandlerArray[n2];
            String migrationId = handler.getMigrationId() == 0 ? "" : Integer.toString(handler.getMigrationId());
            Preferences serverPrefs = new InstanceScope().getNode("com.ibm.team.workitem.rcp.ui").node(PREFS_ID + migrationId);
            if (serverPrefs == null) {
                return;
            }
            serverPrefs.removeNode();
            serverPrefs = new InstanceScope().getNode("com.ibm.team.workitem.rcp.ui").node(PREFS_ID + migrationId);
            serverPrefs.putInt(REPOCOUNT, handler.getMigratedRepositories().size());
            int i = 0;
            for (String repoUrl : handler.getMigratedRepositories()) {
                Preferences repoPref = serverPrefs.node(REPO + i++);
                repoPref.put(REPOURL, repoUrl);
            }
            serverPrefs.flush();
            ++n2;
        }
    }
}

