/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.rcp.ui.internal.explorer.view;

import com.ibm.team.foundation.common.text.XMLString;
import com.ibm.team.process.common.IProjectAreaHandle;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.IItemType;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.workitem.client.ClientEvaluationContext;
import com.ibm.team.workitem.client.IAuditableClient;
import com.ibm.team.workitem.client.internal.util.ClientUtils;
import com.ibm.team.workitem.client.internal.util.ResolvedWorkItem;
import com.ibm.team.workitem.common.IAuditableCommon;
import com.ibm.team.workitem.common.expression.AttributeExpression;
import com.ibm.team.workitem.common.expression.Expression;
import com.ibm.team.workitem.common.expression.IQueryableAttribute;
import com.ibm.team.workitem.common.expression.IQueryableAttributeFactory;
import com.ibm.team.workitem.common.expression.ProgressExpressionVisitor;
import com.ibm.team.workitem.common.expression.QueryableAttributes;
import com.ibm.team.workitem.common.expression.Term;
import com.ibm.team.workitem.common.expression.VariableAttributeExpression;
import com.ibm.team.workitem.common.expression.variables.IEvaluationContext;
import com.ibm.team.workitem.common.model.AttributeOperation;
import com.ibm.team.workitem.common.model.IWorkItem;
import com.ibm.team.workitem.rcp.ui.internal.WorkItemRCPUIPlugin;
import com.ibm.team.workitem.rcp.ui.internal.explorer.view.Messages;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.viewers.AcceptAllFilter;
import org.eclipse.jface.viewers.IFilter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WorkItemFilter
implements IFilter {
    public static final String ID = "WorkItemFilter";
    private final Expression fExpression;
    private Map<String, IQueryableAttribute> fAttributeMap;
    private String fFilterText;

    public static IFilter createAcceptAllFilter() {
        return AcceptAllFilter.getInstance();
    }

    public static IFilter createSummaryOrDescriptionFilter(IProjectAreaHandle projectArea, String filter, IProgressMonitor monitor) throws TeamRepositoryException {
        IAuditableClient auditableClient = (IAuditableClient)ClientUtils.getClientLibrary((IItemHandle)projectArea, IAuditableClient.class);
        IQueryableAttributeFactory factory = QueryableAttributes.getFactory((IItemType)IWorkItem.ITEM_TYPE);
        IQueryableAttribute summaryAttribute = factory.findAttribute(projectArea, IWorkItem.SUMMARY_PROPERTY, (IAuditableCommon)auditableClient, monitor);
        IQueryableAttribute descriptionAttribute = factory.findAttribute(projectArea, IWorkItem.DESCRIPTION_PROPERTY, (IAuditableCommon)auditableClient, monitor);
        String htmlFilter = XMLString.createFromPlainText((String)filter).getXMLText();
        AttributeExpression summaryExpression = new AttributeExpression(summaryAttribute, AttributeOperation.CONTAINS, (Object)htmlFilter);
        AttributeExpression descriptionExpression = new AttributeExpression(descriptionAttribute, AttributeOperation.CONTAINS, (Object)htmlFilter);
        Term term = new Term(1, new Expression[]{summaryExpression, descriptionExpression});
        return WorkItemFilter.createFilter(filter, projectArea, (Expression)term, monitor);
    }

    public static IFilter createFilter(String filterText, IProjectAreaHandle projectArea, Expression expression, IProgressMonitor monitor) throws TeamRepositoryException {
        AttributeVisitor visitor = new AttributeVisitor(projectArea);
        expression.accept((ProgressExpressionVisitor)visitor, monitor);
        return new WorkItemFilter(filterText, expression, visitor.getAttributeMap());
    }

    private WorkItemFilter(String filterText, Expression expression, Map<String, IQueryableAttribute> attributeMap) {
        Assert.isNotNull((Object)expression);
        this.fFilterText = filterText;
        this.fExpression = expression;
        this.fAttributeMap = attributeMap;
    }

    public boolean select(Object toTest) {
        if (toTest instanceof ResolvedWorkItem) {
            return this.matches(((ResolvedWorkItem)toTest).getWorkItem(), this.fExpression);
        }
        if (toTest instanceof IWorkItem) {
            return this.matches((IWorkItem)toTest, this.fExpression);
        }
        return true;
    }

    public String getFilterText() {
        return this.fFilterText;
    }

    private IQueryableAttribute getAttribute(String identifier) {
        return this.fAttributeMap.get(identifier);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean matches(IWorkItem item, Expression expr) {
        try {
            if (expr instanceof AttributeExpression) {
                Object left;
                AttributeExpression ae = (AttributeExpression)expr;
                if ("all".equals(ae.getAttributeIdentifier())) {
                    left = String.valueOf(item.getHTMLSummary().getXMLText()) + "\n" + item.getHTMLDescription().getXMLText();
                } else {
                    IQueryableAttribute attribute = this.getAttribute(ae.getAttributeIdentifier());
                    left = attribute.getValue((Object)item);
                }
                Object right = ae.getResolvedValue((IEvaluationContext)new ClientEvaluationContext(item.getProjectArea()), null);
                return ae.getOperation().evaluate(left, right);
            }
            if (!(expr instanceof Term)) throw new IllegalArgumentException(Messages.WorkItemFilter_UNEXPECTED_TYPE);
            Term term = (Term)expr;
            switch (term.getOperator()) {
                case OR: {
                    Expression expression;
                    Iterator iterator = term.getExpressions().iterator();
                    do {
                        if (iterator.hasNext()) continue;
                        return false;
                    } while (!this.matches(item, expression = (Expression)iterator.next()));
                    return true;
                }
                case AND: {
                    Expression expression;
                    Iterator iterator = term.getExpressions().iterator();
                    do {
                        if (iterator.hasNext()) continue;
                        return true;
                    } while (this.matches(item, expression = (Expression)iterator.next()));
                    return false;
                }
            }
            throw new IllegalArgumentException(Messages.WorkItemFilter_UNEXPECTED_OPERATOR);
        }
        catch (TeamRepositoryException e) {
            WorkItemRCPUIPlugin.getDefault().log(Messages.WorkItemFilter_ERROR_MATCHING, e);
            return false;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class AttributeVisitor
    extends ProgressExpressionVisitor {
        private Map<String, IQueryableAttribute> fAttributeMap = new HashMap<String, IQueryableAttribute>();
        private ClientEvaluationContext fContext;

        public AttributeVisitor(IProjectAreaHandle projectArea) {
            this.fContext = new ClientEvaluationContext(projectArea);
        }

        public Map<String, IQueryableAttribute> getAttributeMap() {
            return this.fAttributeMap;
        }

        public boolean visit(AttributeExpression expression, IProgressMonitor monitor) throws TeamRepositoryException {
            this.handleExpression(expression, monitor);
            return super.visit(expression, monitor);
        }

        public boolean visit(VariableAttributeExpression expression, IProgressMonitor monitor) throws TeamRepositoryException {
            this.handleExpression((AttributeExpression)expression, monitor);
            return super.visit(expression, monitor);
        }

        private void handleExpression(AttributeExpression expression, IProgressMonitor monitor) throws TeamRepositoryException {
            IQueryableAttribute attribute = expression.getAttribute((IEvaluationContext)this.fContext, monitor);
            this.fAttributeMap.put(expression.getAttributeIdentifier(), attribute);
        }
    }
}

