/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.rcp.ui.internal.explorer.view;

import com.ibm.icu.text.Collator;
import com.ibm.team.process.common.IProjectAreaHandle;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.workitem.common.model.IWorkItem;
import com.ibm.team.workitem.rcp.core.internal.queries.QueryViewColumn;
import com.ibm.team.workitem.rcp.ui.internal.ImagePool;
import com.ibm.team.workitem.rcp.ui.internal.WorkItemRCPUIPlugin;
import com.ibm.team.workitem.rcp.ui.internal.actions.ActionDelegateAdapter;
import com.ibm.team.workitem.rcp.ui.internal.actions.CopyToClipboardAction;
import com.ibm.team.workitem.rcp.ui.internal.actions.EditQueryAction;
import com.ibm.team.workitem.rcp.ui.internal.actions.NewQueryAction;
import com.ibm.team.workitem.rcp.ui.internal.actions.NewWorkItemTemplateAction;
import com.ibm.team.workitem.rcp.ui.internal.actions.ProjectAreaSelectionAction;
import com.ibm.team.workitem.rcp.ui.internal.actions.RunFavoriteQueryAction;
import com.ibm.team.workitem.rcp.ui.internal.attribute.AttributeColumn;
import com.ibm.team.workitem.rcp.ui.internal.attribute.AttributeColumnFactory;
import com.ibm.team.workitem.rcp.ui.internal.explorer.view.AbstractWorkItemExplorer;
import com.ibm.team.workitem.rcp.ui.internal.explorer.view.HistoryItem;
import com.ibm.team.workitem.rcp.ui.internal.explorer.view.Messages;
import com.ibm.team.workitem.rcp.ui.internal.viewer.IWorkItemSource;
import com.ibm.team.workitem.rcp.ui.internal.viewer.WorkItemViewerInput;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuCreator;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.actions.ActionFactory;

public class WorkItemExplorer2
extends AbstractWorkItemExplorer {
    private static final String WORK_ITEM_EXPLORER_VIEW_ID = "com.ibm.magnolia.workItemExplorer";
    private Map fAvailableColumns;
    private Map fAvailableColumnMenuItems;
    private Map fColumns;
    private boolean installedColumnMenu = false;
    private ContributionItem fMenuContributionItem;

    protected void installActions(IToolBarManager toolBarManager) {
        this.fNextNavigationAction = new Action(){

            public void run() {
                WorkItemExplorer2.this.showNextItem();
            }
        };
        this.fNextNavigationAction.setText(Messages.WorkItemExplorer2_SHOW_NEXT_ACTION_NAME);
        this.fNextNavigationAction.setToolTipText(Messages.WorkItemExplorer2_SHOW_NEXT_ACTION_TOOLTIP);
        this.fNextNavigationAction.setImageDescriptor(ImagePool.NEXT_ENABLED_ACTION_ICON);
        this.fNextNavigationAction.setDisabledImageDescriptor(ImagePool.NEXT_DISABLED_ACTION_ICON);
        this.fNextNavigationAction.setEnabled(false);
        this.fNextNavigationAction.setActionDefinitionId("org.eclipse.ui.navigate.next");
        this.fPrevNavigationAction = new Action(){

            public void run() {
                WorkItemExplorer2.this.showPreviousItem();
            }
        };
        this.fPrevNavigationAction.setToolTipText(Messages.WorkItemExplorer2_SHOW_PREV_ACTION_TOOLTIP);
        this.fPrevNavigationAction.setImageDescriptor(ImagePool.PREV_ENABLED_ACTION_ICON);
        this.fPrevNavigationAction.setDisabledImageDescriptor(ImagePool.PREV_DISABLED_ACTION_ICON);
        this.fPrevNavigationAction.setEnabled(false);
        this.fPrevNavigationAction.setActionDefinitionId("org.eclipse.ui.navigate.previous");
        this.fRefreshAction = new Action(){

            public void run() {
                WorkItemExplorer2.this.fWorkItemViewer.reload();
                WorkItemExplorer2.this.fHistoryManager.setInput(new HistoryItem(WorkItemExplorer2.this.fInput), new HistoryItem(WorkItemExplorer2.this.fInput));
            }
        };
        this.fRefreshAction.setText(Messages.WorkItemExplorer2_RERUN_ACTION_NAME);
        this.fRefreshAction.setToolTipText(Messages.WorkItemExplorer2_RERUN_ACTION_TOOLTIP);
        this.fRefreshAction.setImageDescriptor(ImagePool.REFRESH_ACTION_ICON);
        this.fRefreshAction.setEnabled(false);
        this.fFilterAction = new FilterAction();
        this.fSelectAllAction = new Action(){

            public void run() {
                WorkItemExplorer2.this.fWorkItemViewer.selectAll();
            }
        };
        ActionDelegateAdapter copyToClipboardAction = new ActionDelegateAdapter(new CopyToClipboardAction(), this.getViewSite().getPart());
        this.fWorkItemViewer.getRowSelectionProvider().addSelectionChangedListener((ISelectionChangedListener)copyToClipboardAction);
        copyToClipboardAction.setEnabled(false);
        IActionBars actionBars = this.getViewSite().getActionBars();
        if (actionBars != null) {
            actionBars.setGlobalActionHandler(ActionFactory.NEXT.getId(), this.fNextNavigationAction);
            actionBars.setGlobalActionHandler(ActionFactory.PREVIOUS.getId(), this.fPrevNavigationAction);
            actionBars.setGlobalActionHandler(ActionFactory.FIND.getId(), this.fFilterAction);
            actionBars.setGlobalActionHandler(ActionFactory.COPY.getId(), (IAction)copyToClipboardAction);
            actionBars.setGlobalActionHandler(ActionFactory.SELECT_ALL.getId(), this.fSelectAllAction);
            actionBars.setGlobalActionHandler(ActionFactory.REFRESH.getId(), this.fRefreshAction);
            actionBars.updateActionBars();
        }
        this.fEditQueryAction = new EditQueryAction(this.getSite().getPart(), (IStructuredSelection)StructuredSelection.EMPTY){

            protected IStructuredSelection getSelection() {
                IWorkItemSource source;
                WorkItemViewerInput input = WorkItemExplorer2.this.getInput();
                if (input != null && (source = input.getWorkItemSource()).isEditable()) {
                    return new StructuredSelection(source.getDefinition());
                }
                return StructuredSelection.EMPTY;
            }
        };
        this.fEditQueryAction.setText(Messages.WorkItemExplorer2_EDIT_QUERY_ACTION_NAME);
        this.fEditQueryAction.setToolTipText(Messages.WorkItemExplorer2_EDIT_QUERY_ACTION_TOOLTIP);
        this.fEditQueryAction.setImageDescriptor(ImagePool.EDIT_QUERY_ACTION_ICON);
        this.fEditQueryAction.setDisabledImageDescriptor(ImagePool.EDIT_QUERY_DISABLED_ACTION_ICON);
        this.fEditQueryAction.setEnabled(false);
        this.fCreateQueryAction = new ProjectAreaSelectionAction("query"){

            protected void updateConnectionStatus() {
            }

            protected void projectAreaSelected(IProjectAreaHandle projectAreaHandle) {
                super.projectAreaSelected(projectAreaHandle);
                this.run();
            }

            public void run() {
                IProjectAreaHandle projectArea = this.getDefaultProjectArea(true);
                if (projectArea != null) {
                    NewQueryAction action = new NewQueryAction(WorkItemExplorer2.this.getSite().getPart(), (IStructuredSelection)new StructuredSelection((Object)projectArea));
                    action.run();
                }
            }
        };
        this.fCreateQueryAction.setEnabled(true);
        this.fCreateQueryAction.setEnableNotLoggedIn(true);
        this.fCreateQueryAction.setText(Messages.WorkItemExplorer2_NEW_QUERY_ACTION_NAME);
        this.fCreateQueryAction.setToolTipText(Messages.WorkItemExplorer2_NEW_QUERY_ACTION_TOOLTIP);
        this.fCreateQueryAction.setImageDescriptor(ImagePool.CREATE_QUERY_ACTION_ICON);
        this.fCreateQueryAction.setDisabledImageDescriptor(ImagePool.CREATE_QUERY_DISABLED_ACTION_ICON);
        this.fCancelQueryAction = new Action(){

            public void run() {
                WorkItemExplorer2.this.fWorkItemViewer.cancelLoad();
            }
        };
        this.fCancelQueryAction.setText(Messages.WorkItemExplorer2_CANCEL_QUERY_ACTION_NAME);
        this.fCancelQueryAction.setToolTipText(Messages.WorkItemExplorer2_CANCEL_QUERY_ACTION_TOOLTIP);
        this.fCancelQueryAction.setImageDescriptor(ImagePool.CANCEL_QUERY_ACTION_ICON);
        this.fCancelQueryAction.setDisabledImageDescriptor(ImagePool.CANCEL_QUERY_DISABLED_ACTION_ICON);
        this.fCancelQueryAction.setEnabled(false);
        this.fShowInArtifactNavigatorAction = new Action(){

            public void run() {
                WorkItemViewerInput input = WorkItemExplorer2.this.fWorkItemViewer.getInput();
                if (input == null) {
                    return;
                }
                WorkItemRCPUIPlugin.openArtifactNavigator(WorkItemExplorer2.this.getViewSite().getWorkbenchWindow(), (ISelection)new StructuredSelection(input.getWorkItemSource().getDefinition()));
            }
        };
        this.fShowInArtifactNavigatorAction.setText(Messages.WorkItemExplorer2_SHOW_IN_TAN_ACTION_NAME);
        this.fShowInArtifactNavigatorAction.setToolTipText(Messages.WorkItemExplorer2_SHOW_IN_TAN_ACTION_TOOLTIP);
        this.fShowInArtifactNavigatorAction.setImageDescriptor(ImagePool.ARTIFACT_NAV_ICON);
        this.fShowInArtifactNavigatorAction.setEnabled(false);
        this.fPinAction = new Action(null, 2){

            public void run() {
                WorkItemExplorer2.this.fPinned = WorkItemExplorer2.this.fPinAction.isChecked();
            }
        };
        this.fPinAction.setToolTipText(Messages.WorkItemExplorer2_PIN_ACTION_TOOLTIP);
        this.fPinAction.setImageDescriptor(ImagePool.PIN_ENABLED_ACTION_ICON);
        this.fPinAction.setDisabledImageDescriptor(ImagePool.PIN_DISABLED_ACTION_ICON);
        this.fPinAction.setEnabled(false);
        final NewWorkItemTemplateAction newTemplateDelegate = new NewWorkItemTemplateAction();
        this.fNewTemplateAction = new Action(){

            public void run() {
                newTemplateDelegate.run((IAction)this);
            }
        };
        this.fNewTemplateAction.setText(Messages.WorkItemExplorer2_NEW_WORKITEM_TEMPLATE_ACTION_NAME);
        this.fNewTemplateAction.setToolTipText(Messages.WorkItemExplorer2_NEW_WORKITEM_TEMPLATE_ACTION_TOOLTIP);
        this.fNewTemplateAction.setImageDescriptor(ImagePool.NEW_WORKITEM_TEMPLATE_ACTION_ICON);
        this.fNewTemplateAction.setEnabled(false);
        this.fWorkItemViewer.getRowSelectionProvider().addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                if (event.getSelection() != null && !event.getSelection().isEmpty()) {
                    newTemplateDelegate.selectionChanged(WorkItemExplorer2.this.fNewTemplateAction, event.getSelection());
                    WorkItemExplorer2.this.fNewTemplateAction.setEnabled(true);
                } else {
                    WorkItemExplorer2.this.fNewTemplateAction.setEnabled(false);
                }
            }
        });
        RunFavoriteQueryAction runQueryAction = new RunFavoriteQueryAction("", this.getSite().getWorkbenchWindow());
        runQueryAction.setImageDescriptor(ImagePool.RUN_QUERY_ENABLED_ICON);
        runQueryAction.setDisabledImageDescriptor(ImagePool.RUN_QUERY_DISABLED_ICON);
        runQueryAction.setToolTipText(Messages.WorkItemExplorer2_RUN_QUERY_TOOLTIP);
        toolBarManager.add((IAction)this.fCreateQueryAction);
        toolBarManager.add(this.fEditQueryAction);
        toolBarManager.add((IAction)runQueryAction);
        this.fHistoryManager.installActions(toolBarManager);
        toolBarManager.add((IContributionItem)new Separator());
        toolBarManager.add(this.fNewTemplateAction);
        toolBarManager.add((IContributionItem)new Separator());
        toolBarManager.add(this.fRefreshAction);
        toolBarManager.add(this.fCancelQueryAction);
        toolBarManager.add((IContributionItem)new Separator());
        toolBarManager.add(this.fNextNavigationAction);
        toolBarManager.add(this.fPrevNavigationAction);
        toolBarManager.add((IContributionItem)new Separator());
        toolBarManager.add(this.fFilterAction);
        toolBarManager.add(this.fPinAction);
        IMenuManager menuManager = this.getViewSite().getActionBars().getMenuManager();
        menuManager.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                if (WorkItemExplorer2.this.fWorkItemViewer.getView() != null) {
                    if (!WorkItemExplorer2.this.installedColumnMenu) {
                        WorkItemExplorer2.this.contributeActionBarItems(manager);
                        WorkItemExplorer2.this.installedColumnMenu = true;
                    }
                    WorkItemExplorer2.this.setMenuItemEnabled(IWorkItem.SUMMARY_PROPERTY, !WorkItemExplorer2.this.getInput().hasRelationships());
                }
            }
        });
    }

    private WorkItemViewerInput getInput() {
        return this.fInput;
    }

    protected String getExplorerId() {
        return WORK_ITEM_EXPLORER_VIEW_ID;
    }

    protected void contributeActionBarItems(IMenuManager menuManager) {
        ITeamRepository repository;
        this.refreshColumns();
        ITeamRepository iTeamRepository = repository = this.getInput() != null ? this.getInput().getWorkItemSource().getTeamRepository() : null;
        if (repository != null) {
            try {
                this.fAvailableColumns = new HashMap();
                AttributeColumn[] columns = AttributeColumnFactory.getInstance(repository, this.getInput().getWorkItemSource().getProjectArea(), null).getColumns();
                int i = 0;
                while (i < columns.length) {
                    this.fAvailableColumns.put(columns[i].getAttribute().getIdentifier(), columns[i]);
                    ++i;
                }
                this.fAvailableColumnMenuItems = new HashMap();
                this.fMenuContributionItem = new ContributionItem(){

                    public void fill(Menu menu, int index) {
                        new MenuItem(menu, 2);
                        MenuItem columnsSubMenuItem = new MenuItem(menu, 64);
                        columnsSubMenuItem.setText(Messages.WorkItemExplorer2_MENU_COLUMNS);
                        Menu columnsSubMenu = new Menu(columnsSubMenuItem);
                        columnsSubMenuItem.setMenu(columnsSubMenu);
                        ArrayList columnCollection = new ArrayList(WorkItemExplorer2.this.fAvailableColumns.values());
                        Collections.sort(columnCollection, new Comparator(){
                            private Collator collator = Collator.getInstance();

                            public int compare(Object o1, Object o2) {
                                return this.collator.compare(((AttributeColumn)o1).getAttribute().getDisplayName(), ((AttributeColumn)o2).getAttribute().getDisplayName());
                            }
                        });
                        for (AttributeColumn column : columnCollection) {
                            if (column.getAttribute().getIdentifier().equals("all")) continue;
                            MenuItem menuItem = new MenuItem(columnsSubMenu, 32);
                            menuItem.setText(column.getAttribute().getDisplayName());
                            menuItem.setSelection(WorkItemExplorer2.this.isColumnVisible(column.getAttribute().getIdentifier()));
                            menuItem.setData((Object)column.getAttribute().getIdentifier());
                            menuItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

                                public void widgetSelected(SelectionEvent e) {
                                    MenuItem item = (MenuItem)e.getSource();
                                    WorkItemExplorer2.this.toggleColumn((String)item.getData());
                                }
                            });
                            WorkItemExplorer2.this.fAvailableColumnMenuItems.put(column.getAttribute().getIdentifier(), menuItem);
                        }
                    }
                };
                menuManager.add((IContributionItem)this.fMenuContributionItem);
            }
            catch (TeamRepositoryException e) {
                WorkItemRCPUIPlugin.getDefault().log(Messages.WorkItemExplorer2_ERROR_CREATING_COLUMNS_MENU, e);
            }
        }
    }

    private boolean isColumnVisible(String columnIdentifier) {
        QueryViewColumn column = (QueryViewColumn)this.fColumns.get(columnIdentifier);
        return column != null;
    }

    private void toggleColumn(String columnIdentifier) {
        QueryViewColumn column = (QueryViewColumn)this.fColumns.get(columnIdentifier);
        if (column != null) {
            this.fColumns.remove(columnIdentifier);
        } else {
            this.fColumns.put(columnIdentifier, new QueryViewColumn(columnIdentifier, true, 0, 0, -1));
            MenuItem columnMenuItem = (MenuItem)this.fAvailableColumnMenuItems.get(columnIdentifier);
            columnMenuItem.setSelection(true);
        }
        this.refreshView();
    }

    private void refreshColumns() {
        this.fColumns = new TreeMap();
        QueryViewColumn[] columns = this.fWorkItemViewer.getView().getColumns();
        int i = 0;
        while (i < columns.length) {
            this.fColumns.put(columns[i].getAttributeIdentifier(), columns[i]);
            ++i;
        }
    }

    private void refreshView() {
        if (this.fColumns.size() == 0) {
            this.toggleColumn(IWorkItem.SUMMARY_PROPERTY);
        }
        ArrayList columnCollection = new ArrayList(this.fColumns.values());
        Collections.sort(columnCollection, this.getColumnOrderComparator());
        QueryViewColumn[] columns = columnCollection.toArray(new QueryViewColumn[columnCollection.size()]);
        this.fWorkItemViewer.getView().setColumns(columns);
        this.fWorkItemViewer.setView(this.fWorkItemViewer.getView());
    }

    private void resetColumnMenu() {
        this.installedColumnMenu = false;
        if (this.fMenuContributionItem != null) {
            IMenuManager manager = this.getViewSite().getActionBars().getMenuManager();
            manager.remove((IContributionItem)this.fMenuContributionItem);
        }
    }

    private void setMenuItemEnabled(String columnIdentifier, boolean state) {
        MenuItem menuItem = (MenuItem)this.fAvailableColumnMenuItems.get(columnIdentifier);
        if (menuItem != null) {
            menuItem.setEnabled(state);
        }
    }

    protected Comparator getColumnOrderComparator() {
        final List orderList = this.getColumnOrder();
        return new Comparator(){

            public int compare(Object o1, Object o2) {
                String attribute1 = ((QueryViewColumn)o1).getAttributeIdentifier();
                String attribute2 = ((QueryViewColumn)o2).getAttributeIdentifier();
                if (orderList.contains(attribute1) && orderList.contains(attribute2)) {
                    if (orderList.indexOf(attribute1) < orderList.indexOf(attribute2)) {
                        return -1;
                    }
                    return 1;
                }
                if (orderList.contains(attribute1) && !orderList.contains(attribute2)) {
                    return -1;
                }
                if (!orderList.contains(attribute1) && orderList.contains(attribute2)) {
                    return 1;
                }
                return 0;
            }
        };
    }

    protected List getColumnOrder() {
        ArrayList<String> order = new ArrayList<String>();
        order.add(IWorkItem.TYPE_PROPERTY);
        order.add(IWorkItem.ID_PROPERTY);
        order.add(IWorkItem.STATE_PROPERTY);
        order.add(IWorkItem.PRIORITY_PROPERTY);
        order.add(IWorkItem.SEVERITY_PROPERTY);
        order.add(IWorkItem.SUMMARY_PROPERTY);
        order.add(IWorkItem.OWNER_PROPERTY);
        order.add(IWorkItem.CREATOR_PROPERTY);
        return order;
    }

    protected void show(WorkItemViewerInput input, boolean addToHistory) {
        super.show(input, addToHistory);
        this.resetColumnMenu();
    }

    private class FilterAction
    extends Action
    implements IMenuCreator {
        private MenuManager fMenuManager;
        private IAction fShowQuickFindAction;
        private IAction fFilterRead;

        public FilterAction() {
            super("", 4);
            this.fShowQuickFindAction = new Action(Messages.WorkItemExplorer2_FIND_ACTION_NAME, 2){

                public void run() {
                    if (this.isChecked()) {
                        ((FilterAction)FilterAction.this).WorkItemExplorer2.this.fWorkItemViewer.showQuickFindBar();
                    } else {
                        ((FilterAction)FilterAction.this).WorkItemExplorer2.this.fWorkItemViewer.hideQuickFindBar();
                    }
                }
            };
            this.fFilterRead = new Action(Messages.WorkItemExplorer2_HIDE_READ, 2){

                public void run() {
                    WorkItemExplorer2.this.getInput().enableUnreadFilter(this.isChecked());
                }
            };
            this.setToolTipText(Messages.WorkItemExplorer2_FIND_ACTION_NAME);
            this.setImageDescriptor(ImagePool.QUICKFILTER_ICON);
            this.fMenuManager = new MenuManager();
        }

        public IMenuCreator getMenuCreator() {
            return this;
        }

        public void run() {
            this.fShowQuickFindAction.setChecked(!this.fShowQuickFindAction.isChecked());
            this.fShowQuickFindAction.run();
        }

        public void dispose() {
            this.fMenuManager.dispose();
        }

        public Menu getMenu(Control parent) {
            this.fMenuManager.removeAll();
            this.fMenuManager.add(this.fShowQuickFindAction);
            this.fMenuManager.add(this.fFilterRead);
            this.fShowQuickFindAction.setChecked(WorkItemExplorer2.this.fWorkItemViewer.isQuickFindBarVisible());
            this.fFilterRead.setChecked(this.isUnreadFilterEnabled());
            return this.fMenuManager.createContextMenu(parent);
        }

        private boolean isUnreadFilterEnabled() {
            WorkItemViewerInput input = WorkItemExplorer2.this.getInput();
            if (input != null) {
                return input.isUnreadFilterSet();
            }
            return false;
        }

        public Menu getMenu(Menu parent) {
            return null;
        }
    }
}

