/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.rcp.ui.internal.explorer.view;

import com.ibm.team.workitem.rcp.ui.internal.WorkItemRCPUIPlugin;
import com.ibm.team.workitem.rcp.ui.internal.explorer.view.Messages;
import com.ibm.team.workitem.rcp.ui.internal.viewer.IRelationshipDescriptor;
import com.ibm.team.workitem.rcp.ui.internal.viewer.RelationshipRegistry;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;

public class RelationshipDialog
extends Dialog {
    private static final String RELATIONSHIP_SETTINGS = "RelationshipDialog";
    private static final String RELATIONSHIP_SETTINGS_ORDER = "order";
    private CheckboxTableViewer fSelector;
    private IRelationshipDescriptor[] fSelected;
    private RelationshipsProvider fContentProvider;
    private Button fMoveUpButton;
    private Button fMoveDownButton;
    private IDialogSettings fDialogSettings;

    public RelationshipDialog(Shell parentShell) {
        super(parentShell);
        this.setShellStyle(this.getShellStyle() | 0x10);
        this.fSelected = IRelationshipDescriptor.NO_RELATIONS;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(Messages.RelationshipDialog_TITLE);
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayoutFactory.fillDefaults().numColumns(2).equalWidth(false).margins(6, 6).applyTo(composite);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)composite);
        Label label = new Label(composite, 0);
        label.setText(Messages.RelationshipDialog_MESSAGE);
        GridDataFactory.fillDefaults().span(2, 1).applyTo((Control)label);
        Table table = new Table(composite, 2080);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)table);
        Composite buttonArea = new Composite(composite, 0);
        GridLayoutFactory.fillDefaults().applyTo(buttonArea);
        GridDataFactory.fillDefaults().align(16384, 128).applyTo((Control)buttonArea);
        this.fMoveUpButton = new Button(buttonArea, 0);
        this.fMoveUpButton.setText(Messages.RelationshipDialog_UP);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.fMoveUpButton);
        this.fMoveUpButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IStructuredSelection selection = (IStructuredSelection)RelationshipDialog.this.fSelector.getSelection();
                if (!selection.isEmpty()) {
                    RelationshipDialog.this.fContentProvider.moveUp(selection.getFirstElement());
                    RelationshipDialog.this.updateButtons();
                }
            }
        });
        this.fMoveDownButton = new Button(buttonArea, 0);
        this.fMoveDownButton.setText(Messages.RelationshipDialog_DOWN);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.fMoveDownButton);
        this.fMoveDownButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IStructuredSelection selection = (IStructuredSelection)RelationshipDialog.this.fSelector.getSelection();
                if (!selection.isEmpty()) {
                    RelationshipDialog.this.fContentProvider.moveDown(selection.getFirstElement());
                    RelationshipDialog.this.updateButtons();
                }
            }
        });
        Button selectAllButton = new Button(buttonArea, 0);
        selectAllButton.setText(Messages.RelationshipDialog_SELECT_ALL);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)selectAllButton);
        selectAllButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                RelationshipDialog.this.fSelector.setAllChecked(true);
            }
        });
        Button deselectAllButton = new Button(buttonArea, 0);
        deselectAllButton.setText(Messages.RelationshipDialog_DESELECT_ALL);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)deselectAllButton);
        deselectAllButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                RelationshipDialog.this.fSelector.setAllChecked(false);
            }
        });
        this.fContentProvider = new RelationshipsProvider();
        this.fSelector = new CheckboxTableViewer(table);
        this.fSelector.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                RelationshipDialog.this.updateButtons();
            }
        });
        this.fSelector.setContentProvider((IContentProvider)this.fContentProvider);
        this.fSelector.setLabelProvider((IBaseLabelProvider)new RelationshipLabelProvider());
        this.fSelector.setInput((Object)this.getRelationships());
        this.fSelector.setCheckedElements((Object[])this.fSelected);
        this.updateButtons();
        return composite;
    }

    public IRelationshipDescriptor[] getSelectedRelationships() {
        return this.fSelected;
    }

    public void setSelectedRelationships(IRelationshipDescriptor[] selected) {
        this.fSelected = selected == null ? IRelationshipDescriptor.NO_RELATIONS : selected;
    }

    protected void okPressed() {
        Object[] elements = this.fSelector.getCheckedElements();
        this.fSelected = new IRelationshipDescriptor[elements.length];
        System.arraycopy(elements, 0, this.fSelected, 0, elements.length);
        this.saveSettings();
        super.okPressed();
    }

    private void updateButtons() {
        IStructuredSelection selection = (IStructuredSelection)this.fSelector.getSelection();
        this.fMoveUpButton.setEnabled(!selection.isEmpty() && !this.fContentProvider.isFirst(selection.getFirstElement()));
        this.fMoveDownButton.setEnabled(!selection.isEmpty() && !this.fContentProvider.isLast(selection.getFirstElement()));
    }

    private IRelationshipDescriptor[] getRelationships() {
        IDialogSettings settings = this.getDialogSettings();
        final String[] ids = settings.getArray(RELATIONSHIP_SETTINGS_ORDER);
        List<IRelationshipDescriptor> relationships = RelationshipRegistry.getInstance().getRelationshipDescriptors();
        if (ids != null) {
            Collections.sort(relationships, new Comparator<IRelationshipDescriptor>(){

                @Override
                public int compare(IRelationshipDescriptor d1, IRelationshipDescriptor d2) {
                    if (d1 == d2) {
                        return 0;
                    }
                    int i = 0;
                    while (i < ids.length) {
                        if (ids[i].equals(d1.getId())) {
                            return -1;
                        }
                        if (ids[i].equals(d2.getId())) {
                            return 1;
                        }
                        ++i;
                    }
                    return 0;
                }
            });
        }
        return relationships.toArray(new IRelationshipDescriptor[relationships.size()]);
    }

    private void saveSettings() {
        IDialogSettings settings = this.getDialogSettings();
        IRelationshipDescriptor[] descriptors = (IRelationshipDescriptor[])this.fSelector.getInput();
        String[] ids = new String[descriptors.length];
        int i = 0;
        while (i < descriptors.length) {
            ids[i] = descriptors[i].getId();
            ++i;
        }
        settings.put(RELATIONSHIP_SETTINGS_ORDER, ids);
    }

    private IDialogSettings getDialogSettings() {
        IDialogSettings settings = WorkItemRCPUIPlugin.getDefault().getDialogSettings();
        if (this.fDialogSettings == null) {
            this.fDialogSettings = settings.getSection(RELATIONSHIP_SETTINGS);
        }
        if (this.fDialogSettings == null) {
            this.fDialogSettings = settings.addNewSection(RELATIONSHIP_SETTINGS);
        }
        return this.fDialogSettings;
    }

    private static class RelationshipLabelProvider
    extends LabelProvider {
        private RelationshipLabelProvider() {
        }

        public String getText(Object element) {
            return ((IRelationshipDescriptor)element).getName();
        }
    }

    private static class RelationshipsProvider
    implements IStructuredContentProvider {
        private IRelationshipDescriptor[] fDescriptors;
        private Viewer fViewer;

        private RelationshipsProvider() {
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            this.fDescriptors = (IRelationshipDescriptor[])newInput;
            this.fViewer = viewer;
        }

        public Object[] getElements(Object inputElement) {
            return this.fDescriptors;
        }

        public void moveUp(Object element) {
            int index = this.getIndex(element);
            if (index > 0) {
                IRelationshipDescriptor temp = this.fDescriptors[index - 1];
                this.fDescriptors[index - 1] = this.fDescriptors[index];
                this.fDescriptors[index] = temp;
                this.fViewer.refresh();
            }
        }

        public void moveDown(Object element) {
            int index = this.getIndex(element);
            if (index < this.fDescriptors.length - 1) {
                IRelationshipDescriptor temp = this.fDescriptors[index + 1];
                this.fDescriptors[index + 1] = this.fDescriptors[index];
                this.fDescriptors[index] = temp;
                this.fViewer.refresh();
            }
        }

        public boolean isFirst(Object element) {
            return this.getIndex(element) == 0;
        }

        public boolean isLast(Object element) {
            return this.getIndex(element) == this.fDescriptors.length - 1;
        }

        private int getIndex(Object element) {
            int i = 0;
            while (i < this.fDescriptors.length) {
                if (this.fDescriptors[i] == element) {
                    return i;
                }
                ++i;
            }
            return -1;
        }
    }
}

