/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.rcp.ui.internal.explorer.view;

import com.ibm.team.repository.common.util.NLS;
import com.ibm.team.workitem.rcp.ui.internal.explorer.view.IHistoryItem;
import com.ibm.team.workitem.rcp.ui.internal.explorer.view.Messages;
import com.ibm.team.workitem.rcp.ui.internal.viewer.IResultModel;
import com.ibm.team.workitem.rcp.ui.internal.viewer.WorkItemViewerInput;

public class HistoryItem
implements IHistoryItem {
    private final WorkItemViewerInput fInput;

    public HistoryItem(WorkItemViewerInput input) {
        this.fInput = input;
    }

    public String getLabel() {
        String label = this.fInput.getName();
        int size = this.fInput.getWorkItemSource().getRetrievalStrategy().getResultModel().size();
        if (size == 0) {
            return NLS.bind((String)Messages.HistoryItem_NO_RESULT_FORMAT, (Object)label, (Object[])new Object[]{size});
        }
        if (size == 1) {
            return NLS.bind((String)Messages.HistoryItem_ONE_RESULT_FORMAT, (Object)label, (Object[])new Object[]{size});
        }
        return NLS.bind((String)Messages.HistoryItem_MANY_RESULT_FORMAT, (Object)label, (Object[])new Object[]{size});
    }

    public int getLastCacheAccess() {
        return 0;
    }

    public void cleanUp() {
        this.fInput.getWorkItemSource().getRetrievalStrategy().getResultModel().invalidate(IResultModel.ROOT);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof HistoryItem) {
            return this.fInput.getName().equals(((HistoryItem)obj).fInput.getName());
        }
        return false;
    }

    public WorkItemViewerInput getInput() {
        return this.fInput;
    }
}

