/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.rcp.ui.internal.explorer.view;

import com.ibm.team.collaboration.ui.context.DefaultCollaborationContextProvider;
import com.ibm.team.collaboration.ui.context.ICollaborationContextProvider;
import com.ibm.team.jface.util.UIUpdaterJob;
import com.ibm.team.jface.viewerutilities.ContextMenuHelper;
import com.ibm.team.process.common.IProjectAreaHandle;
import com.ibm.team.process.rcp.ui.teamnavigator.ConnectedProjectAreaRegistry;
import com.ibm.team.process.rcp.ui.teamnavigator.IConnectedProjectAreaRegistryChangeEvent;
import com.ibm.team.process.rcp.ui.teamnavigator.IConnectedProjectAreaRegistryListener;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.util.NLS;
import com.ibm.team.workitem.client.internal.util.ResolvedWorkItem;
import com.ibm.team.workitem.client.internal.util.ServerListener;
import com.ibm.team.workitem.common.expression.Expression;
import com.ibm.team.workitem.common.expression.IQueryableAttribute;
import com.ibm.team.workitem.common.internal.query.util.QueryUtils;
import com.ibm.team.workitem.common.model.IAttribute;
import com.ibm.team.workitem.common.model.IWorkItem;
import com.ibm.team.workitem.common.model.IWorkItemHandle;
import com.ibm.team.workitem.common.query.IQueryDescriptorHandle;
import com.ibm.team.workitem.common.query.ResultSize;
import com.ibm.team.workitem.common.text.WorkItemTextUtilities;
import com.ibm.team.workitem.common.workflow.IWorkflowInfo;
import com.ibm.team.workitem.rcp.core.queries.Query;
import com.ibm.team.workitem.rcp.ui.WorkItemUI;
import com.ibm.team.workitem.rcp.ui.internal.HelpContextIds;
import com.ibm.team.workitem.rcp.ui.internal.WorkItemRCPUIPlugin;
import com.ibm.team.workitem.rcp.ui.internal.actions.OpenWorkItemAction;
import com.ibm.team.workitem.rcp.ui.internal.actions.ProjectAreaSelectionAction;
import com.ibm.team.workitem.rcp.ui.internal.actions.SynchronizeAttributesAction;
import com.ibm.team.workitem.rcp.ui.internal.attribute.AttributeColumn;
import com.ibm.team.workitem.rcp.ui.internal.attribute.AttributeLabelProviderFactory;
import com.ibm.team.workitem.rcp.ui.internal.attribute.AttributeValueSelectorFactory;
import com.ibm.team.workitem.rcp.ui.internal.attribute.IAttributeLabelProvider;
import com.ibm.team.workitem.rcp.ui.internal.explorer.view.HistoryItem;
import com.ibm.team.workitem.rcp.ui.internal.explorer.view.HistoryManager;
import com.ibm.team.workitem.rcp.ui.internal.explorer.view.Messages;
import com.ibm.team.workitem.rcp.ui.internal.explorer.view.RelationshipDialog;
import com.ibm.team.workitem.rcp.ui.internal.explorer.view.WorkItemViewPageRegistry;
import com.ibm.team.workitem.rcp.ui.internal.queries.IShowsQuery;
import com.ibm.team.workitem.rcp.ui.internal.viewer.AbstractWorkItemSource;
import com.ibm.team.workitem.rcp.ui.internal.viewer.ExpressionWorkItemSource;
import com.ibm.team.workitem.rcp.ui.internal.viewer.IRelationshipDescriptor;
import com.ibm.team.workitem.rcp.ui.internal.viewer.IResultModel;
import com.ibm.team.workitem.rcp.ui.internal.viewer.IResultModelListener;
import com.ibm.team.workitem.rcp.ui.internal.viewer.IResultRetrievalStrategy;
import com.ibm.team.workitem.rcp.ui.internal.viewer.IRetrievalListener;
import com.ibm.team.workitem.rcp.ui.internal.viewer.IWorkItemRetrievalStrategy;
import com.ibm.team.workitem.rcp.ui.internal.viewer.QueryDescriptorWorkItemSource;
import com.ibm.team.workitem.rcp.ui.internal.viewer.QueryWorkItemSource;
import com.ibm.team.workitem.rcp.ui.internal.viewer.RelationshipRegistry;
import com.ibm.team.workitem.rcp.ui.internal.viewer.ResultModelChangedEvent;
import com.ibm.team.workitem.rcp.ui.internal.viewer.RetrievalEvent;
import com.ibm.team.workitem.rcp.ui.internal.viewer.WorkItemArraySource;
import com.ibm.team.workitem.rcp.ui.internal.viewer.WorkItemViewer;
import com.ibm.team.workitem.rcp.ui.internal.viewer.WorkItemViewerInput;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IOpenListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.OpenEvent;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.window.IShellProvider;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IReusableEditor;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.PreferencesUtil;
import org.eclipse.ui.internal.ObjectActionContributorManager;
import org.eclipse.ui.part.IPageSite;
import org.eclipse.ui.part.IShowInSource;
import org.eclipse.ui.part.IShowInTarget;
import org.eclipse.ui.part.Page;
import org.eclipse.ui.part.PageBook;
import org.eclipse.ui.part.PageSite;
import org.eclipse.ui.part.ShowInContext;
import org.eclipse.ui.part.ViewPart;

public abstract class AbstractWorkItemExplorer
extends ViewPart
implements IShowsQuery,
IShowInSource,
IShowInTarget {
    private static final String GROUP_COLUMN_ACTIONS = "group.columnActions";
    private static final String MEMENTO_RELATIONS = "workitemviewer.relations";
    protected WorkItemViewer fWorkItemViewer;
    private PageBook fPageBook;
    private Page fWorkItemViewPage;
    private Page fSetupPage;
    private Page fInitialPage;
    private Page fActivePage;
    protected HistoryManager fHistoryManager;
    protected int fViewCounter;
    protected boolean fPinned;
    protected WorkItemViewerInput fInput;
    protected IEditorInput fEditorInput;
    protected IRelationshipDescriptor[] fRelations = IRelationshipDescriptor.NO_RELATIONS;
    protected ProjectAreaSelectionAction fCreateQueryAction;
    protected IAction fEditQueryAction;
    protected IAction fCancelQueryAction;
    protected IAction fShowInArtifactNavigatorAction;
    protected IAction fRefreshAction;
    protected IAction fNextNavigationAction;
    protected IAction fPrevNavigationAction;
    protected IAction fPinAction;
    protected IAction fFilterAction;
    protected IAction fSelectAllAction;
    protected IAction fNewTemplateAction;
    private ActionEnablementUpdater fActionEnablementUpdater;
    private InputResolver fInputResolver = new InputResolver(Messages.AbstractWorkItemExplorer_LOADING_QUERY);
    private ObjectActionContributorManager fColumnActionManager;
    protected ModelListener fModelListener;
    private IConnectedProjectAreaRegistryListener fPageActivator = new IConnectedProjectAreaRegistryListener(){

        public void connectedProjectAreaRegistryChanged(IConnectedProjectAreaRegistryChangeEvent changeEvent) {
            if (AbstractWorkItemExplorer.this.isConnected()) {
                if (AbstractWorkItemExplorer.this.getActivePage() == AbstractWorkItemExplorer.this.fSetupPage) {
                    this.setActivePageInUI(AbstractWorkItemExplorer.this.fInitialPage);
                }
            } else if (AbstractWorkItemExplorer.this.getActivePage() != AbstractWorkItemExplorer.this.fWorkItemViewPage) {
                this.setActivePageInUI(AbstractWorkItemExplorer.this.fSetupPage);
            }
        }

        private void setActivePageInUI(final Page page) {
            WorkItemRCPUIPlugin.runInUI(Messages.AbstractWorkItemExplorer_CHANGE_ACTIVE_PAGE_JOB_NAME, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    AbstractWorkItemExplorer.this.setActivePage(page);
                }
            }, (IProgressMonitor)new NullProgressMonitor());
        }
    };

    public void init(IViewSite viewSite, IMemento memento) throws PartInitException {
        super.init(viewSite);
        if (memento != null) {
            IMemento[] childMementi = memento.getChildren(MEMENTO_RELATIONS);
            ArrayList<IRelationshipDescriptor> relations = new ArrayList<IRelationshipDescriptor>(childMementi.length);
            int i = 0;
            while (i < childMementi.length) {
                IRelationshipDescriptor descriptor = RelationshipRegistry.getInstance().getRelationshipDescriptor(childMementi[i].getTextData());
                if (descriptor != null) {
                    relations.add(descriptor);
                }
                ++i;
            }
            this.fRelations = relations.toArray(new IRelationshipDescriptor[relations.size()]);
        }
        this.fHistoryManager = new HistoryManager((IShellProvider)this.getViewSite()){

            protected void handleSelected(Object object) {
                if (object instanceof HistoryItem) {
                    AbstractWorkItemExplorer.this.show(((HistoryItem)object).getInput(), false);
                }
            }
        };
        this.fHistoryManager.init(memento);
        this.fModelListener = new ModelListener(null);
        this.fColumnActionManager = new ObjectActionContributorManager();
        this.fActionEnablementUpdater = new ActionEnablementUpdater();
        this.fActionEnablementUpdater.install();
        ConnectedProjectAreaRegistry.getDefault().addListener(this.fPageActivator);
    }

    public void createPartControl(Composite parent) {
        this.fPageBook = new PageBook(parent, 0);
        PageSite pageSite = new PageSite(this.getViewSite());
        this.fSetupPage = WorkItemViewPageRegistry.getInstance().createPage(this.getSite().getId(), "com.ibm.team.workitem.explorer.page.setup");
        if (this.fSetupPage != null) {
            this.fSetupPage.init((IPageSite)pageSite);
            this.fSetupPage.createControl((Composite)this.fPageBook);
        }
        this.fInitialPage = WorkItemViewPageRegistry.getInstance().createPage(this.getSite().getId(), "com.ibm.team.workitem.explorer.page.initial");
        if (this.fInitialPage != null) {
            this.fInitialPage.init((IPageSite)pageSite);
            this.fInitialPage.createControl((Composite)this.fPageBook);
        }
        this.fWorkItemViewPage = new WorkItemViewPage();
        this.fWorkItemViewPage.init((IPageSite)pageSite);
        this.fWorkItemViewPage.createControl((Composite)this.fPageBook);
        this.setActivePage(this.isConnected() ? this.fInitialPage : this.fSetupPage);
        HelpContextIds.hookHelpListener((Control)this.fPageBook, "com.ibm.team.workitem.rcp.ui.work_item_explorer_view");
    }

    protected WorkItemViewer createWorkItemViewer(Composite parent) {
        return new WorkItemViewer(parent);
    }

    public void setFocus() {
        this.getActivePage().setFocus();
    }

    private Page getActivePage() {
        return this.fActivePage;
    }

    private void setActivePage(Page page) {
        Page page2 = this.fActivePage = page != null ? page : this.fWorkItemViewPage;
        if (!this.fPageBook.isDisposed()) {
            this.fPageBook.showPage(this.fActivePage.getControl());
        }
    }

    private void activateWorkItemViewPage() {
        this.setActivePage(this.fWorkItemViewPage);
    }

    private boolean isConnected() {
        return ConnectedProjectAreaRegistry.getDefault().getConnectedProjectAreas(null).size() > 0;
    }

    public void dispose() {
        super.dispose();
        if (this.fWorkItemViewer != null) {
            this.fWorkItemViewer.dispose();
        }
        this.fColumnActionManager.dispose();
        this.fActionEnablementUpdater.uninstall();
        ConnectedProjectAreaRegistry.getDefault().removeListener(this.fPageActivator);
        if (this.fWorkItemViewPage != null) {
            this.fWorkItemViewPage.dispose();
        }
        if (this.fSetupPage != null) {
            this.fSetupPage.dispose();
        }
        if (this.fInitialPage != null) {
            this.fInitialPage.dispose();
        }
        if (this.fCreateQueryAction != null) {
            this.fCreateQueryAction.dispose();
        }
    }

    public void saveState(IMemento memento) {
        this.fHistoryManager.saveState(memento);
        int i = 0;
        while (i < this.fRelations.length) {
            memento.createChild(MEMENTO_RELATIONS).putTextData(this.fRelations[i].getId());
            ++i;
        }
    }

    public void showQuery(IQueryDescriptorHandle descriptorHandle) {
        this.show(new WorkItemViewerInput(new QueryDescriptorWorkItemSource(descriptorHandle)));
    }

    public void showExpression(ITeamRepository teamRepository, String name, Expression expression) {
        this.show(new WorkItemViewerInput(new ExpressionWorkItemSource(teamRepository, expression, name)));
    }

    public void showQuery(Query query) {
        this.show(new WorkItemViewerInput(new QueryWorkItemSource(query)));
    }

    public void showWorkItems(IProjectAreaHandle projectArea, String name, IWorkItemHandle[] workItems) {
        this.show(new WorkItemViewerInput(new WorkItemArraySource(projectArea, workItems, name)));
    }

    public void showWorkItems(String name, IWorkItemHandle[] workItems) {
        this.show(new WorkItemViewerInput(new WorkItemArraySource(null, workItems, name)));
    }

    public IViewPart openNewView() {
        IWorkbenchPage page;
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (window != null && (page = window.getActivePage()) != null) {
            try {
                String secondaryId = String.format("%s.%d.%s", this.getExplorerId(), this.fViewCounter, this.getViewSite().getSecondaryId());
                IViewPart part = page.showView(this.getExplorerId(), secondaryId, 1);
                ++this.fViewCounter;
                return part;
            }
            catch (PartInitException e) {
                WorkItemRCPUIPlugin.getDefault().log(Messages.AbstractWorkItemExplorer_CANNOT_CREATE_NEW_INSTANCE, e);
            }
        }
        return null;
    }

    public boolean isPinned() {
        return this.fPinned;
    }

    public ShowInContext getShowInContext() {
        ISelection selection = this.fWorkItemViewer.getRowSelectionProvider().getSelection();
        Object input = this.getInput() != null ? this.getInput().getWorkItemSource().getDefinition() : null;
        return new ShowInContext(input, selection);
    }

    public boolean show(ShowInContext context) {
        IStructuredSelection selection;
        if (this.isPinned()) {
            return false;
        }
        ISelection objSelection = context.getSelection();
        if (objSelection instanceof IStructuredSelection && (selection = (IStructuredSelection)objSelection).size() == 1 && selection.getFirstElement() instanceof Query) {
            this.showQuery((Query)selection.getFirstElement());
            return true;
        }
        return false;
    }

    protected void show(WorkItemViewerInput input, boolean addToHistory) {
        if (!input.isResolved()) {
            this.fInputResolver.resolve(input, addToHistory);
            return;
        }
        this.activateWorkItemViewPage();
        input.setDefaultViewId(this.getDefaultViewId());
        if (addToHistory) {
            boolean newInputValid = input != null && input.getStatus().isOK() && input.isResolved();
            boolean oldInputValid = this.fInput != null && this.fInput.getStatus().isOK() && this.fInput.isResolved();
            this.fHistoryManager.setInput(oldInputValid ? new HistoryItem(this.fInput) : null, newInputValid ? new HistoryItem(input) : null);
        }
        this.fModelListener.dispose();
        this.fInput = input;
        if (this.fInput != null && this.fInput.getStatus().isOK()) {
            this.fModelListener = new ModelListener(this.getRetrievalStrategy());
            this.getRetrievalStrategy().setRelationships(this.fRelations);
        }
        if (this.fInput == null || this.fInput.getStatus().isOK()) {
            this.fWorkItemViewer.setInput(input);
        }
        this.updateInputDependencies();
    }

    private String getDefaultViewId() {
        String primary = this.getExplorerId();
        String secondary = this.getViewSite().getSecondaryId();
        return String.format("%s.%s", primary, secondary == null ? "" : secondary);
    }

    protected void show(WorkItemViewerInput input) {
        this.show(input, true);
    }

    protected void showNextItem() {
        this.openIndex(this.getModelSelectionIndex() + 1);
    }

    protected void showPreviousItem() {
        this.openIndex(this.getModelSelectionIndex() - 1);
    }

    private int getModelSelectionIndex() {
        IStructuredSelection selection = (IStructuredSelection)this.fWorkItemViewer.getRowSelectionProvider().getSelection();
        if (!selection.isEmpty()) {
            IResultModel model = this.getResultModel();
            return model.indexOf(IResultModel.ROOT, selection.getFirstElement());
        }
        return -1;
    }

    private void openIndex(int index) {
        IResultModel model = this.getResultModel();
        if (index >= 0 && index < model.size()) {
            StructuredSelection newSelection = new StructuredSelection(model.getChild(IResultModel.ROOT, index));
            this.fWorkItemViewer.getRowSelectionProvider().setSelection((ISelection)newSelection);
            this.openSelection((IStructuredSelection)newSelection);
        }
    }

    protected void openSelection(IStructuredSelection selection) {
        IWorkItemHandle handle = WorkItemRCPUIPlugin.getWorkItemHandle(selection.getFirstElement());
        if (handle != null) {
            IEditorInput editorInput = (IEditorInput)Platform.getAdapterManager().loadAdapter((Object)handle, IEditorInput.class.getName());
            if (editorInput == null) {
                WorkItemRCPUIPlugin.getDefault().log(Messages.AbstractWorkItemExplorer_CANNOT_CREATE_EDITOR_INPUT, null);
                return;
            }
            IWorkbenchPage page = this.getSite().getPage();
            IEditorPart editor = page.findEditor(editorInput);
            if (editor != null) {
                page.bringToTop((IWorkbenchPart)editor);
                return;
            }
            boolean reuseEditor = WorkItemRCPUIPlugin.getDefault().getReuseWorkItemEditorPref();
            IEditorPart iEditorPart = editor = this.fEditorInput != null ? page.findEditor(this.fEditorInput) : null;
            if (!reuseEditor || editor == null || editor.isDirty() || page.isEditorPinned(editor) || !(editor instanceof IReusableEditor)) {
                editor = WorkItemUI.openEditor(page, handle);
                if (reuseEditor) {
                    this.fEditorInput = editor.getEditorInput();
                }
            } else {
                this.fEditorInput = editorInput;
                page.reuseEditor((IReusableEditor)editor, this.fEditorInput);
                page.bringToTop((IWorkbenchPart)editor);
            }
        }
    }

    private void internalUpdateActions() {
        if (this.getInput() == null || !this.getInput().getStatus().isOK()) {
            this.fRefreshAction.setEnabled(false);
            this.fCancelQueryAction.setEnabled(false);
            this.fNextNavigationAction.setEnabled(false);
            this.fPrevNavigationAction.setEnabled(false);
            this.fPinAction.setEnabled(false);
            this.fEditQueryAction.setEnabled(false);
            this.fShowInArtifactNavigatorAction.setEnabled(false);
            this.fFilterAction.setEnabled(false);
        } else {
            boolean isRetrieving = this.getRetrievalStrategy().isRetrieving(IResultModel.ROOT);
            this.fRefreshAction.setEnabled(!isRetrieving);
            this.fCancelQueryAction.setEnabled(isRetrieving);
            int selectedIndex = this.getModelSelectionIndex();
            int max = this.getResultModel() == null ? 0 : this.getResultModel().size();
            this.fNextNavigationAction.setEnabled(selectedIndex + 1 < max);
            this.fPrevNavigationAction.setEnabled(selectedIndex - 1 >= 0);
            this.fPinAction.setEnabled(true);
            this.fEditQueryAction.setEnabled(this.fInput.getWorkItemSource().isEditable());
            this.fShowInArtifactNavigatorAction.setEnabled(this.isStoredQuery(this.fInput));
            this.fFilterAction.setEnabled(true);
        }
    }

    private boolean isStoredQuery(WorkItemViewerInput input) {
        if (input == null) {
            return false;
        }
        return input.getWorkItemSource().getDefinition() instanceof IQueryDescriptorHandle;
    }

    private void internalUpdateStatus(String contentDescription) {
        this.setContentDescription(contentDescription);
        this.setTitleToolTip(contentDescription);
        this.internalUpdateActions();
    }

    private void updateActions() {
        WorkItemRCPUIPlugin.runInUI(Messages.AbstractWorkItemExplorer_UPDATE_UI_JOB_NAME, new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) {
                AbstractWorkItemExplorer.this.internalUpdateActions();
            }
        }, (IProgressMonitor)new NullProgressMonitor());
    }

    private void updateStatus(final RetrievalEvent event) {
        WorkItemRCPUIPlugin.runInUI(Messages.AbstractWorkItemExplorer_UPDATE_UI_JOB_NAME, new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) {
                AbstractWorkItemExplorer.this.internalUpdateStatus(AbstractWorkItemExplorer.this.createDescription(event));
            }
        }, (IProgressMonitor)new NullProgressMonitor());
    }

    private void updateInputDependencies() {
        WorkItemRCPUIPlugin.runInUI(Messages.AbstractWorkItemExplorer_UPDATE_UI_JOB_NAME, new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) {
                AbstractWorkItemExplorer.this.internalUpdateStatus(AbstractWorkItemExplorer.this.createDescription(AbstractWorkItemExplorer.this.getInput()));
            }
        }, (IProgressMonitor)new NullProgressMonitor());
    }

    private String createDescription(RetrievalEvent event) {
        if (this.fInput == null) {
            return this.createRetrievalStatusDescription(event);
        }
        return NLS.bind((String)Messages.AbstractWorkItemExplorer_DESCRIPTION_FORMAT, (Object)this.createRetrievalStatusDescription(event), (Object[])new Object[]{this.fInput.getName()});
    }

    private String createDescription(WorkItemViewerInput input) {
        if (input == null || !input.getStatus().isOK()) {
            return this.createInputStatusDescription(input);
        }
        return NLS.bind((String)Messages.AbstractWorkItemExplorer_DESCRIPTION_FORMAT, (Object)this.createInputStatusDescription(input), (Object[])new Object[]{input.getName()});
    }

    private String createRetrievalStatusDescription(RetrievalEvent event) {
        if (event.getType() == 3) {
            return this.createFoundDescription(event.getResultRetrievalStrategy());
        }
        if (event.getType() == 1) {
            if (event.getExpectedCount() < 0) {
                return NLS.bind((String)Messages.AbstractWorkItemExplorer_RETRIEVED_UNKNOWN_FORMAT, (Object)event.getCurrentCount(), (Object[])new Object[0]);
            }
            return NLS.bind((String)Messages.AbstractWorkItemExplorer_RETRIEVED_KNOWN_FORMAT, (Object)event.getCurrentCount(), (Object[])new Object[]{event.getExpectedCount()});
        }
        if (event.getType() == 2) {
            return Messages.AbstractWorkItemExplorer_CANCELED;
        }
        if (event.getType() == 4) {
            if (event.getStatus() != null && event.getStatus().getSeverity() == 4) {
                WorkItemRCPUIPlugin.getDefault().log(event.getStatus());
            }
            return this.createStatusMessage(event.getStatus());
        }
        if (event.getType() == 0) {
            return Messages.AbstractWorkItemExplorer_RETRIEVING;
        }
        return "";
    }

    private String createInputStatusDescription(WorkItemViewerInput input) {
        if (input == null) {
            return Messages.AbstractWorkItemExplorer_NO_RESULTS;
        }
        if (!input.getStatus().isOK()) {
            return this.createStatusMessage(input.getStatus());
        }
        IWorkItemRetrievalStrategy retrievalStrategy = this.getRetrievalStrategy();
        if (retrievalStrategy.isRetrieving(IResultModel.ROOT) || !retrievalStrategy.getExpectedResultSize().isInitialized()) {
            return Messages.AbstractWorkItemExplorer_RETRIEVING;
        }
        return this.createFoundDescription(retrievalStrategy);
    }

    private String createFoundDescription(IResultRetrievalStrategy retrievalStrategy) {
        String searchTerm;
        ResultSize totalSize = retrievalStrategy.getExpectedResultSize();
        int resultSize = retrievalStrategy.getResultModel().getChildCount(IResultModel.ROOT);
        int unfilteredSize = retrievalStrategy.getResultModel().getUnfilteredChildCount(IResultModel.ROOT);
        int notLoaded = totalSize.getTotal() - unfilteredSize;
        int filtered = unfilteredSize - resultSize;
        if (!totalSize.isInitialized()) {
            return Messages.AbstractWorkItemExplorer_CANCELED;
        }
        if (notLoaded == 0 && filtered == 0 && (totalSize.isAccurate() || totalSize.getTotal() <= 1)) {
            if (resultSize == 0) {
                return Messages.AbstractWorkItemExplorer_FOUND_NONE;
            }
            if (resultSize == 1) {
                return Messages.AbstractWorkItemExplorer_FOUND_ONE;
            }
            return NLS.bind((String)Messages.AbstractWorkItemExplorer_FOUND_MANY_FORMAT, (Object)resultSize, (Object[])new Object[0]);
        }
        String explanation = this.createMissingResultExplanation(filtered, notLoaded);
        String string = searchTerm = totalSize.isAccurate() ? null : this.getSearchTerm();
        if (totalSize.isAccurate() || searchTerm == null || searchTerm.length() == 0) {
            return NLS.bind((String)Messages.AbstractWorkItemExplorer_SHOWING_X_OF_Y, (Object)resultSize, (Object[])new Object[]{totalSize.getTotal(), explanation}).trim();
        }
        return NLS.bind((String)Messages.AbstractWorkItemExplorer_SHOWING_TOP_X_OF_ESTIMATED_Y, (Object)resultSize, (Object[])new Object[]{totalSize.getEstimatedTotal(), searchTerm, explanation}).trim();
    }

    private String getSearchTerm() {
        String searchTerm = null;
        if (this.fInput != null && this.fInput.getWorkItemSource() instanceof AbstractWorkItemSource) {
            Expression expression = ((AbstractWorkItemSource)this.fInput.getWorkItemSource()).getExpression();
            List terms = QueryUtils.getFulltextTerms((Expression)expression);
            for (String term : terms) {
                searchTerm = searchTerm == null ? term : NLS.bind((String)Messages.AbstractWorkItemExplorer_LIST_FORMAT, (Object)searchTerm, (Object[])new Object[]{term});
            }
        }
        return searchTerm;
    }

    private String createMissingResultExplanation(int filtered, int notLoaded) {
        if (filtered == 0) {
            return "";
        }
        if (notLoaded == 0) {
            return NLS.bind((String)Messages.AbstractWorkItemExplorer_FILTERED, (Object)filtered, (Object[])new Object[0]);
        }
        return NLS.bind((String)Messages.AbstractWorkItemExplorer_FILTERED_AND_NOT_LOADED, (Object)filtered, (Object[])new Object[]{notLoaded});
    }

    private String createStatusMessage(IStatus status) {
        return NLS.bind((String)Messages.AbstractWorkItemExplorer_ERROR_FORMAT, (Object)status.getMessage(), (Object[])new Object[0]);
    }

    protected void installListeners() {
        this.getSite().setSelectionProvider(this.fWorkItemViewer.getRowSelectionProvider());
        this.fWorkItemViewer.getRowSelectionProvider().addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                AbstractWorkItemExplorer.this.updateActions();
                AbstractWorkItemExplorer.this.updateStatusBar();
            }
        });
        this.fWorkItemViewer.getViewer().addOpenListener(new IOpenListener(){

            public void open(OpenEvent event) {
                AbstractWorkItemExplorer.this.openSelection((IStructuredSelection)event.getSelection());
            }
        });
    }

    private void updateStatusBar() {
        String message = null;
        IStructuredSelection selection = this.fWorkItemViewer.getRawSelection();
        switch (selection.size()) {
            case 0: {
                break;
            }
            case 1: {
                if (!(selection.getFirstElement() instanceof ResolvedWorkItem)) break;
                message = WorkItemTextUtilities.getWorkItemText((IWorkItem)((ResolvedWorkItem)selection.getFirstElement()).getWorkItem());
                break;
            }
            default: {
                message = this.createOpenClosedMessage(selection);
            }
        }
        this.getViewSite().getActionBars().getStatusLineManager().setMessage(message);
    }

    private String createOpenClosedMessage(IStructuredSelection selection) {
        int total = 0;
        int open = 0;
        int closed = 0;
        for (Object selected : selection) {
            if (!(selected instanceof ResolvedWorkItem)) continue;
            ++total;
            ResolvedWorkItem resolved = (ResolvedWorkItem)selected;
            IWorkflowInfo workflow = resolved.getWorkflowInfo();
            if (workflow == null) continue;
            int stateGroup = workflow.getStateGroup(resolved.getWorkItem().getState2());
            switch (stateGroup) {
                case 1: 
                case 4: {
                    ++open;
                    break;
                }
                case 2: {
                    ++closed;
                }
            }
        }
        return NLS.bind((String)Messages.AbstractWorkItemExplorer_PATTERN_SELECTION_STATUS, (Object)total, (Object[])new Object[]{open, closed});
    }

    private void installContextMenu(final IViewSite site) {
        MenuManager contextMenuMgr = new MenuManager("#PopupMenu");
        contextMenuMgr.setRemoveAllWhenShown(true);
        contextMenuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                IStructuredSelection rowSelection = (IStructuredSelection)AbstractWorkItemExplorer.this.fWorkItemViewer.getRowSelectionProvider().getSelection();
                IStructuredSelection columnSelection = (IStructuredSelection)AbstractWorkItemExplorer.this.fWorkItemViewer.getColumnSelectionProvider().getSelection();
                IStructuredSelection rawSelection = AbstractWorkItemExplorer.this.fWorkItemViewer.getRawSelection();
                OpenWorkItemAction openAction = new OpenWorkItemAction(AbstractWorkItemExplorer.this.getSite().getPart(), rowSelection);
                openAction.setText(Messages.AbstractWorkItemExplorer_OPEN_ACTION);
                manager.add((IAction)openAction);
                manager.add((IContributionItem)new Separator("group.edit"));
                IQueryableAttribute selectedAttribute = AbstractWorkItemExplorer.this.getColumnAttribute(columnSelection);
                IAttribute attribute = this.getAttribute(selectedAttribute, rawSelection);
                if (attribute != null) {
                    IContributionItem valueSelectionItem = AttributeValueSelectorFactory.getInstance().createValueSelector(attribute, AbstractWorkItemExplorer.this.fWorkItemViewer.getRowSelectionProvider());
                    if (valueSelectionItem != null) {
                        manager.add(valueSelectionItem);
                    }
                    if (IWorkItem.TYPE_PROPERTY.equals(attribute.getIdentifier())) {
                        manager.add((IAction)new SynchronizeAttributesAction(AbstractWorkItemExplorer.this.fWorkItemViewer.getRowSelectionProvider()));
                    }
                }
                manager.add((IContributionItem)new Separator("additions"));
                manager.add(AbstractWorkItemExplorer.this.fNewTemplateAction);
                manager.add((IContributionItem)new Separator(AbstractWorkItemExplorer.GROUP_COLUMN_ACTIONS));
                manager.add((IContributionItem)new Separator("group.properties"));
                if (columnSelection.size() == 1 && rowSelection.size() == 1 && columnSelection instanceof WorkItemViewer.ColumnSelection) {
                    IAttributeLabelProvider lp = AttributeLabelProviderFactory.createLabelProvider(selectedAttribute);
                    String label = lp.getText(rowSelection.getFirstElement());
                    lp.dispose();
                    MenuManager columnContextMenu = new MenuManager(label);
                    ContextMenuHelper.buildStandardContextMenuGroups((IMenuManager)columnContextMenu);
                    ContextMenuHelper.addNewSubmenu((IMenuManager)columnContextMenu, (boolean)false);
                    AbstractWorkItemExplorer.this.fColumnActionManager.contributeObjectActions(site.getPart(), (IMenuManager)columnContextMenu, AbstractWorkItemExplorer.this.fWorkItemViewer.getColumnSelectionProvider());
                    manager.appendToGroup(AbstractWorkItemExplorer.GROUP_COLUMN_ACTIONS, (IContributionItem)columnContextMenu);
                }
                manager.add((IContributionItem)new Separator());
                manager.add(AbstractWorkItemExplorer.this.fRefreshAction);
            }

            private IAttribute getAttribute(IQueryableAttribute selectedAttribute, IStructuredSelection rawSelection) {
                if (rawSelection.isEmpty() || !(rawSelection.getFirstElement() instanceof ResolvedWorkItem)) {
                    return null;
                }
                ResolvedWorkItem resolved = (ResolvedWorkItem)rawSelection.getFirstElement();
                return resolved.findAttribute(selectedAttribute.getIdentifier());
            }
        });
        this.fWorkItemViewer.installContextMenu(contextMenuMgr);
        site.registerContextMenu(contextMenuMgr, this.fWorkItemViewer.getRowSelectionProvider());
    }

    private IQueryableAttribute getColumnAttribute(IStructuredSelection columnSelection) {
        if (columnSelection instanceof WorkItemViewer.ColumnSelection) {
            int columnIndex = ((WorkItemViewer.ColumnSelection)columnSelection).getPosition().creationIndex;
            AttributeColumn column = this.fWorkItemViewer.getColumnObjectProvider().getColumn(columnIndex);
            return column.getAttribute();
        }
        return null;
    }

    private void installMenu() {
        IMenuManager menuManager = this.getViewSite().getActionBars().getMenuManager();
        Action preferenceAction = new Action(){

            public void run() {
                PreferencesUtil.createPreferenceDialogOn((Shell)AbstractWorkItemExplorer.this.getViewSite().getShell(), (String)"com.ibm.team.workitem.ide.ui.workitemPage", null, null).open();
            }
        };
        preferenceAction.setText(Messages.AbstractWorkItemExplorer_PREFERENCES);
        Action relationshipAction = new Action(){

            public void run() {
                RelationshipDialog relationshipDialog = new RelationshipDialog(AbstractWorkItemExplorer.this.getViewSite().getShell());
                IRelationshipDescriptor[] relations = AbstractWorkItemExplorer.this.fInput != null ? AbstractWorkItemExplorer.this.getRetrievalStrategy().getRelationships() : AbstractWorkItemExplorer.this.fRelations;
                relationshipDialog.setSelectedRelationships(relations);
                if (relationshipDialog.open() == 0) {
                    AbstractWorkItemExplorer.this.fRelations = relationshipDialog.getSelectedRelationships();
                    if (AbstractWorkItemExplorer.this.fInput != null) {
                        if (AbstractWorkItemExplorer.this.getRetrievalStrategy().getRelationships().length > 0) {
                            AbstractWorkItemExplorer.this.getRetrievalStrategy().setRelationships(AbstractWorkItemExplorer.this.fRelations);
                        } else {
                            AbstractWorkItemExplorer.this.show(AbstractWorkItemExplorer.this.fInput, false);
                        }
                    }
                }
            }
        };
        relationshipAction.setText(Messages.AbstractWorkItemExplorer_RELATIONSHIPS);
        menuManager.add((IContributionItem)new Separator());
        menuManager.add((IAction)relationshipAction);
        menuManager.add((IContributionItem)new Separator());
        menuManager.add((IAction)preferenceAction);
    }

    private WorkItemViewerInput getInput() {
        return this.fInput;
    }

    private IWorkItemRetrievalStrategy getRetrievalStrategy() {
        if (this.fInput != null) {
            return this.fInput.getWorkItemSource().getRetrievalStrategy();
        }
        return null;
    }

    protected IResultModel getResultModel() {
        if (this.getRetrievalStrategy() != null) {
            return this.getRetrievalStrategy().getResultModel();
        }
        return null;
    }

    protected abstract void installActions(IToolBarManager var1);

    protected abstract String getExplorerId();

    public Object getAdapter(Class adapter) {
        if (ICollaborationContextProvider.class.equals((Object)adapter)) {
            return new DefaultCollaborationContextProvider(this.fWorkItemViewer.getRowSelectionProvider());
        }
        return super.getAdapter(adapter);
    }

    private class ActionEnablementUpdater
    extends ServerListener {
        private ActionEnablementUpdater() {
        }

        protected void repositoryAdded(ITeamRepository repository) {
            AbstractWorkItemExplorer.this.updateActions();
        }

        protected void repositoryLogin(ITeamRepository repository) {
            AbstractWorkItemExplorer.this.updateActions();
        }

        protected void repositoryLogout(ITeamRepository repository) {
            AbstractWorkItemExplorer.this.updateActions();
        }

        protected void repositoryRemoved(ITeamRepository repository) {
            AbstractWorkItemExplorer.this.updateActions();
        }

        protected void repositoryError(ITeamRepository repository) {
            AbstractWorkItemExplorer.this.updateActions();
        }
    }

    private class InputResolver
    extends UIUpdaterJob {
        private WorkItemViewerInput fToResolve;
        private boolean fAddToHistory;

        public InputResolver(String name) {
            super(name);
        }

        public void resolve(WorkItemViewerInput input, boolean addToHistory) {
            this.cancel();
            this.fToResolve = input;
            this.fAddToHistory = addToHistory;
            this.schedule();
        }

        public IStatus runInBackground(IProgressMonitor monitor) {
            WorkItemViewerInput input = this.fToResolve;
            input.resolve(monitor);
            if (this.fToResolve != input) {
                return Status.CANCEL_STATUS;
            }
            return super.runInBackground(monitor);
        }

        public IStatus runInUI(IProgressMonitor monitor) {
            AbstractWorkItemExplorer.this.show(this.fToResolve, this.fAddToHistory);
            return super.runInUI(monitor);
        }
    }

    private class ModelListener
    implements IResultModelListener,
    IRetrievalListener {
        private IResultRetrievalStrategy fRetrievalStrategy;

        public ModelListener(IResultRetrievalStrategy strategy) {
            this.fRetrievalStrategy = strategy;
            if (this.fRetrievalStrategy != null) {
                this.fRetrievalStrategy.addListener(this);
                this.fRetrievalStrategy.getResultModel().addListener(this);
            }
        }

        public void dispose() {
            if (this.fRetrievalStrategy != null) {
                this.fRetrievalStrategy.removeListener(this);
                this.fRetrievalStrategy.getResultModel().removeListener(this);
                this.fRetrievalStrategy = null;
            }
        }

        public void modelChanged(ResultModelChangedEvent event) {
            if (event.isType(4) || event.isType(6)) {
                AbstractWorkItemExplorer.this.updateInputDependencies();
            } else {
                AbstractWorkItemExplorer.this.updateActions();
            }
        }

        public void statusChanged(RetrievalEvent event) {
            if (event.getParentElement() == IResultModel.ROOT) {
                AbstractWorkItemExplorer.this.updateStatus(event);
            }
        }
    }

    private class WorkItemViewPage
    extends Page {
        private Control fControl;

        private WorkItemViewPage() {
        }

        public void createControl(Composite parent) {
            Composite viewerArea = new Composite(parent, 0);
            GridLayoutFactory.fillDefaults().spacing(0, 0).applyTo(viewerArea);
            GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)viewerArea);
            AbstractWorkItemExplorer.this.fWorkItemViewer = AbstractWorkItemExplorer.this.createWorkItemViewer(viewerArea);
            AbstractWorkItemExplorer.this.installActions(AbstractWorkItemExplorer.this.getViewSite().getActionBars().getToolBarManager());
            AbstractWorkItemExplorer.this.installMenu();
            AbstractWorkItemExplorer.this.installContextMenu(AbstractWorkItemExplorer.this.getViewSite());
            AbstractWorkItemExplorer.this.installListeners();
            AbstractWorkItemExplorer.this.updateInputDependencies();
            this.fControl = viewerArea;
        }

        public Control getControl() {
            return this.fControl;
        }

        public void setFocus() {
            AbstractWorkItemExplorer.this.fWorkItemViewer.setFocus();
        }
    }
}

