/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.rcp.ui.internal.explorer;

import com.ibm.icu.text.DateFormatSymbols;
import com.ibm.team.foundation.common.text.XMLString;
import com.ibm.team.foundation.rcp.ui.util.FoundationUIJob;
import com.ibm.team.foundation.rcp.ui.util.FoundationUIUtils;
import com.ibm.team.jface.labelProviders.ElementRemovedNotifierImpl;
import com.ibm.team.jface.labelProviders.IElementRemovedNotifier;
import com.ibm.team.jface.labelProviders.StandardLabelProvider;
import com.ibm.team.jface.util.UIUpdaterJob;
import com.ibm.team.process.rcp.ui.teamnavigator.Domain;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.client.ITeamRepositoryService;
import com.ibm.team.repository.client.TeamPlatform;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.workitem.client.IWorkItemClient;
import com.ibm.team.workitem.client.IWorkItemListener;
import com.ibm.team.workitem.client.WorkItemChangeEvent;
import com.ibm.team.workitem.common.model.IWorkItem;
import com.ibm.team.workitem.common.model.IWorkItemHandle;
import com.ibm.team.workitem.rcp.core.ClientModel;
import com.ibm.team.workitem.rcp.core.WorkItemEditorHistoryEntry;
import com.ibm.team.workitem.rcp.core.history.HistoryChangeEvent;
import com.ibm.team.workitem.rcp.core.history.IHistoryListener;
import com.ibm.team.workitem.rcp.ui.WorkItemUI;
import com.ibm.team.workitem.rcp.ui.internal.ImagePool;
import com.ibm.team.workitem.rcp.ui.internal.WorkItemLabelProvider;
import com.ibm.team.workitem.rcp.ui.internal.WorkItemRCPUIPlugin;
import com.ibm.team.workitem.rcp.ui.internal.explorer.HistoryRange;
import com.ibm.team.workitem.rcp.ui.internal.explorer.Messages;
import com.ibm.team.workitem.rcp.ui.internal.explorer.WorkItemTreeSorter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.DeviceResourceDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.jface.viewers.DecoratingLabelProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreePathContentProvider;
import org.eclipse.jface.viewers.ITreePathLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerLabel;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.internal.ObjectActionContributorManager;
import org.eclipse.ui.progress.UIJob;

public class HistoryDomain
extends Domain {
    public static final String LABEL_OLDER = Messages.HistoryDomain_LABEL_OLDER;
    public static final String LABEL_YESTERDAY = Messages.HistoryDomain_LABEL_YESTERDAY;
    public static final String LABEL_EARLIER_TODAY = Messages.HistoryDomain_LABEL_EARLIER_TODAY;
    public static final String NLS_PATTERN_DAYS_AGO = Messages.HistoryDomain_PATTERN_DAYS_AGO;
    public static final String NLS_PATTERN_OLDER_THAN = Messages.HistoryDomain_PATTERN_OLDER_THAN;
    private static final long ONE_DAY = 86400000L;
    private static final int TODAY_MAX = 5;
    private static final Calendar fgCal = Calendar.getInstance();
    private ITreePathLabelProvider fLabelProvider;
    private ITreePathContentProvider fContentProvider;
    private ViewerSorter fSorter;
    private StructuredViewer fViewer;
    private int fMaxRange;
    private HistoryRange[] fHistoryRanges;
    private ISelectionProvider fHistorySelectionProvider = new ISelectionProvider(){

        public void addSelectionChangedListener(ISelectionChangedListener listener) {
            HistoryDomain.this.fViewer.addSelectionChangedListener(listener);
        }

        public ISelection getSelection() {
            IStructuredSelection selection = (IStructuredSelection)HistoryDomain.this.fViewer.getSelection();
            ArrayList<Object> converted = new ArrayList<Object>();
            for (Object next : selection) {
                Object convert;
                if (next == (convert = HistoryDomain.this.convertToModel(next))) continue;
                converted.add(convert);
            }
            return new StructuredSelection(converted);
        }

        public void removeSelectionChangedListener(ISelectionChangedListener listener) {
            HistoryDomain.this.fViewer.removeSelectionChangedListener(listener);
        }

        public void setSelection(ISelection selection) {
        }
    };

    protected void testCallback(boolean succeded) {
    }

    public void update(WorkItemChangeEvent event) {
        if (this.fViewer == null) {
            return;
        }
        final IWorkItem workItem = event.getWorkItem();
        WorkItemEditorHistoryEntry[] historyEntries = ClientModel.getHistoryManager().getHistoryEntries();
        int i = 0;
        while (i < historyEntries.length) {
            final WorkItemEditorHistoryEntry entry = historyEntries[i];
            if (entry.getWorkItem().sameItemId((IItemHandle)workItem)) {
                UIUpdaterJob job = new UIUpdaterJob(Messages.HistoryDomain_HANDLING_CHANGE_EVENT_JOB_NAME){

                    public IStatus runInBackground(IProgressMonitor monitor) {
                        IWorkItem realWorkItem = workItem;
                        ITeamRepository teamRepository = null;
                        if (realWorkItem.getOrigin() instanceof ITeamRepository) {
                            teamRepository = (ITeamRepository)realWorkItem.getOrigin();
                            entry.setRepository(teamRepository.getRepositoryURI());
                        }
                        if (teamRepository != null && teamRepository.loggedIn() && teamRepository.getErrorState() == 0) {
                            String[] stringArray = WorkItemLabelProvider.REQUIRED_PROPERTIES;
                            int n = WorkItemLabelProvider.REQUIRED_PROPERTIES.length;
                            int n2 = 0;
                            while (n2 < n) {
                                String property = stringArray[n2];
                                if (!realWorkItem.isPropertySet(property)) {
                                    realWorkItem = this.resolve(realWorkItem, teamRepository, monitor);
                                    break;
                                }
                                ++n2;
                            }
                        } else {
                            HistoryDomain.this.testCallback(false);
                            return Status.OK_STATUS;
                        }
                        if (realWorkItem == null) {
                            HistoryDomain.this.testCallback(false);
                            return Status.OK_STATUS;
                        }
                        String desc = null;
                        try {
                            desc = WorkItemRCPUIPlugin.getWorkItemDescription((IWorkItemHandle)realWorkItem, monitor);
                        }
                        catch (TeamRepositoryException e) {
                            WorkItemRCPUIPlugin.getDefault().log(Messages.HistoryDomain_ERROR_GETTING_DESCRIPTION, e);
                            HistoryDomain.this.testCallback(false);
                            return Status.OK_STATUS;
                        }
                        entry.setDescription(desc);
                        HistoryDomain.this.testCallback(true);
                        return super.runInBackground(monitor);
                    }

                    private IWorkItem resolve(IWorkItem workItem2, ITeamRepository teamRepository, IProgressMonitor monitor) {
                        try {
                            return (IWorkItem)teamRepository.itemManager().fetchPartialItem((IItemHandle)workItem2, 0, Arrays.asList(WorkItemLabelProvider.REQUIRED_PROPERTIES), monitor);
                        }
                        catch (TeamRepositoryException e) {
                            WorkItemRCPUIPlugin.getDefault().log(Messages.HistoryDomain_ERROR_RESOLVING_WORK_ITEM, e);
                            return null;
                        }
                    }

                    public IStatus runInUI(IProgressMonitor monitor) {
                        if (HistoryDomain.this.fViewer != null && !HistoryDomain.this.fViewer.getControl().isDisposed()) {
                            HistoryDomain.this.fViewer.refresh((Object)entry);
                        }
                        return super.runInUI(monitor);
                    }
                };
                job.schedule();
            }
            ++i;
        }
    }

    private long getMorning() {
        Calendar cal = Calendar.getInstance();
        long ret = cal.getTimeInMillis();
        ret -= (long)cal.get(14);
        ret -= (long)(cal.get(13) * 1000);
        ret -= (long)(cal.get(12) * 1000 * 60);
        return ret -= (long)(cal.get(11) * 1000 * 3600);
    }

    public Object getRoot() {
        return this;
    }

    public boolean contains(Object element) {
        return element instanceof HistoryRange || element instanceof WorkItemEditorHistoryEntry || element instanceof HistoryDomain;
    }

    public Object convertToModel(Object object) {
        if (object instanceof WorkItemEditorHistoryEntry) {
            WorkItemEditorHistoryEntry entry = (WorkItemEditorHistoryEntry)object;
            return entry.getWorkItem();
        }
        return object;
    }

    public ITreePathLabelProvider getLabelProvider() {
        if (this.fLabelProvider == null) {
            this.fLabelProvider = new DecoratingLabelProvider((ILabelProvider)new StandardLabelProvider((ILabelProvider)new HistoryLabelProvider(), (IElementRemovedNotifier)new ElementRemovedNotifierImpl()), null);
        }
        return this.fLabelProvider;
    }

    public ITreePathContentProvider getContentProvider() {
        if (this.fContentProvider == null) {
            this.fContentProvider = new HistoryContentProvider();
        }
        return this.fContentProvider;
    }

    public ViewerSorter getSorter() {
        if (this.fSorter == null) {
            this.fSorter = new WorkItemTreeSorter();
        }
        return this.fSorter;
    }

    public void contributeContextMenuActions(IMenuManager manager, IStructuredSelection selection) {
        ObjectActionContributorManager.getManager().contributeObjectActions(this.getWorkbenchPart(), manager, this.fHistorySelectionProvider);
    }

    public boolean open(IWorkbenchPartSite site, IStructuredSelection selection) {
        boolean opened = false;
        for (Object object : selection) {
            if (object instanceof HistoryRange || object instanceof HistoryDomain) {
                Object[] children = null;
                String name = null;
                if (object instanceof HistoryRange) {
                    TreePath treePath = new TreePath(new Object[]{object});
                    children = this.getContentProvider().getChildren(treePath);
                    ViewerLabel label = new ViewerLabel("", null);
                    this.getLabelProvider().updateLabel(label, treePath);
                    name = label.getText();
                } else if (object instanceof HistoryDomain) {
                    children = this.getContentProvider().getElements(null);
                    name = Messages.HistoryDomain_WORKITEM_HISTORY;
                }
                if (children == null) continue;
                ArrayList<IWorkItemHandle> workItems = new ArrayList<IWorkItemHandle>(children.length);
                int i = 0;
                while (i < children.length) {
                    Object child = this.convertToModel(children[i]);
                    if (child instanceof IWorkItemHandle) {
                        workItems.add((IWorkItemHandle)child);
                    }
                    ++i;
                }
                if (workItems.size() <= 0) continue;
                WorkItemUI.showWorkItems(site.getWorkbenchWindow(), name, workItems.toArray(new IWorkItemHandle[workItems.size()]));
                opened = true;
                continue;
            }
            try {
                IWorkItemHandle handle = object instanceof IWorkItemHandle ? (IWorkItemHandle)object : ((WorkItemEditorHistoryEntry)object).getWorkItem();
                ITeamRepository repository = (ITeamRepository)handle.getOrigin();
                FoundationUIUtils.validateRepository((ITeamRepository)repository, (boolean)true, null);
                if (WorkItemUI.openEditor(site.getPage(), handle) == null) continue;
                opened = true;
            }
            catch (RuntimeException runtimeException) {
                MessageDialog.openError((Shell)site.getShell(), (String)Messages.HistoryDomain_ERROR_OPENING_WORKITEM, (String)Messages.HistoryDomain_ERROR_REPOSITORY_NOT_FOUND);
            }
        }
        return opened;
    }

    public void dispose() {
        if (this.fContentProvider != null) {
            this.fContentProvider.dispose();
        }
        this.fContentProvider = null;
        if (this.fLabelProvider != null) {
            this.fLabelProvider.dispose();
        }
        this.fLabelProvider = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getDayName(int range) {
        Calendar calendar = fgCal;
        synchronized (calendar) {
            Date date = new Date(System.currentTimeMillis() - (long)range * 86400000L);
            fgCal.setTime(date);
            DateFormatSymbols sym = new DateFormatSymbols();
            return sym.getWeekdays()[fgCal.get(7)];
        }
    }

    private class HistoryContentProvider
    implements ITreePathContentProvider {
        private ITeamRepositoryService.IRepositoryServiceListener fRepoServiceListener;
        private IWorkItemListener fMyWorkItemListener = new IWorkItemListener(){

            public void workItemAttributeChanged(WorkItemChangeEvent event) {
                HistoryDomain.this.update(event);
            }

            public void workItemAttributeDependencyChanged(WorkItemChangeEvent event) {
            }
        };
        private IHistoryListener fMyHistoryListener = new IHistoryListener(){
            private UIJob fJob = new FoundationUIJob(Messages.HistoryDomain_HANDLING_CHANGE_EVENT_JOB_NAME){

                public IStatus runProtectedInUI(IProgressMonitor monitor) {
                    if (HistoryDomain.this.fViewer != null && !HistoryDomain.this.fViewer.getControl().isDisposed()) {
                        HistoryDomain.this.fViewer.refresh(HistoryDomain.this.getRoot());
                    }
                    return Status.OK_STATUS;
                }
            };

            public void historyChanged(HistoryChangeEvent event) {
                if (!this.fJob.isSystem()) {
                    this.fJob.setSystem(true);
                }
                this.fJob.schedule(100L);
            }
        };
        private boolean[] fFlags;

        HistoryContentProvider() {
            HistoryDomain.this.fHistoryRanges = new HistoryRange[8];
            int i = 0;
            while (i < 8) {
                ((HistoryDomain)HistoryDomain.this).fHistoryRanges[i] = new HistoryRange(i);
                ++i;
            }
            this.initServerRegistryListener();
            ITeamRepository[] repos = TeamPlatform.getTeamRepositoryService().getTeamRepositories();
            int i2 = 0;
            while (i2 < repos.length) {
                IWorkItemClient wiclient = (IWorkItemClient)repos[i2].getClientLibrary(IWorkItemClient.class);
                if (wiclient != null) {
                    wiclient.addWorkItemListener(this.fMyWorkItemListener);
                }
                ++i2;
            }
            ClientModel.getHistoryManager().addHistoryListener(this.fMyHistoryListener);
        }

        public void dispose() {
            TeamPlatform.getTeamRepositoryService().removeRepositoryServiceListener(this.fRepoServiceListener);
            ClientModel.getHistoryManager().removeHistoryListener(this.fMyHistoryListener);
            ITeamRepository[] repos = TeamPlatform.getTeamRepositoryService().getTeamRepositories();
            int i = 0;
            while (i < repos.length) {
                IWorkItemClient wiclient = (IWorkItemClient)repos[i].getClientLibrary(IWorkItemClient.class);
                if (wiclient != null) {
                    wiclient.removeWorkItemListener(this.fMyWorkItemListener);
                }
                ++i;
            }
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            HistoryDomain.this.fViewer = (StructuredViewer)viewer;
        }

        public Object[] getElements(Object inputElement) {
            ArrayList<Object> result = new ArrayList<Object>();
            int n = 0;
            this.fFlags = new boolean[8];
            int totRanges = 0;
            WorkItemEditorHistoryEntry[] historyEntries = ClientModel.getHistoryManager().getHistoryEntries();
            int i = 0;
            while (i < historyEntries.length) {
                WorkItemEditorHistoryEntry e = historyEntries[i];
                int range = this.getRange(e.getDate());
                if (range == 0 && n < 5) {
                    result.add(e);
                    ++n;
                } else if (!this.fFlags[range]) {
                    this.fFlags[range] = true;
                    if (++totRanges == 8) break;
                }
                ++i;
            }
            int maxRange = -1;
            int detailedRangesCount = 0;
            int i2 = 0;
            while (i2 < this.fFlags.length) {
                if (this.fFlags[i2]) {
                    if (detailedRangesCount < 6 && i2 != 7) {
                        maxRange = i2;
                        ++detailedRangesCount;
                        result.add(HistoryDomain.this.fHistoryRanges[i2]);
                    }
                    if (i2 == 7) {
                        result.add(HistoryDomain.this.fHistoryRanges[i2]);
                    }
                }
                ++i2;
            }
            HistoryDomain.this.fMaxRange = maxRange;
            return result.toArray();
        }

        private void initServerRegistryListener() {
            this.fRepoServiceListener = new ITeamRepositoryService.IRepositoryServiceListener(){

                public void addedRepository(ITeamRepository repositiory) {
                    IWorkItemClient wiClient = (IWorkItemClient)repositiory.getClientLibrary(IWorkItemClient.class);
                    if (wiClient != null) {
                        wiClient.addWorkItemListener(HistoryContentProvider.this.fMyWorkItemListener);
                    }
                }

                public void removedRepository(ITeamRepository repositiory) {
                    IWorkItemClient wiClient = (IWorkItemClient)repositiory.getClientLibrary(IWorkItemClient.class);
                    if (wiClient != null) {
                        wiClient.removeWorkItemListener(HistoryContentProvider.this.fMyWorkItemListener);
                    }
                }
            };
            TeamPlatform.getTeamRepositoryService().addRepositoryServiceListener(this.fRepoServiceListener);
        }

        private int getRange(Date da) {
            long date = da.getTime();
            long begin = HistoryDomain.this.getMorning();
            if (begin < date) {
                return 0;
            }
            if ((begin -= 86400000L) <= date) {
                return 1;
            }
            if ((begin -= 86400000L) <= date) {
                return 2;
            }
            if ((begin -= 86400000L) <= date) {
                return 3;
            }
            if ((begin -= 86400000L) <= date) {
                return 4;
            }
            if ((begin -= 86400000L) <= date) {
                return 5;
            }
            if ((begin -= 86400000L) <= date) {
                return 6;
            }
            return 7;
        }

        public Object[] getChildren(TreePath parentPath) {
            Object parentElement = parentPath.getLastSegment();
            if (parentElement instanceof HistoryRange) {
                ArrayList<WorkItemEditorHistoryEntry> result = new ArrayList<WorkItemEditorHistoryEntry>();
                int n = 0;
                int r = ((HistoryRange)parentElement).getRange();
                WorkItemEditorHistoryEntry[] historyEntries = ClientModel.getHistoryManager().getHistoryEntries();
                int i = 0;
                while (i < historyEntries.length) {
                    WorkItemEditorHistoryEntry e = historyEntries[i];
                    int range = this.getRange(e.getDate());
                    if (range == r) {
                        if (r == 0) {
                            if (n >= 5) {
                                result.add(e);
                            }
                            ++n;
                        } else {
                            result.add(e);
                        }
                    } else if (r == 7 && range > HistoryDomain.this.fMaxRange) {
                        result.add(e);
                    }
                    ++i;
                }
                return result.toArray();
            }
            return null;
        }

        public TreePath[] getParents(Object element) {
            if (element instanceof HistoryRange) {
                return new TreePath[]{new TreePath(new Object[]{HistoryDomain.this.getRoot()})};
            }
            return new TreePath[0];
        }

        public boolean hasChildren(TreePath path) {
            Object element = path.getLastSegment();
            if (element == HistoryDomain.this.getRoot()) {
                return ClientModel.getHistoryManager().getHistoryEntries().length > 0;
            }
            return element instanceof HistoryRange;
        }
    }

    private class HistoryLabelProvider
    extends LabelProvider
    implements ITreePathLabelProvider {
        private ResourceManager fResources = new LocalResourceManager(JFaceResources.getResources());

        HistoryLabelProvider() {
        }

        public String getText(Object obj) {
            ViewerLabel label = new ViewerLabel("", null);
            this.updateLabel(label, new TreePath(new Object[]{obj}));
            return label.getText();
        }

        public Image getImage(Object obj) {
            ViewerLabel label = new ViewerLabel("", null);
            this.updateLabel(label, new TreePath(new Object[]{obj}));
            return label.getImage();
        }

        public void dispose() {
            this.fResources.dispose();
        }

        public void updateLabel(ViewerLabel label, TreePath elementPath) {
            Object obj = elementPath.getLastSegment();
            if (obj instanceof HistoryRange) {
                Object existing = this.fResources.find((DeviceResourceDescriptor)ImagePool.HISTORY_ICON);
                if (existing instanceof Image) {
                    label.setImage((Image)existing);
                } else {
                    label.setImage(this.fResources.createImageWithDefault(ImagePool.HISTORY_ICON));
                }
                int range = ((HistoryRange)obj).getRange();
                if (range > HistoryDomain.this.fMaxRange) {
                    if (HistoryDomain.this.fMaxRange < 2) {
                        label.setText(LABEL_OLDER);
                    } else {
                        label.setText(NLS.bind((String)NLS_PATTERN_OLDER_THAN, (Object)HistoryDomain.this.fMaxRange));
                    }
                    return;
                }
                switch (range) {
                    case 0: {
                        label.setText(LABEL_EARLIER_TODAY);
                        break;
                    }
                    case 1: {
                        label.setText(LABEL_YESTERDAY);
                        break;
                    }
                    default: {
                        label.setText(NLS.bind((String)NLS_PATTERN_DAYS_AGO, (Object)range, (Object)HistoryDomain.getDayName(range)));
                        break;
                    }
                }
            } else if (obj instanceof WorkItemEditorHistoryEntry) {
                WorkItemEditorHistoryEntry w = (WorkItemEditorHistoryEntry)obj;
                label.setText(XMLString.createFromXMLText((String)w.getDescription()).getPlainText());
                label.setImage(this.fResources.createImageWithDefault(ImagePool.WORKITEM_TITLE));
            } else {
                label.setText(super.getText(obj));
                label.setImage(super.getImage(obj));
            }
        }
    }
}

