/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.rcp.ui.internal.dashboard;

import com.ibm.team.process.common.IProjectAreaHandle;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.workitem.client.IWorkItemClient;
import com.ibm.team.workitem.client.internal.util.ClientUtils;
import com.ibm.team.workitem.common.model.IAttribute;
import com.ibm.team.workitem.common.model.IWorkItemType;
import com.ibm.team.workitem.common.model.Identifier;
import com.ibm.team.workitem.rcp.ui.internal.dashboard.AbstractGroupingCollector;
import com.ibm.team.workitem.rcp.ui.internal.dashboard.IGroupingCollector;
import com.ibm.team.workitem.rcp.ui.internal.dashboard.QuerySummary;
import com.ibm.team.workitem.rcp.ui.internal.dashboard.WorkItemGroupingProvider;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TypeGroupingProvider
extends WorkItemGroupingProvider {
    public TypeGroupingProvider(String label, Identifier<IAttribute> identifier) {
        super(label, identifier);
    }

    @Override
    public boolean supportsShowAllGroups() {
        return true;
    }

    @Override
    public IGroupingCollector createCollector(IGroupingCollector.Mode mode) {
        return new TypeCollector(mode);
    }

    private static class TypeCollector
    extends AbstractGroupingCollector {
        private final IGroupingCollector.Mode fMode;

        public TypeCollector(IGroupingCollector.Mode mode) {
            this.fMode = mode;
        }

        public void add(IProjectAreaHandle projectArea, String key, int count, IProgressMonitor monitor) throws TeamRepositoryException {
            QuerySummary summary = this.findSummary(projectArea, key, monitor);
            summary.addCount(count);
        }

        private QuerySummary findSummary(IProjectAreaHandle projectArea, String key, IProgressMonitor monitor) throws TeamRepositoryException {
            QuerySummary summary;
            if (IGroupingCollector.Mode.ALL_VALUES == this.fMode && this.isEmpty()) {
                IWorkItemClient workItemClient = (IWorkItemClient)ClientUtils.getClientLibrary((IItemHandle)projectArea, IWorkItemClient.class);
                List types = workItemClient.findWorkItemTypes(projectArea, monitor);
                for (IWorkItemType type : types) {
                    QuerySummary summary2 = new QuerySummary(type.getDisplayName(), 0);
                    summary2.addValue(type.getIdentifier());
                    this.addSummary(summary2);
                }
            }
            if ((summary = this.findExisting(key)) == null) {
                IWorkItemType type;
                IWorkItemClient workItemClient = (IWorkItemClient)ClientUtils.getClientLibrary((IItemHandle)projectArea, IWorkItemClient.class);
                type = workItemClient.findWorkItemType(projectArea, key, monitor);
                summary = new QuerySummary(type != null ? type.getDisplayName() : key, 0);
                summary.addValue(key);
                this.addSummary(summary);
            }
            return summary;
        }
    }
}

