/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.rcp.ui.internal.dashboard;

import com.ibm.team.process.common.IProjectAreaHandle;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.workitem.client.IWorkItemClient;
import com.ibm.team.workitem.client.internal.util.ClientUtils;
import com.ibm.team.workitem.common.internal.model.WorkItemAttributes;
import com.ibm.team.workitem.common.model.IAttribute;
import com.ibm.team.workitem.common.model.IState;
import com.ibm.team.workitem.common.model.Identifier;
import com.ibm.team.workitem.common.workflow.ICombinedWorkflowInfos;
import com.ibm.team.workitem.rcp.ui.internal.dashboard.AbstractGroupingCollector;
import com.ibm.team.workitem.rcp.ui.internal.dashboard.IGroupingCollector;
import com.ibm.team.workitem.rcp.ui.internal.dashboard.IQuerySummary;
import com.ibm.team.workitem.rcp.ui.internal.dashboard.Messages;
import com.ibm.team.workitem.rcp.ui.internal.dashboard.QuerySummary;
import com.ibm.team.workitem.rcp.ui.internal.dashboard.WorkItemGroupingProvider;
import java.util.HashMap;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StateGroupingProvider
extends WorkItemGroupingProvider {
    private boolean fUseStatusGroups;
    private String fIdentifier;

    public StateGroupingProvider(String label, boolean useStatusGroups, String identifier) {
        super(label, (Identifier<IAttribute>)WorkItemAttributes.STATE);
        this.fUseStatusGroups = useStatusGroups;
        this.fIdentifier = identifier;
    }

    @Override
    public String getId() {
        return this.fIdentifier;
    }

    @Override
    public boolean supportsShowAllGroups() {
        return true;
    }

    @Override
    public IGroupingCollector createCollector(IGroupingCollector.Mode mode) {
        return new StateCollector(mode);
    }

    @Override
    public void sort(List<IQuerySummary> summaries) {
        if (!this.fUseStatusGroups) {
            super.sort(summaries);
        }
    }

    private class StateCollector
    extends AbstractGroupingCollector {
        private final IGroupingCollector.Mode fMode;
        private HashMap<Integer, QuerySummary> fGroupMap;

        public StateCollector(IGroupingCollector.Mode mode) {
            this.fMode = mode;
            this.fGroupMap = new HashMap();
            this.fGroupMap.put(1, new QuerySummary(Messages.StateGroupingProvider_GROUP_OPEN, 0));
            this.fGroupMap.put(4, new QuerySummary(Messages.StateGroupingProvider_GROUP_IN_PROGRESS, 0));
            this.fGroupMap.put(2, new QuerySummary(Messages.StateGroupingProvider_GROUP_CLOSED, 0));
            this.fGroupMap.put(0, new QuerySummary(Messages.StateGroupingProvider_GROUP_UNKNOWN, 0));
        }

        public void add(IProjectAreaHandle projectArea, String key, int count, IProgressMonitor monitor) throws TeamRepositoryException {
            QuerySummary summary = this.findSummary(projectArea, key, monitor);
            summary.addCount(count);
        }

        private QuerySummary findSummary(IProjectAreaHandle projectArea, String key, IProgressMonitor monitor) throws TeamRepositoryException {
            QuerySummary summary;
            if (IGroupingCollector.Mode.ALL_VALUES == this.fMode && this.isEmpty()) {
                Identifier stateId;
                int n;
                int n2;
                IWorkItemClient workItemClient = (IWorkItemClient)ClientUtils.getClientLibrary((IItemHandle)projectArea, IWorkItemClient.class);
                ICombinedWorkflowInfos workflowInfos = workItemClient.findCombinedWorkflowInfos(projectArea, monitor);
                if (!StateGroupingProvider.this.fUseStatusGroups) {
                    Identifier[] identifierArray = workflowInfos.getAllStateIds();
                    n2 = identifierArray.length;
                    n = 0;
                    while (n < n2) {
                        stateId = identifierArray[n];
                        QuerySummary summary2 = new QuerySummary(workflowInfos.getStateName(stateId), 0);
                        summary2.addValue(stateId.getStringIdentifier());
                        this.addSummary(summary2);
                        ++n;
                    }
                } else {
                    Identifier[] identifierArray = workflowInfos.getAllStateIds();
                    n2 = identifierArray.length;
                    n = 0;
                    while (n < n2) {
                        stateId = identifierArray[n];
                        int group = workflowInfos.getStateGroup(stateId);
                        QuerySummary summary3 = this.fGroupMap.get(group);
                        summary3.addValue(stateId.getStringIdentifier());
                        ++n;
                    }
                    this.addSummary(this.fGroupMap.get(1));
                    this.addSummary(this.fGroupMap.get(4));
                    this.addSummary(this.fGroupMap.get(2));
                    this.addSummary(this.fGroupMap.get(0));
                }
            }
            if ((summary = this.findExisting(key)) == null) {
                IWorkItemClient workItemClient = (IWorkItemClient)ClientUtils.getClientLibrary((IItemHandle)projectArea, IWorkItemClient.class);
                ICombinedWorkflowInfos workflowInfos = workItemClient.findCombinedWorkflowInfos(projectArea, monitor);
                Identifier stateId = Identifier.create(IState.class, (String)key);
                if (!StateGroupingProvider.this.fUseStatusGroups) {
                    String stateName = workflowInfos.getStateName(stateId);
                    summary = new QuerySummary(stateName != null ? stateName : key, 0);
                } else {
                    int group = workflowInfos.getStateGroup(stateId);
                    summary = this.fGroupMap.get(group);
                }
                summary.addValue(key);
                this.addSummary(summary);
            }
            return summary;
        }
    }
}

