/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.rcp.ui.internal.dashboard;

import com.ibm.team.jface.labelProviders.ElementRemovedNotifierImpl;
import com.ibm.team.jface.labelProviders.IElementRemovedNotifier;
import com.ibm.team.jface.labelProviders.StandardLabelProvider;
import com.ibm.team.process.common.IProjectAreaHandle;
import com.ibm.team.process.rcp.ui.teamnavigator.ConnectedProjectAreaRegistry;
import com.ibm.team.repository.common.IAuditableHandle;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.ItemNotFoundException;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.workitem.client.IAuditableClient;
import com.ibm.team.workitem.client.internal.util.ClientUtils;
import com.ibm.team.workitem.common.internal.util.ItemHandleAwareHashSet;
import com.ibm.team.workitem.common.query.IQueryDescriptor;
import com.ibm.team.workitem.common.query.IQueryDescriptorHandle;
import com.ibm.team.workitem.rcp.ui.internal.HelpContextIds;
import com.ibm.team.workitem.rcp.ui.internal.dashboard.Messages;
import com.ibm.team.workitem.rcp.ui.internal.dashboard.QuerySectionWizardContext;
import com.ibm.team.workitem.rcp.ui.internal.queries.QuerySelectionDialog;
import com.ibm.team.workitem.rcp.ui.internal.util.RepositoryOperationRunnable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SelectQueriesWizardPage
extends WizardPage {
    private static final String PAGE_NAME = "com.ibm.team.workitem.rcp.ui.SelectQueries";
    private QuerySectionWizardContext fContext;
    private List<IQueryDescriptor> fQueries;
    private boolean fResolvingStarted;
    private TableViewer fTableViewer;
    private Button fAddQueryButton;
    private Button fRemoveButton;
    private Button fUpButton;
    private Button fDownButton;

    public SelectQueriesWizardPage(QuerySectionWizardContext wizardContext) {
        super(PAGE_NAME, Messages.SelectQueriesWizardPage_SELECT_QUERIES_TITLE, null);
        this.setDescription(Messages.SelectQueriesWizardPage_SELECT_QUERIES_DESCRIPTION);
        this.fContext = wizardContext;
        this.fQueries = new ArrayList<IQueryDescriptor>();
    }

    public void createControl(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        Composite container = new Composite(parent, 0);
        GridLayoutFactory.swtDefaults().numColumns(2).spacing(5, 5).applyTo(container);
        this.setControl((Control)container);
        this.fTableViewer = new TableViewer(container);
        this.fTableViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.fTableViewer.setLabelProvider((IBaseLabelProvider)new StandardLabelProvider((IElementRemovedNotifier)new ElementRemovedNotifierImpl()));
        this.fTableViewer.setInput(this.fQueries);
        this.fTableViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                SelectQueriesWizardPage.this.updateButtonEnablement();
            }
        });
        this.fAddQueryButton = new Button(container, 0);
        this.fAddQueryButton.setText(Messages.SelectQueriesWizardPage_ADD_QUERY);
        this.fAddQueryButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SelectQueriesWizardPage.this.addQueries();
            }
        });
        this.fRemoveButton = new Button(container, 0);
        this.fRemoveButton.setText(Messages.SelectQueriesWizardPage_REMOVE);
        this.fRemoveButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SelectQueriesWizardPage.this.removeQueries();
            }
        });
        this.fUpButton = new Button(container, 0);
        this.fUpButton.setText(Messages.SelectQueriesWizardPage_UP);
        this.fUpButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SelectQueriesWizardPage.this.move(-1);
            }
        });
        this.fDownButton = new Button(container, 0);
        this.fDownButton.setText(Messages.SelectQueriesWizardPage_DOWN);
        this.fDownButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SelectQueriesWizardPage.this.move(1);
            }
        });
        GridDataFactory.fillDefaults().grab(true, true).span(1, 4).applyTo((Control)this.fTableViewer.getTable());
        GridDataFactory.fillDefaults().align(4, 1).applyTo((Control)this.fAddQueryButton);
        GridDataFactory.fillDefaults().align(4, 1).applyTo((Control)this.fRemoveButton);
        GridDataFactory.fillDefaults().align(4, 1).applyTo((Control)this.fUpButton);
        GridDataFactory.fillDefaults().align(4, 1).applyTo((Control)this.fDownButton);
        Dialog.applyDialogFont((Control)container);
        HelpContextIds.hookHelpListener((Control)container, "com.ibm.team.workitem.rcp.ui.query_section_configuration_wizard_select_queries_page");
    }

    private void addQueries() {
        QuerySelectionDialog dialog = new QuerySelectionDialog(this.getShell());
        dialog.setTitle(Messages.SelectQueriesWizardPage_SELECT_QUERIES_DIALOG_TITLE);
        dialog.setFilteredQueries(this.fQueries);
        dialog.configureProjectAreas(this.getConfiguredProjectAreas());
        if (dialog.open() == 0) {
            Object[] result;
            Object[] objectArray = result = dialog.getResult();
            int n = result.length;
            int n2 = 0;
            while (n2 < n) {
                Object object = objectArray[n2];
                if (object instanceof IQueryDescriptor) {
                    IQueryDescriptor descriptor = (IQueryDescriptor)object;
                    this.fQueries.add(descriptor);
                }
                ++n2;
            }
            this.fTableViewer.refresh();
            this.updateQueryHandles();
            this.updateButtonEnablement();
        }
    }

    private void removeQueries() {
        IStructuredSelection selection = (IStructuredSelection)this.fTableViewer.getSelection();
        for (Object selected : selection) {
            this.fQueries.remove(selected);
        }
        this.fTableViewer.refresh();
        this.updateQueryHandles();
        this.updateButtonEnablement();
    }

    private void move(int offset) {
        IStructuredSelection selection = (IStructuredSelection)this.fTableViewer.getSelection();
        List toBeMoved = selection.toList();
        if (offset > 0) {
            Collections.reverse(toBeMoved);
        }
        for (IQueryDescriptor query : toBeMoved) {
            int index = this.fQueries.indexOf(query);
            int newIndex = index + offset;
            if (newIndex <= -1 || newIndex >= this.fQueries.size()) continue;
            this.fQueries.remove(index);
            this.fQueries.add(newIndex, query);
        }
        this.fTableViewer.refresh();
        this.updateQueryHandles();
        this.updateButtonEnablement();
    }

    private void updateButtonEnablement() {
        Object[] selection = ((IStructuredSelection)this.fTableViewer.getSelection()).toArray();
        this.fRemoveButton.setEnabled(selection.length > 0);
        this.fUpButton.setEnabled(selection.length > 0 && this.fQueries.indexOf(selection[0]) > 0);
        this.fDownButton.setEnabled(selection.length > 0 && this.fQueries.indexOf(selection[selection.length - 1]) < this.fQueries.size() - 1);
    }

    private Collection<IProjectAreaHandle> getConfiguredProjectAreas() {
        ItemHandleAwareHashSet projectAreas = new ItemHandleAwareHashSet();
        List connected = ConnectedProjectAreaRegistry.getDefault().getConnectedProjectAreas(null);
        projectAreas.addAll((Collection)connected);
        projectAreas.addAll(this.fContext.getSelectedProjectAreas());
        return projectAreas;
    }

    private void resolveQueries() {
        final List<IQueryDescriptorHandle> queryHandles = this.fContext.getQueryHandles();
        RepositoryOperationRunnable<List<IQueryDescriptor>> runnable = new RepositoryOperationRunnable<List<IQueryDescriptor>>(){

            @Override
            protected List<IQueryDescriptor> performOperation(IProgressMonitor monitor) throws TeamRepositoryException {
                ArrayList<IQueryDescriptor> resolved = new ArrayList<IQueryDescriptor>();
                for (IQueryDescriptorHandle queryDescriptorHandle : queryHandles) {
                    try {
                        IAuditableClient auditableClient = (IAuditableClient)ClientUtils.getClientLibrary((IItemHandle)queryDescriptorHandle, IAuditableClient.class);
                        IQueryDescriptor descriptor = (IQueryDescriptor)auditableClient.resolveAuditable((IAuditableHandle)queryDescriptorHandle, IQueryDescriptor.SMALL_PROFILE, monitor);
                        resolved.add(descriptor);
                    }
                    catch (ItemNotFoundException itemNotFoundException) {}
                }
                return resolved;
            }
        };
        this.fQueries = (List)runnable.run((IRunnableContext)this.getContainer());
        if (runnable.getStatus().isOK()) {
            this.fTableViewer.setInput(this.fQueries);
            this.updateQueryHandles();
        } else {
            this.setErrorMessage(runnable.getStatus().getMessage());
        }
    }

    private List<IQueryDescriptorHandle> getQueryHandles() {
        ArrayList<IQueryDescriptorHandle> handles = new ArrayList<IQueryDescriptorHandle>(this.fQueries.size());
        for (IQueryDescriptor queryDescriptor : this.fQueries) {
            handles.add((IQueryDescriptorHandle)queryDescriptor.getItemHandle());
        }
        return handles;
    }

    private void updateQueryHandles() {
        this.fContext.setQueryHandles(this.getQueryHandles());
    }

    public void setVisible(boolean visible) {
        if (!this.fResolvingStarted && !this.fContext.getQueryHandles().isEmpty()) {
            this.getShell().getDisplay().asyncExec(new Runnable(){

                public void run() {
                    SelectQueriesWizardPage.this.resolveQueries();
                }
            });
            this.fResolvingStarted = true;
        }
        this.updateButtonEnablement();
        super.setVisible(visible);
    }
}

