/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.rcp.ui.internal.dashboard;

import com.ibm.team.workitem.rcp.ui.internal.HelpContextIds;
import com.ibm.team.workitem.rcp.ui.internal.dashboard.IGroupingProvider;
import com.ibm.team.workitem.rcp.ui.internal.dashboard.Messages;
import com.ibm.team.workitem.rcp.ui.internal.dashboard.QuerySectionConfiguration;
import com.ibm.team.workitem.rcp.ui.internal.dashboard.QuerySectionWizardContext;
import java.util.List;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.Text;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QuerySectionWizardPage
extends WizardPage {
    private static final String PAGE_NAME = "com.ibm.team.workitem.rcp.ui.ConfigureQuerySectionDetails";
    private static final String KEY_STYLE = "KEY_STYLE";
    private QuerySectionWizardContext fContext;
    private Button fHideEmptyCheckBox;

    protected QuerySectionWizardPage(QuerySectionWizardContext wizardContext) {
        super(PAGE_NAME, Messages.QuerySectionWizardPage_SECTION_SETTINGS, null);
        this.setDescription(Messages.QuerySectionWizardPage_CONFIGURE_DETAILS);
        this.fContext = wizardContext;
    }

    public void createControl(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        Composite container = new Composite(parent, 0);
        GridLayoutFactory.swtDefaults().numColumns(2).spacing(5, 5).applyTo(container);
        this.setControl((Control)container);
        this.createNameControls(container);
        this.createStyleControls(container);
        this.createGroupByControls(container);
        this.createHideEmptyGroupControls(container);
        this.createIntervalControls(container);
        Dialog.applyDialogFont((Control)container);
        HelpContextIds.hookHelpListener((Control)container, "com.ibm.team.workitem.rcp.ui.query_section_configuration_wizard_settings_page");
    }

    private void createNameControls(Composite container) {
        Label nameLabel = new Label(container, 0);
        nameLabel.setText(Messages.QuerySectionWizardPage_SECTION_NAME_LABEL);
        Text nameText = new Text(container, 2048);
        nameText.setText(this.fContext.getName());
        nameText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                QuerySectionWizardPage.this.handleNameModified(e);
            }
        });
        this.applyLabelGridData((Control)nameLabel);
        this.applyControlGridData((Control)nameText);
    }

    private void createStyleControls(Composite container) {
        Label styleLabel = new Label(container, 0);
        styleLabel.setText(Messages.QuerySectionWizardPage_STYLE_LABEL);
        Composite styleComposite = new Composite(container, 0);
        SelectionAdapter selectionHandler = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                QuerySectionWizardPage.this.handleStyleModified(e);
            }
        };
        Button multiBarButton = new Button(styleComposite, 16);
        multiBarButton.setText(Messages.QuerySectionWizardPage_MULTI_BAR_BUTTON);
        multiBarButton.setData(KEY_STYLE, (Object)QuerySectionConfiguration.BarStyle.multi);
        multiBarButton.setSelection(this.fContext.getStyle() == QuerySectionConfiguration.BarStyle.multi);
        multiBarButton.addSelectionListener((SelectionListener)selectionHandler);
        Button singleBarButton = new Button(styleComposite, 16);
        singleBarButton.setText(Messages.QuerySectionWizardPage_SINGLE_BAR_BUTTON);
        singleBarButton.setData(KEY_STYLE, (Object)QuerySectionConfiguration.BarStyle.single);
        singleBarButton.setSelection(this.fContext.getStyle() == QuerySectionConfiguration.BarStyle.single);
        singleBarButton.addSelectionListener((SelectionListener)selectionHandler);
        styleComposite.setLayout((Layout)new RowLayout());
        this.applyLabelGridData((Control)styleLabel);
        this.applyControlGridData((Control)styleComposite);
    }

    private void createGroupByControls(Composite container) {
        Label groupByLabel = new Label(container, 0);
        groupByLabel.setText(Messages.QuerySectionWizardPage_GROUP_BY_LABEL);
        ComboViewer comboViewer = new ComboViewer(container);
        comboViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        comboViewer.setLabelProvider((IBaseLabelProvider)new GroupingLabelProvider());
        comboViewer.setInput(this.getGroupingProviders());
        comboViewer.setSelection((ISelection)new StructuredSelection((Object)this.getGroupingProvider()));
        comboViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                QuerySectionWizardPage.this.handleGroupByModified(event);
            }
        });
        this.applyLabelGridData((Control)groupByLabel);
        this.applyControlGridData(comboViewer.getControl());
    }

    private void createHideEmptyGroupControls(Composite container) {
        new Label(container, 0);
        this.fHideEmptyCheckBox = new Button(container, 32);
        this.fHideEmptyCheckBox.setText(Messages.QuerySectionWizardPage_HIDE_EMPTY_GROUPS_LABEL);
        this.fHideEmptyCheckBox.setSelection(!this.fContext.getShowAllGroups());
        this.fHideEmptyCheckBox.setEnabled(this.getGroupingProvider().supportsShowAllGroups());
        this.fHideEmptyCheckBox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                QuerySectionWizardPage.this.handleHideEmptyGroups(e);
            }
        });
        this.applyControlGridData((Control)this.fHideEmptyCheckBox);
    }

    private void createIntervalControls(Composite container) {
        Label intervalLabel = new Label(container, 0);
        intervalLabel.setText(Messages.QuerySectionWizardPage_UPDATE_INTERVAL_LABEL);
        Composite intervalComposite = new Composite(container, 0);
        GridLayoutFactory.swtDefaults().numColumns(2).margins(0, 0).applyTo(intervalComposite);
        Spinner intervalSpinner = new Spinner(intervalComposite, 2048);
        intervalSpinner.setMinimum(1);
        intervalSpinner.setMaximum(1440);
        intervalSpinner.setSelection(this.fContext.getRefreshInterval());
        intervalSpinner.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                QuerySectionWizardPage.this.handleRefreshIntervalModified(e);
            }
        });
        Label timeUnitLabel = new Label(intervalComposite, 0);
        timeUnitLabel.setText(Messages.QuerySectionWizardPage_MINUTES);
        this.applyLabelGridData((Control)intervalLabel);
        GridDataFactory.swtDefaults().applyTo((Control)intervalComposite);
    }

    private void applyLabelGridData(Control control) {
        GridDataFactory.fillDefaults().align(4, 0x1000000).applyTo(control);
    }

    private void applyControlGridData(Control control) {
        GridDataFactory.fillDefaults().grab(true, false).applyTo(control);
    }

    private void handleNameModified(ModifyEvent e) {
        Text nameText = (Text)e.widget;
        this.fContext.setName(nameText.getText());
        this.getContainer().updateButtons();
    }

    private void handleStyleModified(SelectionEvent e) {
        Button styleButton = (Button)e.widget;
        QuerySectionConfiguration.BarStyle style = (QuerySectionConfiguration.BarStyle)((Object)styleButton.getData(KEY_STYLE));
        this.fContext.setStyle(style);
    }

    private void handleGroupByModified(SelectionChangedEvent event) {
        IStructuredSelection selection = (IStructuredSelection)event.getSelection();
        IGroupingProvider provider = (IGroupingProvider)selection.getFirstElement();
        this.fContext.setGroupingProvider(provider);
        this.fHideEmptyCheckBox.setEnabled(provider.supportsShowAllGroups());
    }

    private void handleHideEmptyGroups(SelectionEvent e) {
        Button hideEmptyCheckBox = (Button)e.widget;
        this.fContext.setShowAllGroups(!hideEmptyCheckBox.getSelection());
    }

    private void handleRefreshIntervalModified(SelectionEvent e) {
        Spinner spinner = (Spinner)e.widget;
        this.fContext.setRefreshInterval(spinner.getSelection());
    }

    private IGroupingProvider getGroupingProvider() {
        return this.fContext.getGroupingProvider();
    }

    private List<IGroupingProvider> getGroupingProviders() {
        return this.fContext.getGroupingProviders();
    }

    private static class GroupingLabelProvider
    extends LabelProvider {
        private GroupingLabelProvider() {
        }

        public String getText(Object element) {
            if (element instanceof IGroupingProvider) {
                IGroupingProvider provider = (IGroupingProvider)element;
                return provider.getDisplayName();
            }
            return super.getText(element);
        }
    }
}

