/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.rcp.ui.internal.dashboard;

import com.ibm.team.jface.dashboard.ISectionSite;
import com.ibm.team.workitem.common.internal.model.WorkItemAttributes;
import com.ibm.team.workitem.common.query.IQueryDescriptorHandle;
import com.ibm.team.workitem.rcp.ui.internal.dashboard.GroupingProviders;
import com.ibm.team.workitem.rcp.ui.internal.dashboard.IGroupingProvider;
import com.ibm.team.workitem.rcp.ui.internal.dashboard.LocationGroup;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.ui.IMemento;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QuerySectionConfiguration {
    private static final String PREF_BAR_STYLE = "PREF_BAR_STYLE";
    private static final String PREF_GROUP_BY_ID = "PREF_GROUP_BY_ID";
    private static final String PREF_SHOW_ALL_GOUPS = "PREF_SHOW_ALL_GOUPS";
    private static final String DEFAULT_PARAMETER_BAR_STYLE = "barStyle";
    private static final String DEFAULT_PARAMETER_GROUP_BY = "defaultGroupBy";
    private static final String DEFAULT_PARAMETER_SHOW_ALL = "showAllGroups";
    private static final String DEFAULT_PARAMETER_QUERIES = "defaultQueryId";
    private boolean fShowAllGroups;
    private BarStyle fBarStyle;
    private LocationGroup<IQueryDescriptorHandle> fLocations;
    private IGroupingProvider fGroupingProvider;
    private List<String> fQueryIdentifiers;
    private static final String MEMENTO_PREF_GROUP_BY = "PREF_GROUP_BY";
    private static final String MEMENTO_PREF_MULTI_BAR = "PREF_MULTI_BAR";

    public QuerySectionConfiguration(ISectionSite site) {
        this.initDefaults(site);
    }

    public void init(IMemento memento) {
        if (memento != null) {
            this.initBarStyle(memento);
            this.initLocations(memento);
            this.initGroupingProvider(memento);
            this.initShowAllGroups(memento);
        }
    }

    public void saveState(IMemento memento) {
        this.saveBarStyle(memento);
        this.saveLocations(memento);
        this.saveGroupingProvider(memento);
        this.saveShowAllGroups(memento);
    }

    public LocationGroup<IQueryDescriptorHandle> getLocations() {
        return this.fLocations;
    }

    public BarStyle getBarStyle() {
        return this.fBarStyle;
    }

    public void setBarStyle(BarStyle style) {
        this.fBarStyle = style;
    }

    public IGroupingProvider getGroupingProvider() {
        return this.fGroupingProvider;
    }

    public void setGroupingProvider(IGroupingProvider provider) {
        this.fGroupingProvider = provider;
    }

    public boolean getShowAllGroups() {
        return this.fShowAllGroups;
    }

    public void setShowAllGroups(boolean showAll) {
        this.fShowAllGroups = showAll;
    }

    public List<String> getQueryIdentifiers() {
        return Collections.unmodifiableList(this.fQueryIdentifiers);
    }

    private void initDefaults(ISectionSite site) {
        this.fBarStyle = BarStyle.multi;
        this.fGroupingProvider = GroupingProviders.get("com.ibm.team.workitem.groupingProvider.null");
        this.fShowAllGroups = false;
        this.fQueryIdentifiers = new ArrayList<String>();
        this.fLocations = new LocationGroup();
        if (site.hasParameter(DEFAULT_PARAMETER_BAR_STYLE)) {
            String barStyle = site.getParameter(DEFAULT_PARAMETER_BAR_STYLE);
            this.fBarStyle = BarStyle.valueOf(barStyle);
        }
        if (site.hasParameter(DEFAULT_PARAMETER_GROUP_BY)) {
            String groupingProviderId = site.getParameter(DEFAULT_PARAMETER_GROUP_BY);
            this.fGroupingProvider = GroupingProviders.get(groupingProviderId);
        }
        if (site.hasParameter(DEFAULT_PARAMETER_SHOW_ALL)) {
            String showAll = site.getParameter(DEFAULT_PARAMETER_SHOW_ALL);
            this.fShowAllGroups = new Boolean(showAll);
        }
        if (site.hasParameter(DEFAULT_PARAMETER_QUERIES)) {
            String[] identifiers;
            String queryIdentifiers = site.getParameter(DEFAULT_PARAMETER_QUERIES);
            String[] stringArray = identifiers = queryIdentifiers.split(",");
            int n = identifiers.length;
            int n2 = 0;
            while (n2 < n) {
                String id = stringArray[n2];
                this.fQueryIdentifiers.add(id.trim());
                ++n2;
            }
        }
    }

    private void initBarStyle(IMemento memento) {
        String barStyleString = memento.getString(PREF_BAR_STYLE);
        if (barStyleString != null) {
            this.fBarStyle = BarStyle.valueOf(barStyleString);
        }
        this.checkCompatibilityBarStyle(memento);
    }

    private void saveBarStyle(IMemento memento) {
        memento.putString(PREF_BAR_STYLE, this.fBarStyle.name());
    }

    private void initLocations(IMemento memento) {
        this.fLocations = new LocationGroup();
        this.fLocations.init(memento);
    }

    private void saveLocations(IMemento memento) {
        if (this.fLocations != null) {
            this.fLocations.saveState(memento);
        }
    }

    private void initGroupingProvider(IMemento memento) {
        String groupingProviderId = memento.getString(PREF_GROUP_BY_ID);
        if (groupingProviderId != null) {
            this.fGroupingProvider = GroupingProviders.get(groupingProviderId);
        }
        this.checkCompatibilityGroup(memento);
    }

    private void saveGroupingProvider(IMemento memento) {
        if (this.fGroupingProvider != null) {
            memento.putString(PREF_GROUP_BY_ID, this.fGroupingProvider.getId());
        }
    }

    private void initShowAllGroups(IMemento memento) {
        this.fShowAllGroups = this.initBoolean(memento, PREF_SHOW_ALL_GOUPS, this.fShowAllGroups);
    }

    private void saveShowAllGroups(IMemento memento) {
        memento.putString(PREF_SHOW_ALL_GOUPS, new Boolean(this.fShowAllGroups).toString());
    }

    private boolean initBoolean(IMemento memento, String prefKey, boolean fallBack) {
        String value = memento.getString(prefKey);
        if (value != null) {
            return new Boolean(value);
        }
        return fallBack;
    }

    private void checkCompatibilityGroup(IMemento memento) {
        String group = memento.getString(MEMENTO_PREF_GROUP_BY);
        if (this.fGroupingProvider == null && group != null) {
            if ("severity".equals(group)) {
                this.fGroupingProvider = GroupingProviders.get(WorkItemAttributes.SEVERITY.getStringIdentifier());
            } else if ("priority".equals(group)) {
                this.fGroupingProvider = GroupingProviders.get(WorkItemAttributes.PRIORITY.getStringIdentifier());
            } else if ("state".equals(group)) {
                this.fGroupingProvider = GroupingProviders.get(WorkItemAttributes.STATE.getStringIdentifier());
            } else if ("owner".equals(group)) {
                this.fGroupingProvider = GroupingProviders.get(WorkItemAttributes.OWNER.getStringIdentifier());
            }
        }
    }

    private void checkCompatibilityBarStyle(IMemento memento) {
        String useMultiBarString = memento.getString(MEMENTO_PREF_MULTI_BAR);
        if (useMultiBarString != null) {
            Boolean useMultiBar = new Boolean(useMultiBarString);
            this.fBarStyle = useMultiBar != false ? BarStyle.multi : BarStyle.single;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum BarStyle {
        multi,
        single,
        cloud;

    }
}

