/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.rcp.ui.internal.dashboard;

import com.ibm.icu.text.DateFormat;
import com.ibm.team.foundation.client.util.FoundationJob;
import com.ibm.team.jface.DoubleBufferPainter;
import com.ibm.team.jface.JazzResources;
import com.ibm.team.jface.charts.BarViewer;
import com.ibm.team.jface.charts.HoverEvent;
import com.ibm.team.jface.charts.IChartElementProvider;
import com.ibm.team.jface.charts.IHoverListener;
import com.ibm.team.jface.charts.MultiBarViewer;
import com.ibm.team.jface.charts.SingleBarViewer;
import com.ibm.team.jface.dashboard.ISectionListener;
import com.ibm.team.jface.dashboard.ISectionSite;
import com.ibm.team.jface.dashboard.Section;
import com.ibm.team.jface.dashboard.SectionLabel;
import com.ibm.team.jface.labelProviders.ElementRemovedNotifierImpl;
import com.ibm.team.jface.labelProviders.IElementRemovedNotifier;
import com.ibm.team.jface.labelProviders.StandardLabelProvider;
import com.ibm.team.process.common.IProjectAreaHandle;
import com.ibm.team.process.rcp.ui.teamnavigator.ConnectedProjectAreaRegistry;
import com.ibm.team.process.rcp.ui.teamnavigator.IConnectedProjectAreaRegistryChangeEvent;
import com.ibm.team.process.rcp.ui.teamnavigator.IConnectedProjectAreaRegistryListener;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.util.NLS;
import com.ibm.team.workitem.client.IAuditableClient;
import com.ibm.team.workitem.client.IQueryListener;
import com.ibm.team.workitem.client.QueryChangeEvent;
import com.ibm.team.workitem.client.internal.util.ClientUtils;
import com.ibm.team.workitem.client.query.QueryDescriptorEvents;
import com.ibm.team.workitem.common.IAuditableCommon;
import com.ibm.team.workitem.common.internal.util.ItemHandleAwareHashSet;
import com.ibm.team.workitem.common.internal.util.ItemQueryIterator;
import com.ibm.team.workitem.common.internal.util.WorkItemQueries;
import com.ibm.team.workitem.common.query.IQueryDescriptor;
import com.ibm.team.workitem.common.query.IQueryDescriptorHandle;
import com.ibm.team.workitem.rcp.core.queries.Query;
import com.ibm.team.workitem.rcp.ui.QueriesUI;
import com.ibm.team.workitem.rcp.ui.internal.HelpContextIds;
import com.ibm.team.workitem.rcp.ui.internal.WorkItemRCPUIPlugin;
import com.ibm.team.workitem.rcp.ui.internal.dashboard.DifferenceChartElementProvider;
import com.ibm.team.workitem.rcp.ui.internal.dashboard.GroupingProviders;
import com.ibm.team.workitem.rcp.ui.internal.dashboard.IGroupingProvider;
import com.ibm.team.workitem.rcp.ui.internal.dashboard.IRefreshable;
import com.ibm.team.workitem.rcp.ui.internal.dashboard.LocationGroup;
import com.ibm.team.workitem.rcp.ui.internal.dashboard.Messages;
import com.ibm.team.workitem.rcp.ui.internal.dashboard.PageBookControl;
import com.ibm.team.workitem.rcp.ui.internal.dashboard.QuerySectionConfiguration;
import com.ibm.team.workitem.rcp.ui.internal.dashboard.QuerySectionConfigurationWizard;
import com.ibm.team.workitem.rcp.ui.internal.dashboard.QuerySectionWizardContext;
import com.ibm.team.workitem.rcp.ui.internal.dashboard.QuerySummaryChartElementProvider;
import com.ibm.team.workitem.rcp.ui.internal.dashboard.QuerySummaryComparer;
import com.ibm.team.workitem.rcp.ui.internal.dashboard.QuerySummaryContentProvider;
import com.ibm.team.workitem.rcp.ui.internal.dashboard.QuerySummaryInput;
import com.ibm.team.workitem.rcp.ui.internal.dashboard.RefreshHandler;
import com.ibm.team.workitem.rcp.ui.internal.util.Utils;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.fieldassist.ControlDecoration;
import org.eclipse.jface.fieldassist.FieldDecorationRegistry;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.resource.FontDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.jface.util.LocalSelectionTransfer;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IOpenListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.OpenEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.dnd.DropTarget;
import org.eclipse.swt.dnd.DropTargetAdapter;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.ListDialog;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QuerySection
extends Section
implements IRefreshable,
ISectionListener {
    private static final String PAGE_KEY_NO_RESULT = "pageKeyNoResult";
    private static final String PAGE_KEY_NOT_CONNECTED = "pageKeyNotConnected";
    private static final String PAGE_KEY_EMPTY = "pageKeyEmpty";
    private static final String PAGE_KEY_MULTI_BAR = "pageKeyMultiBar";
    private static final String PAGE_KEY_SINGLE_BAR = "pageKeySingleBar";
    private Action fHideEmptyGroupsAction = new Action(Messages.QuerySection_HIDE_EMPTY_GROUPS, 2){

        public void run() {
            QuerySection.this.getConfiguration().setShowAllGroups(!this.isChecked());
            QuerySection.this.reflectConfigurationUpdates();
        }
    };
    private Action fSwitchToMultiBarAction = new Action(Messages.QuerySection_SHOW_AS_MULTIBAR, 8){

        public void run() {
            QuerySection.this.getConfiguration().setBarStyle(QuerySectionConfiguration.BarStyle.multi);
            QuerySection.this.updateCurrentPage(false);
        }
    };
    private Action fSwitchToSingleBarAction = new Action(Messages.QuerySection_SHOW_AS_SINGLEBAR, 8){

        public void run() {
            QuerySection.this.getConfiguration().setBarStyle(QuerySectionConfiguration.BarStyle.single);
            QuerySection.this.updateCurrentPage(false);
        }
    };
    private Action fConfigureAction = new Action(Messages.QuerySection_CONFIGURE){

        public void run() {
            QuerySection.this.configureSection();
        }
    };
    private IOpenListener fOpenListener = new IOpenListener(){

        public void open(OpenEvent event) {
            if (event.getSelection() instanceof StructuredSelection) {
                StructuredSelection selection = (StructuredSelection)event.getSelection();
                Object summary = selection.getFirstElement();
                QuerySection.this.markAsRead(summary);
                IQueryDescriptorHandle handle = (IQueryDescriptorHandle)ClientUtils.castObject((Object)summary, IQueryDescriptorHandle.class);
                if (handle != null) {
                    QueriesUI.showQueryResults(QuerySection.this.getSectionSite().getViewSite().getWorkbenchWindow(), handle);
                    return;
                }
                Query query = (Query)ClientUtils.castObject((Object)selection.getFirstElement(), Query.class);
                if (query != null) {
                    QueriesUI.showQueryResults(QuerySection.this.getSectionSite().getViewSite().getWorkbenchWindow(), query);
                }
            }
        }
    };
    private IHoverListener fHoverListener = new IHoverListener(){

        public void hover(HoverEvent event) {
            if (event.getSelection() instanceof StructuredSelection) {
                StructuredSelection selection = (StructuredSelection)event.getSelection();
                QuerySection.this.markAsRead(selection.getFirstElement());
            }
        }
    };
    private IConnectedProjectAreaRegistryListener fProjectAreaStateListener = new IConnectedProjectAreaRegistryListener(){

        public void connectedProjectAreaRegistryChanged(IConnectedProjectAreaRegistryChangeEvent changeEvent) {
            if (changeEvent.getType() == 0) {
                WorkItemRCPUIPlugin.runInUI("", new IRunnableWithProgress(){

                    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                        QuerySection.this.updateCurrentPage(true);
                    }
                }, null);
            }
        }
    };
    private IQueryListener fQueryChangeListener = new IQueryListener(){

        public void handleEvents(List events) {
            QuerySection.this.handleQueryChange(events);
        }
    };
    private IQueryListener fQueryDeleteListener = new IQueryListener(){

        public void handleEvents(List events) {
            QuerySection.this.handleQueryDelete(events);
        }
    };
    private List<ChangeGroupingAction> fGroupByActions;
    private QuerySectionConfiguration fConfiguration;
    private SectionLabel fTeaserLabel;
    private PageBookControl fPageBook;
    private MultiBarViewer fMultiBarViewer;
    private SingleBarViewer fSingleBarViewer;
    private ResourceManager fResourceManager;
    private RefreshHandler fRefreshHandler;
    private DifferenceChartElementProvider fChartElementProvider;
    private boolean fInitReadState = false;
    private DateFormat fTimeFormat;
    private ControlDecoration fErrorDecoration;
    private QuerySummaryInput fCurrentInput;

    public void sectionCollapsed() {
    }

    public void sectionExpanded() {
    }

    public void sectionMaximized(boolean isContentClipped) {
    }

    public void sectionResized() {
    }

    public void sectionOpened() {
        this.showQueryResults();
    }

    public QuerySection() {
        QuerySummaryChartElementProvider provider = new QuerySummaryChartElementProvider(this.getResourceManager());
        this.fChartElementProvider = new DifferenceChartElementProvider(this.getResourceManager(), provider, new QuerySummaryComparer());
        this.fTimeFormat = DateFormat.getTimeInstance((int)3);
        this.fGroupByActions = new ArrayList<ChangeGroupingAction>();
    }

    public void init(ISectionSite sectionSite, IMemento memento) {
        super.init(sectionSite, memento);
        this.fConfiguration = new QuerySectionConfiguration(sectionSite);
        this.fConfiguration.init(memento);
        this.fRefreshHandler = new RefreshHandler(this);
        this.fRefreshHandler.init(sectionSite, memento);
        sectionSite.addSectionListener((ISectionListener)this);
    }

    public void saveState(IMemento memento) {
        if (this.fConfiguration != null) {
            this.fConfiguration.saveState(memento);
        }
        if (this.fRefreshHandler != null) {
            this.fRefreshHandler.saveState(memento);
        }
    }

    public void refreshContent() {
        if (this.fRefreshHandler != null) {
            this.fRefreshHandler.scheduleRefresh(0L);
        }
    }

    @Override
    public void refresh(IProgressMonitor monitor) {
        List<IQueryDescriptorHandle> available = this.getQueryHandles(monitor);
        if (available.isEmpty()) {
            this.enableBarViewer(false);
            return;
        }
        QuerySummaryInput input = this.createQuerySummaryInput(available);
        IStatus status = input.resolve(monitor);
        this.asyncUpdateInput(input, status);
    }

    private QuerySummaryInput createQuerySummaryInput(List<IQueryDescriptorHandle> available) {
        IGroupingProvider groupingProvider = this.getConfiguration().getGroupingProvider();
        boolean showAllValues = this.getConfiguration().getShowAllGroups();
        QuerySummaryInput input = new QuerySummaryInput(available, groupingProvider, showAllValues);
        return input;
    }

    private List<IQueryDescriptorHandle> getQueryHandles(IProgressMonitor monitor) {
        LocationGroup<IQueryDescriptorHandle> locations = this.getConfiguration().getLocations();
        Collection<IQueryDescriptorHandle> handles = locations.getItems();
        if (handles.isEmpty()) {
            handles = this.findQueries(this.getConfiguration().getQueryIdentifiers(), monitor);
            locations.setItems(handles);
        }
        List<IQueryDescriptorHandle> available = this.filterByAvailability(handles);
        return available;
    }

    private void asyncUpdateInput(final QuerySummaryInput input, final IStatus status) {
        WorkItemRCPUIPlugin.runInUI("", new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                QuerySection.this.updateInput(input);
                QuerySection.this.updateTeaser(status);
            }
        }, null);
    }

    private void updateInput(QuerySummaryInput input) {
        this.fCurrentInput = input;
        if (this.getCurrentBarViewer() == null || this.getCurrentBarViewer().getControl().isDisposed()) {
            return;
        }
        if (!input.getQuerySummaries().isEmpty()) {
            this.enableBarViewer(true);
            this.fMultiBarViewer.setInput((Object)input);
            this.fSingleBarViewer.setInput((Object)input);
            this.markAllRead();
            this.getCurrentBarViewer().refresh();
        }
        this.updateCurrentPage(false);
    }

    private Collection<IQueryDescriptorHandle> findQueries(List<String> queryIdentifiers, IProgressMonitor monitor) {
        ArrayList<IQueryDescriptorHandle> handles = new ArrayList<IQueryDescriptorHandle>(queryIdentifiers.size());
        IProjectAreaHandle projectArea = this.getProjectArea();
        if (!queryIdentifiers.isEmpty() && projectArea != null) {
            MultiStatus status = new MultiStatus("com.ibm.team.workitem.rcp.ui", 0, Messages.QuerySection_MULTI_ERROR_TITLE, null);
            IAuditableClient auditableClient = (IAuditableClient)ClientUtils.getClientLibrary((IItemHandle)projectArea, IAuditableClient.class);
            for (String identifier : queryIdentifiers) {
                try {
                    ItemQueryIterator iterator = WorkItemQueries.queryDescriptorById((IAuditableCommon)auditableClient, (IProjectAreaHandle)projectArea, (String)identifier);
                    handles.addAll(iterator.toList(monitor));
                }
                catch (TeamRepositoryException e) {
                    String message = NLS.bind((String)Messages.QuerySection_PATTERN_ERROR_WHILE_QUERYING, (Object)identifier, (Object[])new Object[0]);
                    status.add(QuerySummaryInput.createStatus(message, e, (ITeamRepository)projectArea.getOrigin()));
                }
            }
            if (!status.isOK()) {
                this.asyncUpdateTeaser((IStatus)status);
            }
        }
        return handles;
    }

    private IProjectAreaHandle getProjectArea() {
        List list = ConnectedProjectAreaRegistry.getDefault().getConnectedProjectAreas(null);
        for (Object object : list) {
            IProjectAreaHandle projectArea = (IProjectAreaHandle)object;
            if (!this.isAvailable((ITeamRepository)projectArea.getOrigin())) continue;
            return projectArea;
        }
        return null;
    }

    private List<IQueryDescriptorHandle> filterByAvailability(Collection<IQueryDescriptorHandle> handles) {
        ArrayList<IQueryDescriptorHandle> available = new ArrayList<IQueryDescriptorHandle>();
        for (IQueryDescriptorHandle handle : handles) {
            if (!this.isAvailable((ITeamRepository)handle.getOrigin())) continue;
            available.add(handle);
        }
        return available;
    }

    private boolean isAvailable(ITeamRepository repository) {
        return repository.loggedIn() && repository.getErrorState() == 0;
    }

    public void createTeaser(Composite parent) {
        GridLayoutFactory.fillDefaults().numColumns(2).extendedMargins(1, 1, 1, 0).spacing(1, -1).applyTo(parent);
        Composite teaserParent = new Composite(parent, 0);
        teaserParent.setLayoutData((Object)new GridData(0x1000008, 0x1000000, true, true));
        GridLayoutFactory.fillDefaults().extendedMargins(8, 0, 0, 0).applyTo(teaserParent);
        this.fTeaserLabel = new SectionLabel(teaserParent, 131072);
        this.fTeaserLabel.setLayoutData((Object)new GridData(0x1000008, 0x1000000, true, true));
        this.fTeaserLabel.setForeground(JazzResources.getColor((ResourceManager)this.getResourceManager(), (RGB)new RGB(80, 80, 80)));
        this.fErrorDecoration = new ControlDecoration((Control)this.fTeaserLabel, 0x1004000, teaserParent);
        this.fErrorDecoration.hide();
        FontDescriptor fontDescriptor = Utils.createRelativeHeightFontDescriptor(-1);
        this.fTeaserLabel.setFont(JazzResources.getFont((ResourceManager)this.getResourceManager(), (FontDescriptor)fontDescriptor, (Font)JFaceResources.getDefaultFont()));
        this.installMenu();
        HelpContextIds.hookHelpListener((Control)parent.getParent(), "com.ibm.team.workitem.rcp.ui.query_section");
    }

    public void createContent(Composite parent) {
        this.fPageBook = new PageBookControl(parent, 0);
        this.fPageBook.getPageBook().setBackground(parent.getBackground());
        Composite noResultPage = this.fPageBook.createPage(PAGE_KEY_NO_RESULT);
        Composite notConnectedPage = this.fPageBook.createPage(PAGE_KEY_NOT_CONNECTED);
        Composite emptyPage = this.fPageBook.createPage(PAGE_KEY_EMPTY);
        Composite multiBarPage = this.fPageBook.createPage(PAGE_KEY_MULTI_BAR);
        Composite singleBarPage = this.fPageBook.createPage(PAGE_KEY_SINGLE_BAR);
        this.setupNoResultsPage(noResultPage);
        this.setupNotConnectedPage(notConnectedPage);
        this.setupEmptyPage(emptyPage);
        this.setupMultiBarPage(multiBarPage);
        this.setupSingleBarPage(singleBarPage);
        this.installDropSupport((Control)emptyPage);
        this.installDropSupport((Control)noResultPage);
        this.installDropSupport((Control)multiBarPage);
        this.installDropSupport((Control)singleBarPage);
        ConnectedProjectAreaRegistry.getDefault().addListener(this.fProjectAreaStateListener);
        QueryDescriptorEvents.getInstance().addQueryListener((Object)"com.ibm.team.workitem.query.event.QueryChanged", this.fQueryChangeListener);
        QueryDescriptorEvents.getInstance().addQueryListener((Object)"com.ibm.team.workitem.query.event.QueryDeleted", this.fQueryDeleteListener);
        this.updateCurrentPage(true);
        HelpContextIds.hookHelpListener((Control)parent, "com.ibm.team.workitem.rcp.ui.query_section");
    }

    private void asyncUpdateTeaser(final IStatus status) {
        WorkItemRCPUIPlugin.runInUI("", new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                QuerySection.this.updateTeaser(status);
            }
        }, null);
    }

    private void updateTeaser(IStatus status) {
        if (this.fTeaserLabel.isDisposed()) {
            return;
        }
        this.fTeaserLabel.setText(this.getTeaserText());
        if (status.isOK()) {
            this.fErrorDecoration.hide();
        } else {
            String message;
            String string = message = status.isMultiStatus() ? Utils.getMessage((MultiStatus)status) : status.getMessage();
            if (message == null || message.length() == 0) {
                message = Messages.QuerySection_DEFAULT_ERROR_MESSAGE;
            }
            this.fErrorDecoration.setImage(this.getImage(status));
            this.fErrorDecoration.setDescriptionText(message);
            this.fErrorDecoration.show();
        }
        this.getSectionSite().layoutTeaser();
    }

    private Image getImage(IStatus status) {
        String decorationId = this.getDecorationId(status);
        if (decorationId != null) {
            return FieldDecorationRegistry.getDefault().getFieldDecoration(decorationId).getImage();
        }
        return null;
    }

    private String getDecorationId(IStatus status) {
        switch (status.getSeverity()) {
            case 4: {
                return "DEC_ERROR";
            }
            case 2: {
                return "DEC_WARNING";
            }
            case 1: {
                return "DEC_INFORMATION";
            }
        }
        return null;
    }

    private String getTeaserText() {
        String time = this.fTimeFormat.format(new Date());
        if ("com.ibm.team.workitem.groupingProvider.null".equals(this.getConfiguration().getGroupingProvider().getId())) {
            return NLS.bind((String)Messages.QuerySection_PATTERN_TEASER_NO_GROUPING, (Object)time, (Object[])new Object[0]);
        }
        String teaserText = NLS.bind((String)Messages.QuerySection_PATTERN_TEASER_GROUPING, (Object)this.getConfiguration().getGroupingProvider().getDisplayName(), (Object[])new Object[]{time});
        return teaserText;
    }

    private boolean isShowingResults() {
        return this.getCurrentBarViewer().getInput() != null;
    }

    private boolean isConfigured() {
        boolean hasCustomQueries = !this.getConfiguration().getLocations().getItems().isEmpty();
        boolean hasDefaultQueries = !this.getConfiguration().getQueryIdentifiers().isEmpty();
        boolean hasConnectedProjectAreas = !ConnectedProjectAreaRegistry.getDefault().getConnectedProjectAreas(null).isEmpty();
        return (hasCustomQueries || hasDefaultQueries) & hasConnectedProjectAreas;
    }

    private boolean isResultEmpty() {
        if (this.fCurrentInput == null) {
            return false;
        }
        return this.fCurrentInput.getQuerySummaries().isEmpty();
    }

    private boolean isConnected() {
        return this.getProjectArea() != null;
    }

    private void setupNotConnectedPage(Composite parent) {
        Label label = new Label(parent, 0x1000000);
        label.setBackground(parent.getBackground());
        label.setFont(JFaceResources.getBannerFont());
        label.setForeground(this.getMidGray());
        label.setText(Messages.QuerySection_NOT_CONNECTED);
        GridLayoutFactory.fillDefaults().applyTo(parent);
        GridDataFactory.fillDefaults().grab(true, true).align(0x1000000, 0x1000000).applyTo((Control)label);
    }

    private Color getMidGray() {
        return PlatformUI.getWorkbench().getThemeManager().getCurrentTheme().getColorRegistry().get("com.ibm.team.workitem.rcp.ui.MID_SHADOW");
    }

    private void setupNoResultsPage(Composite parent) {
        Label label = new Label(parent, 0x1000000);
        label.setBackground(parent.getBackground());
        label.setFont(JFaceResources.getBannerFont());
        label.setForeground(this.getMidGray());
        label.setText(Messages.QuerySection_NO_RESULTS);
        GridLayoutFactory.fillDefaults().applyTo(parent);
        GridDataFactory.fillDefaults().grab(true, true).align(0x1000000, 0x1000000).applyTo((Control)label);
    }

    private void setupEmptyPage(Composite parent) {
        FillLayout layout = new FillLayout();
        layout.marginHeight = 5;
        layout.marginWidth = 5;
        parent.setLayout((Layout)layout);
        Link link = new Link(parent, 64);
        link.setText(Messages.QuerySection_EMPTY_PAGE_MESSAGE);
        link.setBackground(parent.getBackground());
        link.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                QuerySection.this.configureSection();
            }
        });
    }

    private void setupMultiBarPage(Composite parent) {
        GridLayoutFactory.fillDefaults().extendedMargins(0, 0, 2, 2).applyTo(parent);
        this.fMultiBarViewer = this.createBarViewer(parent, MultiBarViewer.class);
    }

    private void setupSingleBarPage(Composite parent) {
        GridLayoutFactory.fillDefaults().extendedMargins(5, 5, 0, 2).applyTo(parent);
        this.fSingleBarViewer = this.createBarViewer(parent, SingleBarViewer.class);
    }

    public void setFocus() {
        if (this.getCurrentBarViewer() != null) {
            this.getCurrentBarViewer().getControl().setFocus();
        }
    }

    private <T extends BarViewer> T createBarViewer(Composite parent, Class<T> clazz) {
        boolean isMultiBar = clazz.equals(MultiBarViewer.class);
        Canvas canvas = new Canvas(parent, 262144);
        MultiBarViewer barViewer = isMultiBar ? new MultiBarViewer((Composite)canvas, "", true) : new SingleBarViewer((Composite)canvas, "", true);
        new DoubleBufferPainter(canvas, (BarViewer)barViewer){
            private final /* synthetic */ BarViewer val$barViewer;
            {
                this.val$barViewer = barViewer;
                super($anonymous0);
            }

            public void doPaint(PaintEvent e) {
                this.val$barViewer.paintControl(e);
            }
        };
        barViewer.getControl().setBackground(parent.getBackground());
        barViewer.getControl().setCursor(parent.getDisplay().getSystemCursor(21));
        GridData gridData = new GridData(4, isMultiBar ? 4 : 0x1000000, true, true);
        Point preferredSize = barViewer.getPreferredSize();
        gridData.heightHint = preferredSize.y;
        barViewer.getControl().setLayoutData((Object)gridData);
        barViewer.setContentProvider((IStructuredContentProvider)new QuerySummaryContentProvider());
        barViewer.setLabelProvider((IChartElementProvider)this.fChartElementProvider);
        barViewer.addOpenListener(this.fOpenListener);
        barViewer.addHoverListener(this.fHoverListener);
        return (T)barViewer;
    }

    private void installMenu() {
        Menu menu = this.getSectionSite().getSectionMenu();
        this.updateStyleActions();
        new ActionContributionItem((IAction)this.fSwitchToMultiBarAction).fill(menu, -1);
        new ActionContributionItem((IAction)this.fSwitchToSingleBarAction).fill(menu, -1);
        new MenuItem(menu, 2);
        this.fRefreshHandler.createMenu(menu);
        new MenuItem(menu, 2);
        MenuManager subMenu = new MenuManager(Messages.QuerySection_GROUP_BY_MENU);
        this.createGroupBySubMenu(subMenu);
        subMenu.fill(menu, -1);
        this.updateGroupModeActions();
        this.updateGroupModeActionEnablement();
        new ActionContributionItem((IAction)this.fHideEmptyGroupsAction).fill(menu, -1);
        new MenuItem(menu, 2);
        new ActionContributionItem((IAction)this.fConfigureAction).fill(menu, -1);
    }

    private void updateCurrentPage(boolean schedule) {
        if (this.fPageBook == null) {
            return;
        }
        if (!this.isConnected() && !this.isShowingResults()) {
            this.fPageBook.showPage(PAGE_KEY_NOT_CONNECTED);
            this.getSectionSite().onContentChange();
        } else if (!this.isConfigured()) {
            this.fPageBook.showPage(PAGE_KEY_EMPTY);
            this.getSectionSite().onContentChange();
        } else if (this.isResultEmpty() && this.isConnected()) {
            this.fPageBook.showPage(PAGE_KEY_NO_RESULT);
            this.getSectionSite().onContentChange();
        } else {
            if (!this.getBarViewerPageKey().equals(this.fPageBook.getCurrentPageKey())) {
                this.fPageBook.showPage(this.getBarViewerPageKey());
                this.updateStyleActions();
                this.getSectionSite().onContentChange();
            }
            if (schedule) {
                this.scheduleRefresh();
            }
        }
    }

    private void updateStyleActions() {
        this.fSwitchToMultiBarAction.setChecked(this.getConfiguration().getBarStyle() == QuerySectionConfiguration.BarStyle.multi);
        this.fSwitchToSingleBarAction.setChecked(this.getConfiguration().getBarStyle() == QuerySectionConfiguration.BarStyle.single);
    }

    private void updateGroupModeActions() {
        this.fHideEmptyGroupsAction.setChecked(!this.getConfiguration().getShowAllGroups());
    }

    private void updateGroupModeActionEnablement() {
        IGroupingProvider provider = this.getConfiguration().getGroupingProvider();
        this.fHideEmptyGroupsAction.setEnabled(provider.supportsShowAllGroups());
    }

    private void updateGroupBy() {
        IGroupingProvider currentProvider = this.getConfiguration().getGroupingProvider();
        for (ChangeGroupingAction action : this.fGroupByActions) {
            boolean checked = currentProvider.getId().equals(action.getProvider().getId());
            action.setChecked(checked);
        }
    }

    private void reflectConfigurationUpdates() {
        this.updateCurrentPage(false);
        this.updateStyleActions();
        this.updateGroupModeActions();
        this.updateGroupModeActionEnablement();
        this.updateGroupBy();
        this.initReadState();
        this.scheduleRefresh();
    }

    private void createGroupBySubMenu(MenuManager subMenu) {
        ArrayList<IGroupingProvider> groupingProviders = new ArrayList<IGroupingProvider>(GroupingProviders.getAll());
        Collections.sort(groupingProviders, GroupingProviders.COMPARATOR);
        for (IGroupingProvider provider : groupingProviders) {
            ChangeGroupingAction changeGroupingAction = new ChangeGroupingAction(provider.getDisplayName(), provider);
            this.fGroupByActions.add(changeGroupingAction);
            subMenu.add((IAction)changeGroupingAction);
        }
        this.updateGroupBy();
    }

    private void installDropSupport(Control control) {
        DropTarget target = new DropTarget(control, 22);
        target.setTransfer(new Transfer[]{LocalSelectionTransfer.getTransfer()});
        target.addDropListener((DropTargetListener)new DropTargetAdapter(){

            public void drop(DropTargetEvent event) {
                ISelection selection = LocalSelectionTransfer.getTransfer().getSelection();
                QuerySection.this.onDrop(selection);
            }

            public void dragOver(DropTargetEvent event) {
                ISelection selection = LocalSelectionTransfer.getTransfer().getSelection();
                event.detail = QuerySection.this.acceptDrop(selection) ? 4 : 0;
            }
        });
    }

    public void setQueries(Collection<IQueryDescriptorHandle> handles) {
        this.getConfiguration().getLocations().setItems(handles);
        this.updateCurrentPage(true);
    }

    public void addQueries(Collection<IQueryDescriptorHandle> queriesToAdd) {
        this.onDrop((ISelection)new StructuredSelection(queriesToAdd.toArray()));
    }

    public Collection<IQueryDescriptorHandle> getQueries() {
        return Collections.unmodifiableCollection(this.getConfiguration().getLocations().getItems());
    }

    private void onDrop(ISelection selection) {
        if (selection instanceof IStructuredSelection) {
            IQueryDescriptorHandle handle;
            Collection<IQueryDescriptorHandle> existing = this.getConfiguration().getLocations().getItems();
            ItemHandleAwareHashSet existingSet = new ItemHandleAwareHashSet();
            existingSet.addAll(existing);
            ArrayList<IQueryDescriptorHandle> queries = new ArrayList<IQueryDescriptorHandle>(existing);
            IStructuredSelection structuredSelection = (IStructuredSelection)selection;
            for (Object dropElement : structuredSelection) {
                IQueryDescriptorHandle handle2;
                if (!(dropElement instanceof IQueryDescriptorHandle) || existing.contains(handle2 = (IQueryDescriptorHandle)dropElement)) continue;
                queries.add(handle2);
            }
            this.setQueries(queries);
            if (existing.isEmpty() && !queries.isEmpty() && (handle = queries.get(0)).hasFullState()) {
                String name = ((IQueryDescriptor)handle).getName();
                this.getSectionSite().setName(name);
            }
        }
    }

    private boolean acceptDrop(ISelection selection) {
        if (selection instanceof IStructuredSelection) {
            ItemHandleAwareHashSet existing = new ItemHandleAwareHashSet();
            existing.addAll(this.getConfiguration().getLocations().getItems());
            IStructuredSelection structuredSelection = (IStructuredSelection)selection;
            for (Object dropElement : structuredSelection) {
                IQueryDescriptorHandle handle;
                if (!(dropElement instanceof IQueryDescriptorHandle) || existing.contains((Object)(handle = (IQueryDescriptorHandle)dropElement))) continue;
                return true;
            }
        }
        return false;
    }

    private void handleQueryChange(List events) {
        ItemHandleAwareHashSet handleSet = new ItemHandleAwareHashSet(this.getConfiguration().getLocations().getItems());
        for (Object object : events) {
            QueryChangeEvent event = (QueryChangeEvent)object;
            if (!handleSet.contains((Object)event.getQueryDescriptor())) continue;
            this.scheduleRefresh();
            return;
        }
    }

    private void handleQueryDelete(List events) {
        Collection<IQueryDescriptorHandle> configured = this.getConfiguration().getLocations().getItems();
        ArrayList<IQueryDescriptorHandle> remaining = new ArrayList<IQueryDescriptorHandle>(configured.size());
        ItemHandleAwareHashSet deleted = new ItemHandleAwareHashSet();
        for (Object object : events) {
            QueryChangeEvent event = (QueryChangeEvent)object;
            deleted.add((Object)((IQueryDescriptorHandle)event.getQueryDescriptor().getItemHandle()));
        }
        for (IQueryDescriptorHandle handle : configured) {
            if (deleted.contains((Object)handle)) continue;
            remaining.add(handle);
        }
        if (remaining.size() != configured.size()) {
            this.getConfiguration().getLocations().setItems(remaining);
            this.scheduleRefresh();
        }
    }

    private void scheduleRefresh() {
        this.fRefreshHandler.scheduleRefresh(0L);
    }

    private void configureSection() {
        QuerySectionWizardContext context = new QuerySectionWizardContext(this.getConfiguration(), this.getSectionSite().getName(), this.fRefreshHandler.getRefreshInterval());
        QuerySectionConfigurationWizard wizard = new QuerySectionConfigurationWizard(context);
        WizardDialog dialog = new WizardDialog(this.getSectionSite().getViewSite().getShell(), (IWizard)wizard);
        if (dialog.open() == 0) {
            this.updateConfiguration(context);
            this.reflectConfigurationUpdates();
        }
    }

    private void updateConfiguration(QuerySectionWizardContext context) {
        this.getConfiguration().setBarStyle(context.getStyle());
        this.getConfiguration().setGroupingProvider(context.getGroupingProvider());
        this.getConfiguration().setShowAllGroups(context.getShowAllGroups());
        this.getConfiguration().getLocations().setItems(context.getQueryHandles());
        this.getSectionSite().setName(context.getName());
        this.fRefreshHandler.setRefreshInterval(context.getRefreshInterval());
    }

    private IStatus resolveQueries(IProgressMonitor monitor, List<IQueryDescriptorHandle> handles) {
        QuerySummaryInput input = this.createQuerySummaryInput(handles);
        IStatus status = input.resolve(monitor);
        List<IQueryDescriptor> queries = input.getResolvedQueries();
        if (queries.size() != 0) {
            this.asyncChooseAndShowQueryResults(queries, status);
        }
        return Status.OK_STATUS;
    }

    private void asyncChooseAndShowQueryResults(final List<IQueryDescriptor> queries, final IStatus status) {
        WorkItemRCPUIPlugin.runInUI("", new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                if (status.isOK()) {
                    if (queries.size() == 1) {
                        QuerySection.this.displayQueryResult((IQueryDescriptorHandle)queries.get(0));
                    } else {
                        QuerySection.this.displayQueryResult(QuerySection.this.choose(queries));
                    }
                } else {
                    QuerySection.this.updateTeaser(status);
                }
            }
        }, null);
    }

    /*
     * Enabled aggressive block sorting
     */
    private void showQueryResults() {
        IQueryDescriptorHandle handle;
        block6: {
            this.initReadState();
            this.markAllRead();
            BarViewer barViewer = this.getCurrentBarViewer();
            if (barViewer != null) {
                barViewer.refresh();
            }
            handle = null;
            QuerySummaryInput input = this.fCurrentInput;
            if (input == null) {
                LocationGroup<IQueryDescriptorHandle> locations = this.getConfiguration().getLocations();
                ArrayList<IQueryDescriptorHandle> handles = new ArrayList<IQueryDescriptorHandle>(locations.getItems());
                if (handles.size() == 1) {
                    handle = (IQueryDescriptorHandle)handles.get(0);
                    break block6;
                } else {
                    GetAndResolveQueryJob findQueriesJob = new GetAndResolveQueryJob(Messages.QuerySection_RESOLVING_QUERIES);
                    if (this.getSectionSite().getProgressService() != null) {
                        this.getSectionSite().getProgressService().schedule((Job)findQueriesJob);
                        return;
                    }
                    findQueriesJob.schedule();
                    return;
                }
            }
            List<IQueryDescriptor> queries = input.getResolvedQueries();
            if (queries.isEmpty()) {
                return;
            }
            handle = queries.size() == 1 ? (IQueryDescriptorHandle)queries.get(0) : this.choose(queries);
        }
        this.displayQueryResult(handle);
    }

    private void displayQueryResult(IQueryDescriptorHandle handle) {
        if (handle != null) {
            QueriesUI.showQueryResults(this.getSectionSite().getViewSite().getWorkbenchWindow(), handle);
        }
    }

    private IQueryDescriptorHandle choose(List<IQueryDescriptor> queries) {
        Object[] result;
        ListDialog dialog = new ListDialog(this.getSectionSite().getViewSite().getShell());
        dialog.setContentProvider((IStructuredContentProvider)new ArrayContentProvider());
        dialog.setLabelProvider((ILabelProvider)new StandardLabelProvider((IElementRemovedNotifier)new ElementRemovedNotifierImpl()));
        dialog.setTitle(Messages.QuerySection_SELECT_QUERY_DIALOG_TITLE);
        dialog.setMessage(Messages.QuerySection_SELECT_QUERY_DIALOG_MESSAGE);
        dialog.setInput(queries);
        if (dialog.open() == 0 && (result = dialog.getResult()).length > 0) {
            return (IQueryDescriptorHandle)result[0];
        }
        return null;
    }

    private void markAsRead(Object summary) {
        this.fChartElementProvider.clear(summary);
    }

    private void initReadState() {
        this.fInitReadState = true;
    }

    private void markAllRead() {
        if (this.fInitReadState) {
            this.fChartElementProvider.clearAll();
            this.fInitReadState = false;
        }
    }

    private void enableBarViewer(boolean enabled) {
        if (this.fMultiBarViewer != null) {
            this.fMultiBarViewer.setEnabled(enabled);
        }
        if (this.fSingleBarViewer != null) {
            this.fSingleBarViewer.setEnabled(enabled);
        }
    }

    private BarViewer getCurrentBarViewer() {
        switch (this.getConfiguration().getBarStyle()) {
            case multi: {
                return this.fMultiBarViewer;
            }
            case single: {
                return this.fSingleBarViewer;
            }
        }
        return this.fMultiBarViewer;
    }

    private String getBarViewerPageKey() {
        switch (this.getConfiguration().getBarStyle()) {
            case multi: {
                return PAGE_KEY_MULTI_BAR;
            }
            case single: {
                return PAGE_KEY_SINGLE_BAR;
            }
        }
        return PAGE_KEY_MULTI_BAR;
    }

    private QuerySectionConfiguration getConfiguration() {
        return this.fConfiguration;
    }

    private ResourceManager getResourceManager() {
        if (this.fResourceManager == null) {
            this.fResourceManager = new LocalResourceManager(JFaceResources.getResources());
        }
        return this.fResourceManager;
    }

    public void dispose() {
        this.fRefreshHandler.dispose();
        if (this.fResourceManager != null) {
            this.fResourceManager.dispose();
        }
        ConnectedProjectAreaRegistry.getDefault().removeListener(this.fProjectAreaStateListener);
        QueryDescriptorEvents.getInstance().removeQueryListener(this.fQueryChangeListener);
        QueryDescriptorEvents.getInstance().removeQueryListener(this.fQueryDeleteListener);
        super.dispose();
    }

    private class ChangeGroupingAction
    extends Action {
        private IGroupingProvider fProvider;

        public ChangeGroupingAction(String label, IGroupingProvider provider) {
            super(label, 8);
            this.fProvider = provider;
        }

        public IGroupingProvider getProvider() {
            return this.fProvider;
        }

        public void run() {
            QuerySection.this.getConfiguration().setGroupingProvider(this.fProvider);
            QuerySection.this.reflectConfigurationUpdates();
        }
    }

    private class GetAndResolveQueryJob
    extends FoundationJob {
        public GetAndResolveQueryJob(String name) {
            super(name);
        }

        protected IStatus runProtected(IProgressMonitor monitor) throws Exception {
            List handles = QuerySection.this.getQueryHandles(monitor);
            QuerySection.this.resolveQueries(monitor, handles);
            return Status.OK_STATUS;
        }
    }
}

