/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.rcp.ui.internal.dashboard;

import com.ibm.team.jface.JazzResources;
import com.ibm.team.jface.charts.IChartElementProviderExt;
import com.ibm.team.repository.common.util.NLS;
import com.ibm.team.workitem.rcp.ui.internal.util.Utils;
import java.util.HashMap;
import org.eclipse.jface.resource.FontDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.jface.viewers.IElementComparer;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.ui.IViewSite;

public class DifferenceChartElementProvider
implements IChartElementProviderExt {
    private final ResourceManager fResourceManager;
    private final IChartElementProviderExt fDelegate;
    private final HashMap<Wrapper, Integer> fLastValues;
    private final IElementComparer fComparer;
    private FontDescriptor fBoldFontDescriptor;
    private Font fBoldFont;
    private FontDescriptor fAnnotationFontDescriptor;
    private Font fAnnotationFont;
    private Wrapper fWrapper = new Wrapper(null);

    public DifferenceChartElementProvider(ResourceManager resourceManager, IChartElementProviderExt delegate, IElementComparer comparer) {
        this.fResourceManager = resourceManager;
        this.fDelegate = delegate;
        this.fLastValues = new HashMap();
        this.fComparer = comparer;
        this.fBoldFontDescriptor = Utils.createRelativeHeightFontDescriptor(-1, 1);
        this.fBoldFont = JazzResources.getFont((ResourceManager)this.fResourceManager, (FontDescriptor)this.fBoldFontDescriptor, (Font)JFaceResources.getDefaultFont());
        this.fAnnotationFontDescriptor = Utils.createRelativeHeightFontDescriptor(-2, 0);
        this.fAnnotationFont = JazzResources.getFont((ResourceManager)this.fResourceManager, (FontDescriptor)this.fAnnotationFontDescriptor, (Font)JFaceResources.getDefaultFont());
    }

    public void init(IViewSite viewSite) {
    }

    public void clear(Object element) {
        this.fWrapper.fObject = element;
        this.fLastValues.remove(this.fWrapper);
    }

    public void clearAll() {
        this.fLastValues.clear();
    }

    public IChartElementProviderExt getDelegate() {
        return this.fDelegate;
    }

    public void dispose() {
        this.fDelegate.dispose();
        this.fResourceManager.destroyFont(this.fBoldFontDescriptor);
        this.fResourceManager.destroyFont(this.fAnnotationFontDescriptor);
    }

    public Font getFont(Object element) {
        int difference = this.getDifference(element);
        if (difference == 0) {
            return this.fDelegate.getFont(element);
        }
        return this.fBoldFont;
    }

    public String getValueAsString(Object element) {
        return this.fDelegate.getValueAsString(element);
    }

    public String getAnnotation(Object element) {
        int difference = this.getDifference(element);
        if (difference == 0) {
            return this.fDelegate.getAnnotation(element);
        }
        if (difference > 0) {
            return NLS.bind((String)"(+{0})", (Object)difference, (Object[])new Object[0]);
        }
        return NLS.bind((String)"({0})", (Object)difference, (Object[])new Object[0]);
    }

    public Font getAnnotationFont(Object element) {
        int difference = this.getDifference(element);
        if (difference == 0) {
            return this.fDelegate.getFont(element);
        }
        return this.fAnnotationFont;
    }

    public Color getColor(Object element) {
        return this.fDelegate.getColor(element);
    }

    public String getShortText(Object element) {
        return this.fDelegate.getShortText(element);
    }

    public String getText(Object element) {
        return this.fDelegate.getText(element);
    }

    public int getValue(Object element) {
        return this.fDelegate.getValue(element);
    }

    public boolean isBusyLoading(Object element) {
        return this.fDelegate.isBusyLoading(element);
    }

    private int getDifference(Object element) {
        this.fWrapper.fObject = element;
        Integer last = this.fLastValues.get(this.fWrapper);
        if (last == null) {
            last = this.getValue(element);
            this.fLastValues.put(new Wrapper(element), last);
        }
        Integer current = this.getValue(element);
        return current - last;
    }

    public Color getActiveBackgroundColor(Object element) {
        return this.fDelegate.getActiveBackgroundColor(element);
    }

    public Color getActiveForegroundColor(Object element) {
        return this.fDelegate.getActiveForegroundColor(element);
    }

    public Color getBackgroundColor(Object element) {
        return this.fDelegate.getBackgroundColor(element);
    }

    public Color getForegroundColor(Object element) {
        return this.fDelegate.getForegroundColor(element);
    }

    private class Wrapper {
        private Object fObject;

        public Wrapper(Object object) {
            this.fObject = object;
        }

        public Object getObject() {
            return this.fObject;
        }

        public boolean equals(Object object) {
            if (object instanceof Wrapper) {
                object = ((Wrapper)object).getObject();
            }
            return DifferenceChartElementProvider.this.fComparer.equals(this.fObject, object);
        }

        public int hashCode() {
            return DifferenceChartElementProvider.this.fComparer.hashCode(this.fObject);
        }
    }
}

