/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.rcp.ui.internal.attribute;

import com.ibm.team.repository.common.IAuditableHandle;
import com.ibm.team.workitem.common.expression.IQueryableAttribute;
import com.ibm.team.workitem.common.model.IWorkItem;
import com.ibm.team.workitem.rcp.ui.internal.attribute.AttributeLabelProviderFactory;
import com.ibm.team.workitem.rcp.ui.internal.attribute.IAttributeLabelProvider;
import com.ibm.team.workitem.rcp.ui.internal.attribute.IAuditableResolver;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.DecoratingLabelProvider;
import org.eclipse.jface.viewers.IColorDecorator;
import org.eclipse.jface.viewers.IFontDecorator;
import org.eclipse.jface.viewers.IFontProvider;
import org.eclipse.jface.viewers.ILabelDecorator;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;

public class DecoratingAttributeLabelProvider
extends DecoratingLabelProvider
implements IAttributeLabelProvider {
    private IQueryableAttribute fAttribute;
    private boolean fMaskWorkItem;
    private IAuditableResolver fAuditableResolver;

    public DecoratingAttributeLabelProvider(ILabelProvider provider, ILabelDecorator decorator, boolean maskWorkItem) {
        super(provider, decorator);
        this.fMaskWorkItem = maskWorkItem;
    }

    public IQueryableAttribute getAttribute() {
        return this.fAttribute;
    }

    public void init(IQueryableAttribute attribute, boolean workItemRelative) {
        this.fAttribute = attribute;
        if (this.getLabelProvider() instanceof IAttributeLabelProvider) {
            ((IAttributeLabelProvider)this.getLabelProvider()).init(attribute, workItemRelative);
        }
    }

    public String getText(Object objWorkItem) {
        return super.getText(this.getElement(objWorkItem, this.fAttribute));
    }

    public Image getImage(Object objWorkItem) {
        return super.getImage(this.getElement(objWorkItem, this.fAttribute));
    }

    public Color getBackground(Object objWorkItem) {
        Color color;
        Object element;
        ILabelDecorator decorator = this.getLabelDecorator();
        if (decorator instanceof IColorDecorator && (element = this.getElement(objWorkItem, this.fAttribute)) != null && (color = ((IColorDecorator)decorator).decorateBackground(element)) != null) {
            return color;
        }
        return super.getBackground(this.getElement(objWorkItem, this.fAttribute));
    }

    public Color getForeground(Object objWorkItem) {
        Color color;
        Object element;
        ILabelDecorator decorator = this.getLabelDecorator();
        if (decorator instanceof IColorDecorator && (element = this.getElement(objWorkItem, this.fAttribute)) != null && (color = ((IColorDecorator)decorator).decorateForeground(element)) != null) {
            return color;
        }
        return super.getForeground(this.getElement(objWorkItem, this.fAttribute));
    }

    public Font getFont(Object objWorkItem) {
        Font font;
        Object element = this.getElement(objWorkItem, this.fAttribute);
        ILabelDecorator decorator = this.getLabelDecorator();
        if (decorator instanceof IFontDecorator && (font = ((IFontDecorator)decorator).decorateFont(element)) != null) {
            return font;
        }
        ILabelProvider provider = this.getLabelProvider();
        if (provider instanceof IFontProvider) {
            return ((IFontProvider)provider).getFont(element);
        }
        return JFaceResources.getDefaultFont();
    }

    private Object getElement(Object element, IQueryableAttribute attribute) {
        if (!this.fMaskWorkItem) {
            return element;
        }
        if (element instanceof IWorkItem) {
            element = attribute.getValue(element);
        }
        if (element instanceof IAuditableHandle) {
            IAuditableHandle handle = (IAuditableHandle)element;
            return this.fAuditableResolver.resolve(handle, AttributeLabelProviderFactory.getItemProfile(handle.getItemType()), null);
        }
        return element;
    }
}

