/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.rcp.ui.internal.attribute;

import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IAuditableHandle;
import com.ibm.team.repository.common.IItemType;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.workitem.client.IAuditableClient;
import com.ibm.team.workitem.common.model.ItemProfile;
import com.ibm.team.workitem.rcp.ui.internal.WorkItemRCPUIPlugin;
import com.ibm.team.workitem.rcp.ui.internal.attribute.IAuditableResolver;
import com.ibm.team.workitem.rcp.ui.internal.attribute.Messages;
import org.eclipse.core.runtime.IProgressMonitor;

public class AuditableResolver
implements IAuditableResolver {
    private ITeamRepository fTeamRepository;

    public AuditableResolver(ITeamRepository repository) {
        this.fTeamRepository = repository;
    }

    public Object resolve(IAuditableHandle handle, ItemProfile profile, IProgressMonitor monitor) {
        try {
            if (profile == null) {
                profile = ItemProfile.createFullProfile((IItemType)handle.getItemType());
            }
            IAuditableClient auditableClient = (IAuditableClient)this.fTeamRepository.getClientLibrary(IAuditableClient.class);
            return auditableClient.resolveAuditable(handle, profile, monitor);
        }
        catch (TeamRepositoryException e) {
            WorkItemRCPUIPlugin.getDefault().log(Messages.AuditableResolver_ERROR_RESOLVING_ITEM, e);
            return null;
        }
    }

    public ITeamRepository getTeamRepository() {
        return this.fTeamRepository;
    }
}

