/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.rcp.ui.internal.attribute;

import com.ibm.icu.text.Collator;
import com.ibm.team.process.common.IIteration;
import com.ibm.team.process.common.IProjectAreaHandle;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IAuditableHandle;
import com.ibm.team.repository.common.IContributor;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.IItemType;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.workitem.client.IWorkItemClient;
import com.ibm.team.workitem.client.internal.util.ClientUtils;
import com.ibm.team.workitem.client.internal.util.ResolvedWorkItem;
import com.ibm.team.workitem.common.expression.AttributeExpression;
import com.ibm.team.workitem.common.expression.IQueryableAttribute;
import com.ibm.team.workitem.common.internal.expression.QueryableWorkItemAttribute;
import com.ibm.team.workitem.common.internal.model.DefaultModel;
import com.ibm.team.workitem.common.internal.model.Deliverable;
import com.ibm.team.workitem.common.model.AttributeTypes;
import com.ibm.team.workitem.common.model.IAttribute;
import com.ibm.team.workitem.common.model.ICategory;
import com.ibm.team.workitem.common.model.IDeliverable;
import com.ibm.team.workitem.common.model.IEnumeration;
import com.ibm.team.workitem.common.model.ILiteral;
import com.ibm.team.workitem.common.model.IWorkItem;
import com.ibm.team.workitem.common.model.Identifier;
import com.ibm.team.workitem.common.model.ItemProfile;
import com.ibm.team.workitem.rcp.ui.internal.WorkItemRCPUIPlugin;
import com.ibm.team.workitem.rcp.ui.internal.attribute.AttributeLabelProviderFactory;
import com.ibm.team.workitem.rcp.ui.internal.attribute.AuditableResolver;
import com.ibm.team.workitem.rcp.ui.internal.attribute.IAttributeComparator;
import com.ibm.team.workitem.rcp.ui.internal.attribute.Messages;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AttributeComparatorFactory {
    private static HashMap<String, Class> fgProviders = new HashMap();
    private static HashMap<String, ItemProfile> fgComparatorProfiles;

    static {
        fgProviders.put("integer", ComparableComparator.class);
        fgProviders.put("long", ComparableComparator.class);
        fgProviders.put("timestamp", ComparableComparator.class);
        fgProviders.put("category", CategoryComparator.class);
        fgProviders.put("deliverable", DeliverableComparator.class);
        fgProviders.put("interval", IterationComparator.class);
        fgProviders.put("severity", ComparableComparator.class);
        fgProviders.put("priority", ComparableComparator.class);
        fgProviders.put("type", ComparableComparator.class);
        fgProviders.put("contributor", ContributorComparator.class);
        fgProviders.put(IWorkItem.STATE_PROPERTY, ComparableComparator.class);
        fgProviders.put(IWorkItem.RESOLUTION_PROPERTY, ComparableComparator.class);
        fgProviders.put("score", ComparableComparator.class);
        fgProviders.put("duration", ComparableComparator.class);
        fgComparatorProfiles = new HashMap();
        fgComparatorProfiles.put(AttributeComparatorFactory.getItemTypeKey(IContributor.ITEM_TYPE), ItemProfile.CONTRIBUTOR_DEFAULT);
        fgComparatorProfiles.put(AttributeComparatorFactory.getItemTypeKey(ICategory.ITEM_TYPE), ICategory.SMALL_PROFILE);
        fgComparatorProfiles.put(AttributeComparatorFactory.getItemTypeKey(IIteration.ITEM_TYPE), ItemProfile.ITERATION_DEFAULT);
        fgComparatorProfiles.put(AttributeComparatorFactory.getItemTypeKey(IDeliverable.ITEM_TYPE), IDeliverable.SMALL_PROFILE);
    }

    private static String getItemTypeKey(IItemType type) {
        return String.valueOf(type.getNamespaceURI()) + type.getName();
    }

    private static ItemProfile getItemProfile(IItemType type) {
        ItemProfile profile = fgComparatorProfiles.get(AttributeComparatorFactory.getItemTypeKey(type));
        if (profile == null) {
            profile = ItemProfile.createFullProfile((IItemType)type);
        }
        return profile;
    }

    public static Comparator<Object> createComparator(IAttribute attribute) {
        return AttributeComparatorFactory.createComparator((IQueryableAttribute)new QueryableWorkItemAttribute(attribute));
    }

    public static Comparator<Object> createComparator(IQueryableAttribute attribute) {
        AttributeComparator comparator;
        Class providerClass = null;
        if (attribute != null) {
            providerClass = fgProviders.get(attribute.getIdentifier());
        }
        if (providerClass == null && attribute != null) {
            providerClass = !AttributeTypes.isEnumerationAttributeType((String)attribute.getAttributeType()) ? fgProviders.get(attribute.getAttributeType()) : EnumerationComparator.class;
        }
        if (providerClass == null) {
            comparator = new StringComparator();
        } else {
            try {
                comparator = (AttributeComparator)providerClass.newInstance();
            }
            catch (InstantiationException e) {
                throw new RuntimeException(e);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
        }
        comparator.init(attribute);
        return comparator;
    }

    public static <T> Comparator<T> reverseComparator(Comparator<T> comparator) {
        return new ReverseComparator<T>(comparator);
    }

    static abstract class AttributeComparator
    implements IAttributeComparator {
        private IQueryableAttribute fAttribute;
        private Map<UUID, IQueryableAttribute> fEquivalentAttributeMap = new HashMap<UUID, IQueryableAttribute>();

        public void init(IQueryableAttribute attribute) {
            this.fAttribute = attribute;
        }

        protected Object getValue(Object element) {
            if (element instanceof ResolvedWorkItem) {
                ResolvedWorkItem resolved = (ResolvedWorkItem)element;
                if (!resolved.contains(this.fAttribute.getIdentifier())) {
                    return null;
                }
                return resolved.getValue(this.fAttribute.getIdentifier());
            }
            if (element instanceof IWorkItem) {
                IQueryableAttribute attribute = this.getEquivalentAttribute(this.getProjectArea(element));
                if (attribute == null) {
                    return null;
                }
                element = attribute.getValue(element);
            }
            if (element instanceof IAuditableHandle) {
                IAuditableHandle handle = (IAuditableHandle)element;
                return this.resolve(handle);
            }
            return element;
        }

        protected IProjectAreaHandle getProjectArea(Object element) {
            if (element instanceof ResolvedWorkItem) {
                return ((ResolvedWorkItem)element).getWorkItem().getProjectArea();
            }
            if (element instanceof IWorkItem) {
                return ((IWorkItem)element).getProjectArea();
            }
            IAttribute attribute = this.getAttribute();
            return attribute != null ? attribute.getProjectArea() : null;
        }

        protected IAttribute getAttribute() {
            return this.fAttribute instanceof QueryableWorkItemAttribute ? ((QueryableWorkItemAttribute)this.fAttribute).getAttribute() : null;
        }

        public boolean equals(Object o) {
            if (!(o instanceof AttributeComparator)) {
                return false;
            }
            return this.fAttribute.getIdentifier().equals(((AttributeComparator)o).fAttribute.getIdentifier());
        }

        private Object resolve(IAuditableHandle handle) {
            AuditableResolver resolver = new AuditableResolver((ITeamRepository)handle.getOrigin());
            return resolver.resolve(handle, AttributeComparatorFactory.getItemProfile(handle.getItemType()), null);
        }

        private IQueryableAttribute getEquivalentAttribute(IProjectAreaHandle projectArea) {
            if (projectArea.sameItemId((IItemHandle)this.getAttribute().getProjectArea())) {
                return this.fAttribute;
            }
            if (!this.fEquivalentAttributeMap.containsKey(projectArea.getItemId())) {
                try {
                    IWorkItemClient workItemClient = (IWorkItemClient)ClientUtils.getClientLibrary((IItemHandle)projectArea, IWorkItemClient.class);
                    IAttribute attribute = workItemClient.findAttribute(projectArea, this.fAttribute.getIdentifier(), null);
                    QueryableWorkItemAttribute equivalent = attribute != null ? new QueryableWorkItemAttribute(attribute) : null;
                    this.fEquivalentAttributeMap.put(projectArea.getItemId(), (IQueryableAttribute)equivalent);
                }
                catch (TeamRepositoryException e) {
                    WorkItemRCPUIPlugin.getDefault().log(Messages.AttributeComparatorFactory_ERROR_RESOLVING_ATTRIBUTE, e);
                    return this.fAttribute;
                }
            }
            return this.fEquivalentAttributeMap.get(projectArea.getItemId());
        }
    }

    static class CategoryComparator
    extends AttributeComparator {
        CategoryComparator() {
        }

        public int compare(Object o1, Object o2) {
            ICategory p1 = (ICategory)this.getValue(o1);
            ICategory p2 = (ICategory)this.getValue(o2);
            if (p1 == null) {
                return 1;
            }
            if (p2 == null) {
                return -1;
            }
            return p1.getCategoryId().compareTo(p2.getCategoryId());
        }
    }

    static class ComparableComparator
    extends AttributeComparator {
        ComparableComparator() {
        }

        public int compare(Object o1, Object o2) {
            o1 = this.getValue(o1);
            o2 = this.getValue(o2);
            if (o1 instanceof Identifier) {
                o1 = ((Identifier)o1).getStringIdentifier();
            }
            if (o2 instanceof Identifier) {
                o2 = ((Identifier)o2).getStringIdentifier();
            }
            if (o1 == null) {
                return 1;
            }
            if (o2 == null) {
                return -1;
            }
            return ((Comparable)o1).compareTo(o2);
        }
    }

    static class ContributorComparator
    extends AttributeComparator {
        private Collator fCollator = Collator.getInstance();

        ContributorComparator() {
        }

        public int compare(Object o1, Object o2) {
            IContributor c1 = (IContributor)this.getValue(o1);
            IContributor c2 = (IContributor)this.getValue(o2);
            if (c1 == null) {
                return 1;
            }
            if (c2 == null) {
                return -1;
            }
            if (DefaultModel.NULL_CONTRIBUTOR_ITEM_ID.equals((Object)c1.getItemId())) {
                return -1;
            }
            if (DefaultModel.NULL_CONTRIBUTOR_ITEM_ID.equals((Object)c2.getItemId())) {
                return 1;
            }
            return this.fCollator.compare(c1.getName(), c2.getName());
        }
    }

    static class DeliverableComparator
    extends AttributeComparator {
        DeliverableComparator() {
        }

        public int compare(Object o1, Object o2) {
            Deliverable d1 = (Deliverable)this.getValue(o1);
            Deliverable d2 = (Deliverable)this.getValue(o2);
            if (d1 == null) {
                return 1;
            }
            if (d2 == null) {
                return -1;
            }
            Integer seq1 = d1.getSequenceValue();
            Integer seq2 = d2.getSequenceValue();
            return seq2.compareTo(seq1);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class EnumerationComparator
    extends AttributeComparator {
        private Collator fCollator = Collator.getInstance();
        private Map<Identifier, Integer> fOrdinalMap;
        private long fLastAccessed;
        private IProjectAreaHandle fLastProjectArea;

        EnumerationComparator() {
        }

        @Override
        public int compare(Object o1, Object o2) {
            Identifier id1 = this.getIdentifier(o1);
            Identifier id2 = this.getIdentifier(o2);
            if (id1 == null) {
                return 1;
            }
            if (id2 == null) {
                return -1;
            }
            IProjectAreaHandle pa1 = this.getProjectArea(o1);
            IProjectAreaHandle pa2 = this.getProjectArea(o2);
            Integer ordinal1 = this.getOrdinal(id1, pa1);
            Integer ordinal2 = this.getOrdinal(id2, pa2);
            if (ordinal1 != null && ordinal2 != null) {
                return ordinal1.compareTo(ordinal2);
            }
            return this.fCollator.compare(id1.getStringIdentifier(), id2.getStringIdentifier());
        }

        private Identifier getIdentifier(Object object) {
            Object value = this.getValue(object);
            if (value instanceof Identifier) {
                return (Identifier)value;
            }
            if (value instanceof ILiteral) {
                return ((ILiteral)value).getIdentifier2();
            }
            return null;
        }

        private Integer getOrdinal(Identifier id, IProjectAreaHandle projectArea) {
            if (projectArea == null) {
                return null;
            }
            Map<Identifier, Integer> ordinalMap = this.getOrdinalMap(projectArea);
            return ordinalMap.get(id);
        }

        private Map<Identifier, Integer> getOrdinalMap(IProjectAreaHandle projectArea) {
            if (System.currentTimeMillis() - this.fLastAccessed > 1000L || this.fLastProjectArea == null || !this.fLastProjectArea.sameItemId((IItemHandle)projectArea)) {
                this.fOrdinalMap = this.createOrdinalMap(projectArea);
                this.fLastProjectArea = projectArea;
            }
            this.fLastAccessed = System.currentTimeMillis();
            return this.fOrdinalMap;
        }

        private Map<Identifier, Integer> createOrdinalMap(IProjectAreaHandle projectArea) {
            HashMap<Identifier, Integer> ordinalMap = new HashMap<Identifier, Integer>();
            IAttribute attribute = this.getAttribute();
            if (attribute != null) {
                IWorkItemClient client = (IWorkItemClient)ClientUtils.getClientLibrary((IItemHandle)attribute, IWorkItemClient.class);
                IEnumeration enumeration = client.findCachedEnumeration(attribute);
                List literals = enumeration.getEnumerationLiterals();
                int i = 0;
                while (i < literals.size()) {
                    ordinalMap.put(((ILiteral)literals.get(i)).getIdentifier2(), i);
                    ++i;
                }
            }
            return ordinalMap;
        }
    }

    static class IterationComparator
    extends AttributeComparator {
        private Collator fCollator = Collator.getInstance();

        IterationComparator() {
        }

        public int compare(Object o1, Object o2) {
            IIteration p1 = (IIteration)this.getValue(o1);
            IIteration p2 = (IIteration)this.getValue(o2);
            if (p1 == null) {
                return 1;
            }
            if (p2 == null) {
                return -1;
            }
            String label1 = AttributeLabelProviderFactory.IterationLabelProvider.getIterationName(p1);
            String label2 = AttributeLabelProviderFactory.IterationLabelProvider.getIterationName(p2);
            return this.fCollator.compare(label1, label2);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class ReverseComparator<T>
    implements Comparator<T> {
        private Comparator<T> fComparator;

        public ReverseComparator(Comparator<T> comparator) {
            this.fComparator = comparator;
        }

        @Override
        public int compare(T o1, T o2) {
            int cmp = this.fComparator.compare(o1, o2);
            return -(cmp | cmp >>> 1);
        }
    }

    static class StringComparator
    extends AttributeComparator {
        private Collator fCollator = Collator.getInstance();

        StringComparator() {
        }

        public int compare(Object o1, Object o2) {
            String s1 = AttributeExpression.toString((Object)this.getValue(o1));
            String s2 = AttributeExpression.toString((Object)this.getValue(o2));
            if (s1 == null) {
                return 1;
            }
            if (s2 == null) {
                return -1;
            }
            return this.fCollator.compare(s1, s2);
        }
    }
}

