/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.rcp.ui.internal.actions;

import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.workitem.client.IWorkItemClient;
import com.ibm.team.workitem.client.WorkItemOperation;
import com.ibm.team.workitem.client.WorkItemWorkingCopy;
import com.ibm.team.workitem.common.model.IWorkItem;
import com.ibm.team.workitem.common.model.IWorkItemHandle;
import com.ibm.team.workitem.common.model.IWorkItemType;
import com.ibm.team.workitem.common.model.ItemProfile;
import com.ibm.team.workitem.rcp.ui.internal.actions.Messages;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SynchronizeAttributesAction
extends Action {
    private ISelectionProvider fSelectionProvider;

    public SynchronizeAttributesAction(ISelectionProvider selectionProvider) {
        this.setText(Messages.SynchronizeAttributesAction_SYNCHRONIZE_LABEL);
        this.fSelectionProvider = selectionProvider;
    }

    public void run() {
        ItemProfile profile = IWorkItem.SMALL_PROFILE.createExtension(IWorkItem.CUSTOM_ATTRIBUTE_PROPERTIES);
        WorkItemOperation operation = new WorkItemOperation(Messages.SynchronizeAttributesAction_SYNCHRONIZE_JOB, profile){

            protected void execute(WorkItemWorkingCopy workingCopy, IProgressMonitor monitor) throws TeamRepositoryException {
                IWorkItem workItem;
                ITeamRepository teamRepository = workingCopy.getTeamRepository();
                IWorkItemClient workItemClient = (IWorkItemClient)teamRepository.getClientLibrary(IWorkItemClient.class);
                IWorkItemType type = workItemClient.findWorkItemType((workItem = workingCopy.getWorkItem()).getProjectArea(), workItem.getWorkItemType(), monitor);
                if (type != null) {
                    workItemClient.updateWorkItemType(workItem, type, type, monitor);
                }
            }
        };
        List<IWorkItemHandle> handles = this.getHandles();
        operation.runInJob(handles.toArray(new IWorkItemHandle[handles.size()]));
    }

    private List<IWorkItemHandle> getHandles() {
        ArrayList<IWorkItemHandle> handles = new ArrayList<IWorkItemHandle>();
        ISelection selection = this.fSelectionProvider.getSelection();
        if (selection instanceof IStructuredSelection) {
            for (Object element : ((IStructuredSelection)selection).toList()) {
                if (!(element instanceof IWorkItemHandle)) continue;
                handles.add((IWorkItemHandle)element);
            }
        }
        return handles;
    }
}

