/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.rcp.ui.internal.actions;

import com.ibm.team.feed.ui.FeedUI;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.util.NLS;
import com.ibm.team.workitem.common.query.IQueryDescriptor;
import com.ibm.team.workitem.rcp.ui.internal.WorkItemRCPUIPlugin;
import com.ibm.team.workitem.rcp.ui.internal.actions.AddQueryToSubscriptionsAction;
import com.ibm.team.workitem.rcp.ui.internal.actions.Messages;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPartSite;

public class ShowRecentQueryEventsAction
extends AddQueryToSubscriptionsAction {
    protected void createChannel(IQueryDescriptor query, ITeamRepository repo) {
        try {
            URL url = new URL(this.buildURL(repo, query));
            IWorkbenchPartSite site = this.getWorkbenchPart().getSite();
            if (site != null) {
                String feedName = NLS.bind((String)Messages.ShowRecentQueryEventsAction_RECENT_EVENTS_FEED_NAME, (Object)query.getName(), (Object[])new Object[0]);
                String status = NLS.bind((String)Messages.ShowRecentQueryEventsAction_RECENT_EVENTS_STATUS, (Object)query.getName(), (Object[])new Object[0]);
                FeedUI.openRecentItemView((IWorkbenchPage)site.getPage(), (URL)url, (String)feedName, (String)status);
            }
            return;
        }
        catch (UnsupportedEncodingException e) {
            WorkItemRCPUIPlugin.getDefault().log(ShowRecentQueryEventsAction.getLogMessage(query), e);
        }
        catch (URISyntaxException e) {
            WorkItemRCPUIPlugin.getDefault().log(ShowRecentQueryEventsAction.getLogMessage(query), e);
        }
        catch (MalformedURLException e) {
            WorkItemRCPUIPlugin.getDefault().log(ShowRecentQueryEventsAction.getLogMessage(query), e);
        }
        String description = NLS.bind((String)Messages.ShowRecentQueryEventsAction_ERROR_DESCRIPTION, (Object)query.getName(), (Object[])new Object[0]);
        MessageDialog.openError((Shell)this.getWorkbenchPart().getSite().getShell(), (String)Messages.ShowRecentQueryEventsAction_ERROR_SHOWING_EVENTS_TITLE, (String)description);
    }

    private static String getLogMessage(IQueryDescriptor query) {
        return NLS.bind((String)"Error while showing recent events of query: {0}", (Object)query.getName(), (Object[])new Object[0]);
    }
}

