/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.rcp.ui.internal.actions;

import com.ibm.team.process.common.IProjectAreaHandle;
import com.ibm.team.repository.common.IContributorHandle;
import com.ibm.team.repository.common.IItemType;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.util.NLS;
import com.ibm.team.workitem.client.IAuditableClient;
import com.ibm.team.workitem.common.IAuditableCommon;
import com.ibm.team.workitem.common.expression.AttributeExpression;
import com.ibm.team.workitem.common.expression.Expression;
import com.ibm.team.workitem.common.expression.IQueryableAttribute;
import com.ibm.team.workitem.common.expression.IQueryableAttributeFactory;
import com.ibm.team.workitem.common.expression.QueryableAttributes;
import com.ibm.team.workitem.common.expression.SelectClause;
import com.ibm.team.workitem.common.expression.SortCriteria;
import com.ibm.team.workitem.common.expression.Statement;
import com.ibm.team.workitem.common.expression.Term;
import com.ibm.team.workitem.common.expression.VariableAttributeExpression;
import com.ibm.team.workitem.common.expression.variables.IAttributeVariable;
import com.ibm.team.workitem.common.expression.variables.StatusVariable;
import com.ibm.team.workitem.common.model.AttributeOperation;
import com.ibm.team.workitem.common.model.IWorkItem;
import com.ibm.team.workitem.rcp.ui.internal.actions.AbstractShowWorkAction;
import com.ibm.team.workitem.rcp.ui.internal.actions.Messages;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ShowCurrentWorkAction
extends AbstractShowWorkAction {
    private String fLabel;
    private Expression fExpression;

    @Override
    protected void initialize(IProgressMonitor monitor) throws TeamRepositoryException {
        List<IContributorHandle> contributors = this.getSelectedContributors();
        IAuditableClient auditableClient = this.getAuditableClient();
        try {
            monitor.beginTask(Messages.ShowCurrentWorkAction_INITIALIZING, 100);
            this.fExpression = this.createExpression(auditableClient, contributors, (IProgressMonitor)new SubProgressMonitor(monitor, 40));
            this.fLabel = this.createLabel((IAuditableCommon)auditableClient, contributors, (IProgressMonitor)new SubProgressMonitor(monitor, 60));
        }
        finally {
            monitor.done();
        }
    }

    private Expression createExpression(IAuditableClient auditableClient, List<IContributorHandle> contributors, IProgressMonitor monitor) throws TeamRepositoryException {
        IProjectAreaHandle projectArea = this.getDefaultProjectArea(auditableClient, monitor);
        IQueryableAttributeFactory factory = QueryableAttributes.getFactory((IItemType)IWorkItem.ITEM_TYPE);
        IQueryableAttribute ownerAttribute = factory.findAttribute(projectArea, IWorkItem.OWNER_PROPERTY, (IAuditableCommon)auditableClient, monitor);
        IQueryableAttribute statusAttribute = factory.findAttribute(projectArea, IWorkItem.STATE_PROPERTY, (IAuditableCommon)auditableClient, monitor);
        IQueryableAttribute modifiedDateAttribute = factory.findAttribute(projectArea, IWorkItem.MODIFIED_PROPERTY, (IAuditableCommon)auditableClient, monitor);
        ArrayList<AttributeExpression> ownerConditions = new ArrayList<AttributeExpression>(contributors.size());
        for (IContributorHandle contributor : contributors) {
            AttributeExpression ownerCondition = new AttributeExpression(ownerAttribute, AttributeOperation.EQUALS, (Object)contributor);
            ownerConditions.add(ownerCondition);
        }
        VariableAttributeExpression statusCondition = new VariableAttributeExpression(statusAttribute, AttributeOperation.EQUALS, (IAttributeVariable)new StatusVariable(4));
        Object ownerCondition = ownerConditions.size() == 1 ? (Expression)ownerConditions.get(0) : new Term(1, ownerConditions.toArray(new Expression[ownerConditions.size()]));
        Term term = new Term(0, new Expression[]{ownerCondition, statusCondition});
        SortCriteria sortByModifiedDate = new SortCriteria(modifiedDateAttribute, false);
        return new Statement(new SelectClause(), (Expression)term, new SortCriteria[]{sortByModifiedDate});
    }

    private String createLabel(IAuditableCommon auditableCommon, List<IContributorHandle> handles, IProgressMonitor monitor) throws TeamRepositoryException {
        return NLS.bind((String)Messages.ShowCurrentWorkAction_PATTERN_CURRENT_WORK, (Object)this.getNameList(monitor), (Object[])new Object[0]);
    }

    @Override
    protected Expression getExpression() {
        return this.fExpression;
    }

    @Override
    protected String getLabel() {
        return this.fLabel;
    }
}

