/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.rcp.ui.internal.actions;

import com.ibm.team.foundation.rcp.core.hyperlinks.ContextProvider;
import com.ibm.team.foundation.rcp.core.hyperlinks.Hyperlinks;
import com.ibm.team.foundation.rcp.core.hyperlinks.StandardContextProvider;
import com.ibm.team.foundation.rcp.core.internal.favorites.FavoritesFolder;
import com.ibm.team.foundation.rcp.core.internal.favorites.FavoritesManager;
import com.ibm.team.foundation.rcp.core.internal.favorites.FavoritesNode;
import com.ibm.team.foundation.rcp.core.internal.favorites.URIFavorite;
import com.ibm.team.workitem.common.query.IQueryDescriptorHandle;
import com.ibm.team.workitem.rcp.ui.QueriesUI;
import com.ibm.team.workitem.rcp.ui.internal.actions.Messages;
import com.ibm.team.workitem.rcp.ui.internal.queries.QueryDescriptorHyperlinkHandler;
import com.ibm.team.workitem.rcp.ui.internal.queries.QuerySelectionDialog;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IMenuCreator;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.ui.IWorkbenchWindow;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RunFavoriteQueryAction
extends Action
implements IMenuCreator {
    private SelectionAdapter fSelectionListener = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent event) {
            MenuItem item = (MenuItem)event.widget;
            RunFavoriteQueryAction.this.handleFavoriteSelected((URIFavorite)item.getData());
        }
    };
    private Menu fMenu;
    private IWorkbenchWindow fWorkbenchWindow;
    private final String fFavoriteType;

    public RunFavoriteQueryAction(String name, IWorkbenchWindow workbenchWindow) {
        super(name, 4);
        Assert.isNotNull((Object)workbenchWindow);
        this.fFavoriteType = QueryDescriptorHyperlinkHandler.TYPE;
        this.fWorkbenchWindow = workbenchWindow;
    }

    public void run() {
        this.handleSelectQuery();
    }

    public IMenuCreator getMenuCreator() {
        return this;
    }

    public Menu getMenu(Control parent) {
        this.disposeMenu();
        this.fMenu = new Menu(parent);
        this.fillMenu(this.fMenu, FavoritesManager.getInstance().getFavorites(), true);
        this.addSelectWorkItemAction(this.fMenu);
        return this.fMenu;
    }

    protected void fillMenu(Menu menu, FavoritesNode node, boolean isRoot) {
        if (node instanceof FavoritesFolder) {
            FavoritesFolder folder = (FavoritesFolder)node;
            List<URIFavorite> favorites = this.sort(this.getQueryFavorites(folder));
            List<FavoritesFolder> folders = this.sort(this.getFolders(folder));
            Menu folderMenu = isRoot ? menu : this.createFolderMenu(menu, folder);
            for (URIFavorite queryFavorite : favorites) {
                this.createQueryMenuItem(folderMenu, queryFavorite);
            }
            for (FavoritesFolder favoritesFolder : folders) {
                this.fillMenu(folderMenu, (FavoritesNode)favoritesFolder, false);
            }
            if (folderMenu != menu && folderMenu.getItemCount() == 0) {
                folderMenu.getParentItem().dispose();
            } else if (isRoot && folderMenu.getItemCount() == 1 && folderMenu.getItem(0).getMenu() != null) {
                folderMenu.getItem(0).dispose();
                for (FavoritesFolder favoritesFolder : folders) {
                    this.fillMenu(folderMenu, (FavoritesNode)favoritesFolder, true);
                }
            }
        }
    }

    private MenuItem createQueryMenuItem(Menu menu, URIFavorite queryFavorite) {
        MenuItem menuItem = new MenuItem(menu, 8);
        menuItem.setText(queryFavorite.getText());
        menuItem.setData((Object)queryFavorite);
        menuItem.addSelectionListener((SelectionListener)this.fSelectionListener);
        return menuItem;
    }

    private Menu createFolderMenu(Menu menu, FavoritesFolder folder) {
        MenuItem folderMenuItem = new MenuItem(menu, 64);
        folderMenuItem.setText(folder.getText());
        Menu folderMenu = new Menu(folderMenuItem);
        folderMenuItem.setMenu(folderMenu);
        return folderMenu;
    }

    private List<URIFavorite> getQueryFavorites(FavoritesFolder folder) {
        ArrayList<URIFavorite> favorites = new ArrayList<URIFavorite>();
        for (Object node : folder.getChildren()) {
            URIFavorite favorite;
            if (!(node instanceof URIFavorite) || !this.fFavoriteType.equals((favorite = (URIFavorite)node).getFavoriteType())) continue;
            favorites.add(favorite);
        }
        return favorites;
    }

    private List<FavoritesFolder> getFolders(FavoritesFolder folder) {
        ArrayList<FavoritesFolder> folders = new ArrayList<FavoritesFolder>();
        for (Object node : folder.getChildren()) {
            if (!(node instanceof FavoritesFolder)) continue;
            folders.add((FavoritesFolder)node);
        }
        return folders;
    }

    private <T extends FavoritesNode> List<T> sort(List<T> nodes) {
        Collections.sort(nodes, new Comparator<FavoritesNode>(){

            @Override
            public int compare(FavoritesNode node1, FavoritesNode node2) {
                return Double.compare(node1.getSortOrder(), node2.getSortOrder());
            }
        });
        return nodes;
    }

    private void addSelectWorkItemAction(Menu menu) {
        if (menu.getItemCount() == 0) {
            MenuItem noFavorites = new MenuItem(menu, 8);
            noFavorites.setText(Messages.RunFavoriteQueryAction_NO_QUERY_FAVORITES);
            noFavorites.setEnabled(false);
        }
        new MenuItem(menu, 2);
        MenuItem selectQueryItem = new MenuItem(menu, 8);
        selectQueryItem.setText(Messages.RunFavoriteQueryAction_RUN_ANOTHER_QUERY);
        selectQueryItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                RunFavoriteQueryAction.this.handleSelectQuery();
            }
        });
    }

    private void handleFavoriteSelected(URIFavorite favorite) {
        URI uri = URI.create(favorite.getUri());
        StandardContextProvider contextProvider = new StandardContextProvider(null);
        contextProvider.setUIContext((Object)this.fWorkbenchWindow);
        Hyperlinks.open((URI)uri, (ContextProvider)contextProvider);
    }

    private void handleSelectQuery() {
        List<IQueryDescriptorHandle> queries;
        QuerySelectionDialog dialog = new QuerySelectionDialog(this.fWorkbenchWindow.getShell());
        dialog.setAllowMultiple(false);
        dialog.setTitle(Messages.RunFavoriteQueryAction_RUN_QUERY_TITLE);
        if (dialog.open() == 0 && !(queries = dialog.getSelectedQueries()).isEmpty()) {
            QueriesUI.showQueryResults(this.fWorkbenchWindow, queries.get(0));
        }
    }

    public Menu getMenu(Menu parent) {
        return null;
    }

    public void dispose() {
        this.disposeMenu();
    }

    private void disposeMenu() {
        if (this.fMenu != null && !this.fMenu.isDisposed()) {
            this.fMenu.dispose();
        }
    }
}

