/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.rcp.ui.internal.actions;

import com.ibm.team.jface.labelProviders.ElementRemovedNotifierImpl;
import com.ibm.team.jface.labelProviders.IElementRemovedNotifier;
import com.ibm.team.jface.labelProviders.StandardLabelProvider;
import com.ibm.team.process.common.IProjectAreaHandle;
import com.ibm.team.process.rcp.ui.teamnavigator.ConnectedProjectAreaRegistry;
import com.ibm.team.process.rcp.ui.teamnavigator.IConnectedProjectAreaRegistryChangeEvent;
import com.ibm.team.process.rcp.ui.teamnavigator.IConnectedProjectAreaRegistryListener;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.client.TeamPlatform;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.workitem.rcp.ui.internal.ConnectedProjectAreas;
import com.ibm.team.workitem.rcp.ui.internal.IDefaultProjectAreaListener;
import com.ibm.team.workitem.rcp.ui.internal.ProjectAreaPicker;
import com.ibm.team.workitem.rcp.ui.internal.actions.NewWorkItemAction;
import java.util.Collections;
import java.util.List;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IMenuCreator;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProjectAreaSelectionAction
extends Action
implements IMenuCreator,
IDefaultProjectAreaListener {
    public static final String QUERY_CATEGORY = "query";
    public static final String PICKER_CATEGORY = "picker";
    private Menu fMenu;
    private ITeamRepository fCurrentTeamRepository;
    private ITeamRepository fRestrictingRepository;
    private ILabelProvider fStandardLabelProvider;
    private boolean fRepositoryFallback;
    private ConnectedProjectAreas fProjectAreas;
    private boolean fInactiveOnDefault = false;
    private boolean fEnableNotLoggedIn = false;
    private IConnectedProjectAreaRegistryListener fConnectionListener = new IConnectedProjectAreaRegistryListener(){

        public void connectedProjectAreaRegistryChanged(IConnectedProjectAreaRegistryChangeEvent changeEvent) {
            ProjectAreaSelectionAction.this.updateConnectionStatus();
        }
    };
    private SelectionListener fSelectionListener = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent e) {
            MenuItem item = (MenuItem)e.widget;
            if (item.getSelection()) {
                if (item.getData() instanceof IProjectAreaHandle) {
                    IProjectAreaHandle projectArea = (IProjectAreaHandle)item.getData();
                    ProjectAreaSelectionAction.this.fProjectAreas.setDefaultProjectArea(projectArea);
                    ProjectAreaSelectionAction.this.projectAreaSelected(projectArea);
                } else if (item.getData() instanceof ITeamRepository) {
                    ProjectAreaSelectionAction.this.fCurrentTeamRepository = (ITeamRepository)item.getData();
                    ProjectAreaSelectionAction.this.repositorySelected(ProjectAreaSelectionAction.this.fCurrentTeamRepository);
                }
            }
        }
    };

    public ProjectAreaSelectionAction(String category) {
        this(category, false);
    }

    public ProjectAreaSelectionAction(String category, boolean repositoryFallback) {
        this(repositoryFallback, ConnectedProjectAreas.getInstance(category));
    }

    public ProjectAreaSelectionAction(ConnectedProjectAreas projectAreas) {
        this(false, projectAreas);
    }

    public ProjectAreaSelectionAction(boolean repositoryFallback, ConnectedProjectAreas projectAreas) {
        this.fRepositoryFallback = repositoryFallback;
        this.fProjectAreas = projectAreas;
        this.fStandardLabelProvider = new StandardLabelProvider((IElementRemovedNotifier)new ElementRemovedNotifierImpl());
        ConnectedProjectAreaRegistry.getDefault().addListener(this.fConnectionListener);
        this.fProjectAreas.addListener(this);
        this.updateEnablement();
    }

    public IProjectAreaHandle getProjectArea() {
        return this.fProjectAreas.getDefaultProjectAreaFallback(this.fRestrictingRepository, false);
    }

    public IProjectAreaHandle getDefaultProjectArea(boolean includeLoggedOut) {
        return this.fProjectAreas.getDefaultProjectAreaFallback(this.fRestrictingRepository, includeLoggedOut);
    }

    public ITeamRepository getTeamRepository() {
        IProjectAreaHandle projectArea = this.getProjectArea();
        if (projectArea != null) {
            return (ITeamRepository)projectArea.getOrigin();
        }
        if (this.fCurrentTeamRepository == null || !this.fCurrentTeamRepository.loggedIn()) {
            this.fCurrentTeamRepository = this.getDefaultTeamRepository();
        }
        return this.fCurrentTeamRepository;
    }

    public void restrictToRepository(ITeamRepository repository) {
        this.fRestrictingRepository = repository;
        this.updateEnablement();
    }

    protected void projectAreaSelected(IProjectAreaHandle projectAreaHandle) {
    }

    protected void repositorySelected(ITeamRepository currentTeamRepository) {
    }

    protected void updateConnectionStatus() {
        this.updateEnablement();
    }

    public IMenuCreator getMenuCreator() {
        return this;
    }

    public int getStyle() {
        return 4;
    }

    public void dispose() {
        if (this.fMenu != null) {
            this.fMenu.dispose();
            this.fMenu = null;
        }
        if (this.fStandardLabelProvider != null) {
            this.fStandardLabelProvider.dispose();
            this.fStandardLabelProvider = null;
        }
        ConnectedProjectAreaRegistry.getDefault().removeListener(this.fConnectionListener);
        this.fProjectAreas.removeListener(this);
    }

    public Menu getMenu(Control parent) {
        if (this.fMenu != null) {
            this.fMenu.dispose();
        }
        this.fMenu = new Menu(parent);
        this.fillMenu(this.fMenu);
        return this.fMenu;
    }

    public Menu getMenu(Menu parent) {
        if (this.fMenu != null) {
            this.fMenu.dispose();
        }
        this.fMenu = new Menu(parent);
        this.fillMenu(this.fMenu);
        return this.fMenu;
    }

    protected void fillMenu(Menu menu) {
        List<IProjectAreaHandle> connected = this.getConnectedProjectAreas();
        if (connected.size() == 0 && this.fRepositoryFallback) {
            ITeamRepository[] repositories = TeamPlatform.getTeamRepositoryService().getTeamRepositories();
            if (repositories.length > 1) {
                new GroupMarker("RepositoryStart").fill(menu, 0);
                ITeamRepository[] iTeamRepositoryArray = repositories;
                int n = repositories.length;
                int n2 = 0;
                while (n2 < n) {
                    ITeamRepository teamRepository = iTeamRepositoryArray[n2];
                    MenuItem item = new MenuItem(menu, 16);
                    item.setData((Object)teamRepository);
                    item.setEnabled(teamRepository.loggedIn() || this.fEnableNotLoggedIn);
                    item.setSelection(this.isSelected(teamRepository));
                    item.addSelectionListener(this.fSelectionListener);
                    item.setText(this.fStandardLabelProvider.getText((Object)teamRepository));
                    item.setImage(this.fStandardLabelProvider.getImage((Object)teamRepository));
                    ++n2;
                }
                new GroupMarker("RepositoryEnd").fill(menu, -1);
            }
        } else if (connected.size() > 1) {
            Collections.sort(connected, ProjectAreaPicker.fgProjectAreaComparator);
            new GroupMarker("ProjectAreaStart").fill(menu, 0);
            for (IProjectAreaHandle projectAreaHandle : connected) {
                MenuItem item = new MenuItem(menu, 16);
                item.setData((Object)projectAreaHandle);
                item.setEnabled(this.isAvailable(projectAreaHandle) || this.fEnableNotLoggedIn);
                item.setSelection(this.isSelected(projectAreaHandle));
                item.addSelectionListener(this.fSelectionListener);
                item.setText(NewWorkItemAction.asMenuName(ProjectAreaPicker.getUnambiguousProjectName(connected, projectAreaHandle)));
                item.setImage(this.fStandardLabelProvider.getImage((Object)projectAreaHandle));
            }
            new GroupMarker("ProjectAreaEnd").fill(menu, -1);
        }
    }

    private boolean isSelected(ITeamRepository teamRepository) {
        if (this.getTeamRepository() == null) {
            return false;
        }
        return this.getTeamRepository().getId().equals((Object)teamRepository.getId());
    }

    private boolean isSelected(IProjectAreaHandle projectAreaHandle) {
        if (this.getProjectArea() == null) {
            return false;
        }
        return this.getProjectArea().sameItemId((IItemHandle)projectAreaHandle);
    }

    private boolean isAvailable(IProjectAreaHandle projectAreaHandle) {
        if (projectAreaHandle == null) {
            return false;
        }
        ITeamRepository repository = (ITeamRepository)projectAreaHandle.getOrigin();
        return repository.loggedIn() && repository.getErrorState() == 0;
    }

    private ITeamRepository getDefaultTeamRepository() {
        ITeamRepository[] repositories;
        ITeamRepository[] iTeamRepositoryArray = repositories = TeamPlatform.getTeamRepositoryService().getTeamRepositories();
        int n = repositories.length;
        int n2 = 0;
        while (n2 < n) {
            ITeamRepository teamRepository = iTeamRepositoryArray[n2];
            if (teamRepository.loggedIn()) {
                return teamRepository;
            }
            ++n2;
        }
        return null;
    }

    protected void updateEnablement() {
        if (this.fProjectAreas.getDefaultProjectAreaFallback() == null) {
            this.setEnabled(this.fRepositoryFallback && this.getTeamRepository() != null);
        } else if (this.fInactiveOnDefault) {
            this.setEnabled(this.getConnectedProjectAreas().size() > 1);
        } else {
            this.setEnabled(true);
        }
    }

    protected List<IProjectAreaHandle> getConnectedProjectAreas() {
        return ConnectedProjectAreaRegistry.getDefault().getConnectedProjectAreas(this.fRestrictingRepository);
    }

    public void setInactiveOnDefault(boolean inactive) {
        this.fInactiveOnDefault = inactive;
        this.updateEnablement();
    }

    public void setEnableNotLoggedIn(boolean enable) {
        this.fEnableNotLoggedIn = enable;
    }

    @Override
    public void defaultProjectAreaChanged(IProjectAreaHandle before, IProjectAreaHandle after) {
    }
}

