/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.rcp.ui.internal.actions;

import com.ibm.team.foundation.rcp.ui.util.FoundationUIUtils;
import com.ibm.team.process.common.IProcessArea;
import com.ibm.team.process.common.IProcessAreaHandle;
import com.ibm.team.process.common.IProjectAreaHandle;
import com.ibm.team.process.common.ITeamAreaHandle;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IAuditableHandle;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.workitem.client.IQueryClient;
import com.ibm.team.workitem.common.query.IAssociation;
import com.ibm.team.workitem.common.query.IQueryDescriptor;
import com.ibm.team.workitem.common.query.IQueryDescriptorHandle;
import com.ibm.team.workitem.rcp.ui.QueriesUI;
import com.ibm.team.workitem.rcp.ui.internal.ConnectedProjectAreas;
import com.ibm.team.workitem.rcp.ui.internal.ProjectAreaPicker;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;

public class NewQueryAction
extends Action
implements IObjectActionDelegate {
    private IStructuredSelection fSelection;
    private IWorkbenchPart fWorkbenchPart;

    public NewQueryAction() {
    }

    public NewQueryAction(IWorkbenchPart part, IStructuredSelection selection) {
        this.fWorkbenchPart = part;
        this.fSelection = selection;
    }

    public NewQueryAction(IWorkbenchPart part) {
        this(part, (IStructuredSelection)StructuredSelection.EMPTY);
    }

    public void run() {
        ITeamRepository repository;
        Shell shell = this.getShell();
        if (shell == null) {
            return;
        }
        IProjectAreaHandle projectArea = this.getProjectAreaFromSelection(shell, this.fSelection);
        ITeamAreaHandle teamArea = this.getTeamAreaFromSelection(this.fSelection);
        if (projectArea != null && FoundationUIUtils.validateRepository((ITeamRepository)(repository = (ITeamRepository)projectArea.getOrigin()), (boolean)true, null).isOK()) {
            IQueryClient queryClient = (IQueryClient)repository.getClientLibrary(IQueryClient.class);
            IQueryDescriptor query = queryClient.createQuery(projectArea, "com.ibm.team.workitem.workItemType", "", null);
            if (teamArea != null) {
                IAssociation association = query.getAssociations().createAssociation((IAuditableHandle)teamArea);
                query.getAssociations().associate(association);
            }
            IWorkbenchPage page = null;
            page = this.fWorkbenchPart != null ? this.fWorkbenchPart.getSite().getPage() : FoundationUIUtils.getActivePage();
            if (page != null) {
                QueriesUI.editQuery(page, (IQueryDescriptorHandle)query);
            }
        }
    }

    private Shell getShell() {
        if (this.fWorkbenchPart != null && this.fWorkbenchPart.getSite() != null) {
            return this.fWorkbenchPart.getSite().getShell();
        }
        return Display.getCurrent().getActiveShell();
    }

    private IProjectAreaHandle getProjectAreaFromSelection(Shell shell, IStructuredSelection selection) {
        IProjectAreaHandle projectArea;
        IProcessArea processArea;
        if (selection == null || selection.isEmpty()) {
            return this.getDefaultProjectArea(shell);
        }
        Object firstElement = selection.getFirstElement();
        if (firstElement instanceof IProjectAreaHandle) {
            return (IProjectAreaHandle)firstElement;
        }
        if (firstElement instanceof IProcessAreaHandle && (processArea = this.getFullState((IProcessAreaHandle)firstElement)) != null) {
            return processArea.getProjectArea();
        }
        if (firstElement instanceof IAdaptable && (projectArea = (IProjectAreaHandle)((IAdaptable)firstElement).getAdapter(IProjectAreaHandle.class)) != null) {
            return projectArea;
        }
        return this.getDefaultProjectArea(shell);
    }

    private IProjectAreaHandle getDefaultProjectArea(Shell shell) {
        IProjectAreaHandle projectArea = ConnectedProjectAreas.getInstance().getDefaultProjectArea();
        if (projectArea == null) {
            projectArea = ProjectAreaPicker.showDialog(shell, false);
        }
        return projectArea;
    }

    private ITeamAreaHandle getTeamAreaFromSelection(IStructuredSelection selection) {
        if (selection == null || selection.isEmpty()) {
            return null;
        }
        Object firstElement = selection.getFirstElement();
        if (firstElement instanceof ITeamAreaHandle) {
            return (ITeamAreaHandle)firstElement;
        }
        if (firstElement instanceof IAdaptable) {
            return (ITeamAreaHandle)((IAdaptable)firstElement).getAdapter(ITeamAreaHandle.class);
        }
        return null;
    }

    private IProcessArea getFullState(IProcessAreaHandle handle) {
        if (handle.hasFullState()) {
            return (IProcessArea)handle.getFullState();
        }
        ITeamRepository repository = (ITeamRepository)handle.getOrigin();
        return (IProcessArea)repository.itemManager().getSharedItemIfKnown((IItemHandle)handle);
    }

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
        this.fWorkbenchPart = targetPart;
    }

    public void run(IAction action) {
        this.run();
    }

    public void selectionChanged(IAction action, ISelection selection) {
        if (selection instanceof IStructuredSelection) {
            this.fSelection = (IStructuredSelection)selection;
        }
    }
}

