/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.rcp.ui.internal.actions;

import com.ibm.team.foundation.rcp.ui.internal.util.Utils;
import com.ibm.team.foundation.rcp.ui.util.FoundationUIUtils;
import com.ibm.team.jface.util.UIUpdaterJob;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IAuditableHandle;
import com.ibm.team.repository.common.IItem;
import com.ibm.team.repository.common.Location;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.util.NLS;
import com.ibm.team.workitem.client.IAuditableClient;
import com.ibm.team.workitem.common.model.IWorkItem;
import com.ibm.team.workitem.common.model.IWorkItemHandle;
import com.ibm.team.workitem.common.text.WorkItemTextUtilities;
import com.ibm.team.workitem.rcp.ui.internal.WorkItemRCPUIPlugin;
import com.ibm.team.workitem.rcp.ui.internal.actions.Messages;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.HTMLTransfer;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;

public class CopyToClipboardAction
implements IObjectActionDelegate {
    private ISelection fSelection;
    private IWorkbenchPart fWorkbenchPart;

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
        this.fWorkbenchPart = targetPart;
    }

    public void selectionChanged(IAction action, ISelection selection) {
        this.fSelection = selection;
        if (action != null) {
            action.setEnabled(this.isEnabled(selection));
        }
    }

    private boolean isEnabled(ISelection selection) {
        if (selection instanceof IStructuredSelection) {
            IStructuredSelection structuredSelection = (IStructuredSelection)selection;
            for (Object next : structuredSelection) {
                if (next instanceof IWorkItemHandle) {
                    IWorkItem workitem;
                    IWorkItemHandle handle = (IWorkItemHandle)next;
                    if (!handle.hasFullState() || !(workitem = (IWorkItem)handle.getFullState()).isNewItem()) continue;
                    return false;
                }
                return false;
            }
            return !structuredSelection.isEmpty();
        }
        return false;
    }

    public void run(IAction action) {
        InternalUIUpdaterJob job = new InternalUIUpdaterJob(Messages.CopyToClipboardAction_COPY_TO_CLIPBOARD){
            private List<IWorkItem> fData;
            {
                this.fData = new ArrayList<IWorkItem>();
            }

            public boolean needsRunInBackground() {
                IStructuredSelection selection = (IStructuredSelection)CopyToClipboardAction.this.fSelection;
                for (IWorkItemHandle workItemHandle : selection) {
                    ITeamRepository teamRepository = (ITeamRepository)workItemHandle.getOrigin();
                    IAuditableClient auditableClient = (IAuditableClient)teamRepository.getClientLibrary(IAuditableClient.class);
                    IWorkItem workItem = (IWorkItem)auditableClient.findCachedAuditable((IAuditableHandle)workItemHandle, IWorkItem.SMALL_PROFILE);
                    if (workItem == null) {
                        return true;
                    }
                    this.fData.add(workItem);
                }
                return false;
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public IStatus runInBackground(IProgressMonitor monitor) {
                try {
                    IStructuredSelection selection = (IStructuredSelection)CopyToClipboardAction.this.fSelection;
                    Iterator iter = selection.iterator();
                    while (true) {
                        if (!iter.hasNext()) {
                            return Status.OK_STATUS;
                        }
                        IWorkItemHandle workItemHandle = (IWorkItemHandle)iter.next();
                        ITeamRepository teamRepository = (ITeamRepository)workItemHandle.getOrigin();
                        IStatus status = FoundationUIUtils.validateRepository((ITeamRepository)teamRepository, (boolean)true, (IProgressMonitor)monitor);
                        if (!status.isOK()) {
                            return status;
                        }
                        IAuditableClient auditableClient = (IAuditableClient)teamRepository.getClientLibrary(IAuditableClient.class);
                        IWorkItem workItem = (IWorkItem)auditableClient.resolveAuditable((IAuditableHandle)workItemHandle, IWorkItem.SMALL_PROFILE, monitor);
                        if (workItem == null) {
                            return null;
                        }
                        this.fData.add(workItem);
                    }
                }
                catch (TeamRepositoryException x) {
                    return new Status(4, "com.ibm.team.workitem.rcp.ui", 0, Messages.CopyToClipboardAction_EXCEPTION_RESOLVING_WORKITEM, (Throwable)x);
                }
            }

            public IStatus runInUI(IProgressMonitor monitor) {
                Iterator iterator = ((IStructuredSelection)CopyToClipboardAction.this.fSelection).iterator();
                StringBuffer buffer = new StringBuffer();
                StringBuffer htmlBuffer = new StringBuffer();
                while (iterator.hasNext()) {
                    IWorkItemHandle workItemHandle = (IWorkItemHandle)iterator.next();
                    ITeamRepository teamRepository = (ITeamRepository)workItemHandle.getOrigin();
                    IAuditableClient auditableClient = (IAuditableClient)teamRepository.getClientLibrary(IAuditableClient.class);
                    IWorkItem workItem = (IWorkItem)auditableClient.findCachedAuditable((IAuditableHandle)workItemHandle, IWorkItem.SMALL_PROFILE);
                    if (workItem == null) continue;
                    try {
                        String link = CopyToClipboardAction.this.getLink(teamRepository, workItem);
                        buffer.append(CopyToClipboardAction.this.getLabel(workItem, link));
                        if (iterator.hasNext()) {
                            buffer.append("\r\n");
                        }
                        htmlBuffer.append("<a itemId=\"");
                        htmlBuffer.append(workItem.getItemId().getUuidValue());
                        htmlBuffer.append("\" href=\"");
                        htmlBuffer.append(link);
                        htmlBuffer.append("\">");
                        htmlBuffer.append(CopyToClipboardAction.this.getHTMLLabel(workItem));
                        htmlBuffer.append("</a>");
                        if (!iterator.hasNext()) continue;
                        htmlBuffer.append("<br/>");
                    }
                    catch (IllegalStateException e) {
                        WorkItemRCPUIPlugin.getDefault().log("Error while creating URL", e);
                    }
                    catch (TeamRepositoryException e) {
                        WorkItemRCPUIPlugin.getDefault().log("Error while creating URL", e);
                    }
                }
                String textContent = buffer.toString();
                String htmlContent = Utils.escapeForHTMLTransfer((String)htmlBuffer.toString());
                if (textContent.length() > 0 && htmlContent.length() > 0) {
                    Display display = CopyToClipboardAction.this.fWorkbenchPart != null ? CopyToClipboardAction.this.fWorkbenchPart.getSite().getShell().getDisplay() : Display.getDefault();
                    Clipboard cb = new Clipboard(display);
                    try {
                        cb.setContents(new Object[]{textContent, htmlContent}, new Transfer[]{TextTransfer.getInstance(), HTMLTransfer.getInstance()});
                    }
                    finally {
                        cb.dispose();
                    }
                }
                return Status.OK_STATUS;
            }
        };
        job.run();
    }

    private String getLink(ITeamRepository repository, IWorkItem workItem) throws IllegalStateException, TeamRepositoryException {
        String repositoryURI = this.getRepositoryUri(repository);
        Location location = Location.namedLocation((IItem)workItem, (String)repositoryURI);
        String url = location.toAbsoluteUri().toString();
        return url;
    }

    protected String getRepositoryUri(ITeamRepository repository) {
        String publicUriRoot = repository.publicUriRoot();
        if (publicUriRoot != null) {
            return publicUriRoot;
        }
        return repository.getRepositoryURI();
    }

    protected String getLabel(IWorkItem workItem, String link) {
        return WorkItemTextUtilities.getWorkItemText((IWorkItem)workItem);
    }

    protected String getHTMLLabel(IWorkItem workItem) {
        String escapedFormat = com.ibm.team.workitem.rcp.ui.internal.util.Utils.escapeToHTML(Messages.CopyToClipboardAction_PATTERN_HTML_LABEL);
        return NLS.bind((String)escapedFormat, (Object)workItem.getHTMLSummary().getXMLText(), (Object[])new Object[]{WorkItemTextUtilities.getWorkItemId((IWorkItem)workItem)});
    }

    private static class InternalUIUpdaterJob
    extends UIUpdaterJob {
        public InternalUIUpdaterJob(String name) {
            super(name);
        }

        public boolean needsRunInBackground() {
            return true;
        }

        public void run() {
            if (this.needsRunInBackground()) {
                this.schedule();
            } else {
                this.runInUI(null);
            }
        }
    }
}

