/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.rcp.ui.internal.actions;

import com.ibm.team.foundation.client.internal.util.ClientURIUtils;
import com.ibm.team.foundation.common.URIReference;
import com.ibm.team.foundation.rcp.core.hyperlinks.Hyperlinks;
import com.ibm.team.foundation.rcp.ui.internal.util.Utils;
import com.ibm.team.foundation.rcp.ui.util.FoundationUIUtils;
import com.ibm.team.jface.util.UIUpdaterJob;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.workitem.rcp.ui.internal.actions.Messages;
import java.net.URI;
import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.HTMLTransfer;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;

public class CopyHyperlinkToClipboardAction
implements IObjectActionDelegate {
    private ISelection fSelection;
    private IWorkbenchPart fWorkbenchPart;

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
        this.fWorkbenchPart = targetPart;
    }

    public void selectionChanged(IAction action, ISelection selection) {
        this.fSelection = selection;
        if (action != null) {
            action.setEnabled(this.isEnabled(selection));
        }
    }

    private boolean isEnabled(ISelection selection) {
        return selection instanceof IStructuredSelection;
    }

    public void run(IAction action) {
        UIUpdaterJob job = new UIUpdaterJob(Messages.CopyHyperlinkToClipboardAction_COPY_HYPERLINKS_TO_CLIPBOARD){
            private StringBuffer fTextBuffer;
            private StringBuffer fHTMLBuffer;
            {
                this.fTextBuffer = new StringBuffer();
                this.fHTMLBuffer = new StringBuffer();
            }

            public IStatus runInBackground(IProgressMonitor monitor) {
                ArrayList<URIReference> references = new ArrayList<URIReference>();
                IStructuredSelection selection = (IStructuredSelection)CopyHyperlinkToClipboardAction.this.fSelection;
                SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)selection.size());
                for (IItemHandle handle : selection) {
                    ITeamRepository teamRepository = (ITeamRepository)handle.getOrigin();
                    IStatus status = FoundationUIUtils.validateRepository((ITeamRepository)teamRepository, (boolean)true, (IProgressMonitor)monitor);
                    if (!status.isOK()) {
                        return status;
                    }
                    references.add(Hyperlinks.create((Object)handle, (IProgressMonitor)subMonitor.newChild(1)));
                }
                Iterator iterator = references.iterator();
                while (iterator.hasNext()) {
                    URIReference reference = (URIReference)iterator.next();
                    this.fTextBuffer.append(CopyHyperlinkToClipboardAction.this.createTextReference(reference));
                    if (iterator.hasNext()) {
                        this.fTextBuffer.append("\r\n");
                    }
                    this.fHTMLBuffer.append(CopyHyperlinkToClipboardAction.this.createHTMLReference(reference));
                    if (!iterator.hasNext()) continue;
                    this.fHTMLBuffer.append("<br>");
                }
                return Status.OK_STATUS;
            }

            public IStatus runInUI(IProgressMonitor monitor) {
                Clipboard cb = new Clipboard(CopyHyperlinkToClipboardAction.this.fWorkbenchPart.getSite().getShell().getDisplay());
                try {
                    cb.setContents(new Object[]{this.fTextBuffer.toString(), Utils.escapeForHTMLTransfer((String)this.fHTMLBuffer.toString())}, new Transfer[]{TextTransfer.getInstance(), HTMLTransfer.getInstance()});
                }
                finally {
                    cb.dispose();
                }
                return Status.OK_STATUS;
            }
        };
        job.schedule();
    }

    protected String createHTMLReference(URIReference reference) {
        String linkText = reference.getName();
        if (reference.getDetails().length() > 0) {
            linkText = reference.getDetails();
        }
        return String.format("<a href=\"%s\">%s</a>", ClientURIUtils.toPublicRepositoryURI((URI)reference.getURI()).toString(), linkText);
    }

    protected String createTextReference(URIReference reference) {
        return ClientURIUtils.toPublicRepositoryURI((URI)reference.getURI()).toString();
    }
}

