/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.rcp.ui.internal.actions;

import com.ibm.team.jface.dashboard.ISection;
import com.ibm.team.jface.internal.dashboard.views.Perspective;
import com.ibm.team.jface.internal.dashboard.views.PerspectiveSectionSlot;
import com.ibm.team.jface.internal.dashboard.views.PerspectivesManager;
import com.ibm.team.jface.internal.dashboard.views.SectionPart;
import com.ibm.team.jface.internal.dashboard.views.SectionsManager;
import com.ibm.team.jface.internal.dashboard.views.TeamCentralView;
import com.ibm.team.workitem.common.internal.util.ItemHandleAwareHashSet;
import com.ibm.team.workitem.common.query.IQueryDescriptor;
import com.ibm.team.workitem.common.query.IQueryDescriptorHandle;
import com.ibm.team.workitem.rcp.ui.internal.actions.Messages;
import com.ibm.team.workitem.rcp.ui.internal.dashboard.QuerySection;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuCreator;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.events.MenuAdapter;
import org.eclipse.swt.events.MenuEvent;
import org.eclipse.swt.events.MenuListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AddQueryToTeamCentralAction
implements IObjectActionDelegate,
IMenuCreator {
    private IStructuredSelection fSelection;

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
    }

    public void selectionChanged(IAction action, ISelection selection) {
        action.setMenuCreator((IMenuCreator)this);
        action.setEnabled(TeamCentralView.getDefault() != null);
        if (selection instanceof IStructuredSelection) {
            this.fSelection = (IStructuredSelection)selection;
        }
    }

    public Menu getMenu(Control parent) {
        return null;
    }

    private void fillMenu(final Menu menu) {
        if (this.fSelection.isEmpty()) {
            return;
        }
        final ArrayList<IQueryDescriptorHandle> queryList = new ArrayList<IQueryDescriptorHandle>();
        for (Object selected : this.fSelection.toList()) {
            if (!(selected instanceof IQueryDescriptorHandle)) continue;
            IQueryDescriptorHandle queryDescriptor = (IQueryDescriptorHandle)selected;
            queryList.add(queryDescriptor);
        }
        TeamCentralView view = TeamCentralView.getDefault();
        if (view == null) {
            return;
        }
        SectionsManager sectionManager = view.getSectionsManager();
        if (sectionManager == null) {
            return;
        }
        final WeakReference<SectionsManager> weakSectionsManager = new WeakReference<SectionsManager>(sectionManager);
        PerspectivesManager perspectivesManager = sectionManager.getPerspectivesManager();
        Perspective perspective = perspectivesManager.getCurrentPerspective();
        MenuItem createItem = new MenuItem(menu, 0);
        createItem.setText(Messages.AddQueryToTeamCentralAction_CREATE_SECTION);
        createItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                QuerySection section;
                SectionsManager sectionManager = (SectionsManager)weakSectionsManager.get();
                if (sectionManager == null) {
                    return;
                }
                String sectionName = this.getDefaultSectionName(queryList);
                InputDialog inputDialog = new InputDialog(menu.getShell(), Messages.AddQueryToTeamCentralAction_CREATE_SECTION, Messages.AddQueryToTeamCentralAction_ENTER_NAME, sectionName, new IInputValidator(){

                    public String isValid(String newText) {
                        if (newText.trim().length() == 0) {
                            return "";
                        }
                        return null;
                    }
                });
                if (inputDialog.open() == 0 && (section = (QuerySection)sectionManager.cloneSection("com.ibm.magnolia.workitems.views.userDefinedSection", "")) != null) {
                    section.setQueries(queryList);
                    section.getSectionSite().setName(inputDialog.getValue());
                }
            }

            private String getDefaultSectionName(List<IQueryDescriptorHandle> queryList2) {
                if (queryList2.size() == 1 && queryList2.get(0).hasFullState()) {
                    return ((IQueryDescriptor)queryList2.get(0)).getName();
                }
                return "";
            }
        });
        boolean first = true;
        Iterator iterator = perspective.getSectionSlots().iterator();
        while (iterator.hasNext()) {
            ISection objSection;
            String sectionId = ((PerspectiveSectionSlot)iterator.next()).getSectionId();
            SectionPart part = sectionManager.getSection(sectionId);
            if (part == null || !((objSection = part.getSectionImpl()) instanceof QuerySection)) continue;
            QuerySection section = (QuerySection)objSection;
            final WeakReference<QuerySection> weakQuerySection = new WeakReference<QuerySection>(section);
            if (first) {
                new MenuItem(menu, 2);
                first = false;
            }
            MenuItem item = new MenuItem(menu, 0);
            item.setText(section.getSectionSite().getName());
            item.setEnabled(!this.containsAll(queryList, section.getQueries()));
            item.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    QuerySection querySection = (QuerySection)weakQuerySection.get();
                    if (querySection != null) {
                        querySection.addQueries(queryList);
                    }
                }
            });
        }
    }

    private boolean containsAll(List<IQueryDescriptorHandle> source, Collection<IQueryDescriptorHandle> target) {
        ItemHandleAwareHashSet existing = new ItemHandleAwareHashSet(target);
        return existing.containsAll(source);
    }

    public void dispose() {
    }

    public void run(IAction action) {
    }

    public Menu getMenu(Menu parent) {
        Menu menu = new Menu(parent);
        menu.addMenuListener((MenuListener)new MenuAdapter(){

            public void menuShown(MenuEvent e) {
                Menu m = (Menu)e.widget;
                MenuItem[] items = m.getItems();
                int i = 0;
                while (i < items.length) {
                    items[i].dispose();
                    ++i;
                }
                AddQueryToTeamCentralAction.this.fillMenu(m);
            }
        });
        return menu;
    }
}

