/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.rcp.ui.internal.actions;

import com.ibm.team.foundation.client.util.FoundationJob;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.workitem.common.model.IWorkItem;
import com.ibm.team.workitem.common.model.IWorkItemHandle;
import com.ibm.team.workitem.rcp.core.ClientModel;
import com.ibm.team.workitem.rcp.ui.internal.actions.Messages;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;

public final class ActivateWorkItemAction
implements IObjectActionDelegate {
    private IWorkItemHandle fHandle = null;

    private static boolean isNewItem(IWorkItemHandle handle) {
        Assert.isNotNull((Object)handle);
        if (handle instanceof IWorkItem) {
            return ((IWorkItem)handle).isNewItem();
        }
        return false;
    }

    public void run(IAction action) {
        if (this.fHandle != null) {
            FoundationJob job = new FoundationJob(Messages.ActivateWorkItemAction_START_WORKING){

                protected IStatus runProtected(IProgressMonitor monitor) {
                    return ClientModel.getWorkItemActivationManager().activateWorkItem(ActivateWorkItemAction.this.fHandle, monitor);
                }
            };
            job.schedule();
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
        Object element;
        IStructuredSelection extended;
        Assert.isNotNull((Object)action);
        Assert.isNotNull((Object)selection);
        action.setText(Messages.ActivateWorkItemAction_START_WORKING);
        this.fHandle = null;
        if (selection instanceof IStructuredSelection && (extended = (IStructuredSelection)selection).size() == 1 && (element = extended.getFirstElement()) instanceof IWorkItemHandle) {
            this.fHandle = (IWorkItemHandle)element;
        }
        action.setEnabled(this.fHandle != null && !ActivateWorkItemAction.isNewItem(this.fHandle) && !this.fHandle.sameItemId((IItemHandle)ClientModel.getWorkItemActivationManager().getActiveWorkItem()));
    }

    public void setActivePart(IAction action, IWorkbenchPart part) {
    }
}

