/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.rcp.ui.internal.actions;

import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.util.NLS;
import com.ibm.team.workitem.common.model.IAttribute;
import com.ibm.team.workitem.common.model.IWorkItemHandle;
import com.ibm.team.workitem.rcp.ui.internal.ChangeWorkItemAttributeOperation;
import com.ibm.team.workitem.rcp.ui.internal.actions.Messages;
import java.util.List;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public abstract class AbstractChangeWorkItemAttributeAction
extends Action {
    private ISelectionProvider fSelectionProvider;
    private IAttribute fAttribute;
    public static final Object NULLVALUE = new Object();

    public AbstractChangeWorkItemAttributeAction(IAttribute attribute, ISelectionProvider selectionProvider) {
        this.fAttribute = attribute;
        this.fSelectionProvider = selectionProvider;
    }

    public void run() {
        ISelection selection = this.fSelectionProvider.getSelection();
        if (selection == null || selection.isEmpty() || !(selection instanceof IStructuredSelection)) {
            return;
        }
        Object value = this.getValue();
        if (value != null) {
            if (value == NULLVALUE) {
                value = null;
            }
            List elements = ((IStructuredSelection)selection).toList();
            String operationName = NLS.bind((String)Messages.AbstractChangeWorkItemAttributeAction_CHANGE_VALUE_OPERATION_NAME, (Object)this.fAttribute.getDisplayName(), (Object[])new Object[0]);
            ChangeWorkItemAttributeOperation operation = new ChangeWorkItemAttributeOperation(operationName, this.fAttribute, value);
            operation.runInJob(elements.toArray(new IWorkItemHandle[elements.size()]));
        }
    }

    protected abstract Object getValue();

    protected ITeamRepository getTeamRepository() {
        return (ITeamRepository)this.fAttribute.getOrigin();
    }

    protected Shell getShell() {
        return Display.getCurrent().getActiveShell();
    }
}

