/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.rcp.ui.internal;

import com.ibm.team.feed.core.ClientFeedUtils;
import com.ibm.team.feed.core.FeedManager;
import com.ibm.team.feed.core.INewsListener;
import com.ibm.team.feed.core.NewsEvent;
import com.ibm.team.feed.core.model.NewsItem;
import com.ibm.team.foundation.rcp.core.readstate.IReadStateManager;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.client.TeamPlatform;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.workitem.common.model.IWorkItem;
import com.ibm.team.workitem.common.model.IWorkItemHandle;

public class WorkItemNewsListener
implements INewsListener {
    public void newsReceived(NewsEvent event) {
        NewsItem[] news;
        NewsItem[] newsItemArray = news = event.getAddedNews();
        int n = news.length;
        int n2 = 0;
        while (n2 < n) {
            NewsItem newsItem = newsItemArray[n2];
            IWorkItemHandle wi = this.getWorkItem(newsItem);
            if (wi != null) {
                IReadStateManager readStateManager = IReadStateManager.DEFAULT;
                if (readStateManager.isMarkedRead((IItemHandle)wi, newsItem.getPublishDate())) {
                    FeedManager.getDefault().setRead(newsItem, true);
                } else if (!ClientFeedUtils.getInstance().isModifier(newsItem)) {
                    readStateManager.markUnread((IItemHandle)wi);
                }
            }
            ++n2;
        }
    }

    public void newsRemoved(NewsEvent event) {
    }

    public void newsStateChanged(NewsEvent event) {
        NewsItem[] news;
        NewsItem[] newsItemArray = news = event.getChangedNews();
        int n = news.length;
        int n2 = 0;
        while (n2 < n) {
            NewsItem newsItem = newsItemArray[n2];
            IWorkItemHandle wi = this.getWorkItem(newsItem);
            if (wi != null) {
                IReadStateManager readStateManager = IReadStateManager.DEFAULT;
                if (newsItem.isIsRead() != readStateManager.isMarkedRead((IItemHandle)wi, newsItem.getPublishDate())) {
                    if (newsItem.isIsRead()) {
                        readStateManager.markRead((IItemHandle)wi, newsItem.getPublishDate());
                    } else {
                        readStateManager.markUnread((IItemHandle)wi);
                    }
                }
            }
            ++n2;
        }
    }

    private IWorkItemHandle getWorkItem(NewsItem newsItem) {
        ITeamRepository[] teamRepositories;
        String wiUUID = newsItem.getCustomAttribute("http://www.ibm.com/jazz/0.1.0/syndication", "itemId");
        if (wiUUID == null) {
            return null;
        }
        String typeNS = newsItem.getCustomAttribute("http://www.ibm.com/jazz/0.1.0/syndication", "typeNamespace");
        String typeName = newsItem.getCustomAttribute("http://www.ibm.com/jazz/0.1.0/syndication", "typeName");
        if (typeNS == null || typeName == null || !typeNS.equals(IWorkItem.ITEM_TYPE.getNamespaceURI()) || !typeName.equals(IWorkItem.ITEM_TYPE.getName())) {
            return null;
        }
        String repourl = newsItem.getCustomAttribute("http://www.ibm.com/jazz/0.1.0/syndication", "repositoryURL");
        if (repourl == null) {
            return null;
        }
        ITeamRepository repo = null;
        ITeamRepository[] iTeamRepositoryArray = teamRepositories = TeamPlatform.getTeamRepositoryService().getTeamRepositories();
        int n = teamRepositories.length;
        int n2 = 0;
        while (n2 < n) {
            ITeamRepository teamRepository = iTeamRepositoryArray[n2];
            if (teamRepository.getRepositoryURI().equals(repourl)) {
                repo = teamRepository;
                break;
            }
            ++n2;
        }
        if (repo == null) {
            return null;
        }
        IWorkItemHandle handle = (IWorkItemHandle)IWorkItem.ITEM_TYPE.createItemHandle(repo, UUID.valueOf((String)wiUUID), null);
        return handle;
    }
}

