/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.rcp.ui.internal;

import com.ibm.team.foundation.ide.ui.internal.styledtextviewer.contentassist.AbstractContentAssistProposalComputer;
import com.ibm.team.foundation.ide.ui.internal.styledtextviewer.contentassist.ContentAssistContext;
import com.ibm.team.foundation.ide.ui.internal.styledtextviewer.contentassist.ContentAssistContextProvider;
import com.ibm.team.foundation.ide.ui.internal.styledtextviewer.contentassist.ContextProviderContentAssistContext;
import com.ibm.team.foundation.ide.ui.internal.styledtextviewer.contentassist.ReferenceInsertionStrategy;
import com.ibm.team.foundation.ide.ui.internal.styledtextviewer.contentassist.ResolvableProposal;
import com.ibm.team.foundation.ide.ui.internal.styledtextviewer.contentassist.TeamContextProvider;
import com.ibm.team.jface.labelProviders.ElementRemovedNotifierImpl;
import com.ibm.team.jface.labelProviders.IElementRemovedNotifier;
import com.ibm.team.jface.labelProviders.StandardLabelProvider;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IAuditableHandle;
import com.ibm.team.repository.common.IItem;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.workitem.client.IAuditableClient;
import com.ibm.team.workitem.common.model.IWorkItem;
import com.ibm.team.workitem.common.model.IWorkItemHandle;
import com.ibm.team.workitem.rcp.core.ClientModel;
import com.ibm.team.workitem.rcp.core.WorkItemEditorHistoryEntry;
import com.ibm.team.workitem.rcp.ui.internal.ImagePool;
import com.ibm.team.workitem.rcp.ui.internal.WorkItemRCPUIPlugin;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.ViewerLabel;
import org.eclipse.swt.graphics.Image;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WorkItemHistoryProposalComputer
extends AbstractContentAssistProposalComputer {
    private static final int MAX_PROPOSALS = 20;
    private final ReferenceInsertionStrategy fInsertionStrategy;
    private StandardLabelProvider fStandardLabelProvider;

    public WorkItemHistoryProposalComputer(ReferenceInsertionStrategy insertionStrategy) {
        this.fInsertionStrategy = insertionStrategy;
    }

    public void sessionStarted() {
        super.sessionStarted();
        this.fStandardLabelProvider = new StandardLabelProvider((ILabelProvider)new FallBackLabelProvider(), (IElementRemovedNotifier)new ElementRemovedNotifierImpl());
    }

    public List<ICompletionProposal> computeCompletionProposals(ContentAssistContext context) {
        ContentAssistContextProvider contextProvider;
        ITeamRepository teamRepository = null;
        if (context instanceof ContextProviderContentAssistContext && (contextProvider = ((ContextProviderContentAssistContext)context).getContextProvider()) instanceof TeamContextProvider) {
            teamRepository = ((TeamContextProvider)contextProvider).getTeamRepository();
        }
        ArrayList<WorkItemHistoryEntryProposal> result = new ArrayList<WorkItemHistoryEntryProposal>();
        WorkItemEditorHistoryEntry[] historyEntries = ClientModel.getHistoryManager().getHistoryEntries();
        int i = 0;
        while (i < historyEntries.length && i < 20) {
            WorkItemEditorHistoryEntry entry = historyEntries[i];
            if (teamRepository == null || teamRepository.getRepositoryURI().equals(entry.getRepository())) {
                ViewerLabel label = new ViewerLabel(entry.getDescription(), null);
                this.fStandardLabelProvider.updateLabel(label, (Object)entry);
                result.add(new WorkItemHistoryEntryProposal(label.getText(), label.getImage(), entry, this.fInsertionStrategy));
            }
            ++i;
        }
        return this.filter(context, result);
    }

    public void sessionEnded() {
        if (this.fStandardLabelProvider != null) {
            this.fStandardLabelProvider.dispose();
            this.fStandardLabelProvider = null;
        }
        super.sessionEnded();
    }

    private static final class FallBackLabelProvider
    extends LabelProvider {
        private LocalResourceManager fManager = new LocalResourceManager(JFaceResources.getResources());

        public Image getImage(Object element) {
            return this.fManager.createImageWithDefault(ImagePool.WORKITEM_TITLE);
        }

        public String getText(Object element) {
            return ((WorkItemEditorHistoryEntry)element).getDescription();
        }

        public void dispose() {
            super.dispose();
            this.fManager.dispose();
        }
    }

    private static final class WorkItemHistoryEntryProposal
    extends ResolvableProposal {
        private WorkItemHistoryEntryProposal(String displayString, Image image, Object element, ReferenceInsertionStrategy insertionStrategy) {
            super(displayString, image, element, insertionStrategy);
        }

        protected Object resolve(Object element, IProgressMonitor monitor) throws CoreException {
            IWorkItemHandle workItem = ((WorkItemEditorHistoryEntry)element).getWorkItem();
            IItem fullState = workItem.getFullState();
            if (fullState != null) {
                return fullState;
            }
            ITeamRepository teamRepository = (ITeamRepository)workItem.getOrigin();
            if (teamRepository == null || !teamRepository.loggedIn()) {
                return workItem;
            }
            IAuditableClient auditableClient = (IAuditableClient)teamRepository.getClientLibrary(IAuditableClient.class);
            try {
                return auditableClient.resolveAuditable((IAuditableHandle)workItem, IWorkItem.SMALL_PROFILE, monitor);
            }
            catch (TeamRepositoryException e) {
                WorkItemRCPUIPlugin.getDefault().log(e.getLocalizedMessage(), e);
                return workItem;
            }
        }
    }
}

