/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.rcp.ui.internal;

import com.ibm.team.foundation.common.URIReference;
import com.ibm.team.foundation.ide.ui.internal.styledtextviewer.contentassist.ReferenceInsertionStrategy;
import com.ibm.team.foundation.ide.ui.internal.styledtextviewer.contentassist.ResolvableProposal;
import com.ibm.team.foundation.rcp.core.hyperlinks.Hyperlinks;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IAuditableHandle;
import com.ibm.team.repository.common.IContributor;
import com.ibm.team.repository.common.IContributorHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.workitem.client.IAuditableClient;
import com.ibm.team.workitem.common.model.ItemProfile;
import com.ibm.team.workitem.rcp.ui.internal.WorkItemRCPUIPlugin;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.progress.IProgressService;

public abstract class UserResolvableProposal
extends ResolvableProposal {
    private int fNewOffset;
    private final ReferenceInsertionStrategy fInsertionStrategy;
    protected ITeamRepository fTeamRepository;

    public UserResolvableProposal(String displayString, Image image, Object element, ReferenceInsertionStrategy insertionStrategy, ITeamRepository repository) {
        super(displayString, image, element, insertionStrategy);
        this.fInsertionStrategy = insertionStrategy;
        this.fTeamRepository = repository;
    }

    public Point getSelection(IDocument document) {
        return new Point(this.fNewOffset, 0);
    }

    protected void resolveAndInsert(IDocument document, int offset, final IContributorHandle[] contributorHandles, final String taskLabel, boolean insertAsLink) {
        IProgressService service = PlatformUI.getWorkbench().getProgressService();
        try {
            final boolean[] canceled = new boolean[1];
            final IContributor[] contributors = new IContributor[contributorHandles.length];
            final URIReference[] references = new URIReference[contributorHandles.length];
            service.busyCursorWhile(new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    monitor.beginTask(taskLabel, contributorHandles.length * 100);
                    int i = 0;
                    while (i < contributorHandles.length) {
                        try {
                            contributors[i] = (IContributor)UserResolvableProposal.this.resolve(contributorHandles[i], (IProgressMonitor)new SubProgressMonitor(monitor, 50));
                        }
                        catch (CoreException x) {
                            WorkItemRCPUIPlugin.getDefault().log(x.getMessage(), x);
                        }
                        if (monitor.isCanceled()) {
                            canceled[0] = true;
                            return;
                        }
                        ++i;
                    }
                    i = 0;
                    while (i < contributors.length) {
                        if (contributors[i] != null) {
                            references[i] = Hyperlinks.create((Object)contributors[i], (IProgressMonitor)new SubProgressMonitor(monitor, 50));
                        }
                        if (monitor.isCanceled()) {
                            canceled[0] = true;
                            return;
                        }
                        ++i;
                    }
                    monitor.done();
                }
            });
            if (canceled[0]) {
                return;
            }
            this.insertContributors(document, offset, contributors, references, insertAsLink);
        }
        catch (InvocationTargetException x) {
            WorkItemRCPUIPlugin.getDefault().log(x.getMessage(), x);
            return;
        }
        catch (InterruptedException x) {
            WorkItemRCPUIPlugin.getDefault().log(x.getMessage(), x);
            return;
        }
        catch (BadLocationException e) {
            WorkItemRCPUIPlugin.getDefault().log(e.getMessage(), e);
            return;
        }
        catch (CoreException e) {
            WorkItemRCPUIPlugin.getDefault().log(e.getMessage(), e);
            return;
        }
    }

    private void insertContributors(IDocument document, int offset, IContributor[] contributors, URIReference[] uriReferences, boolean insertAsLinks) throws BadLocationException, CoreException {
        String prefix = this.getPrefix(document, offset);
        int prefixLength = prefix.length();
        if (!insertAsLinks) {
            int i = 0;
            while (i < contributors.length) {
                if (contributors[i] != null) {
                    String atUserId;
                    if (i == 0) {
                        atUserId = String.valueOf('@') + contributors[i].getUserId();
                        document.replace(offset - prefixLength, prefixLength, atUserId);
                        this.fNewOffset = offset - prefixLength + atUserId.length();
                    } else {
                        atUserId = " @" + contributors[i].getUserId();
                        document.replace(this.fNewOffset, 0, atUserId);
                        this.fNewOffset += atUserId.length();
                    }
                }
                ++i;
            }
        } else {
            int i = 0;
            while (i < contributors.length) {
                if (contributors[i] != null && uriReferences[i] != null) {
                    if (i == 0) {
                        this.fNewOffset = this.fInsertionStrategy.insert(uriReferences[i], (Object)contributors[i], document, offset, document.get(offset - prefix.length(), prefix.length()));
                    } else {
                        document.replace(this.fNewOffset, 0, " ");
                        ++this.fNewOffset;
                        this.fNewOffset = this.fInsertionStrategy.insert(uriReferences[i], (Object)contributors[i], document, this.fNewOffset, "");
                    }
                }
                ++i;
            }
        }
    }

    protected String getPrefix(IDocument doc, int offset) throws BadLocationException {
        if (doc == null || offset > doc.getLength()) {
            return null;
        }
        int length = 0;
        while (--offset >= 0 && !Character.isWhitespace(doc.getChar(offset))) {
            ++length;
        }
        return doc.get(offset + 1, length);
    }

    protected Shell getShell() {
        IWorkbenchWindow activeWorkbenchWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (activeWorkbenchWindow != null) {
            return activeWorkbenchWindow.getShell();
        }
        return null;
    }

    protected Object resolve(Object element, IProgressMonitor monitor) throws CoreException {
        IAuditableClient auditableClient;
        if (element instanceof IContributor) {
            return element;
        }
        if (element instanceof IContributorHandle && (auditableClient = (IAuditableClient)this.fTeamRepository.getClientLibrary(IAuditableClient.class)) != null) {
            try {
                return auditableClient.resolveAuditable((IAuditableHandle)((IContributorHandle)element), ItemProfile.CONTRIBUTOR_DEFAULT, monitor);
            }
            catch (TeamRepositoryException teamRepositoryException) {
                throw new CoreException(Status.CANCEL_STATUS);
            }
        }
        return null;
    }
}

