/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.rcp.ui.internal;

import com.ibm.team.feed.core.FeedManager;
import com.ibm.team.feed.core.model.Channel;
import com.ibm.team.feed.core.model.NewsItem;
import com.ibm.team.foundation.client.util.FoundationJob;
import com.ibm.team.foundation.rcp.core.IReadStateTracker;
import com.ibm.team.foundation.rcp.core.readstate.IReadStateManager;
import com.ibm.team.repository.common.IItem;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.workitem.common.model.IWorkItem;
import com.ibm.team.workitem.rcp.ui.internal.Messages;
import java.util.ArrayList;
import org.eclipse.core.runtime.IAdapterFactory;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

public class ReadStateTrackerFactory
implements IAdapterFactory {
    private Class[] fAdapterList = new Class[]{IReadStateTracker.class};

    public void synchronizeChangeEvents(final IWorkItem workItem, final boolean markRead) {
        FoundationJob syncJob = new FoundationJob(Messages.ReadStateTrackerFactory_SYNCHRONIZING_READ_STATE){

            protected IStatus runProtected(IProgressMonitor monitor) {
                Channel[] channels = FeedManager.getDefault().getChannels();
                ArrayList<NewsItem> toChange = new ArrayList<NewsItem>();
                Channel[] channelArray = channels;
                int n = channels.length;
                int n2 = 0;
                while (n2 < n) {
                    NewsItem[] items;
                    Channel channel = channelArray[n2];
                    NewsItem[] newsItemArray = items = channel.getItems();
                    int n3 = items.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        NewsItem newsItem = newsItemArray[n4];
                        if (!markRead || !newsItem.isIsRead()) {
                            try {
                                String customAttribute = newsItem.getCustomAttribute("http://www.ibm.com/jazz/0.1.0/syndication", "itemId");
                                if (customAttribute != null) {
                                    UUID id = UUID.valueOf((String)customAttribute);
                                    if (workItem.getItemId().equals((Object)id)) {
                                        toChange.add(newsItem);
                                    }
                                }
                            }
                            catch (NullPointerException nullPointerException) {}
                        }
                        ++n4;
                    }
                    ++n2;
                }
                if (markRead) {
                    if (!toChange.isEmpty()) {
                        FeedManager.getDefault().setRead(toChange.toArray(new NewsItem[toChange.size()]), true);
                    }
                } else {
                    NewsItem mostRecent = null;
                    for (NewsItem newsItem : toChange) {
                        if (mostRecent != null && !mostRecent.getPublishDate().before(newsItem.getPublishDate())) continue;
                        mostRecent = newsItem;
                    }
                    if (mostRecent != null) {
                        FeedManager.getDefault().setRead(mostRecent, false);
                    }
                }
                return Status.OK_STATUS;
            }
        };
        syncJob.setSystem(true);
        syncJob.schedule();
    }

    public Object getAdapter(Object adaptableObject, Class adapterType) {
        if (IReadStateTracker.class.equals((Object)adapterType) && adaptableObject instanceof IWorkItem) {
            return new WorkItemReadStateTracker((IWorkItem)adaptableObject);
        }
        return null;
    }

    public Class[] getAdapterList() {
        return this.fAdapterList;
    }

    private class WorkItemReadStateTracker
    implements IReadStateTracker {
        private IWorkItem fWorkItem;

        public WorkItemReadStateTracker(IWorkItem workItem) {
            this.fWorkItem = workItem;
        }

        public void markRead() {
            if (this.fWorkItem.getId() < 0) {
                return;
            }
            IReadStateManager.DEFAULT.markRead((IItem)this.fWorkItem);
            ReadStateTrackerFactory.this.synchronizeChangeEvents(this.fWorkItem, true);
        }

        public void markUnread() {
            if (this.fWorkItem.getId() < 0) {
                return;
            }
            IReadStateManager.DEFAULT.markUnread((IItemHandle)this.fWorkItem);
            ReadStateTrackerFactory.this.synchronizeChangeEvents(this.fWorkItem, false);
        }

        public boolean isMarkedRead() {
            if (this.fWorkItem.getId() < 0) {
                return true;
            }
            return IReadStateManager.DEFAULT.isMarkedRead((IItem)this.fWorkItem);
        }
    }
}

