/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.rcp.ui.internal;

import com.ibm.team.process.common.IProjectAreaHandle;
import com.ibm.team.process.rcp.ui.teamnavigator.ConnectedProjectAreaRegistry;
import com.ibm.team.process.rcp.ui.teamnavigator.IConnectedProjectAreaRegistryChangeEvent;
import com.ibm.team.process.rcp.ui.teamnavigator.IConnectedProjectAreaRegistryListener;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.workitem.client.internal.ClientLinkDetectorHelper;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LinkDetectorConnectionManager
implements ClientLinkDetectorHelper.IConnectionStateManager {
    private ProjectAreaListener fListener = new ProjectAreaListener();

    public LinkDetectorConnectionManager() {
        ConnectedProjectAreaRegistry.getDefault().addListener((IConnectedProjectAreaRegistryListener)this.fListener);
        ClientLinkDetectorHelper.getInstance().setConnectionStateManager((ClientLinkDetectorHelper.IConnectionStateManager)this);
    }

    public List<? extends IProjectAreaHandle> getConnectedProjectAreas(ITeamRepository repository) {
        return ConnectedProjectAreaRegistry.getDefault().getConnectedProjectAreas(repository);
    }

    public List<? extends IProjectAreaHandle> getConnectedProjectAreas(ITeamRepository repository, IProgressMonitor monitor) {
        return this.getConnectedProjectAreas(repository);
    }

    public String getProjectAreaName(IProjectAreaHandle handle) {
        return ConnectedProjectAreaRegistry.getDefault().getProjectAreaName(handle);
    }

    public void dispose() {
        ConnectedProjectAreaRegistry.getDefault().removeListener((IConnectedProjectAreaRegistryListener)this.fListener);
    }

    private static class ProjectAreaListener
    implements IConnectedProjectAreaRegistryListener {
        private ProjectAreaListener() {
        }

        public void connectedProjectAreaRegistryChanged(IConnectedProjectAreaRegistryChangeEvent changeEvent) {
            if (changeEvent.getType() == 0 || changeEvent.getType() == 1 || changeEvent.getType() == 2) {
                ClientLinkDetectorHelper.getInstance().connectionEventOccurred(changeEvent.getTeamRepository());
            }
        }
    }
}

