/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.rcp.ui.internal;

import com.ibm.icu.text.Collator;
import com.ibm.team.foundation.client.util.FoundationJob;
import com.ibm.team.jface.DimmedIconDescriptor;
import com.ibm.team.jface.JazzResources;
import com.ibm.team.jface.internal.AdaptedElementTreeSelectionDialog;
import com.ibm.team.jface.labelProviders.TypeLabelProvider;
import com.ibm.team.process.common.IIteration;
import com.ibm.team.process.common.IIterationHandle;
import com.ibm.team.process.common.IProjectArea;
import com.ibm.team.process.common.IProjectAreaHandle;
import com.ibm.team.process.rcp.ui.teamnavigator.ConnectedProjectAreaRegistry;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IAuditableHandle;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.IItemType;
import com.ibm.team.repository.common.PermissionDeniedException;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.repository.common.util.NLS;
import com.ibm.team.workitem.client.IAuditableClient;
import com.ibm.team.workitem.client.IWorkItemClient;
import com.ibm.team.workitem.common.IAuditableCommon;
import com.ibm.team.workitem.common.internal.util.AuditablesHelper;
import com.ibm.team.workitem.common.internal.util.ItemHandleAwareHashSet;
import com.ibm.team.workitem.common.model.CategoryId;
import com.ibm.team.workitem.common.model.IAttribute;
import com.ibm.team.workitem.common.model.ICategory;
import com.ibm.team.workitem.common.model.ICategoryHandle;
import com.ibm.team.workitem.common.model.IWorkItem;
import com.ibm.team.workitem.common.model.ItemProfile;
import com.ibm.team.workitem.rcp.ui.internal.HelpContextIds;
import com.ibm.team.workitem.rcp.ui.internal.ImagePool;
import com.ibm.team.workitem.rcp.ui.internal.Messages;
import com.ibm.team.workitem.rcp.ui.internal.WorkItemRCPUIPlugin;
import com.ibm.team.workitem.rcp.ui.internal.wizards.CopyToProjectAreaWizard;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.jface.viewers.AbstractTreeViewer;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerLabel;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.FilteredTree;
import org.eclipse.ui.dialogs.ISelectionStatusValidator;
import org.eclipse.ui.dialogs.PatternFilter;

public class ItemSelectionDialog
extends AdaptedElementTreeSelectionDialog {
    private Job fFetchingJob;
    private boolean fIsEnabled = false;
    private PatternFilter fPatternFilter;
    private String fAttributeIdentifier;
    private Label fDesc;
    private ICategory fGuessedCategory;
    private Button fGuessButton;
    private boolean fGuessValue;
    private Label fProjectAreaLabel;
    private IWorkItem fContext;

    public static ICategory getCategory(Shell shell, IProjectAreaHandle projectArea, IWorkItem workItem, ICategory defaultValue, boolean guessCategory) throws OperationCanceledException {
        TypeLabelProvider labelProvider = new TypeLabelProvider(){

            public void updateLabel(ViewerLabel label, Object element) {
                if (element instanceof ICategory) {
                    label.setText(((ICategory)element).getName());
                    label.setImage(JazzResources.getImageWithDefault((ResourceManager)this.getResources(), (ImageDescriptor)ImagePool.CATEGORY));
                } else if (element instanceof String) {
                    label.setText((String)element);
                }
            }
        };
        ITreeContentProvider contentProvider = new ITreeContentProvider(){
            private List<ICategory> fValueSet = new ArrayList<ICategory>();
            HashMap<UUID, CategoryId> fParentIdCache = new HashMap();

            public Object[] getChildren(Object parentElement) {
                if (!(parentElement instanceof ICategory)) {
                    return new Object[0];
                }
                ArrayList<ICategory> children = new ArrayList<ICategory>();
                for (ICategory cat : this.fValueSet) {
                    CategoryId parentId = this.getParentCategoryId(cat);
                    if (parentId == null || !parentId.equals((Object)((ICategory)parentElement).getCategoryId())) continue;
                    children.add(cat);
                }
                return children.toArray();
            }

            private CategoryId getParentCategoryId(ICategory cat) {
                CategoryId parentId = this.fParentIdCache.get(cat.getItemId());
                if (parentId == null && !this.fParentIdCache.containsKey(cat.getItemId())) {
                    parentId = cat.getParentId();
                    this.fParentIdCache.put(cat.getItemId(), parentId);
                }
                return parentId;
            }

            public Object getParent(Object element) {
                if (!(element instanceof ICategory)) {
                    return null;
                }
                for (ICategory cat : this.fValueSet) {
                    CategoryId parentId = this.getParentCategoryId((ICategory)element);
                    if (parentId == null || !parentId.equals((Object)cat.getCategoryId())) continue;
                    return cat;
                }
                return null;
            }

            public boolean hasChildren(Object element) {
                return this.getChildren(element) != null && this.getChildren(element).length != 0;
            }

            public Object[] getElements(Object inputElement) {
                if (inputElement instanceof String) {
                    return new Object[]{inputElement};
                }
                if (inputElement instanceof Object[]) {
                    ArrayList<ICategory> elements = new ArrayList<ICategory>();
                    for (ICategory cat : this.fValueSet) {
                        if (cat.getDepth() != 0) continue;
                        elements.add(cat);
                    }
                    return elements.toArray();
                }
                return this.getChildren(inputElement);
            }

            public void dispose() {
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
                if (newInput instanceof Object[]) {
                    ArrayList<ICategory> elements = new ArrayList<ICategory>();
                    Object[] objectArray = (Object[])newInput;
                    int n = objectArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Object o = objectArray[n2];
                        if (o instanceof ICategory) {
                            elements.add((ICategory)o);
                        }
                        ++n2;
                    }
                    this.fValueSet = elements;
                } else {
                    this.fValueSet = new ArrayList<ICategory>();
                }
            }
        };
        Comparator<Object> comparator = new Comparator<Object>(){
            UUID fUnassigned;

            @Override
            public int compare(Object o1, Object o2) {
                if (o1 instanceof String && o2 instanceof String) {
                    return Collator.getInstance().compare((String)o1, (String)o2);
                }
                if (!(o1 instanceof ICategory)) {
                    return 1;
                }
                if (!(o2 instanceof ICategory)) {
                    return -1;
                }
                ICategory category1 = (ICategory)o1;
                ICategory category2 = (ICategory)o2;
                if (this.isTheUnassignedCategory(category1)) {
                    return -1;
                }
                if (this.isTheUnassignedCategory(category2)) {
                    return 1;
                }
                return Collator.getInstance().compare(category1.getName(), category2.getName());
            }

            private boolean isTheUnassignedCategory(ICategory cat) {
                if (this.fUnassigned == null && cat.isUnassigned()) {
                    this.fUnassigned = cat.getItemId();
                    return true;
                }
                return cat.getItemId().equals((Object)this.fUnassigned);
            }
        };
        Object result = ItemSelectionDialog.showDialog(shell, IWorkItem.CATEGORY_PROPERTY, projectArea, workItem, (LabelProvider)labelProvider, contentProvider, defaultValue, comparator, guessCategory);
        if (result instanceof ICategory) {
            return (ICategory)result;
        }
        return null;
    }

    public static IIteration getIteration(Shell shell, IProjectAreaHandle projectArea, IWorkItem workItem, IIteration defaultValue) throws OperationCanceledException {
        Object result;
        LocalResourceManager resourceManager = new LocalResourceManager(JFaceResources.getResources());
        final Object nullElement = new Object();
        LabelProvider labelProvider = new LabelProvider((ResourceManager)resourceManager, defaultValue){
            private final /* synthetic */ ResourceManager val$resourceManager;
            private final /* synthetic */ IIteration val$defaultValue;
            {
                this.val$resourceManager = resourceManager;
                this.val$defaultValue = iIteration;
            }

            public String getText(Object element) {
                if (element == null || element == nullElement) {
                    return IWorkItem.UNASSIGNED_TARGET_NAME;
                }
                if (element instanceof String) {
                    return (String)element;
                }
                if (element instanceof IIteration) {
                    IIteration interval = (IIteration)element;
                    String name = interval.getLabel();
                    return name;
                }
                return IWorkItem.UNASSIGNED_TARGET_NAME;
            }

            public Image getImage(Object element) {
                ImageDescriptor desc = this.getImageDescriptor(element);
                if (desc == null) {
                    return null;
                }
                if (element instanceof IIteration && !((IIteration)element).hasDeliverable()) {
                    desc = new DimmedIconDescriptor(desc);
                }
                return JazzResources.getImageWithDefault((ResourceManager)this.val$resourceManager, (ImageDescriptor)desc);
            }

            private ImageDescriptor getImageDescriptor(Object element) {
                if (element instanceof IIteration) {
                    IIteration interval = (IIteration)element;
                    if (this.val$defaultValue != null && interval.sameItemId((IItemHandle)this.val$defaultValue)) {
                        return com.ibm.team.process.internal.ide.ui.ImagePool.PROCESS_CURRENT_ITERATION;
                    }
                    if (interval.getParent() == null) {
                        return com.ibm.team.process.internal.ide.ui.ImagePool.PROCESS_PROJECT_PHASE;
                    }
                    return com.ibm.team.process.internal.ide.ui.ImagePool.PROCESS_ITERATION;
                }
                if (element == null || element == nullElement) {
                    return com.ibm.team.process.internal.ide.ui.ImagePool.PROCESS_ITERATION;
                }
                return null;
            }
        };
        final TargetContentProvider contentProvider = new TargetContentProvider(nullElement);
        Comparator<Object> comparator = new Comparator<Object>(){

            @Override
            public int compare(Object o1, Object o2) {
                if (o1 instanceof String && o2 instanceof String) {
                    return Collator.getInstance().compare((String)o1, (String)o2);
                }
                if (o1 == null || o1 == nullElement) {
                    return -1;
                }
                if (o2 == null || o2 == nullElement) {
                    return 1;
                }
                if (!(o1 instanceof IIteration)) {
                    return 1;
                }
                if (!(o2 instanceof IIteration)) {
                    return -1;
                }
                if (contentProvider.fValueSet.isEmpty()) {
                    return -1;
                }
                return contentProvider.fValueSet.indexOf(o1) - contentProvider.fValueSet.indexOf(o2);
            }
        };
        try {
            result = ItemSelectionDialog.showDialog(shell, IWorkItem.TARGET_PROPERTY, projectArea, workItem, labelProvider, contentProvider, defaultValue, comparator, false);
        }
        finally {
            resourceManager.dispose();
        }
        if (result instanceof IIteration) {
            return (IIteration)result;
        }
        return null;
    }

    public static Object showDialog(final Shell shell, final String attributeIdentifier, final IProjectAreaHandle projectArea, final IWorkItem workItem, LabelProvider labelProvider, ITreeContentProvider contentProvider, final Object defaultValue, final Comparator comparator, final boolean guessValue) throws OperationCanceledException {
        PatternFilter filter = attributeIdentifier.equals(IWorkItem.CATEGORY_PROPERTY) ? new PatternFilter(){
            private final HashSet<CategoryId> fCache = new HashSet();

            protected boolean isParentMatch(Viewer viewer, Object element) {
                boolean isMatch = this.isLeafMatch(viewer, element);
                return isMatch || super.isParentMatch(viewer, element);
            }

            protected boolean isLeafMatch(Viewer viewer, Object element) {
                if (!(element instanceof ICategory)) {
                    return true;
                }
                ICategory category = (ICategory)element;
                CategoryId parentCategoryId = category.getParentId();
                if (this.fCache.contains(parentCategoryId)) {
                    this.fCache.add(category.getCategoryId());
                    return true;
                }
                boolean matches = super.isLeafMatch(viewer, element);
                if (matches) {
                    this.fCache.add(category.getCategoryId());
                }
                return matches;
            }

            public void setPattern(String patternString) {
                super.setPattern(patternString);
                this.fCache.clear();
            }
        } : (attributeIdentifier.equals(IWorkItem.TARGET_PROPERTY) ? new PatternFilter(){

            protected boolean isParentMatch(Viewer viewer, Object element) {
                if (this.anyParentMatches(viewer, ((ITreeContentProvider)((AbstractTreeViewer)viewer).getContentProvider()).getParent(element))) {
                    return true;
                }
                return super.isParentMatch(viewer, element);
            }

            private boolean anyParentMatches(Viewer viewer, Object parent) {
                if (parent == null) {
                    return false;
                }
                String labelText = ((ILabelProvider)((StructuredViewer)viewer).getLabelProvider()).getText(parent);
                if (this.wordMatches(labelText)) {
                    return true;
                }
                return this.anyParentMatches(viewer, ((ITreeContentProvider)((AbstractTreeViewer)viewer).getContentProvider()).getParent(parent));
            }
        } : new PatternFilter());
        final ItemSelectionDialog dialog = new ItemSelectionDialog(shell, (ILabelProvider)labelProvider, contentProvider, attributeIdentifier, filter, guessValue);
        dialog.fContext = workItem;
        FoundationJob fetchingJob = new FoundationJob(NLS.bind((String)Messages.ItemSelectionDialog_FETCHING_VALUES, (Object)attributeIdentifier, (Object[])new Object[0])){

            protected IStatus runProtected(IProgressMonitor monitor) {
                try {
                    ICategory guessedCategory;
                    ITeamRepository teamRepository = (ITeamRepository)projectArea.getOrigin();
                    IAuditableClient auditableClient = (IAuditableClient)teamRepository.getClientLibrary(IAuditableClient.class);
                    IWorkItemClient workItemClient = (IWorkItemClient)teamRepository.getClientLibrary(IWorkItemClient.class);
                    IAttribute attribute = workItemClient.findAttribute(projectArea, attributeIdentifier, monitor);
                    final Object[] values = ItemSelectionDialog.computeValueSet(attribute, auditableClient, workItem, monitor);
                    final Object iSelection = defaultValue;
                    if (guessValue && workItem != null) {
                        ICategoryHandle categoryHandle = null;
                        try {
                            categoryHandle = workItemClient.guessCategory(workItem, monitor);
                        }
                        catch (RuntimeException e) {
                            WorkItemRCPUIPlugin.getDefault().log(e.getMessage(), e);
                        }
                        guessedCategory = categoryHandle != null ? (ICategory)auditableClient.resolveAuditable((IAuditableHandle)categoryHandle, ICategory.DEFAULT_PROFILE, monitor) : null;
                    } else {
                        guessedCategory = null;
                    }
                    String pAName = null;
                    if (workItem != null) {
                        IProjectArea area = (IProjectArea)auditableClient.resolveAuditable((IAuditableHandle)workItem.getProjectArea(), ItemProfile.createProfile((IItemType)IProjectArea.ITEM_TYPE, (Collection)AuditablesHelper.getProcessPropertiesFromIds(IProjectArea.class, (String[])new String[]{"name"})), monitor);
                        pAName = area.getName();
                    }
                    final String projectAreaName = pAName;
                    if (shell.isDisposed()) {
                        return Status.CANCEL_STATUS;
                    }
                    shell.getDisplay().asyncExec(new Runnable(){

                        public void run() {
                            if (dialog.getShell() == null || dialog.getShell().isDisposed()) {
                                return;
                            }
                            if (guessValue) {
                                dialog.setGuessedCategory(guessedCategory);
                            }
                            if (projectAreaName != null) {
                                dialog.setProjectAreaLabel(projectAreaName);
                            }
                            dialog.setInput(values);
                            dialog.setEnabled();
                            dialog.expand(1);
                            if (iSelection != null) {
                                dialog.setSelection(iSelection);
                            }
                        }
                    });
                }
                catch (PermissionDeniedException x) {
                    if (shell.isDisposed()) {
                        return Status.CANCEL_STATUS;
                    }
                    shell.getDisplay().asyncExec(new Runnable(){

                        public void run() {
                            if (dialog.getShell() == null || dialog.getShell().isDisposed()) {
                                return;
                            }
                            dialog.setInput(NLS.bind((String)Messages.ItemSelectionDialog_NO_PERMISSION_TO_FETCH, (Object)attributeIdentifier, (Object[])new Object[0]));
                        }
                    });
                    return new Status(8, "com.ibm.team.workitem.rcp.ui", 0, NLS.bind((String)Messages.ItemSelectionDialog_NO_PERMISSION_TO_FETCH, (Object)attributeIdentifier, (Object[])new Object[0]), (Throwable)x);
                }
                catch (TeamRepositoryException x) {
                    WorkItemRCPUIPlugin.getDefault().log(NLS.bind((String)Messages.ItemSelectionDialog_ERROR_FETCHING_VALUES, (Object)attributeIdentifier, (Object[])new Object[0]), x);
                    if (shell.isDisposed()) {
                        return Status.CANCEL_STATUS;
                    }
                    shell.getDisplay().asyncExec(new Runnable(){

                        public void run() {
                            if (dialog.getShell() == null || dialog.getShell().isDisposed()) {
                                return;
                            }
                            dialog.setInput(NLS.bind((String)Messages.ItemSelectionDialog_ERROR_FETCHING_VALUES, (Object)attributeIdentifier, (Object[])new Object[0]));
                        }
                    });
                    return new Status(8, "com.ibm.team.workitem.rcp.ui", 0, NLS.bind((String)Messages.ItemSelectionDialog_ERROR_FETCHING_VALUES, (Object)attributeIdentifier, (Object[])new Object[0]), (Throwable)x);
                }
                return Status.OK_STATUS;
            }
        };
        dialog.setFetchingJob((Job)fetchingJob);
        if (attributeIdentifier.equals(IWorkItem.CATEGORY_PROPERTY)) {
            dialog.setTitle(Messages.ItemSelectionDialog_SELECT_CATEGORY);
            dialog.setMessage(Messages.ItemSelectionDialog_SELECT_CATEGORY_FILTER);
        } else if (attributeIdentifier.equals(IWorkItem.TARGET_PROPERTY)) {
            dialog.setTitle(Messages.ItemSelectionDialog_SELECT_ITERATION);
            dialog.setMessage(Messages.ItemSelectionDialog_SELECT_ITERATION_FILTER);
        } else {
            dialog.setTitle(Messages.ItemSelectionDialog_SELECT_VALUE);
            dialog.setMessage(Messages.ItemSelectionDialog_SELECT_VALUE_FILTER);
        }
        dialog.setInput(Messages.ItemSelectionDialog_LOADING);
        dialog.setAllowMultiple(false);
        dialog.setSorter(comparator != null ? new ViewerSorter(){

            public int compare(Viewer viewer, Object o1, Object o2) {
                return comparator.compare(o1, o2);
            }
        } : new ViewerSorter());
        fetchingJob.schedule();
        dialog.setBlockOnOpen(true);
        if (dialog.open() != 0) {
            fetchingJob.cancel();
            throw new OperationCanceledException();
        }
        fetchingJob.cancel();
        Object result = dialog.getFirstResult();
        return result;
    }

    private static Object[] computeValueSet(IAttribute attribute, IAuditableClient auditableClient, IWorkItem workItem, IProgressMonitor monitor) throws TeamRepositoryException {
        if (attribute.getIdentifier().equals(IWorkItem.TARGET_PROPERTY)) {
            ArrayList<Object> values = new ArrayList<Object>(Arrays.asList(attribute.getValueSet((IAuditableCommon)auditableClient, workItem, monitor)));
            HashMap<String, IIteration> cache = new HashMap<String, IIteration>();
            ItemHandleAwareHashSet theResolved = new ItemHandleAwareHashSet();
            for (Object e : values) {
                if (!(e instanceof IIteration)) continue;
                cache.put(((IIteration)e).getItemId().getUuidValue(), (IIteration)e);
                theResolved.add((Object)((IIteration)e));
            }
            ItemHandleAwareHashSet itemHandleAwareHashSet = new ItemHandleAwareHashSet();
            while (!theResolved.isEmpty()) {
                ItemHandleAwareHashSet itemHandleAwareHashSet2 = new ItemHandleAwareHashSet();
                for (IIteration i : theResolved) {
                    IIterationHandle parent = i.getParent();
                    if (parent == null || cache.get(parent.getItemId().getUuidValue()) != null) continue;
                    itemHandleAwareHashSet2.add((Object)parent);
                }
                theResolved = new ItemHandleAwareHashSet();
                if (itemHandleAwareHashSet2.isEmpty()) continue;
                List resolved = auditableClient.resolveAuditablesPermissionAware(itemHandleAwareHashSet2.toList(), ItemProfile.ITERATION_DEFAULT, monitor);
                for (IIteration r : resolved) {
                    if (r == null) continue;
                    values.add(r);
                    theResolved.add((Object)r);
                    cache.put(r.getItemId().getUuidValue(), r);
                }
            }
            return values.toArray();
        }
        return attribute.getValueSet((IAuditableCommon)auditableClient, workItem, monitor);
    }

    public ItemSelectionDialog(Shell parent, ILabelProvider labelProvider, ITreeContentProvider contentProvider, final String attributeIdentifier, PatternFilter patternFilter, boolean guessValue) {
        super(parent, labelProvider, contentProvider);
        this.fPatternFilter = patternFilter;
        this.fAttributeIdentifier = attributeIdentifier;
        this.fGuessValue = guessValue;
        this.setValidator(new ISelectionStatusValidator(){

            public IStatus validate(Object[] selection) {
                if (!ItemSelectionDialog.this.fIsEnabled) {
                    return new Status(4, "com.ibm.team.workitem.rcp.ui", 4, "", null);
                }
                if (selection.length == 0) {
                    String message = attributeIdentifier.equals(IWorkItem.CATEGORY_PROPERTY) ? Messages.ItemSelectionDialog_MUST_SELECT_CATEGORY : (attributeIdentifier.equals(IWorkItem.TARGET_PROPERTY) ? Messages.ItemSelectionDialog_MUST_SELECT_ITERATION : Messages.ItemSelectionDialog_MUST_SELECT_VALUE);
                    return new Status(4, "com.ibm.team.workitem.rcp.ui", 4, message, null);
                }
                if (attributeIdentifier.equals(IWorkItem.TARGET_PROPERTY)) {
                    boolean anyValid = false;
                    Object[] objectArray = selection;
                    int n = selection.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Object o = objectArray[n2];
                        if (o instanceof IIteration && ((IIteration)o).hasDeliverable()) {
                            anyValid = true;
                            break;
                        }
                        if (!(o instanceof IIteration)) {
                            anyValid = true;
                            break;
                        }
                        ++n2;
                    }
                    if (!anyValid) {
                        String message = Messages.ItemSelectionDialog_NO_RELEASE_FOR_ITERATION;
                        return new Status(4, "com.ibm.team.workitem.rcp.ui", 4, message, null);
                    }
                }
                return new Status(0, "com.ibm.team.workitem.rcp.ui", 0, "", null);
            }
        });
    }

    public void setProjectAreaLabel(String projectAreaName) {
        if (this.fProjectAreaLabel != null && !this.fProjectAreaLabel.isDisposed()) {
            this.fProjectAreaLabel.setText(projectAreaName);
            this.fProjectAreaLabel.getParent().layout(new Control[]{this.fProjectAreaLabel});
        }
    }

    public void setFetchingJob(Job fetchingJob) {
        this.fFetchingJob = fetchingJob;
    }

    protected Label createMessageArea(Composite composite) {
        if (this.fContext != null && IWorkItem.CATEGORY_PROPERTY.equals(this.fAttributeIdentifier) && ConnectedProjectAreaRegistry.getDefault().getConnectedProjectAreas((ITeamRepository)this.fContext.getOrigin()).size() > 1) {
            Composite area = new Composite(composite, 0);
            GridLayout layout = new GridLayout(3, false);
            layout.marginWidth = 0;
            layout.marginHeight = 0;
            area.setLayout((Layout)layout);
            area.setLayoutData((Object)new GridData(4, 4, true, false));
            Label l = new Label(area, 0);
            l.setText(Messages.ItemSelectionDialog_PROJECT_AREA);
            l.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
            this.fProjectAreaLabel = new Label(area, 0);
            this.fProjectAreaLabel.setLayoutData((Object)new GridData(16384, 0x1000000, true, false));
            Button movePA = new Button(area, 0x800000);
            movePA.setLayoutData((Object)new GridData(131072, 0x1000000, false, false));
            movePA.setToolTipText(Messages.ItemSelectionDialog_MOVE_TO_PA);
            LocalResourceManager resourceManager = new LocalResourceManager(JFaceResources.getResources(), (Control)composite);
            Image image = JazzResources.getImageWithDefault((ResourceManager)resourceManager, (ImageDescriptor)ImagePool.MOVE_COPY);
            movePA.setImage(image);
            movePA.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    ItemSelectionDialog.this.setReturnCode(1);
                    ItemSelectionDialog.this.close();
                    CopyToProjectAreaWizard.CopyToProjectAreaAction action = new CopyToProjectAreaWizard.CopyToProjectAreaAction();
                    action.setCopyAllowed(false);
                    action.selectionChanged(null, (ISelection)new StructuredSelection((Object)ItemSelectionDialog.this.fContext));
                    action.run(null);
                }
            });
        }
        return super.createMessageArea(composite);
    }

    protected FilteredTree createFilteredTree(Composite parent) {
        FilteredTree filteredTree = new FilteredTree(parent, 2052, this.fPatternFilter){

            protected Text doCreateFilterText(Composite parent) {
                Text text = super.doCreateFilterText(parent);
                text.setFocus();
                return text;
            }

            protected Composite createFilterControls(Composite parent) {
                Composite composite = super.createFilterControls(parent);
                if (ItemSelectionDialog.this.fGuessValue) {
                    ((GridLayout)composite.getLayout()).numColumns = 3;
                    ItemSelectionDialog.this.fGuessButton = new Button(composite, 0x800000);
                    ItemSelectionDialog.this.fGuessButton.setLayoutData((Object)new GridData(131072, 0x1000000, false, false));
                    ItemSelectionDialog.this.fGuessButton.setToolTipText(Messages.ItemSelectionDialog_GUESS_CATEGORY);
                    LocalResourceManager resourceManager = new LocalResourceManager(JFaceResources.getResources(), (Control)composite);
                    Image image = JazzResources.getImageWithDefault((ResourceManager)resourceManager, (ImageDescriptor)ImagePool.GUESS_CATEGORY);
                    ItemSelectionDialog.this.fGuessButton.setImage(image);
                    ItemSelectionDialog.this.fGuessButton.setEnabled(false);
                    ItemSelectionDialog.this.fGuessButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                        public void widgetSelected(SelectionEvent e) {
                            if (ItemSelectionDialog.this.fGuessedCategory != null) {
                                ItemSelectionDialog.this.getTreeViewer().setSelection((ISelection)new StructuredSelection((Object)ItemSelectionDialog.this.fGuessedCategory), true);
                            }
                        }
                    });
                    ((GridData)this.getFilterControl().getLayoutData()).verticalAlignment = 0x1000000;
                }
                return composite;
            }
        };
        return filteredTree;
    }

    public boolean close() {
        if (this.fFetchingJob != null) {
            this.fFetchingJob.cancel();
        }
        return super.close();
    }

    public void setGuessedCategory(ICategory guessed) {
        this.fGuessedCategory = guessed;
        if (this.fGuessButton != null) {
            this.fGuessButton.setEnabled(guessed != null);
        }
    }

    public void setInput(Object input) {
        super.setInput(input);
        if (this.getTreeViewer() != null && !this.getTreeViewer().getTree().isDisposed()) {
            this.getTreeViewer().setInput(input);
        }
    }

    public void setSelection(Object selection) {
        this.getTreeViewer().setSelection((ISelection)new StructuredSelection(selection), true);
    }

    protected Control createDialogArea(Composite parent) {
        Composite c = (Composite)super.createDialogArea(parent);
        this.getTreeViewer().getTree().setEnabled(false);
        if (IWorkItem.CATEGORY_PROPERTY.equals(this.fAttributeIdentifier)) {
            Composite description = new Composite(c, 0);
            GridLayout layout = new GridLayout();
            layout.marginWidth = 0;
            description.setLayout((Layout)layout);
            description.setLayoutData((Object)new GridData(4, 4, true, false));
            Label l = new Label(description, 0);
            l.setText(Messages.ItemSelectionDialog_CATEGORY_DESCRIPTION);
            GridData data = new GridData(4, 4, false, false);
            data.horizontalIndent = 2;
            l.setLayoutData((Object)data);
            ScrolledComposite sc = new ScrolledComposite(description, 2560);
            sc.setLayout((Layout)new GridLayout());
            data = new GridData(4, 4, true, false);
            GC gc = new GC((Drawable)parent);
            data.heightHint = Dialog.convertHeightInCharsToPixels((FontMetrics)gc.getFontMetrics(), (int)3);
            gc.dispose();
            sc.setLayoutData((Object)data);
            this.fDesc = new Label((Composite)sc, 64);
            sc.setContent((Control)this.fDesc);
            data = new GridData(4, 4, true, false);
            this.fDesc.setLayoutData((Object)data);
            this.getTreeViewer().addSelectionChangedListener(new ISelectionChangedListener(){

                public void selectionChanged(SelectionChangedEvent event) {
                    if (!ItemSelectionDialog.this.getTreeViewer().getSelection().isEmpty()) {
                        if (((IStructuredSelection)ItemSelectionDialog.this.getTreeViewer().getSelection()).getFirstElement() instanceof ICategory) {
                            ItemSelectionDialog.this.fDesc.setText(((ICategory)((IStructuredSelection)ItemSelectionDialog.this.getTreeViewer().getSelection()).getFirstElement()).getHTMLDescription().getPlainText());
                            ItemSelectionDialog.this.fDesc.setSize(ItemSelectionDialog.this.fDesc.computeSize(((ItemSelectionDialog)ItemSelectionDialog.this).fDesc.getParent().getBounds().width - 20, -1));
                            ItemSelectionDialog.this.fDesc.getParent().layout();
                        } else {
                            ItemSelectionDialog.this.fDesc.setText("");
                            ItemSelectionDialog.this.fDesc.setSize(ItemSelectionDialog.this.fDesc.computeSize(-1, -1));
                            ItemSelectionDialog.this.fDesc.getParent().layout();
                        }
                    }
                }
            });
            this.fDesc.setSize(this.fDesc.computeSize(-1, -1));
        }
        if (IWorkItem.CATEGORY_PROPERTY.equals(this.fAttributeIdentifier)) {
            HelpContextIds.hookHelpListener((Control)parent, "com.ibm.team.workitem.rcp.ui.category_selection_dialog");
        } else if (IWorkItem.TARGET_PROPERTY.equals(this.fAttributeIdentifier)) {
            HelpContextIds.hookHelpListener((Control)parent, "com.ibm.team.workitem.rcp.ui.iteration_selection_dialog");
        }
        return c;
    }

    public void setEnabled() {
        this.fIsEnabled = true;
        if (this.getTreeViewer() != null && !this.getTreeViewer().getControl().isDisposed()) {
            this.getTreeViewer().getTree().setEnabled(true);
        }
    }

    public void expand(int level) {
        if (this.getTreeViewer() != null && !this.getTreeViewer().getControl().isDisposed()) {
            this.getTreeViewer().expandToLevel(level);
        }
    }

    private static class TargetContentProvider
    implements ITreeContentProvider {
        List fValueSet = new ArrayList();
        private Object fNullElement;

        TargetContentProvider(Object nullElement) {
            this.fNullElement = nullElement;
        }

        public Object[] getChildren(Object parentElement) {
            if (!(parentElement instanceof IIteration)) {
                return new Object[0];
            }
            ArrayList<IIteration> children = new ArrayList<IIteration>();
            for (Object interval : this.fValueSet) {
                if (!(interval instanceof IIteration) || !((IIteration)parentElement).sameItemId((IItemHandle)((IIteration)interval).getParent())) continue;
                children.add((IIteration)interval);
            }
            return children.toArray();
        }

        public Object getParent(Object element) {
            if (!(element instanceof IIteration)) {
                return null;
            }
            for (Object interval : this.fValueSet) {
                if (!(interval instanceof IIteration) || !((IIteration)interval).sameItemId((IItemHandle)((IIteration)element).getParent())) continue;
                return interval;
            }
            return null;
        }

        public boolean hasChildren(Object element) {
            return this.getChildren(element) != null && this.getChildren(element).length != 0;
        }

        public Object[] getElements(Object inputElement) {
            if (inputElement instanceof String) {
                return new Object[]{inputElement};
            }
            if (inputElement instanceof Object[]) {
                ArrayList<Object> elements = new ArrayList<Object>();
                for (Object o : this.fValueSet) {
                    if (o instanceof IIteration && ((IIteration)o).getParent() == null) {
                        elements.add(o);
                        continue;
                    }
                    if (o != this.fNullElement) continue;
                    elements.add(this.fNullElement);
                }
                return elements.toArray();
            }
            return this.getChildren(inputElement);
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            if (newInput instanceof Object[]) {
                ArrayList<Object> elements = new ArrayList<Object>();
                Object[] objectArray = (Object[])newInput;
                int n = objectArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Object o = objectArray[n2];
                    if (o instanceof IIteration) {
                        elements.add(o);
                    } else if (o == null) {
                        elements.add(this.fNullElement);
                    }
                    ++n2;
                }
                this.fValueSet = elements;
            } else {
                this.fValueSet = new ArrayList();
            }
        }
    }
}

