/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.rcp.ui.internal;

import com.ibm.team.jface.JazzResources;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IAuditableHandle;
import com.ibm.team.repository.common.IContent;
import com.ibm.team.repository.common.IContributor;
import com.ibm.team.repository.common.IContributorDetails;
import com.ibm.team.repository.common.IContributorDetailsHandle;
import com.ibm.team.repository.common.IContributorHandle;
import com.ibm.team.repository.common.IItemType;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.workitem.client.IAuditableClient;
import com.ibm.team.workitem.common.model.ItemProfile;
import com.ibm.team.workitem.rcp.ui.internal.ImagePool;
import com.ibm.team.workitem.rcp.ui.internal.WorkItemRCPUIPlugin;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.ImageLoader;
import org.eclipse.swt.graphics.Point;

public class ContributorPhoto {
    private static final Point PHOTO_SIZE = new Point(48, 48);
    private static final int DEFAULT_SWT_FORMAT = 4;

    public static ImageDescriptor getPhoto(IContributorHandle user) {
        try {
            return ContributorPhoto.internalGetPhoto(user, false, null);
        }
        catch (TeamRepositoryException teamRepositoryException) {
            return ImagePool.TEAM_UNKNOWN;
        }
    }

    public static ImageDescriptor getPhoto(IContributorHandle user, IProgressMonitor pm) throws TeamRepositoryException {
        return ContributorPhoto.internalGetPhoto(user, true, pm);
    }

    private static ImageDescriptor internalGetPhoto(IContributorHandle user, boolean longOp, IProgressMonitor pm) throws TeamRepositoryException {
        ImageData imageData;
        String key = user.getItemId().getUuidValue();
        ImageRegistry imageRegistry = WorkItemRCPUIPlugin.getDefault().getImageRegistry();
        ImageDescriptor imgDesc = imageRegistry.getDescriptor(key);
        if (imgDesc != null) {
            return imgDesc;
        }
        if (imgDesc == null) {
            imgDesc = JazzResources.getImageDescriptorFromFileCache((String)"com.ibm.team.workitem.rcp.ui", (String)ContributorPhoto.getLocalFileCacheKey(user));
        }
        if (imgDesc == null && longOp && (pm == null || !pm.isCanceled()) && (imageData = ContributorPhoto.fetchPhoto(user, pm)) != null) {
            ImageData scaledImageData = imageData.scaledTo(ContributorPhoto.PHOTO_SIZE.x, ContributorPhoto.PHOTO_SIZE.y);
            imgDesc = ContributorPhoto.store(user, scaledImageData);
        }
        if (imgDesc == null) {
            imgDesc = ImagePool.TEAM_UNKNOWN;
        }
        imageRegistry.put(key, imgDesc);
        return imgDesc;
    }

    private static ImageData fetchPhoto(IContributorHandle handle, IProgressMonitor pm) throws TeamRepositoryException {
        ImageData imageData;
        ITeamRepository teamRepository = (ITeamRepository)handle.getOrigin();
        IAuditableClient auditableClient = (IAuditableClient)teamRepository.getClientLibrary(IAuditableClient.class);
        IContributor contributor = (IContributor)auditableClient.resolveAuditable((IAuditableHandle)handle, ItemProfile.CONTRIBUTOR_DEFAULT, pm);
        IContributorDetailsHandle detailsHandle = contributor.getDetails();
        if (detailsHandle == null) {
            return null;
        }
        IContributorDetails details = (IContributorDetails)auditableClient.resolveAuditable((IAuditableHandle)detailsHandle, ItemProfile.createFullProfile((IItemType)IContributorDetails.ITEM_TYPE), pm);
        IContent photoContent = details.getPhoto();
        if (photoContent == null) {
            return null;
        }
        InputStream retrieveContentStream = teamRepository.contentManager().retrieveContentStream(photoContent, pm);
        try {
            imageData = new ImageData(retrieveContentStream);
        }
        catch (Throwable throwable) {
            try {
                retrieveContentStream.close();
            }
            catch (IOException iOException) {}
            throw throwable;
        }
        try {
            retrieveContentStream.close();
        }
        catch (IOException iOException) {}
        return imageData;
    }

    private static ImageDescriptor store(IContributorHandle user, ImageData imageData) throws TeamRepositoryException {
        IPath filePath;
        ImageLoader loader;
        block3: {
            try {
                loader = new ImageLoader();
                loader.data = new ImageData[]{imageData};
                filePath = JazzResources.getFilePathFromConfigArea((String)"com.ibm.team.workitem.rcp.ui", (String)ContributorPhoto.getLocalFileCacheKey(user));
                if (filePath != null) break block3;
                return null;
            }
            catch (MalformedURLException e) {
                throw new TeamRepositoryException((Throwable)e);
            }
        }
        String path = filePath.toOSString();
        loader.save(path, 4);
        URL filePathAsUrl = new File(path).toURL();
        ImageDescriptor localImageDescriptor = ImageDescriptor.createFromURL((URL)filePathAsUrl);
        JazzResources.registerUrl((ImageDescriptor)localImageDescriptor, (URL)filePathAsUrl);
        return localImageDescriptor;
    }

    private static String getLocalFileCacheKey(IContributorHandle user) {
        return "photo_" + user.getItemId().getUuidValue() + "." + ContributorPhoto.getExtension(4);
    }

    private static String getExtension(int swtFormat) {
        switch (swtFormat) {
            case 5: {
                return "png";
            }
        }
        return "jpg";
    }
}

