/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.rcp.ui.internal;

import com.ibm.team.process.common.IProjectAreaHandle;
import com.ibm.team.process.rcp.ui.teamnavigator.ConnectedProjectAreaRegistry;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.workitem.rcp.ui.internal.IDefaultProjectAreaListener;
import com.ibm.team.workitem.rcp.ui.internal.Messages;
import com.ibm.team.workitem.rcp.ui.internal.WorkItemRCPUIPlugin;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.WorkbenchException;
import org.eclipse.ui.XMLMemento;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConnectedProjectAreas {
    public static final String DEFAULT_CATEGORY = "default";
    private static final String DEFAULT_CONNECTED_PROJECT_AREA = "defaultConnectedProjectArea";
    private static final String DEFAULT_CONNECTED_PROJECT_AREA_MEMENTO = "ConnectedProjectAreaMemento";
    private static final String KEY_ITEM_ID = "itemId";
    private static Map<String, ConnectedProjectAreas> fgConnectedProjectAreas = new HashMap<String, ConnectedProjectAreas>();
    private IProjectAreaHandle fDefaultProjectArea;
    private final ListenerList fListeners = new ListenerList(1);
    private final String fCategory;

    public static ConnectedProjectAreas getInstance() {
        return ConnectedProjectAreas.getInstance(DEFAULT_CATEGORY);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ConnectedProjectAreas getInstance(String category) {
        if (!fgConnectedProjectAreas.containsKey(category)) {
            Map<String, ConnectedProjectAreas> map = fgConnectedProjectAreas;
            synchronized (map) {
                if (!fgConnectedProjectAreas.containsKey(category)) {
                    ConnectedProjectAreas connectedProjectAreas = new ConnectedProjectAreas(category);
                    connectedProjectAreas.restoreState();
                    fgConnectedProjectAreas.put(category, connectedProjectAreas);
                }
            }
        }
        return fgConnectedProjectAreas.get(category);
    }

    public static void saveState() {
        for (ConnectedProjectAreas connectedProjectAreas : fgConnectedProjectAreas.values()) {
            connectedProjectAreas.defaultSaveState();
        }
    }

    private ConnectedProjectAreas(String category) {
        this.fCategory = category;
    }

    public IProjectAreaHandle getDefaultProjectArea(boolean includeLoggedOut) {
        return this.validate(this.fDefaultProjectArea, includeLoggedOut);
    }

    public IProjectAreaHandle getDefaultProjectArea() {
        return this.getDefaultProjectArea(false);
    }

    public IProjectAreaHandle getDefaultProjectAreaFallback(ITeamRepository repository, boolean includeLoggedOut) {
        IProjectAreaHandle validated = null;
        if (repository == null || this.fDefaultProjectArea != null && this.fDefaultProjectArea.getOrigin() == repository) {
            validated = this.validate(this.fDefaultProjectArea, includeLoggedOut);
        }
        if (validated == null) {
            validated = this.getFallbackProjectArea(includeLoggedOut, repository);
        }
        return validated;
    }

    public IProjectAreaHandle getDefaultProjectAreaFallback(boolean includeLoggedOut) {
        IProjectAreaHandle validated = this.validate(this.fDefaultProjectArea, includeLoggedOut);
        if (validated == null) {
            validated = this.getFallbackProjectArea(includeLoggedOut, null);
        }
        return validated;
    }

    public IProjectAreaHandle getDefaultProjectAreaFallback() {
        return this.getDefaultProjectAreaFallback(false);
    }

    public void setDefaultProjectArea(IProjectAreaHandle projectArea) {
        IProjectAreaHandle before = this.fDefaultProjectArea;
        this.fDefaultProjectArea = projectArea;
        this.notifyListeners(before, this.fDefaultProjectArea);
    }

    public void addListener(IDefaultProjectAreaListener listener) {
        this.fListeners.add((Object)listener);
    }

    public void removeListener(IDefaultProjectAreaListener listener) {
        this.fListeners.remove((Object)listener);
    }

    private void notifyListeners(IProjectAreaHandle before, IProjectAreaHandle after) {
        Object[] objectArray = this.fListeners.getListeners();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object listener = objectArray[n2];
            ((IDefaultProjectAreaListener)listener).defaultProjectAreaChanged(before, after);
            ++n2;
        }
    }

    private IProjectAreaHandle validate(IProjectAreaHandle projectArea, boolean includeLoggedOut) {
        if (projectArea == null || !ConnectedProjectAreaRegistry.getDefault().isConnectedProjectArea(projectArea)) {
            return null;
        }
        ITeamRepository repository = (ITeamRepository)projectArea.getOrigin();
        if (!includeLoggedOut && !repository.loggedIn() || repository.getErrorState() != 0) {
            return null;
        }
        return projectArea;
    }

    private IProjectAreaHandle getFallbackProjectArea(boolean includeLoggedOut, ITeamRepository repository) {
        List<IProjectAreaHandle> projectAreas = this.getConnectedProjectAreas(repository);
        for (IProjectAreaHandle projectAreaHandle : projectAreas) {
            IProjectAreaHandle validated = this.validate(projectAreaHandle, includeLoggedOut);
            if (validated == null) continue;
            return validated;
        }
        return null;
    }

    private List<IProjectAreaHandle> getConnectedProjectAreas(ITeamRepository repository) {
        return ConnectedProjectAreaRegistry.getDefault().getConnectedProjectAreas(repository);
    }

    public void saveState(IMemento memento) {
        if (this.fDefaultProjectArea != null) {
            memento.putString(KEY_ITEM_ID, this.fDefaultProjectArea.getItemId().getUuidValue());
        }
    }

    private void defaultSaveState() {
        XMLMemento memento = XMLMemento.createWriteRoot((String)DEFAULT_CONNECTED_PROJECT_AREA);
        this.saveState((IMemento)memento);
        StringWriter writer = new StringWriter();
        try {
            memento.save((Writer)writer);
            IPreferenceStore preferences = WorkItemRCPUIPlugin.getDefault().getPreferenceStore();
            preferences.setValue(this.getPreferenceKey(), writer.toString());
        }
        catch (IOException e) {
            WorkItemRCPUIPlugin.getDefault().log(Messages.ConnectedProjectAreas_ERROR_SAVING_DEFAULT_PROJECT, e);
        }
    }

    public void restoreState(IMemento memento) {
        if (memento == null) {
            return;
        }
        String itemId = memento.getString(KEY_ITEM_ID);
        if (itemId == null || itemId.length() == 0) {
            return;
        }
        List<IProjectAreaHandle> projectAreas = this.getConnectedProjectAreas(null);
        for (IProjectAreaHandle projectAreaHandle : projectAreas) {
            if (!projectAreaHandle.getItemId().getUuidValue().equals(itemId)) continue;
            this.fDefaultProjectArea = projectAreaHandle;
            return;
        }
    }

    private void restoreState() {
        Preferences preferences = WorkItemRCPUIPlugin.getDefault().getPluginPreferences();
        String stringMemento = preferences.getString(this.getPreferenceKey());
        XMLMemento memento = null;
        if (stringMemento != null && stringMemento.length() > 0) {
            try {
                memento = XMLMemento.createReadRoot((Reader)new StringReader(stringMemento));
            }
            catch (WorkbenchException e) {
                WorkItemRCPUIPlugin.getDefault().log(Messages.ConnectedProjectAreas_ERROR_RESTORING_DEFAULT_PROJECT, e);
            }
        }
        this.restoreState((IMemento)memento);
    }

    private String getPreferenceKey() {
        return String.valueOf(this.fCategory) + DEFAULT_CONNECTED_PROJECT_AREA_MEMENTO;
    }
}

