/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.rcp.ui.internal;

import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.workitem.client.WorkItemOperation;
import com.ibm.team.workitem.client.WorkItemWorkingCopy;
import com.ibm.team.workitem.common.model.AttributeIdentifiers;
import com.ibm.team.workitem.common.model.AttributeTypes;
import com.ibm.team.workitem.common.model.IAttribute;
import com.ibm.team.workitem.common.model.IWorkItem;
import com.ibm.team.workitem.common.model.ItemProfile;
import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ChangeWorkItemAttributeOperation
extends WorkItemOperation {
    private final IAttribute fAttribute;
    private final Object fValue;

    private static ItemProfile<IWorkItem> createProfile(IAttribute attribute) {
        boolean isCustomProperty;
        ArrayList<String> properties = new ArrayList<String>(3);
        properties.add(IWorkItem.CATEGORY_PROPERTY);
        properties.add(IWorkItem.TARGET_PROPERTY);
        boolean bl = isCustomProperty = !Arrays.asList(AttributeIdentifiers.ATTRIBUTES).contains(attribute.getIdentifier());
        if (!isCustomProperty) {
            properties.add(attribute.getIdentifier());
        }
        return IWorkItem.SMALL_PROFILE.createExtension(properties);
    }

    public ChangeWorkItemAttributeOperation(String name, IAttribute attribute, Object value) {
        super(name, ChangeWorkItemAttributeOperation.createProfile(attribute));
        if (value != null) {
            Assert.isLegal((boolean)AttributeTypes.getAttributeType((String)attribute.getAttributeType()).getInstanceType().isAssignableFrom(value.getClass()));
        }
        this.fAttribute = attribute;
        this.fValue = value;
    }

    protected void execute(WorkItemWorkingCopy[] workingCopies, IProgressMonitor monitor) throws TeamRepositoryException {
        WorkItemWorkingCopy[] workItemWorkingCopyArray = workingCopies;
        int n = workingCopies.length;
        int n2 = 0;
        while (n2 < n) {
            WorkItemWorkingCopy workingCopy = workItemWorkingCopyArray[n2];
            IWorkItem workItem = workingCopy.getWorkItem();
            if (workItem.hasAttribute(this.fAttribute)) {
                workItem.setValue(this.fAttribute, this.fValue);
            }
            ++n2;
        }
    }
}

